/*******************************************************************************************
CodeVisionAVR V2.05.0 Professional

Project :  ( . RTC)      ( +- 59 .)
          + 
          +  
          +     () (DS1820 / DS18S20 / DS18B20)  
          +   4-  7-      (*)
          +       (*) 
          +      (*)
          +   
          +    /  
          
          (*) -  


          -------------------------------------------------------
          *  / ()  (ru.wikipedia.org):

                   .    ( 23,5)
             ,           .
             ( 66,33)       (    ),
             (   ). ,          30  55.


Version :   , ,   /   .  
Date    : 03.04.2011
Author  : Danil Pervakov

Comments:    DS18x20 (   int  float)
           DS1307 ( -  -    
          - )

             :     
          ,    . (   )

           : "+" -  ..  - " +" 
                               -  ..  - " +"
                               -  .. - "  +"
                               - . () 
                               -    -  
                               
                           "-" -  ..  - " -" 
                               -  ..  - " -"
                               -  .. - "  -"
                               - . () 
                               -    -  
                               
                           "Sec" -     :
                                       :
                                   (  :  "" -    00,
                                      30  -  +1, 
                                    59 ,   +1)
                                   
                           "Set" -      
                                         
                                   :  ,  ,  ,
                                      , , ,
                                        :
                                   
                           "" -   .  .  ,
                                  23  00    -   23:00:00,  
                                  22  59    -   23:00:00,
                                        

                           "AL1" -  1  (   )

                           "AL2" -  2 

Chip type           : ATmega8 / ATmega88
Program type        : Application
Clock frequency     : 4,0 MHz / 8,0 MHz
Memory model        : Small
External SRAM size  : 0
Data Stack size     : 256
********************************************************************************************/
//
//  Fuse bit's mega8:   SKSEL3..0 = 0011, SUT1..0 = 10 (Int RC = 4 MHz) 
//             mega88:  SKSEL3..0 = 0010, SUT1..0 = 10 (Int RC = 8 MHz)
//
//  () DS1820 / DS18S20 / DS18B20 - (PORTD bit 7)
//  
//  Realtime DS1307 - (sda -  27, scl -  28)
//
//   -  (ADC0 -  23) - "+", "-", "Sec", "Set", "K", "A1", "A2" 
//
//   
//                   (PORTB - ) - a-bit0, b-bit2, c-bit4, d-bit6, e-bit7, f-bit1, g-bit3, dp-bit5
//                   (PORTD - ) - 1-bit0, 2-bit1, 3-bit2, 4-bit3 
//
//    (   ) - ADC1
//


/*
mega8:
Program size: 3795 words (7590 bytes), 92,7% of FLASH

mega88:
Program size: 3846 words (7692 bytes), 93,9% of FLASH
*/

#if __CODEVISIONAVR__ < 2000
#error CodeVisionAVR V2.0 or later
#endif

//  -          ,    IBM PC XT   Intel 8088 
#ifdef _CHIP_ATMEGA8_
	#include <mega8.h>

	// 1 Wire Bus functions (PORTD bit 7)
	#asm
		.equ __w1_port=0x12
		.equ __w1_bit=7
	#endasm
#endif

#ifdef _CHIP_ATMEGA88_ 
	#include <mega88.h>

	// 1 Wire Bus functions (PORTD bit 7)
	#asm
		.equ __w1_port=0x0B
		.equ __w1_bit=7
	#endasm
#endif

// DS1820 / DS18S20 / DS18B20 Temperature Sensor functions
#include "ds18x20_v3.h"  

// DS1307 Real Time Clock TWI functions
#include "ds1307_twi.h"

#include <delay.h> 
#include <bcd.h>

// ,   . 
#include "term_mega8_88.h"

void alarm_OFF(void);


// ---------------- Timer 2 overflow interrupt service routine -----------------------------
//
//  -    (62500  / 256) = 244 
//       (244 / 4) = 61 
//
interrupt [TIM2_OVF] void timer2_ovf_isr(void)
{
	if (led_r) { PORTD&=0b11110000; }                   //   ( - off)
	else       { PORTD|=0b00001111; }

	if (led_s) { PORTB=digits[digit_out[cur_dig]];  }   //   
	else       { PORTB=~digits[digit_out[cur_dig]]; }

	if (zpt_4 & (1<<cur_dig)) {   //   (  0  3  zpt_4   . )
		if (led_s) { PORTB.5=1; }
		else       { PORTB.5=0; }
	}

	if (led_r) { PORTD |= (1<<cur_dig);  }  //    (  - on)
	else       { PORTD &= ~(1<<cur_dig); } 


	if (zpt_BLINK == 1) {
		t2Hz++;
		if (t2Hz > 122) { //  2 
			t2Hz = 0;

			//   (1 )
			if (zpt_4) { zpt_4 = 0;                        } //    
			else       { if (dubldot)  zpt_4 = 0b00000010;   //    1  
			             else          zpt_4 = 0b00000001; } //                  0  
		}
	}

	cur_dig++; if (cur_dig > 3) {
		cur_dig = 0;

		#ifdef _CHIP_ATMEGA8_
		OCR2 = yarkost;
		#endif

		#ifdef _CHIP_ATMEGA88_
		OCR2A = yarkost;
		#endif
	}
}// ----------------------------------------------------------------------------------------


// ------------------ Timer2 output compare interrupt service routine ----------------------
#ifdef _CHIP_ATMEGA8_
interrupt [TIM2_COMP] void timer2_comp_isr(void)
#endif
#ifdef _CHIP_ATMEGA88_
interrupt [TIM2_COMPA] void timer2_compa_isr(void)
#endif
{
	if ((rushechki) && (fotorez)) return;  //      - 

	if (led_s) { PORTB=0x00; }        //   
	else       { PORTB=0xFF; }

	if (led_r) { PORTD&=0b11110000; } //   ( - off)
	else       { PORTD|=0b00001111; }
}// ----------------------------------------------------------------------------------------


// ----------------------- Timer 0 overflow interrupt service routine ----------------------
// mega8:
//       500.000 Hz / 250 = 2.000 Hz
//       255-250 = 5 (0x05)
//
// mega88:
//       125.000 Hz / 62 = 2.000 Hz
//       255-62 = 193 (0xC1)
//
interrupt [TIM0_OVF] void timer0_ovf_isr(void) {

	#ifdef _CHIP_ATMEGA8_
	TCNT0=0x05;
	#endif

	#ifdef _CHIP_ATMEGA88_
	TCNT0=0xC1;
	#endif
	
	if (t1kHz == 0) {    // 
		t1kHz = 1;       // (     2)
		count_1_min++;

		if (count_2_sec < 2000) { // 2   
			count_2_sec++;
			PORT_ALARM_1KHZ = 1;
		}
		else {
			count_1_sec++;       // 1   
		}

		if (count_1_sec > 1000) { //  1     
			count_2_sec = 0;
			count_1_sec = 0;
		}
	}
	else {
		t1kHz = 0;
		PORT_ALARM_1KHZ = 0;
	}

	if (count_1_min >= 60000) { // 60000 = 1 
		alarm_OFF(); //  1   
	}
}//-----------------------------------------------------------------------------------------


// ---------------------------    eeprom ----------------------------------
void read_eeprom (void) {
	led_s      = eled_s;
	led_r      = eled_r;
	hour0      = ehour0;
	des        = edes;
	rushechki  = erushechki;
	fotorez    = efotorez;
	dubldot    = edubldot;
	plusminus  = eplusminus;
	zimaleto   = ezimaleto;
	maxfotorez = emaxfotorez;
}//----------------------------------------------------------------------------------------- 


//-----------------------------    ---------------------------------
void alarm_ON(void) {
	if ((alarm_active == ON) && (indicate == IND_CLOCK)) {
		// Timer/Counter 0 initialization
		// Clock source: System Clock
		// Clock value: 500,000 kHz (mega8)
		//              125,000 kHz (mega88)
		#ifdef _CHIP_ATMEGA8_
		TCCR0=0x02; TCNT0=0x05;
		#endif
		
		#ifdef _CHIP_ATMEGA88_
		TCCR0B=0x03; TCNT0=0xC1;
		#endif
		
		count_1_min = 0;
		count_2_sec = 0;
		count_1_sec = 0;

		PORT_ALARM_BIPER = 1;
		alarm_active = OFF;
	}
}//-----------------------------------------------------------------------------------------


//-----------------------------    --------------------------------
void alarm_OFF(void) {

	#ifdef _CHIP_ATMEGA8_
	TCCR0=0x00;              // Timer/Counter 0 Stoped
	#endif

	#ifdef _CHIP_ATMEGA88_
	TCCR0B=0x00;
	#endif
	
	PORT_ALARM_1KHZ  = 0;
	PORT_ALARM_BIPER = 0;
	alarm_active = OFF;
}//-----------------------------------------------------------------------------------------


// -----         --------------
// 
//          ( 2009   29 , 2010  28 ).
//          ( 2009   25 ,  2010  31 ).
//
void date_LetoZima(void) {
	unsigned char y;

	y = bcd2bin(myyear);
		
	//        (ru.wikipedia.org)
	// a = (14 - ) / 12
	// y =  - a
	// m =  + 12 * a - 2
	//  = (7000 + ( + y + y / 4 - y / 100 + y / 400 + (31 * m) / 12))  7
	

	// __ = 31  __31_
	last_sunday_March   = bin2bcd(31 - ((33 + y + (y>>2)) % 7));

	// __ = 31  __31_
	last_sunday_October = bin2bcd(31 - ((51 + y + (y>>2)) % 7));
} // ---------------------------------------------------------------------------------------


//-----------------    (    ) --------------
unsigned char Zima_or_Leto(void) {

	//    c 3:00  23:00
	if ((mymonth == 0x03) && (mydate == last_sunday_March) && (myhour >= 0x03) && (myhour < 0x23)) return LETO;

	//  c 1:00  23:00      
	if ((mymonth == 0x03) && (mydate > last_sunday_March) && (myhour > 0x00) && (myhour < 0x23)) return LETO;

	//  c 1:00  23:00     
	if ((mymonth > 0x03) && (mymonth < 0x10) && (myhour > 0x00) && (myhour < 0x23)) return LETO;

	//   1:00  23:00      
	if ((mymonth == 0x10) && (mydate < last_sunday_October) && (myhour > 0x00) && (myhour < 0x23)) return LETO;

	//   1:00  2:59     
	if ((mymonth == 0x10) && (mydate == last_sunday_October) && ((myhour == 0x01) || (myhour == 0x02))) return LETO;	

	//----------------------------------------------

	//    c 4:00  23:59
	if ((mymonth == 0x10) && (mydate == last_sunday_October) && (myhour >= 0x04) && (myhour != 0x00)) return ZIMA;

	//  c 2:00  23:59      
	if ((mymonth == 0x10) && (mydate > last_sunday_October) && (myhour != 0x00) && (myhour >= 0x02)) return ZIMA;

	//  c 2:00  23:59     
	if ((mymonth > 0x10) && (myhour != 0x00) && (myhour >= 0x02))return ZIMA;

	//  c 2:00  23:59     ,
	if ((mymonth < 0x03) && (myhour != 0x00) && (myhour >= 0x02))return ZIMA;

	//   2:00  23:59      
	if ((mymonth == 0x03) && (mydate < last_sunday_March) && (myhour != 0x00) && (myhour >= 0x02)) return ZIMA;

	//   1:00  2:59     
	if ((mymonth == 0x03) && (mydate == last_sunday_March) && ((myhour == 0x01) || (myhour == 0x02))) return ZIMA;	

	return NE_LETO_NE_ZIMA; //          	
}//-----------------------------------------------------------------------------------------


// --------------------------------  ADC ---------------------------------------------
// Read the 8 most significant bits of the AD conversion result
unsigned char read_adc(unsigned char adc_input) {
	ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
	// Delay needed for the stabilization of the ADC input voltage
	delay_us(10);
	// Start the AD conversion
	ADCSRA|=0x40;
	// Wait for the AD conversion to complete
	while ((ADCSRA & 0x10)==0);
	ADCSRA|=0x10;
	return ADCH;
}  //---------------------------------------------------------------------------------------


// ----------------------------    ------------------------------------
unsigned char read_key(void) {
	unsigned char key_adc, new_key;

	key_adc=read_adc(0);

	switch (key_adc) {
		case 0: case 1: case 2:	case 3:
			new_key = KEY_PLUS;                 // = 0
		break;

		case 124: case 125:	case 126:
		case 127: case 128:	case 129: case 130:
			new_key = KEY_MINUS;                // = 1/2  255
		break;

		case 167: case 168:	case 169:
		case 170: case 171:	case 172: case 173:        
			new_key = KEY_SEC;                  // = 2/3  255
		break;

		case 188: case 189: case 190:
		case 191: case 192: case 193: case 194:        
			new_key = KEY_SET;                  // = 3/4  255
		break;

		case 201: case 202:	case 203:
		case 204: case 205: case 206: case 207:        
			new_key = KEY_K;                    // = 4/5  255
		break;

		case 209: case 210:	case 211:
		case 212: case 213:	case 214: case 215:        
			new_key = KEY_AL1;                  // = 5/6  255
		break;

		case 216: case 217: case 218:
		case 219: case 220: case 221: case 222:        
			new_key = KEY_AL2;                  // = 6/7  255
		break;

		default:
			povtor_key = OFF;                   //  
			return 0;
	}

	if (new_key == old_key) povtor_key = ON;  //       ..  
	else                    povtor_key = OFF;

	old_key = new_key; //    

	return new_key;
} // ---------------------------------------------------------------------------------------


// ---------------------------    DS1307 ------------------------------------
void read_time(void) {
	unsigned int i;
	
	rtc_get_time(&myhour, &mymin, &mysec);
	rtc_get_date(&mydate, &mymonth, &myyear);

	//           23:57
	if ((indicate == IND_CLOCK) && (Corect != 0) && (myhour == 0x23) && (mymin == 0x57) && (mysec > 0)) {

		while (mymin != 0x58) { //    23  58  00,0 
			rtc_get_time(&myhour, &mymin, &mysec);
			#asm("wdr") //  Watchdog Timer
			delay_ms(10);
		}
		
		if (Corect & 0x80) { i = Corect & 0x7F; } //    
		else               { i = 600 - Corect;  } //  
		
		while(i) { 
			delay_ms(100); //     
			i--;
			#asm("wdr") //  Watchdog Timer			
		}
		
		myhour=0x23; mysec=0x00;
		if (Corect & 0x80) { mymin=0x58;  } //    
		else               { mymin=0x59;  } //  
		
		rtc_set_time(myhour, mymin, mysec);
	}

	if (((myhour == al1_h) && (mymin == al1_m)) 
	||  ((myhour == al2_h) && (mymin == al2_m))) {alarm_ON();       }
	else                                         {alarm_active = ON;}
        
	#asm("wdr") //  Watchdog Timer     
} //----------------------------------------------------------------------------------------


// -----------------------------------------------------------------------------------------
void delay_ms_read_time (unsigned int d) {
	while (d) {
		read_time();
		delay_ms(1);
		d--;
	}
}//-----------------------------------------------------------------------------------------


//----------        ? --- (   )--------
void view_time(void) {
	unsigned char tmp;

	//     .
	if (al1_h < 0x25) LED_AL1 = ON; else LED_AL1 = OFF;
	if (al2_h < 0x25) LED_AL2 = ON; else LED_AL2 = OFF;


	if (indicate == IND_CLOCK) {            //  : 
		if (hour0) { digit_out[0] = (myhour >> 4) ? (myhour >> 4) : (PROBEL); }
		else       { digit_out[0] = myhour >> 4;                              }
		
		             digit_out[1] = myhour & 0x0F;
		             digit_out[2] = mymin >> 4;
		             digit_out[3] = mymin & 0x0F;
	}

	if (indicate == IND_SEC){               //  : 
			digit_out[0] = mymin >> 4;
			digit_out[1] = mymin & 0x0F;
			digit_out[2] = mysec >> 4;
			digit_out[3] = mysec & 0x0F;
	}

	if (indicate == IND_SET_H) {            // .
		if (hour0) { digit_out[0] = (myhour >> 4) ? (myhour >> 4) : (PROBEL); }
		else       { digit_out[0] = myhour >> 4;                              }

		             digit_out[1] = myhour & 0x0F;
		             digit_out[2] = PROBEL;
		             digit_out[3] = PROBEL;
	}

	if (indicate == IND_SET_M) {            // .
			digit_out[0] = PROBEL;
			digit_out[1] = PROBEL;
			digit_out[2] = mymin >> 4;
			digit_out[3] = mymin & 0x0F;
	}

	if (indicate == IND_SET_YR) {           // .
			digit_out[0] = myyear >> 4;
			digit_out[1] = myyear & 0x0F;
			digit_out[2] = 13;  // d1
			digit_out[3] = 1;
	}

	if (indicate == IND_SET_MN) {           // .
			digit_out[0] = mymonth >> 4;
			digit_out[1] = mymonth & 0x0F;
			digit_out[2] = 13;  // d2
			digit_out[3] = 2;
	}

	if (indicate == IND_SET_DT) {           // .
			digit_out[0] = mydate >> 4;
			digit_out[1] = mydate & 0x0F;
			digit_out[2] = 13;  // d3
			digit_out[3] = 3;
	}

	if (indicate == IND_SET_T1){            // .  
			tmp = bin2bcd(t_ind_clock);
			digit_out[0] = tmp >> 4;
			digit_out[1] = tmp & 0x0F;
			digit_out[2] = SYMBOL_T;
			digit_out[3] = 1;
	}

	if (indicate == IND_SET_T2){            // .  
			tmp = bin2bcd(t_ind_date);
			digit_out[0] = tmp >> 4;
			digit_out[1] = tmp & 0x0F;
			digit_out[2] = SYMBOL_T;
			digit_out[3] = 2;
	}

	if (indicate == IND_SET_T3){            // .  
			tmp = bin2bcd(t_ind_term);
			digit_out[0] = tmp >> 4;
			digit_out[1] = tmp & 0x0F;
			digit_out[2] = SYMBOL_T;
			digit_out[3] = 3;
	}

	if (indicate == IND_SET_AL1_H) {           // . 1  
			if (al1_h == 0x25) {
				digit_out[0] = MINUS;
				digit_out[1] = MINUS;
			} else {        
				digit_out[0] = al1_h >> 4;
				digit_out[1] = al1_h & 0x0F;
			}
				digit_out[2] = 10;  // A1
				digit_out[3] = 1;
	}

	if (indicate == IND_SET_AL1_M) {           // . 1 
				digit_out[0] = 10;  // A1
				digit_out[1] = 1;
				digit_out[2] = al1_m >> 4;
				digit_out[3] = al1_m & 0x0F;
	}

	if (indicate == IND_SET_AL2_H) {           // . 2 
				if (al2_h == 0x25) {
					digit_out[0] = MINUS;
					digit_out[1] = MINUS;
				} else {        
					digit_out[0] = al2_h >> 4;
					digit_out[1] = al2_h & 0x0F;
				}   
					digit_out[2] = 10;  // A2
					digit_out[3] = 2;
	}

	if (indicate == IND_SET_AL2_M) {           // . 2 
			digit_out[0] = 10;  // A2
			digit_out[1] = 2;
			digit_out[2] = al2_m >> 4;
			digit_out[3] = al2_m & 0x0F;
	}

	if (indicate == IND_K){                 // . 
			tmp = bin2bcd(Corect & 0x7F);

			if (Corect & 0x80) digit_out[0] = MINUS;
			else               digit_out[0] = PROBEL;

			digit_out[1] = tmp >> 4;
			digit_out[2] = tmp & 0x0F;
			
			digit_out[3] = PROBEL;
	}


	if (indicate == IND_TEST_ADC0){         //  ,  0 () 
			tmp = read_adc(0);

			digit_out[0] = PROBEL;
			digit_out[1] = tmp / 100;
			digit_out[2] = tmp / 10 % 10;
			digit_out[3] = tmp % 10;
	}
	if (indicate == IND_TEST_ADC1){         //  ,  1 () 
			tmp = read_adc(1);

			digit_out[0] = PROBEL;
			digit_out[1] = tmp / 100;
			digit_out[2] = tmp / 10 % 10;
			digit_out[3] = tmp % 10;
	}
} //----------------------------------------------------------------------------------------


// ---------        ? ------- ( ) ------------------
void view_date(void) {
	if (indicate == IND_CLOCK) {           //  - 
			digit_out[0] = mydate >> 4;
			digit_out[1] = mydate & 0x0F;
			digit_out[2] = mymonth >> 4;
			digit_out[3] = mymonth & 0x0F;
	}
} //----------------------------------------------------------------------------------------


//------------------------------------------------------------------------------------------
void dot_ON(void) {
    if (dubldot)  zpt_4 = 0b00000010;  //    1  
    else          zpt_4 = 0b00000001;  //                  0  
}//----------------------------------------------------------------------------------------


// ------------------------------     --------------------------------
void set_ind(void) {
    unsigned char key, tmp, max_date;
    key=read_key();

    if (key != 0) {
        key_time = 0; //     -   

        tmp=bcd2bin(mymonth);
        max_date = date_of_month[tmp-1];

        //    
        if (((bcd2bin(myyear) % 4) == 0 ) && (tmp == 2)) max_date = 29;

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_CLOCK){
                if (key == KEY_PLUS) {
                       alarm_OFF();
                       if (devices >= 1) { num_DS = 0; indicate = IND_TERM; }
                }

                if (key == KEY_MINUS) {
                       alarm_OFF();
                       if (devices > 1)  { num_DS = 1; indicate = IND_TERM; }
                }

                if (key == KEY_SEC) {
                        indicate = IND_SEC;
                        zpt_BLINK=0;
                        dot_ON();
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_H;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                if (key == KEY_AL1) {
                        indicate = IND_SET_AL1_H;
                        zpt_BLINK=0;
                        zpt_4=0;
                        alarm_active = OFF;
                }

                if (key == KEY_AL2) {
                        indicate = IND_SET_AL2_H;
                        zpt_BLINK=0;
                        zpt_4=0;
                        alarm_active = OFF;
                }

                if (key == KEY_K) {
                        indicate = IND_K;
                        zpt_BLINK=0;
                        zpt_4 = 0b00000010;
                        Corect=rtc_read(MEM_CORECT); //   DS1307
                }

                return;
        }
 
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SEC){
                if (key == KEY_SEC) {
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        dot_ON();
                }

                if (key == KEY_K) {
                        if (bcd2bin(mysec) > 30) {  //   30 
                                tmp=bcd2bin(mymin); //  +1
                                tmp++;
                                if (tmp >= 60) {  //   59 
                                        mymin=0;
                                        tmp=bcd2bin(myhour);
                                        tmp++;
                                        if (tmp >= 24) myhour=0; else myhour=bin2bcd(tmp); //   23  
                                } else mymin=bin2bcd(tmp);
                                        
                        }
                        rtc_set_time(myhour, mymin, 0);  //  00
                        view_time();
                }

                return;
        } 

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_H){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(myhour);
                        tmp++; if (tmp >= 24) tmp=0;         //   +1
                        myhour=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(myhour);
                        if (tmp == 0) {tmp = 23;}
                        else          {tmp--;   }            //   -1
                        myhour=bin2bcd(tmp);
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_M;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                rtc_set_time(myhour, mymin, mysec);
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_M){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(mymin);
                        tmp++; if (tmp > 59) tmp=0;          //  +1
                        mymin=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(mymin);
                        if (tmp == 0) {tmp = 59;}
                        else          {tmp--;   }            //  -1
                        mymin=bin2bcd(tmp);
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_YR;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                rtc_set_time(myhour, mymin, mysec);
                view_time();
                return;
        }


        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_YR){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(myyear);
                        tmp++; if (tmp > 99) tmp=9;             //  +1
                        myyear=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(myyear);
                        if (tmp < 9) {tmp = 99;}
                        else         {tmp--;   }                //  -1
                        myyear=bin2bcd(tmp);
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_MN;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                date_LetoZima();
                rtc_set_date(mydate, mymonth, myyear);
                month_corect = Zima_or_Leto();
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_MN){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(mymonth);
                        tmp++; if (tmp > 12) tmp = 1;           //  +1
                        mymonth=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(mymonth);
                        if (tmp <= 1) {tmp = 12;}
                        else          {tmp--;   }               //  -1
                        mymonth=bin2bcd(tmp);
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_DT;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                rtc_set_date(mydate, mymonth, myyear);
                month_corect = Zima_or_Leto();
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_DT){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(mydate);
                        tmp++; if (tmp > max_date) tmp = 1;     //  +1
                        mydate=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(mydate);
                        if (tmp == 1) {tmp = max_date;}
                        else          {tmp--;   }               //  -1
                        mydate=bin2bcd(tmp);
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_T1;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                rtc_set_date(mydate, mymonth, myyear);
                month_corect = Zima_or_Leto();
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_T1){
                if (key == KEY_PLUS) {  //   +1 
                        t_ind_clock++; if (t_ind_clock > 50) t_ind_clock = 5;
                }

                if (key == KEY_MINUS) { //   -1 
                        if (t_ind_clock <= 5) {t_ind_clock = 50;}
                        else                  {t_ind_clock--;   }
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_T2;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                rtc_write(MEM_T_IND_CLOCK,t_ind_clock);
                tc1 = (unsigned int)t_ind_clock * 10;
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_T2){
                if (key == KEY_PLUS) { //   +1 
                        t_ind_date++; if (t_ind_date > 50) t_ind_date = 0;
                }

                if (key == KEY_MINUS) { //   -1 
                        if (t_ind_date == 0) {t_ind_date = 50;}
                        else                 {t_ind_date--;   }
                }

                if (key == KEY_SET) {
                        indicate = IND_SET_T3;
                        zpt_BLINK=0;
                        zpt_4=0;
                }

                rtc_write(MEM_T_IND_DATE,t_ind_date);
                td2 = (unsigned int)t_ind_date * 10;
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_T3){
                if (key == KEY_PLUS) { //   +1 
                        t_ind_term++; if (t_ind_term > 25) t_ind_term = 0;
                }

                if (key == KEY_MINUS) { //   -1 
                        if (t_ind_term == 0) {t_ind_term = 25;}
                        else                 {t_ind_term--;   }
                }

                if (key == KEY_SET) {
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        dot_ON();
                }

                rtc_write(MEM_T_IND_TERM,t_ind_term);
                tt3 = t_ind_term * 10;
                view_time();
                return;
        }


        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_AL1_H){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(al1_h);
                        tmp++;                         //   1  +1
                        if (tmp >= 25) tmp=0;
                        if (tmp == 24) tmp=25;
                        al1_h=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(al1_h);
                        if (tmp == 25) {tmp = 24;}
                        
                        if (tmp == 0) {tmp = 25;}
                        else          {tmp--;   }      //   -1
                        al1_h=bin2bcd(tmp);
                }

                if (key == KEY_AL1) {
                        indicate = IND_SET_AL1_M;
                        zpt_BLINK=0;
                        zpt_4=0;
                        alarm_active = OFF;
                }
                
                rtc_write(MEM_AL1_H,al1_h); //  ()  DS1307
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_AL1_M){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(al1_m);
                        tmp++;
                        if ((al1_h==0x23) && (tmp > 55)) tmp=0; 
                        if (tmp > 59) tmp=0;    //   1  +1
                        al1_m=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(al1_m);
                        if (tmp == 0) {tmp = 59;}
                        else          {tmp--;   }      //  -1 
                        if ((al1_h==0x23) && (tmp > 55)) tmp=55;
                        al1_m=bin2bcd(tmp);
                }

                if (key == KEY_AL1) {
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        dot_ON();
                        alarm_active = ON;
                }

                rtc_write(MEM_AL1_M,al1_m); //  ()  DS1307
                view_time();
                return;
        }


        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_AL2_H){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(al2_h);
                        tmp++;                         //   2  +1
                        if (tmp >= 25) tmp=0;
                        if (tmp == 24) tmp=25;
                        al2_h=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(al2_h);
                        if (tmp == 25) {tmp = 24;}
                        
                        if (tmp == 0) {tmp = 25;}
                        else          {tmp--;   }      //   -1
                        al2_h=bin2bcd(tmp);
                }

                if (key == KEY_AL2) {
                        indicate = IND_SET_AL2_M;
                        zpt_BLINK=0;
                        zpt_4=0;
                        alarm_active = OFF;
                }

                rtc_write(MEM_AL2_H,al2_h); //  ()  DS1307
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET_AL2_M){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(al2_m);
                        tmp++; 
                        if ((al2_h==0x23) && (tmp > 55)) tmp=0;                        
                        if (tmp > 59) tmp=0;    //   2  +1
                        al2_m=bin2bcd(tmp);
                }

                if (key == KEY_MINUS) {
                        tmp=bcd2bin(al2_m);
                        if (tmp == 0) {tmp = 59;}
                        else          {tmp--;   }      //  -1
                        if ((al2_h==0x23) && (tmp > 55)) tmp=55;
                        al2_m=bin2bcd(tmp);
                }

                if (key == KEY_AL2) {
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        dot_ON();
                        alarm_active = ON;                
                }

                rtc_write(MEM_AL2_M,al2_m); //  ()  DS1307
                view_time();
                return;
        }

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_K){
                if (key == KEY_PLUS) {
                        if (Corect < 100) { //   
                                Corect++;
                                if (Corect > 99) Corect=99;  //      
                        }
                        else { //   
                                Corect--;
                                if (Corect < 129) Corect=0;  //    0    
                        }
                }

                if (key == KEY_MINUS) {
                        if (Corect < 100) { //   
                                if (Corect == 0) Corect=129; //  0    
                                else             Corect--;                                
                        }
                        else { //   
                                Corect++;
                                if (Corect > 227) Corect=227; //      
                        }
                }

                if ((key == KEY_SEC) || (key == KEY_SET) || (key == KEY_K)){
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        dot_ON();
                        rtc_write(MEM_CORECT,Corect); //  ()  DS1307
                }

                return;
        }

		//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		if (indicate == IND_EEPROM){
			if (key == KEY_PLUS)  { num_eeprom ++; if (num_eeprom > 10) num_eeprom = 2; } //   +1

			if (key == KEY_MINUS) { num_eeprom --; if (num_eeprom < 2) num_eeprom = 10; } //   -1

			if (key == KEY_SET)   {                                                      //    (   8  9)
				switch (num_eeprom) {
					case 2: //   eeprom (    )
						if (ehour0) ehour0 = 0; else ehour0 = 0xFF;
					break;

					case 3: //   eeprom (   ..)
						if (edes) edes = 0; else edes = 0xFF;
					break;

					case 4: //   eeprom (   )
						if (erushechki) erushechki = 0; else erushechki = 0xFF;
					break;

					case 5: //   eeprom (    )
						if (efotorez) efotorez = 0; else efotorez = 0xFF;
					break;

					case 6: //   eeprom ( -   )
						if (edubldot) edubldot = 0; else edubldot = 0xFF;
					break;

					case 7: //   eeprom (       .)
						if (eplusminus) eplusminus = 0; else eplusminus = 0xFF;
					break;

					case 8: //   eeprom ( )
						if (etest_adc == 0xFF) { etest_adc = 0; }
						else { if (etest_adc)    etest_adc = 0xFF;
						       else              etest_adc = 0x01;
						     }
					break;

					case 9: //   eeprom (     )
						if (ezimaleto) ezimaleto = 0; else ezimaleto = 0xFF;
					break;

					case 10: //   eeprom (  )
						if (emaxfotorez == 0xFF) { emaxfotorez = maxfotorez = 40; }
						else { maxfotorez+=10;  
						       if (maxfotorez > 200) maxfotorez = 40;
						       emaxfotorez = maxfotorez;
						     }
					break;
				}
			}

			if (key == KEY_SEC) { //     EEPROM
				indicate = IND_CLOCK;
				read_eeprom(); //    eeprom
			}
		}
	}
} // ---------------------------------------------------------------------------------------



// -----------------------------------------------------------------------------------------
void view_term(void) {
	unsigned char celie, drob, tmp, cur_t=0;
	unsigned int temp, celie_tmp, drob_tmp;
	bit zero;
	
	//       ...  
	if ((indicate != IND_CLOCK) && (indicate != IND_TERM)) return;

	zpt_BLINK=0; //   
	
	if (des) zpt_4=0b00000010;  //    .
	else     zpt_4=0;
	

	// ******************************   **********************************
	temp = (unsigned int) temperature;

	if (temperature < 0) {
		temp = ( ~temp ) + 0x0001; //       .
			
		zero = 1; //  . (   ..)	
	} else {
		zero = 0; // .
	}	  

	celie_tmp = temp >> 4;              //   
	drob_tmp  = temp & 0x000F;          //      1/16 

	drob  = (unsigned char) ((drob_tmp * 10) / 16); //      "1/16 "
	                                                //      0,1  

	celie = (unsigned char) celie_tmp;  //     

	if (celie > 99) return; //     100 .
		
	tmp=bin2bcd(celie); //   
	// *****************************   ************************************

	
	if (plusminus && zero) { //   4-   . 
			digit_out[cur_t++] = MINUS;
				
			if (celie >= 10) { 
				digit_out[cur_t++] = tmp >> 4;    // 
				digit_out[cur_t++] = tmp & 0x0F;  // 
				zpt_4=0;
			} else {
				digit_out[cur_t++] = tmp & 0x0F;      // 
				if (des) { digit_out[cur_t++] = drob; //  
				           zpt_4=0b00000010;
				         }
				}
			digit_out[cur_t++] = GRADUS;
			digit_out[cur_t]   = SYMBOL_C;
			return;
	}
	
	//  .
		digit_out[cur_t++] = (tmp >> 4) ? (tmp >> 4) : (PROBEL); //  -       
		digit_out[cur_t++] = tmp & 0x0F;                         // 
		if (des) digit_out[cur_t++] = drob;                      //  
		digit_out[cur_t++] = GRADUS;
		digit_out[cur_t]   = SYMBOL_C;		
		
	
	if (!plusminus) {
		if (zero) zpt_4 |= 0b00000100; //   ""  ""
		else      zpt_4 |= 0b00001100; //          --//--             ""
		
	}
}  // --------------------------------------------------------------------------------------


// -----------------------------------------------------------------------------------------
void yarkost_down (void) {
	if (rushechki) return;  //  " " -  

	//      10    4mS
	for (yarkost = max_yarkost; yarkost > 10; yarkost--) {
		delay_ms(4);
		set_ind();
		if (indicate != IND_CLOCK) {yarkost = max_yarkost = 250; break;} //      
	} 
}

// -----------------------------------------------------------------------------------------
void yarkost_up (void) {
	if (rushechki) return;  //  " " -  

	//    10      10mS
	for (yarkost = 10; yarkost < max_yarkost; yarkost++) {
		delay_ms(10);
		set_ind();
		if (indicate != IND_CLOCK) {yarkost = max_yarkost = 250; break;} //      
	}
}

// -----------------------------------------------------------------------------------------
void set_yarkost (void) {
	unsigned char adc_rez, rez_100, rez_50;
	
	if (fotorez) return;  //  " " -    	

	adc_rez  = read_adc(1); //    

	if (maxfotorez == 0xFF) {rez_100 = 190; rez_50 = 100;}
	else                    {rez_100 = maxfotorez; rez_50 = maxfotorez/2;}

	if (adc_rez > rez_100) {
		max_yarkost = 250; //  100%
	}

	if ((adc_rez >= rez_50) && (adc_rez <= rez_100)) {
		max_yarkost = 128; //  50%
	}

	if (adc_rez < rez_50) {
		max_yarkost = 64; //  25%
	}

	if (rushechki) {  //    -  
		#asm("cli")

		#ifdef _CHIP_ATMEGA8_
		OCR2 = max_yarkost; //  "tipoya  radiokot.ru"
		#endif

		#ifdef _CHIP_ATMEGA88_
		OCR2A = max_yarkost;
		#endif

		#asm("sei")
	}

	yarkost = max_yarkost; //  "tipoya  radiokot.ru" 
}


// -----------------------------------------------------------------------------------------
void delay_100ms (unsigned char d) {
	while (d) {
		read_time();
		set_ind();
		if (indicate != IND_CLOCK) return; //      
		set_yarkost();
		delay_ms(90);
		d--;
	}
}


//===================================== main ==============================================
void main(void) {
unsigned char i, tmp;
unsigned int  j;

read_eeprom(); //    eeprom

//  
digit_out[0]=PROBEL;
digit_out[1]=PROBEL;
digit_out[2]=PROBEL;
digit_out[3]=PROBEL;

#ifdef _CHIP_ATMEGA8_
#include "mega8.init" //  
#endif

#ifdef _CHIP_ATMEGA88_
#include "mega88.init"
#endif

//  7 (CH)   DS1307    
// (0 - , 1 - )
rtc_get_time(&myhour, &mymin, &mysec);
mysec &= 0b01111111;                    //   7-   "0"
rtc_set_time(myhour, mymin, mysec); 

//       DS1307   " " 
if  (efirst_start) {
	for (i=7;i<64;i++) rtc_write(i,0x00); //   0x07   DS1307 

	rtc_write(MEM_T_IND_CLOCK,30); //    (.)
	rtc_write(MEM_T_IND_DATE,5);   //                 
	rtc_write(MEM_T_IND_TERM,5);   //                 

	rtc_write(MEM_AL1_H,0x25); //  . 25  .. ..
	rtc_write(MEM_AL2_H,0x25);
		
	efirst_start = 0x00; //    
}

w1_init();            // 1 Wire Bus initialization

//   DS1307
Corect       = rtc_read(MEM_CORECT);
month_corect = rtc_read(MEM_MONTH_CORECT);
al1_h        = rtc_read(MEM_AL1_H);
al1_m        = rtc_read(MEM_AL1_M);
al2_h        = rtc_read(MEM_AL2_H);
al2_m        = rtc_read(MEM_AL2_M);

t_ind_clock = rtc_read(MEM_T_IND_CLOCK); //    (.)
t_ind_date  = rtc_read(MEM_T_IND_DATE);  //                 
t_ind_term  = rtc_read(MEM_T_IND_TERM);  //                 

if (al1_h > 0x25) { al1_h = 0x25; rtc_write(MEM_AL1_H,al1_h); }
if (al1_m > 0x59) { al1_m = 0;    rtc_write(MEM_AL1_M,al1_m); }
if (al2_h > 0x25) { al2_h = 0x25; rtc_write(MEM_AL2_H,al2_h); }
if (al2_m > 0x59) { al2_m = 0;    rtc_write(MEM_AL2_M,al2_m); }

//    ( 5  50 )
if ((t_ind_clock < 5) || (t_ind_clock > 50)) { t_ind_clock = 10; rtc_write(MEM_T_IND_CLOCK,t_ind_clock); }
tc1 = (unsigned int)t_ind_clock * 10;

//    ( 0  50 )
// 0 ->     
if (t_ind_date > 50) { t_ind_date = 10; rtc_write(MEM_T_IND_DATE,t_ind_date); }
td2 = (unsigned int)t_ind_date * 10;

//    ( 0  25 )
// 0 ->     
if (t_ind_term > 25) { t_ind_term = 5; rtc_write(MEM_T_IND_TERM,t_ind_term); }
tt3 = t_ind_term * 10;

//   ( )
devices=w1_search(0xf0,rom_code);

indicate = IND_CLOCK; //    
zpt_BLINK=0;
zpt_4=0;              //  

// Global enable interrupts
#asm("sei")


//  ()      
//     eeprom
switch (read_key()) {
	case KEY_PLUS: //   (...0, ...0)
		eled_s = led_s = 0; eled_r = led_r = 0;
	break;

	case KEY_MINUS: //   (...0, ...1)
		eled_s = led_s = 0; eled_r = led_r = 1;
	break;

	case KEY_SEC:   //   (...1, ...0)
		eled_s = led_s = 1; eled_r = led_r = 0;
	break;

	case KEY_SET:   //   (...1, ...1)
		eled_s = led_s = 1; eled_r = led_r = 1;
	break;

	case KEY_K:     //   (    EEPROM)
		indicate = IND_EEPROM;
	break;
}

//       eeprom
 if (indicate == IND_EEPROM) {
	digit_out[0] = SYMBOL_E;

	num_eeprom = 2;
	while (indicate == IND_EEPROM) { //        .EEPROM
		digit_out[1] = num_eeprom;
        digit_out[2] = PROBEL;
		switch (num_eeprom) {
			case 2:
				if (ehour0)     digit_out[3] = 1; else digit_out[3] = 0;
			break;

			case 3:
				if (edes)       digit_out[3] = 1; else digit_out[3] = 0;
			break;

			case 4:
				if (erushechki) digit_out[3] = 1; else digit_out[3] = 0;
			break;
			
			case 5:
				if (efotorez)   digit_out[3] = 1; else digit_out[3] = 0;
			break;

			case 6:
				if (edubldot)   digit_out[3] = 1; else digit_out[3] = 0;
			break;

			case 7:
				if (eplusminus)   digit_out[3] = 1; else digit_out[3] = 0;
			break;

			case 8:
				if (etest_adc == 0xFF) digit_out[3] = SYMBOL_F;
				if (etest_adc == 0x01) digit_out[3] = 1;
				if (etest_adc == 0x00) digit_out[3] = 0;
			break;
 
			case 9:
				if (ezimaleto) digit_out[3] = 1; else digit_out[3] = 0;
			break;

			case 10:
				digit_out[2] = maxfotorez/100;
				digit_out[3] = maxfotorez/10%10;
			break;
		}
		set_ind();
		delay_ms_read_time(200);
	}
 }

indicate = IND_CLOCK; //    

//      reset
#ifdef _CHIP_ATMEGA8_
if ((MCUCSR & 1) || (MCUCSR & 2)) {
    MCUCSR=0; //  
#endif
#ifdef _CHIP_ATMEGA88_    
if ((MCUSR & 1) || (MCUSR & 2)) { 
    MCUSR=0;
#endif
    //  1     Fnd.'-  '
    digit_out[0]=SYMBOL_F;
    digit_out[1]=SYMBOL_N;
    digit_out[2]=SYMBOL_D;
    digit_out[3]=devices;  // 'devices'
    
    delay_ms_read_time(1000);
}

// ..       
//      
if (devices >= 1) {
	for (i=0;i<devices;i++) {
		temperature=ds18x20_temperature(&rom_code[i][0]); 
	}
}

//------          -------
// hour0 = 0;
// rushechki = 0;
// fotorez = 0;
// dubldot = 0;
// plusminus = 0;
// des = 0;
// etest_adc = 0;
// etest_adc = 1;
//-----------------------------------------------------------------

//   
if (etest_adc == 0) indicate = IND_TEST_ADC0; //  0 - 
if (etest_adc == 1) indicate = IND_TEST_ADC1; //  1 - 


 // --------------------------------   -----------------------------------
 while (1) {
	//     "+"( 1 )  "-"( 2) 
	if ((devices >= 1) && (indicate == IND_TERM)) {
		temperature=ds18x20_temperature(&rom_code[num_DS][0]); 
		if (temperature!=-9999){ view_term(); delay_ms_read_time(5000); }
		indicate = IND_CLOCK;
	}


 	if (indicate != IND_CLOCK) delay_ms(200); //      
 	                                          //        

	//        ..
	while (indicate != IND_CLOCK) {
		read_time();
		view_time();
		set_ind();
		set_yarkost();
 
		if (povtor_key == ON) delay_ms(200); //      
		else                  delay_ms(100);

		key_time++;
 		if ( ((indicate != IND_TEST_ADC0) && (indicate != IND_TEST_ADC1)) && //      
 		     (((indicate == IND_SEC) && (key_time > 3000)) || //        .. 5 
 		     ((indicate != IND_SEC) && (key_time > 600 ))) ){ //   .  1 
 					key_time = 0; indicate = IND_CLOCK;       //     
 		}
	}



	//==========================================================================================================================
	//========================================   (/) =====================================================
	//==========================================================================================================================
	//          
	if ((indicate == IND_CLOCK) && (zimaleto)) {
		read_time();
		date_LetoZima();

		//     ,    "" 
		if (month_corect == ZIMA) { 
			if (Zima_or_Leto() == LETO) {
				tmp = bcd2bin(myhour); tmp++; //     
				myhour = bin2bcd(tmp);
				rtc_set_time(myhour, mymin, mysec); 

				month_corect = LETO;                      //  
				rtc_write(MEM_MONTH_CORECT,month_corect); //     DS1307
			}
		}
		//     ,    "" 
		if (month_corect == LETO) {
			if (Zima_or_Leto() == ZIMA) {
				tmp = bcd2bin(myhour); tmp--; //     
				myhour = bin2bcd(tmp);
				rtc_set_time(myhour, mymin, mysec); 

				month_corect = ZIMA;                      //  
				rtc_write(MEM_MONTH_CORECT,month_corect); //     DS1307
			}
		}
	} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



	//==========================================================================================================================
	//===========================================   ============================================================
	//==========================================================================================================================
	if ((indicate == IND_CLOCK) && ((t_ind_date!=0) || ((devices >= 1) && (t_ind_term != 0)))) {
		yarkost_down();
		read_time();
		view_time();

		zpt_4=0;
		zpt_BLINK=1; //   

		yarkost_up();
	}

	if (indicate == IND_CLOCK) {
		zpt_BLINK=1; //   

		for (j=0;j<tc1;j++){ //  
			read_time();
			view_time();
			set_ind();
			set_yarkost();
			delay_ms(100); 

			if (indicate != IND_CLOCK) break; //      
		}
	} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



	//==========================================================================================================================
	//============================================   ==============================================================
	//==========================================================================================================================
	//         
	if ((t_ind_date!=0) && (indicate == IND_CLOCK)) {
		yarkost_down();

		zpt_BLINK=0;
		zpt_4=0;

		read_time();
		view_date();

		yarkost_up();

		for (j=0;j<td2;j++){ //  
			read_time();
			view_date();
			set_ind();
 			set_yarkost(); 
			delay_ms(100);

			if (indicate != IND_CLOCK) break; //      
		}
	} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^



	//==========================================================================================================================
	//==========================================   =========================================================
	//==========================================================================================================================
	//           
	if ((devices >= 1) && (indicate == IND_CLOCK) && (t_ind_term != 0)) {
		for (i=0;i<devices;i++) {
			temperature=ds18x20_temperature(&rom_code[i][0]); 
			if (temperature!=-9999){yarkost_down(); view_term(); yarkost_up();}
			delay_100ms(tt3);
		}
	} //^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^




 } // -----------------------------   (end) ------------------------------------

} // =================================== end main ==========================================





//
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- The End -=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//