#define NE_LETO_NE_ZIMA 0
#define ZIMA 1
#define LETO 2

#define OFF 0
#define ON  1

//   

// 8 ,   = 2.56 
//#define ADC_VREF_TYPE 0xE0

// 8 ,   = AVCC
#define ADC_VREF_TYPE 0x60

// 8 ,   = AREF
//#define ADC_VREF_TYPE 0x20

// 10 ,   = 2.56 
//#define ADC_VREF_TYPE 0xC0

// 10 ,   = AVCC
//#define ADC_VREF_TYPE 0x40

// 10 ,   = AREF
//#define ADC_VREF_TYPE 0x00


#define A   1
#define B   4
#define C  16 
#define D  64  
#define E 128 
#define F   2 
#define G   8 

static flash unsigned char digits[] = {
	(A+B+C+D+E+F),   // 0
	(B+C),           // 1
	(A+B+D+E+G),     // 2
	(A+B+C+D+G),     // 3
	(B+C+F+G),       // 4
	(A+C+D+F+G),     // 5
	(A+C+D+E+F+G),   // 6
	(A+B+C),         // 7
	(A+B+C+D+E+F+G), // 8
	(A+B+C+D+F+G),   // 9
	(A+B+C+E+F+G),   // A - 10
	(C+D+E+F+G),     // b - 11
	(A+D+E+F),       // C - 12
	(B+C+D+E+G),     // d - 13
	(A+D+E+F+G),     // E - 14
	(A+E+F+G),       // F - 15
	(G),             // 16 -  
	(A+B+F+G),       // 17 -   
	(0),             // 18 - 
	(C+E+G),         // n
	(D+E+F+G)        // t
};

#define MINUS    16
#define GRADUS   17
#define PROBEL   18
#define SYMBOL_A 10
#define SYMBOL_B 11
#define SYMBOL_C 12
#define SYMBOL_D 13
#define SYMBOL_E 14
#define SYMBOL_F 15
#define SYMBOL_N 19
#define SYMBOL_T 20


//       
#define LED_s0   0     //  =  .0
#define LED_s1   1     //                        1
#define LED_r0   0     //  =  .0                    
#define LED_r1   1     //                       1

//  : -, -,   , 
//                   eeprom, .1 ,  .2 ,
//                  ., ., ., ., .,
//                  .  , .  ,
//                  .   
#define IND_CLOCK      0
#define IND_SEC        1
#define IND_K          2
#define IND_EEPROM     3
#define IND_TERM       4
#define IND_SET_H      5
#define IND_SET_M      6
#define IND_SET_YR     7
#define IND_SET_MN     8
#define IND_SET_DT     9
#define IND_SET_T1    10
#define IND_SET_T2    11
#define IND_SET_T3    12
#define IND_SET_AL1_H 13
#define IND_SET_AL1_M 14
#define IND_SET_AL2_H 15
#define IND_SET_AL2_M 16
#define IND_TEST_ADC0 17
#define IND_TEST_ADC1 18

// 
#define KEY_PLUS  1
#define KEY_MINUS 2
#define KEY_SEC   3
#define KEY_SET   4
#define KEY_K     5
#define KEY_AL1   6
#define KEY_AL2   7

//   DS1307    
#define MEM_CORECT        9
#define MEM_MONTH_CORECT 10
#define MEM_T_IND_CLOCK  11
#define MEM_T_IND_DATE   12
#define MEM_T_IND_TERM   13
#define MEM_AL1_H        14
#define MEM_AL1_M        15
#define MEM_AL2_H        16
#define MEM_AL2_M        17

#define PORT_ALARM_1KHZ  PORTD.5     //   1 
#define PORT_ALARM_BIPER PORTD.6     //     

#define LED_AL1  PORTC.2     //    1
#define LED_AL2  PORTC.3     //     --//--           2

unsigned char digit_out[5], //   (  0  3    )
                   cur_dig, // .  ()
                  indicate, // . (  = IND_CLOCK, ...)
                     zpt_4, //    (0 = 1 -  0 , 1 = 1 ...)
                 zpt_BLINK, // =1 -  
                    Corect, //  (.)
                      t2Hz, //     2 
         max_yarkost = 250, //    (    )
             yarkost = 250, //  
                   devices, // -   DS1820 / DS18S20 / DS18B20
                    num_DS, //   (     )
                   old_key, //   
                povtor_key; //   

unsigned int      key_time; //      


eeprom unsigned char //    eeprom
      eled_s @0x000,
      eled_r @0x001,
      ehour0 @0x002,
        edes @0x003,
  erushechki @0x004,
    efotorez @0x005,
    edubldot @0x006,
  eplusminus @0x007,
   etest_adc @0x008,
   ezimaleto @0x009,   
 emaxfotorez @0x00a,
  
efirst_start @0x1FF; //    

//        RAM
static unsigned char
  led_s, led_r, //     
         hour0, //       
           des, //     (  )
     rushechki, // "" (   )
       fotorez, //     
       dubldot, //        -   
     plusminus, // ""  / ( :   )
      zimaleto, //        (0xFF - , 0x00 - .)      
    maxfotorez, //      ( 50  200)
    num_eeprom; //       .EEPROM


int temperature; // ,    DS1820 / DS18S20 / DS18B20

unsigned char t_ind_clock, //    (.)
              t_ind_date, //    -- // --     
              t_ind_term; //    -- // --     

unsigned int  tc1, // -   
              td2; //    -- // --             
unsigned char tt3; //    -- // --             

//        ,   - 
unsigned char myhour, mymin, mysec,    //  
              mydate, mymonth, myyear, //  
              al1_h, al1_m,            // 1 
              al2_h, al2_m,            // 2 
              alarm_active = ON,       //                  
              last_sunday_March,       //   
              last_sunday_October,     // -- // --              
              month_corect;            //       / 

unsigned int count_1_min, //   2     1 
             count_2_sec, //         -- // --                          2 
             count_1_sec; //         -- // --                          1 

unsigned char t1kHz; //     1 


const unsigned char date_of_month[12]={31,28,31,30,31,30,31,31,30,31,30,31};

// maximum number of DS1820 / DS18S20 / DS18B20 connected to the 1 Wire bus
#define MAX_DEVICES 4

// DS1820 / DS18S20 / DS18B20 devices ROM code storage area
unsigned char rom_code[MAX_DEVICES][9];
