
;CodeVisionAVR C Compiler V2.05.0 Professional
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATtiny2313A
;Program type             : Application
;Clock frequency          : 8,000000 MHz
;Memory model             : Tiny
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 32 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : No
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATtiny2313A
	#pragma AVRPART MEMORY PROG_FLASH 2048
	#pragma AVRPART MEMORY EEPROM 128
	#pragma AVRPART MEMORY INT_SRAM SIZE 223
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU WDTCR=0x21
	.EQU MCUSR=0x34
	.EQU MCUCR=0x35
	.EQU SPL=0x3D
	.EQU SREG=0x3F
	.EQU GPIOR0=0x13
	.EQU GPIOR1=0x14
	.EQU GPIOR2=0x15

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x00DF
	.EQU __DSTACK_SIZE=0x0020
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOV  R26,R@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	SUBI R26,-@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _ESDAddress=R3
	.DEF _SwapData=R4
	.DEF _Countdown=R6
	.DEF _SetProg=R8
	.DEF _Item=R2
	.DEF _Iteration1=R11
	.DEF _Iteration2=R10
	.DEF _Iteration3=R13

;GPIOR0-GPIOR2 INITIALIZATION VALUES
	.EQU __GPIOR0_INIT=0x00
	.EQU __GPIOR1_INIT=0x00
	.EQU __GPIOR2_INIT=0x00

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP _ext_int0_isr
	RJMP 0x00
	RJMP 0x00
	RJMP _timer1_compa_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_0x3:
	.DB  0x3F,0x3E,0x1,0x3F,0x3E
_0x2000060:
	.DB  0x1
_0x2000000:
	.DB  0x2D,0x4E,0x41,0x4E,0x0,0x49,0x4E,0x46
	.DB  0x0

__GLOBAL_INI_TBL:
	.DW  0x05
	.DW  _StarLights
	.DW  _0x3*2

	.DW  0x01
	.DW  __seed_G100
	.DW  _0x2000060*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	IN   R26,MCUSR
	CBR  R26,8
	OUT  MCUSR,R26
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,__CLEAR_SRAM_SIZE
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;GPIOR0-GPIOR2 INITIALIZATION
	LDI  R30,__GPIOR0_INIT
	OUT  GPIOR0,R30
	;__GPIOR1_INIT = __GPIOR0_INIT
	OUT  GPIOR1,R30
	;__GPIOR2_INIT = __GPIOR0_INIT
	OUT  GPIOR2,R30

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x80

	.CSEG
;/*****************************************************
;Project :       ""
;Version :   1.3.1
;Date    :   22.02.2016
;Author  :   Ramm-SD
;Comments:   6  : 5  (PB1-PB5) + 1  (PB0)
;            Int0 -   
;            - : 19
;             
;
;Chip type               : ATtiny2313A
;AVR Core Clock frequency: 8,000000 MHz
;Memory model            : Tiny
;External RAM size       : 0
;Data Stack size         : 32
;*****************************************************/
;
;/*****************************************************
;   EEPROM:
;
; 0 - :
;0 -  
;1 -     ( )
;2 -  
;3 -  
;4 -  
;5 -  
;6 -  
;7 -  
;8 -  
;9 -  
;A -  
;B -  
;C -  
;D -  
;E -  
;F -  
;
; 1-7 -    .    2  .    8 :
;0 -     EEPROM:  
;1 -     EEPROM:  
;2 -   
;3 -     :  
;4 -     :  
;5 -  
;6 -  
;7 -  
;*****************************************************/
;
;#include <tiny2313a.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x50
	.EQU __sm_powerdown=0x10
	.EQU __sm_standby=0x40
	.SET power_ctrl_reg=mcucr
	#endif
;#include <delay.h>
;#include <stdlib.h>
;
;//   EEPROM
;//  
;eeprom unsigned char EEPMaintCounter @0x00;
;//     
;eeprom unsigned char EEPTime @0x01;
;//    
;eeprom unsigned char EEPSaveData[14][8] @0x10;
;
;//  
;//      
;unsigned char ESDAddress;
;//     
;unsigned int SwapData;
;//      
;signed int Countdown;
;//    
;signed int SetProg;
;//    
;unsigned char StarLights[6]={
;    0b00111111,0b00111110,0b00000001,0b00111111,0b00111110,0b00000000
;};

	.DSEG
;//   
;unsigned char Item;
;//    
;unsigned char Iteration1;
;unsigned char Iteration2;
;unsigned char Iteration3;
;
;// Int0  
;interrupt [EXT_INT0] void ext_int0_isr(void){
; 0000 0053 interrupt [2] void ext_int0_isr(void){

	.CSEG
_ext_int0_isr:
	ST   -Y,R30
	ST   -Y,R31
; 0000 0054     SetProg=2;
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	MOVW R8,R30
; 0000 0055 }
	LD   R31,Y+
	LD   R30,Y+
	RETI
;
;// Timer1      
;interrupt [TIM1_COMPA] void timer1_compa_isr(void){
; 0000 0058 interrupt [5] void timer1_compa_isr(void){
_timer1_compa_isr:
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0059     Countdown++;
	MOVW R30,R6
	ADIW R30,1
	MOVW R6,R30
; 0000 005A }
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	RETI
;
;//     EEPROM
;void SaveData(void){
; 0000 005D void SaveData(void){
_SaveData:
; 0000 005E     if(EEPSaveData[ESDAddress][0]==0xFF){
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0x1
	CPI  R30,LOW(0xFF)
	BRNE _0x4
; 0000 005F         if(EEPSaveData[ESDAddress][1]==0xFF){
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0x2
	CPI  R30,LOW(0xFF)
	BRNE _0x5
; 0000 0060             EEPMaintCounter++;
	RCALL SUBOPT_0x3
	RCALL SUBOPT_0x4
; 0000 0061             ESDAddress=EEPMaintCounter;
	RCALL SUBOPT_0x3
	MOV  R3,R30
; 0000 0062             if(EEPMaintCounter>=14)ESDAddress=ESDAddress-14;
	RCALL SUBOPT_0x3
	CPI  R30,LOW(0xE)
	BRLO _0x6
	LDI  R30,LOW(14)
	SUB  R3,R30
; 0000 0063         }
_0x6:
; 0000 0064         EEPSaveData[ESDAddress][1]++;
_0x5:
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x4
; 0000 0065     }
; 0000 0066     EEPSaveData[ESDAddress][0]++;
_0x4:
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0x1
	RCALL SUBOPT_0x4
; 0000 0067     EEPSaveData[ESDAddress][2]=Item;
	RCALL SUBOPT_0x0
	__ADDW1MN _EEPSaveData,2
	MOVW R26,R30
	MOV  R30,R2
	RCALL __EEPROMWRB
; 0000 0068     EEPSaveData[ESDAddress][3]=rand()%256;
	RCALL SUBOPT_0x0
	__ADDW1MN _EEPSaveData,3
	PUSH R31
	PUSH R30
	RCALL _rand
	POP  R26
	POP  R27
	RCALL __EEPROMWRB
; 0000 0069     EEPSaveData[ESDAddress][4]=rand()%256;
	RCALL SUBOPT_0x0
	__ADDW1MN _EEPSaveData,4
	PUSH R31
	PUSH R30
	RCALL _rand
	POP  R26
	POP  R27
	RCALL __EEPROMWRB
; 0000 006A }
	RET
;
;//      
;void StartData(void){
; 0000 006D void StartData(void){
_StartData:
; 0000 006E     if(Item>18)Item=0;
	LDI  R30,LOW(18)
	CP   R30,R2
	BRSH _0x7
	CLR  R2
; 0000 006F     //    
; 0000 0070     switch (Item){
_0x7:
	MOV  R30,R2
; 0000 0071         case 0:
	CPI  R30,0
	BREQ _0xC
; 0000 0072         case 2:
	CPI  R30,LOW(0x2)
	BRNE _0xD
_0xC:
; 0000 0073         case 6:
	RJMP _0xE
_0xD:
	CPI  R30,LOW(0x6)
	BRNE _0xF
_0xE:
; 0000 0074         case 7:
	RJMP _0x10
_0xF:
	CPI  R30,LOW(0x7)
	BRNE _0x11
_0x10:
; 0000 0075             PORTB=0b00111111;
	LDI  R30,LOW(63)
	OUT  0x18,R30
; 0000 0076             Iteration1=0;
	CLR  R11
; 0000 0077             Iteration2=2;
	LDI  R30,LOW(2)
	RJMP _0x71
; 0000 0078         break;
; 0000 0079         case 1:
_0x11:
	CPI  R30,LOW(0x1)
	BRNE _0x12
; 0000 007A             PORTB=0b00111110;
	LDI  R30,LOW(62)
	OUT  0x18,R30
; 0000 007B         break;
	RJMP _0xA
; 0000 007C         case 3:
_0x12:
	CPI  R30,LOW(0x3)
	BREQ _0x14
; 0000 007D         case 4:
	CPI  R30,LOW(0x4)
	BRNE _0x15
_0x14:
; 0000 007E         case 5:
	RJMP _0x16
_0x15:
	CPI  R30,LOW(0x5)
	BRNE _0x17
_0x16:
; 0000 007F         case 8:
	RJMP _0x18
_0x17:
	CPI  R30,LOW(0x8)
	BRNE _0x19
_0x18:
; 0000 0080         case 9:
	RJMP _0x1A
_0x19:
	CPI  R30,LOW(0x9)
	BRNE _0x1B
_0x1A:
; 0000 0081         case 10:
	RJMP _0x1C
_0x1B:
	CPI  R30,LOW(0xA)
	BRNE _0x1D
_0x1C:
; 0000 0082         case 16:
	RJMP _0x1E
_0x1D:
	CPI  R30,LOW(0x10)
	BRNE _0x1F
_0x1E:
; 0000 0083         case 17:
	RJMP _0x20
_0x1F:
	CPI  R30,LOW(0x11)
	BRNE _0x21
_0x20:
; 0000 0084         case 18:
	RJMP _0x22
_0x21:
	CPI  R30,LOW(0x12)
	BRNE _0x23
_0x22:
; 0000 0085             PORTB=0b00000000;
	RCALL SUBOPT_0x5
; 0000 0086             Iteration1=0;
	RCALL SUBOPT_0x6
; 0000 0087             Iteration2=0;
; 0000 0088             Iteration3=5;
; 0000 0089         break;
	RJMP _0xA
; 0000 008A         case 11:
_0x23:
	CPI  R30,LOW(0xB)
	BREQ _0x25
; 0000 008B         case 12:
	CPI  R30,LOW(0xC)
	BRNE _0xA
_0x25:
; 0000 008C             PORTB=0b00000000;
	RCALL SUBOPT_0x5
; 0000 008D             Iteration1=1;
	LDI  R30,LOW(1)
	MOV  R11,R30
; 0000 008E             Iteration2=3;
	LDI  R30,LOW(3)
_0x71:
	MOV  R10,R30
; 0000 008F         break;
; 0000 0090     };
_0xA:
; 0000 0091     Countdown=0;
	CLR  R6
	CLR  R7
; 0000 0092 }
	RET
;
;//  
;void main(void){
; 0000 0095 void main(void){
_main:
; 0000 0096     //  
; 0000 0097     //      
; 0000 0098     signed int TimeToChange;
; 0000 0099 
; 0000 009A     // Crystal Oscillator division factor: 1
; 0000 009B     #pragma optsize-
; 0000 009C     CLKPR=0x80;
;	TimeToChange -> R16,R17
	LDI  R30,LOW(128)
	OUT  0x26,R30
; 0000 009D     CLKPR=0x00;
	LDI  R30,LOW(0)
	OUT  0x26,R30
; 0000 009E     #ifdef _OPTIMIZE_SIZE_
; 0000 009F     #pragma optsize+
; 0000 00A0     #endif
; 0000 00A1 
; 0000 00A2     //   A     
; 0000 00A3     PORTD=0b00000111;
	LDI  R30,LOW(7)
	OUT  0x12,R30
; 0000 00A4     DDRD=0b00000000;
	LDI  R30,LOW(0)
	OUT  0x11,R30
; 0000 00A5 
; 0000 00A6     //     
; 0000 00A7     PORTB=0b00000000;
	RCALL SUBOPT_0x5
; 0000 00A8     DDRB=0b11111111;
	LDI  R30,LOW(255)
	OUT  0x17,R30
; 0000 00A9 
; 0000 00AA     //   D     
; 0000 00AB     PORTD=0b01111111;
	LDI  R30,LOW(127)
	OUT  0x12,R30
; 0000 00AC     DDRD=0b00000000;
	LDI  R30,LOW(0)
	OUT  0x11,R30
; 0000 00AD 
; 0000 00AE     //    Timer/Counter 1
; 0000 00AF     // : 7813 
; 0000 00B0     TCCR1A=0x00;
	OUT  0x2F,R30
; 0000 00B1     TCCR1B=0x0D;
	LDI  R30,LOW(13)
	OUT  0x2E,R30
; 0000 00B2     TCNT1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
; 0000 00B3     TCNT1L=0x00;
	OUT  0x2C,R30
; 0000 00B4     ICR1H=0x00;
	OUT  0x25,R30
; 0000 00B5     ICR1L=0x00;
	OUT  0x24,R30
; 0000 00B6     OCR1AH=0x1E;
	LDI  R30,LOW(30)
	OUT  0x2B,R30
; 0000 00B7     OCR1AL=0x85;
	LDI  R30,LOW(133)
	OUT  0x2A,R30
; 0000 00B8     OCR1BH=0x00;
	LDI  R30,LOW(0)
	OUT  0x29,R30
; 0000 00B9     OCR1BL=0x00;
	OUT  0x28,R30
; 0000 00BA 
; 0000 00BB     //    
; 0000 00BC     // Int0 - Falling edge
; 0000 00BD     // Timer1 - 
; 0000 00BE     GIMSK=0x40;
	LDI  R30,LOW(64)
	OUT  0x3B,R30
; 0000 00BF     MCUCR=0x02;
	LDI  R30,LOW(2)
	OUT  0x35,R30
; 0000 00C0     EIFR=0x40;
	LDI  R30,LOW(64)
	OUT  0x3A,R30
; 0000 00C1     TIMSK=0x40;
	OUT  0x39,R30
; 0000 00C2 
; 0000 00C3     //  
; 0000 00C4     PORTB=0b00111111;delay_ms(1000);
	RCALL SUBOPT_0x7
; 0000 00C5     PORTB=0b00000000;delay_ms(1000);
	RCALL SUBOPT_0x8
; 0000 00C6 
; 0000 00C7     //  
; 0000 00C8     #asm("sei")
	sei
; 0000 00C9 
; 0000 00CA     //  
; 0000 00CB     //    EEPROM
; 0000 00CC     if(EEPMaintCounter==0xFF){
	RCALL SUBOPT_0x3
	CPI  R30,LOW(0xFF)
	BRNE _0x27
; 0000 00CD         EEPMaintCounter=0;
	LDI  R26,LOW(_EEPMaintCounter)
	LDI  R27,HIGH(_EEPMaintCounter)
	LDI  R30,LOW(0)
	RCALL __EEPROMWRB
; 0000 00CE         EEPSaveData[0][0]=0;
	LDI  R26,LOW(_EEPSaveData)
	LDI  R27,HIGH(_EEPSaveData)
	RCALL __EEPROMWRB
; 0000 00CF         EEPSaveData[0][1]=0;
	__POINTW2MN _EEPSaveData,1
	RCALL __EEPROMWRB
; 0000 00D0         EEPSaveData[0][2]=1;
	__POINTW2MN _EEPSaveData,2
	LDI  R30,LOW(1)
	RCALL __EEPROMWRB
; 0000 00D1     }
; 0000 00D2     if((EEPTime<5)||(EEPTime==0xFF)){
_0x27:
	RCALL SUBOPT_0x9
	RCALL __EEPROMRDB
	CPI  R30,LOW(0x5)
	BRLO _0x29
	CPI  R30,LOW(0xFF)
	BRNE _0x28
_0x29:
; 0000 00D3         EEPTime=10;
	RCALL SUBOPT_0x9
	LDI  R30,LOW(10)
	RCALL __EEPROMWRB
; 0000 00D4     }
; 0000 00D5     //     EEPROM
; 0000 00D6     ESDAddress=EEPMaintCounter;
_0x28:
	RCALL SUBOPT_0x3
	MOV  R3,R30
; 0000 00D7     if(EEPMaintCounter>=14)ESDAddress=ESDAddress-14;
	RCALL SUBOPT_0x3
	CPI  R30,LOW(0xE)
	BRLO _0x2B
	LDI  R30,LOW(14)
	SUB  R3,R30
; 0000 00D8     TimeToChange=60*(signed int)EEPTime;
_0x2B:
	RCALL SUBOPT_0x9
	RCALL SUBOPT_0xA
	LDI  R26,LOW(60)
	LDI  R27,HIGH(60)
	RCALL __MULW12
	MOVW R16,R30
; 0000 00D9     Item=EEPSaveData[ESDAddress][2];
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0xB
	MOV  R2,R30
; 0000 00DA     SwapData=EEPSaveData[ESDAddress][4];
	RCALL SUBOPT_0x0
	__ADDW1MN _EEPSaveData,4
	MOVW R26,R30
	RCALL __EEPROMRDB
	MOV  R4,R30
	CLR  R5
; 0000 00DB     SwapData=SwapData<<8|EEPSaveData[ESDAddress][3];
	MOV  R31,R4
	LDI  R30,LOW(0)
	MOVW R0,R30
	RCALL SUBOPT_0x0
	__ADDW1MN _EEPSaveData,3
	MOVW R26,R30
	RCALL SUBOPT_0xA
	OR   R30,R0
	OR   R31,R1
	MOVW R4,R30
; 0000 00DC     srand(SwapData);
	ST   -Y,R5
	ST   -Y,R4
	RCALL _srand
; 0000 00DD     StartData();
	RCALL _StartData
; 0000 00DE 
; 0000 00DF     //  
; 0000 00E0     while (1){
_0x2C:
; 0000 00E1         //    
; 0000 00E2         if(SetProg==2){
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CP   R30,R8
	CPC  R31,R9
	BRNE _0x2F
; 0000 00E3             Item++;
	INC  R2
; 0000 00E4             SetProg--;
	MOVW R30,R8
	SBIW R30,1
	MOVW R8,R30
; 0000 00E5             StartData();
	RCALL _StartData
; 0000 00E6         }
; 0000 00E7         //         EEPROM
; 0000 00E8         if((Countdown>=TimeToChange)&&(EEPTime<251)){
_0x2F:
	__CPWRR 6,7,16,17
	BRLT _0x31
	RCALL SUBOPT_0x9
	RCALL __EEPROMRDB
	CPI  R30,LOW(0xFB)
	BRLO _0x32
_0x31:
	RJMP _0x30
_0x32:
; 0000 00E9             do{
_0x34:
; 0000 00EA                 Item=rand()%19;
	RCALL SUBOPT_0xC
	LDI  R30,LOW(19)
	LDI  R31,HIGH(19)
	RCALL __MODW21
	MOV  R2,R30
; 0000 00EB             }while (Item==EEPSaveData[ESDAddress][2]);
	RCALL SUBOPT_0x0
	RCALL SUBOPT_0xB
	CP   R30,R2
	BREQ _0x34
; 0000 00EC             StartData();
	RCALL _StartData
; 0000 00ED             SaveData();
	RCALL _SaveData
; 0000 00EE         }
; 0000 00EF         //    EEPROM  5    
; 0000 00F0         if((SetProg==1)&&(Countdown>=300)){
_0x30:
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	CP   R30,R8
	CPC  R31,R9
	BRNE _0x37
	LDI  R30,LOW(300)
	LDI  R31,HIGH(300)
	CP   R6,R30
	CPC  R7,R31
	BRGE _0x38
_0x37:
	RJMP _0x36
_0x38:
; 0000 00F1             SaveData();
	RCALL _SaveData
; 0000 00F2             SetProg=0;
	CLR  R8
	CLR  R9
; 0000 00F3         }
; 0000 00F4         //    EEPROM  30   ,  ,   
; 0000 00F5         if((EEPTime>250)&&(Countdown>=1800)&&(Item>13)){
_0x36:
	RCALL SUBOPT_0x9
	RCALL __EEPROMRDB
	CPI  R30,LOW(0xFB)
	BRLO _0x3A
	LDI  R30,LOW(1800)
	LDI  R31,HIGH(1800)
	CP   R6,R30
	CPC  R7,R31
	BRLT _0x3A
	LDI  R30,LOW(13)
	CP   R30,R2
	BRLO _0x3B
_0x3A:
	RJMP _0x39
_0x3B:
; 0000 00F6             SaveData();
	RCALL _SaveData
; 0000 00F7             Countdown=0;
	CLR  R6
	CLR  R7
; 0000 00F8         }
; 0000 00F9         // 
; 0000 00FA         switch (Item){
_0x39:
	MOV  R30,R2
; 0000 00FB             case 0:
	CPI  R30,0
	BREQ _0x40
; 0000 00FC             //  0
; 0000 00FD             // : /  
; 0000 00FE             case 1:
	CPI  R30,LOW(0x1)
	BRNE _0x41
_0x40:
; 0000 00FF             //  1
; 0000 0100             // :  /
; 0000 0101                 PORTB^=0b00111111;
	IN   R30,0x18
	LDI  R26,LOW(63)
	RCALL SUBOPT_0xD
; 0000 0102                 delay_ms(2000);
	LDI  R30,LOW(2000)
	LDI  R31,HIGH(2000)
	RJMP _0x72
; 0000 0103             break;
; 0000 0104             case 2:
_0x41:
	CPI  R30,LOW(0x2)
	BRNE _0x42
; 0000 0105             //  2
; 0000 0106             //  :  
; 0000 0107                 Iteration1++;
	INC  R11
; 0000 0108                 if(Iteration1>2)Iteration1=0;
	LDI  R30,LOW(2)
	CP   R30,R11
	BRSH _0x43
	CLR  R11
; 0000 0109                 PORTB=StarLights[Iteration1];
_0x43:
	LDI  R26,LOW(_StarLights)
	ADD  R26,R11
	LD   R30,X
	OUT  0x18,R30
; 0000 010A                 if(Iteration1==0)delay_ms(2000);
	TST  R11
	BRNE _0x44
	LDI  R30,LOW(2000)
	LDI  R31,HIGH(2000)
	RCALL SUBOPT_0xE
; 0000 010B                 delay_ms(100);
_0x44:
	RCALL SUBOPT_0xF
	RJMP _0x72
; 0000 010C             break;
; 0000 010D             case 3:
_0x42:
	CPI  R30,LOW(0x3)
	BRNE _0x45
; 0000 010E             //  3
; 0000 010F             //  : 
; 0000 0110                 Iteration3++;
	INC  R13
; 0000 0111                 if(Iteration3>5)Iteration3=2;
	LDI  R30,LOW(5)
	CP   R30,R13
	BRSH _0x46
	LDI  R30,LOW(2)
	MOV  R13,R30
; 0000 0112                 PORTB=StarLights[Iteration3];
_0x46:
	RCALL SUBOPT_0x10
; 0000 0113                 if(Iteration3==5)delay_ms(300);
	BRNE _0x47
	LDI  R30,LOW(300)
	LDI  R31,HIGH(300)
	RCALL SUBOPT_0xE
; 0000 0114                 delay_ms(150);
_0x47:
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	RJMP _0x72
; 0000 0115             break;
; 0000 0116             case 4:
_0x45:
	CPI  R30,LOW(0x4)
	BRNE _0x48
; 0000 0117             //  4
; 0000 0118             //  :  
; 0000 0119                 Iteration3--;
	DEC  R13
; 0000 011A                 if(Iteration3<2)Iteration3=5;
	LDI  R30,LOW(2)
	CP   R13,R30
	BRSH _0x49
	LDI  R30,LOW(5)
	MOV  R13,R30
; 0000 011B                 PORTB=StarLights[Iteration3];
_0x49:
	RCALL SUBOPT_0x10
; 0000 011C                 if(Iteration3==5)delay_ms(300);
	BRNE _0x4A
	LDI  R30,LOW(300)
	LDI  R31,HIGH(300)
	RCALL SUBOPT_0xE
; 0000 011D                 delay_ms(150);
_0x4A:
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	RJMP _0x72
; 0000 011E             break;
; 0000 011F             case 5:
_0x48:
	CPI  R30,LOW(0x5)
	BRNE _0x4B
; 0000 0120             //  5
; 0000 0121             //  : 
; 0000 0122                 Iteration1=rand()%5+1;
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0x11
; 0000 0123                 for (Iteration3=0;Iteration3<2;Iteration3++){
_0x4D:
	LDI  R30,LOW(2)
	CP   R13,R30
	BRSH _0x4E
; 0000 0124                     PORTB^=0b00000001;
	RCALL SUBOPT_0x12
; 0000 0125                     delay_ms(70);
	LDI  R30,LOW(70)
	LDI  R31,HIGH(70)
	RCALL SUBOPT_0xE
; 0000 0126                     PORTB^=1<<Iteration1;
	RCALL SUBOPT_0x13
; 0000 0127                     delay_ms(70);
	LDI  R30,LOW(70)
	LDI  R31,HIGH(70)
	RCALL SUBOPT_0xE
; 0000 0128                 }
	INC  R13
	RJMP _0x4D
_0x4E:
; 0000 0129                 delay_ms(200);
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	RJMP _0x72
; 0000 012A             break;
; 0000 012B             case 6:
_0x4B:
	CPI  R30,LOW(0x6)
	BRNE _0x4F
; 0000 012C             //  6
; 0000 012D             //  :  
; 0000 012E                 Iteration1++;
	INC  R11
; 0000 012F                 Iteration2++;
	INC  R10
; 0000 0130                 if(Iteration1>5)Iteration1=1;
	LDI  R30,LOW(5)
	CP   R30,R11
	BRSH _0x50
	LDI  R30,LOW(1)
	MOV  R11,R30
; 0000 0131                 if(Iteration2>5)Iteration2=1;
_0x50:
	LDI  R30,LOW(5)
	CP   R30,R10
	BRSH _0x51
	LDI  R30,LOW(1)
	MOV  R10,R30
; 0000 0132                 PORTB=0b00111111^(1<<Iteration1|1<<Iteration2);
_0x51:
	MOV  R30,R11
	RCALL SUBOPT_0x14
	MOV  R1,R30
	RCALL SUBOPT_0x15
	OR   R30,R1
	LDI  R26,LOW(63)
	RCALL SUBOPT_0xD
; 0000 0133                 delay_ms(150);
	LDI  R30,LOW(150)
	LDI  R31,HIGH(150)
	RJMP _0x72
; 0000 0134             break;
; 0000 0135             case 7:
_0x4F:
	CPI  R30,LOW(0x7)
	BREQ _0x53
; 0000 0136             //  7
; 0000 0137             //  : ""
; 0000 0138             case 8:
	CPI  R30,LOW(0x8)
	BRNE _0x54
_0x53:
; 0000 0139             //  8
; 0000 013A             //  : "-2"
; 0000 013B                 PORTB^=1<<Iteration1;
	RCALL SUBOPT_0x13
; 0000 013C                 Iteration1++;
	INC  R11
; 0000 013D                 if(Iteration1>5){
	LDI  R30,LOW(5)
	CP   R30,R11
	BRSH _0x55
; 0000 013E                     Iteration1=1;
	LDI  R30,LOW(1)
	MOV  R11,R30
; 0000 013F                     PORTB^=0b00000001;
	RCALL SUBOPT_0x12
; 0000 0140                 }
; 0000 0141                 PORTB^=1<<Iteration1;
_0x55:
	RCALL SUBOPT_0x13
; 0000 0142                 delay_ms(90);
	LDI  R30,LOW(90)
	LDI  R31,HIGH(90)
	RJMP _0x72
; 0000 0143             break;
; 0000 0144             case 9:
_0x54:
	CPI  R30,LOW(0x9)
	BRNE _0x56
; 0000 0145             //  9
; 0000 0146             //  : 
; 0000 0147                 if(Iteration2==Iteration3){
	CP   R13,R10
	BRNE _0x57
; 0000 0148                     Iteration1^=1<<Iteration2;
	RCALL SUBOPT_0x15
	EOR  R11,R30
; 0000 0149                     PORTB=Iteration1;
	OUT  0x18,R11
; 0000 014A                     Iteration2=0;
	CLR  R10
; 0000 014B                     Iteration3--;
	DEC  R13
; 0000 014C                     delay_ms(1000);
	RCALL SUBOPT_0x8
; 0000 014D                 }
; 0000 014E                 else{
	RJMP _0x58
_0x57:
; 0000 014F                     PORTB=Iteration1|1<<Iteration2;
	RCALL SUBOPT_0x15
	OR   R30,R11
	OUT  0x18,R30
; 0000 0150                     delay_ms(100);
	RCALL SUBOPT_0x16
; 0000 0151                     Iteration2++;
	INC  R10
; 0000 0152                 };
_0x58:
; 0000 0153                 if(Iteration3==0){
	TST  R13
	BRNE _0x59
; 0000 0154                     Iteration1=0;
	RCALL SUBOPT_0x6
; 0000 0155                     Iteration2=0;
; 0000 0156                     Iteration3=5;
; 0000 0157                     PORTB=0b00111111;
	RCALL SUBOPT_0x7
; 0000 0158                     delay_ms(1000);
; 0000 0159                     PORTB=0b00000000;
; 0000 015A                     delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	RCALL SUBOPT_0xE
; 0000 015B                 }
; 0000 015C             break;
_0x59:
	RJMP _0x3E
; 0000 015D             case 10:
_0x56:
	CPI  R30,LOW(0xA)
	BRNE _0x5A
; 0000 015E             //  10
; 0000 015F             //  : 
; 0000 0160                 Iteration1++;
	INC  R11
; 0000 0161                 if(Iteration1>5)Iteration1=0;
	LDI  R30,LOW(5)
	CP   R30,R11
	BRSH _0x5B
	CLR  R11
; 0000 0162                 PORTB^=1<<Iteration1;
_0x5B:
	RCALL SUBOPT_0x13
; 0000 0163                 delay_ms(100);
	RCALL SUBOPT_0xF
	RJMP _0x72
; 0000 0164             break;
; 0000 0165             case 11:
_0x5A:
	CPI  R30,LOW(0xB)
	BRNE _0x5C
; 0000 0166             //  11
; 0000 0167             //  : -2
; 0000 0168                 Iteration1--;
	DEC  R11
; 0000 0169                 PORTB^=1<<Iteration1;
	RCALL SUBOPT_0x13
; 0000 016A                 if(Iteration1==0)Iteration1=6;
	TST  R11
	BRNE _0x5D
	LDI  R30,LOW(6)
	MOV  R11,R30
; 0000 016B                 delay_ms(100);
_0x5D:
	RCALL SUBOPT_0xF
	RJMP _0x72
; 0000 016C             break;
; 0000 016D             case 12:
_0x5C:
	CPI  R30,LOW(0xC)
	BRNE _0x5E
; 0000 016E             //  12
; 0000 016F             //  :  
; 0000 0170                 for (Iteration3=0;Iteration3<2;Iteration3++){
	CLR  R13
_0x60:
	LDI  R30,LOW(2)
	CP   R13,R30
	BRSH _0x61
; 0000 0171                     PORTB^=1<<Iteration1;
	RCALL SUBOPT_0x13
; 0000 0172                     delay_ms(100);
	RCALL SUBOPT_0x16
; 0000 0173                     PORTB^=0b00000001;
	RCALL SUBOPT_0x12
; 0000 0174                     delay_ms(100);
	RCALL SUBOPT_0x16
; 0000 0175                     PORTB^=1<<Iteration2;
	IN   R1,24
	RCALL SUBOPT_0x15
	EOR  R30,R1
	OUT  0x18,R30
; 0000 0176                     delay_ms(100);
	RCALL SUBOPT_0x16
; 0000 0177                 }
	INC  R13
	RJMP _0x60
_0x61:
; 0000 0178                 Iteration3=Iteration1;
	MOV  R13,R11
; 0000 0179                 Iteration1=Iteration2;
	MOV  R11,R10
; 0000 017A                 Iteration3--;
	DEC  R13
; 0000 017B                 Iteration2=Iteration3;
	MOV  R10,R13
; 0000 017C                 if(Iteration2<1)Iteration2=5;
	LDI  R30,LOW(1)
	CP   R10,R30
	BRSH _0x62
	LDI  R30,LOW(5)
	MOV  R10,R30
; 0000 017D             break;
_0x62:
	RJMP _0x3E
; 0000 017E             case 13:
_0x5E:
	CPI  R30,LOW(0xD)
	BRNE _0x63
; 0000 017F             //  13
; 0000 0180             //  
; 0000 0181                 PORTB++;
	IN   R30,0x18
	SUBI R30,-LOW(1)
	OUT  0x18,R30
; 0000 0182                 if(PORTB>63)PORTB=0;
	IN   R30,0x18
	CPI  R30,LOW(0x40)
	BRLO _0x64
	RCALL SUBOPT_0x5
; 0000 0183                 delay_ms(500);
_0x64:
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	RJMP _0x72
; 0000 0184             break;
; 0000 0185             case 14:
_0x63:
	CPI  R30,LOW(0xE)
	BRNE _0x65
; 0000 0186             //  14
; 0000 0187             // 
; 0000 0188                 PORTB^=0b01000000>>(rand()%6+1);
	IN   R30,0x18
	PUSH R30
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0x17
	POP  R26
	RCALL SUBOPT_0xD
; 0000 0189                 delay_ms(1000);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	RJMP _0x72
; 0000 018A             break;
; 0000 018B             case 15:
_0x65:
	CPI  R30,LOW(0xF)
	BRNE _0x66
; 0000 018C             //  15
; 0000 018D             // -2
; 0000 018E                 PORTB=rand()%64;
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0x18
; 0000 018F                 delay_ms(1000);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	RJMP _0x72
; 0000 0190             break;
; 0000 0191             case 16:
_0x66:
	CPI  R30,LOW(0x10)
	BRNE _0x67
; 0000 0192             //  16
; 0000 0193             //  (  )
; 0000 0194                 PORTB^=0b01000000>>(rand()%6+1);
	IN   R30,0x18
	PUSH R30
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0x17
	POP  R26
	RCALL SUBOPT_0xD
; 0000 0195                 delay_ms(20);
	RCALL SUBOPT_0x19
; 0000 0196                 PORTB=0b00000000;
	RCALL SUBOPT_0x5
; 0000 0197                 delay_ms(1000);
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	RJMP _0x72
; 0000 0198             break;
; 0000 0199             case 17:
_0x67:
	CPI  R30,LOW(0x11)
	BRNE _0x68
; 0000 019A             //  17
; 0000 019B             //   (         )
; 0000 019C                 Iteration1=rand()%5+1;
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0x11
; 0000 019D                 for (Iteration3=0;Iteration3<Iteration1;Iteration3++){
_0x6A:
	CP   R13,R11
	BRSH _0x6B
; 0000 019E                     PORTB=0b01000000>>(rand()%6+1);
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0x17
	OUT  0x18,R30
; 0000 019F                     delay_ms(20);
	RCALL SUBOPT_0x19
; 0000 01A0                     PORTB=0b00000000;
	RCALL SUBOPT_0x5
; 0000 01A1                     delay_ms(50);
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	RCALL SUBOPT_0xE
; 0000 01A2                 }
	INC  R13
	RJMP _0x6A
_0x6B:
; 0000 01A3                 delay_ms(rand()%2500+500);
	RCALL SUBOPT_0xC
	LDI  R30,LOW(2500)
	LDI  R31,HIGH(2500)
	RJMP _0x73
; 0000 01A4             break;
; 0000 01A5             case 18:
_0x68:
	CPI  R30,LOW(0x12)
	BRNE _0x3E
; 0000 01A6             //  18
; 0000 01A7             //    (         )
; 0000 01A8                 Iteration1=rand()%2+2;
	RCALL SUBOPT_0xC
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	RCALL __MODW21
	SUBI R30,-LOW(2)
	MOV  R11,R30
; 0000 01A9                 for (Iteration3=0;Iteration3<Iteration1;Iteration3++){
	CLR  R13
_0x6E:
	CP   R13,R11
	BRSH _0x6F
; 0000 01AA                     PORTB=rand()%64;
	RCALL SUBOPT_0xC
	RCALL SUBOPT_0x18
; 0000 01AB                     delay_ms(20);
	RCALL SUBOPT_0x19
; 0000 01AC                     PORTB=0b00000000;
	RCALL SUBOPT_0x5
; 0000 01AD                     delay_ms(50);
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	RCALL SUBOPT_0xE
; 0000 01AE                 }
	INC  R13
	RJMP _0x6E
_0x6F:
; 0000 01AF                 delay_ms(rand()%1500+500);
	RCALL SUBOPT_0xC
	LDI  R30,LOW(1500)
	LDI  R31,HIGH(1500)
_0x73:
	RCALL __MODW21
	SUBI R30,LOW(-500)
	SBCI R31,HIGH(-500)
_0x72:
	ST   -Y,R31
	ST   -Y,R30
	RCALL _delay_ms
; 0000 01B0             break;
; 0000 01B1         };
_0x3E:
; 0000 01B2     }
	RJMP _0x2C
; 0000 01B3 }
_0x70:
	RJMP _0x70

	.CSEG

	.DSEG

	.CSEG
_srand:
	LD   R30,Y
	LDD  R31,Y+1
	RCALL __CWD1
	RCALL SUBOPT_0x1A
	ADIW R28,2
	RET
_rand:
	LDS  R30,__seed_G100
	LDS  R31,__seed_G100+1
	LDS  R22,__seed_G100+2
	LDS  R23,__seed_G100+3
	__GETD2N 0x41C64E6D
	RCALL __MULD12U
	__ADDD1N 30562
	RCALL SUBOPT_0x1A
	movw r30,r22
	andi r31,0x7F
	RET

	.CSEG

	.CSEG

	.CSEG

	.ESEG

	.ORG 0x0
_EEPMaintCounter:
	.BYTE 0x1

	.ORG 0x0

	.ORG 0x1
_EEPTime:
	.BYTE 0x1

	.ORG 0x0

	.ORG 0x10
_EEPSaveData:
	.BYTE 0x70

	.ORG 0x0

	.DSEG
_StarLights:
	.BYTE 0x6
__seed_G100:
	.BYTE 0x4

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:38 WORDS
SUBOPT_0x0:
	MOV  R30,R3
	LDI  R31,0
	RCALL __LSLW3
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1:
	SUBI R30,LOW(-_EEPSaveData)
	SBCI R31,HIGH(-_EEPSaveData)
	MOVW R26,R30
	RCALL __EEPROMRDB
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x2:
	__ADDW1MN _EEPSaveData,1
	MOVW R26,R30
	RCALL __EEPROMRDB
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x3:
	LDI  R26,LOW(_EEPMaintCounter)
	LDI  R27,HIGH(_EEPMaintCounter)
	RCALL __EEPROMRDB
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x4:
	SUBI R30,-LOW(1)
	RCALL __EEPROMWRB
	SUBI R30,LOW(1)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:6 WORDS
SUBOPT_0x5:
	LDI  R30,LOW(0)
	OUT  0x18,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x6:
	CLR  R11
	CLR  R10
	LDI  R30,LOW(5)
	MOV  R13,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x7:
	LDI  R30,LOW(63)
	OUT  0x18,R30
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	RCALL _delay_ms
	RJMP SUBOPT_0x5

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x8:
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x9:
	LDI  R26,LOW(_EEPTime)
	LDI  R27,HIGH(_EEPTime)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xA:
	RCALL __EEPROMRDB
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0xB:
	__ADDW1MN _EEPSaveData,2
	MOVW R26,R30
	RCALL __EEPROMRDB
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0xC:
	RCALL _rand
	MOVW R26,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xD:
	EOR  R30,R26
	OUT  0x18,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 15 TIMES, CODE SIZE REDUCTION:26 WORDS
SUBOPT_0xE:
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xF:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x10:
	LDI  R26,LOW(_StarLights)
	ADD  R26,R13
	LD   R30,X
	OUT  0x18,R30
	LDI  R30,LOW(5)
	CP   R30,R13
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:3 WORDS
SUBOPT_0x11:
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	RCALL __MODW21
	SUBI R30,-LOW(1)
	MOV  R11,R30
	CLR  R13
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x12:
	IN   R30,0x18
	LDI  R26,LOW(1)
	RJMP SUBOPT_0xD

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:23 WORDS
SUBOPT_0x13:
	IN   R1,24
	MOV  R30,R11
	LDI  R26,LOW(1)
	RCALL __LSLB12
	EOR  R30,R1
	OUT  0x18,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x14:
	LDI  R26,LOW(1)
	RCALL __LSLB12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x15:
	MOV  R30,R10
	RJMP SUBOPT_0x14

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x16:
	RCALL SUBOPT_0xF
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x17:
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	RCALL __MODW21
	SUBI R30,-LOW(1)
	LDI  R26,LOW(64)
	LDI  R27,HIGH(64)
	RCALL __LSRW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x18:
	LDI  R30,LOW(64)
	LDI  R31,HIGH(64)
	RCALL __MODW21
	OUT  0x18,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x19:
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	RJMP SUBOPT_0xE

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:5 WORDS
SUBOPT_0x1A:
	STS  __seed_G100,R30
	STS  __seed_G100+1,R31
	STS  __seed_G100+2,R22
	STS  __seed_G100+3,R23
	RET


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__LSLB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSLB12R
__LSLB12L:
	LSL  R30
	DEC  R0
	BRNE __LSLB12L
__LSLB12R:
	RET

__LSRW12:
	TST  R30
	MOV  R0,R30
	MOVW R30,R26
	BREQ __LSRW12R
__LSRW12L:
	LSR  R31
	ROR  R30
	DEC  R0
	BRNE __LSRW12L
__LSRW12R:
	RET

__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__MULW12U:
	MOV  R0,R26
	MOV  R1,R27
	LDI  R24,17
	CLR  R26
	SUB  R27,R27
	RJMP __MULW12U1
__MULW12U3:
	BRCC __MULW12U2
	ADD  R26,R0
	ADC  R27,R1
__MULW12U2:
	LSR  R27
	ROR  R26
__MULW12U1:
	ROR  R31
	ROR  R30
	DEC  R24
	BRNE __MULW12U3
	RET

__MULD12U:
	PUSH R19
	PUSH R20
	PUSH R21
	LDI  R21,33
	MOV  R0,R26
	MOV  R1,R27
	MOV  R19,R24
	MOV  R20,R25
	CLR  R26
	CLR  R27
	CLR  R24
	SUB  R25,R25
	RJMP __MULD12U1
__MULD12U3:
	BRCC __MULD12U2
	ADD  R26,R0
	ADC  R27,R1
	ADC  R24,R19
	ADC  R25,R20
__MULD12U2:
	LSR  R25
	ROR  R24
	ROR  R27
	ROR  R26
__MULD12U1:
	ROR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R21
	BRNE __MULD12U3
	POP  R21
	POP  R20
	POP  R19
	RET

__MULW12:
	RCALL __CHKSIGNW
	RCALL __MULW12U
	BRTC __MULW121
	RCALL __ANEGW1
__MULW121:
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__MODW21:
	CLT
	SBRS R27,7
	RJMP __MODW211
	COM  R26
	COM  R27
	ADIW R26,1
	SET
__MODW211:
	SBRC R31,7
	RCALL __ANEGW1
	RCALL __DIVW21U
	MOVW R30,R26
	BRTC __MODW212
	RCALL __ANEGW1
__MODW212:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__EEPROMRDB:
	SBIC EECR,EEWE
	RJMP __EEPROMRDB
	PUSH R31
	IN   R31,SREG
	CLI
	OUT  EEARL,R26
	SBI  EECR,EERE
	IN   R30,EEDR
	OUT  SREG,R31
	POP  R31
	RET

__EEPROMWRB:
	SBIS EECR,EEWE
	RJMP __EEPROMWRB1
	WDR
	RJMP __EEPROMWRB
__EEPROMWRB1:
	IN   R25,SREG
	CLI
	OUT  EEARL,R26
	SBI  EECR,EERE
	IN   R24,EEDR
	CP   R30,R24
	BREQ __EEPROMWRB0
	OUT  EEDR,R30
	SBI  EECR,EEMWE
	SBI  EECR,EEWE
__EEPROMWRB0:
	OUT  SREG,R25
	RET

;END OF CODE MARKER
__END_OF_CODE:
