/*****************************************************
Project :       ""
Version :   1.3.1
Date    :   22.02.2016
Author  :   Ramm-SD
Comments:   6  : 5  (PB1-PB5) + 1  (PB0)
            Int0 -   
            - : 19
             

Chip type               : ATtiny2313A
AVR Core Clock frequency: 8,000000 MHz
Memory model            : Tiny
External RAM size       : 0
Data Stack size         : 32
*****************************************************/

/*****************************************************
   EEPROM:

 0 - :
0 -  
1 -     ( )
2 -  
3 -  
4 -  
5 -  
6 -  
7 -  
8 -  
9 -  
A -  
B -  
C -  
D -  
E -  
F -  

 1-7 -    .    2  .    8 :
0 -     EEPROM:  
1 -     EEPROM:  
2 -   
3 -     :  
4 -     :  
5 -  
6 -  
7 -  
*****************************************************/

#include <tiny2313a.h>
#include <delay.h>
#include <stdlib.h>

//   EEPROM
//  
eeprom unsigned char EEPMaintCounter @0x00;
//     
eeprom unsigned char EEPTime @0x01;
//    
eeprom unsigned char EEPSaveData[14][8] @0x10;

//  
//      
unsigned char ESDAddress;
//     
unsigned int SwapData;
//      
signed int Countdown;
//    
signed int SetProg;
//     
unsigned char StarLights[6]={
    0b00111111,0b00111110,0b00000001,0b00111111,0b00111110,0b00000000
};
//   
unsigned char Item;
//    
unsigned char Iteration1; 
unsigned char Iteration2;
unsigned char Iteration3;

// Int0  
interrupt [EXT_INT0] void ext_int0_isr(void){
    SetProg=2;
}

// Timer1      
interrupt [TIM1_COMPA] void timer1_compa_isr(void){
    Countdown++;
}

//     EEPROM
void SaveData(void){
    if(EEPSaveData[ESDAddress][0]==0xFF){
        if(EEPSaveData[ESDAddress][1]==0xFF){
            EEPMaintCounter++;
            ESDAddress=EEPMaintCounter;
            if(EEPMaintCounter>=14)ESDAddress=ESDAddress-14;
        }
        EEPSaveData[ESDAddress][1]++;
    }
    EEPSaveData[ESDAddress][0]++;
    EEPSaveData[ESDAddress][2]=Item;
    EEPSaveData[ESDAddress][3]=rand()%256;
    EEPSaveData[ESDAddress][4]=rand()%256;
}

//      
void StartData(void){
    if(Item>18)Item=0;
    //    
    switch (Item){
        case 0:
        case 2:
        case 6:
        case 7:
            PORTB=0b00111111;
            Iteration1=0;
            Iteration2=2;
        break;
        case 1:
            PORTB=0b00111110;
        break;
        case 3:
        case 4:
        case 5:
        case 8:
        case 9:
        case 10:
        case 16:
        case 17:
        case 18:
            PORTB=0b00000000;
            Iteration1=0;
            Iteration2=0;
            Iteration3=5;
        break;
        case 11:
        case 12:
            PORTB=0b00000000;
            Iteration1=1;
            Iteration2=3;
        break;
    };
    Countdown=0;
}

//  
void main(void){
    //  
    //      
    signed int TimeToChange;

    // Crystal Oscillator division factor: 1
    #pragma optsize-
    CLKPR=0x80;
    CLKPR=0x00;
    #ifdef _OPTIMIZE_SIZE_
    #pragma optsize+
    #endif

    //   A     
    PORTD=0b00000111;
    DDRD=0b00000000;

    //     
    PORTB=0b00000000;
    DDRB=0b11111111;

    //   D     
    PORTD=0b01111111;
    DDRD=0b00000000;

    //    Timer/Counter 1
    // : 7813 
    TCCR1A=0x00;
    TCCR1B=0x0D;
    TCNT1H=0x00;
    TCNT1L=0x00;
    ICR1H=0x00;
    ICR1L=0x00;
    OCR1AH=0x1E;
    OCR1AL=0x85;
    OCR1BH=0x00;
    OCR1BL=0x00;

    //    
    // Int0 - Falling edge
    // Timer1 - 
    GIMSK=0x40;
    MCUCR=0x02;
    EIFR=0x40;
    TIMSK=0x40;

    //  
    PORTB=0b00111111;delay_ms(1000);
    PORTB=0b00000000;delay_ms(1000);

    //  
    #asm("sei")
    
    //  
    //    EEPROM
    if(EEPMaintCounter==0xFF){
        EEPMaintCounter=0;
        EEPSaveData[0][0]=0;
        EEPSaveData[0][1]=0;
        EEPSaveData[0][2]=1;
    }
    if((EEPTime<5)||(EEPTime==0xFF)){
        EEPTime=10;
    }
    //     EEPROM
    ESDAddress=EEPMaintCounter;
    if(EEPMaintCounter>=14)ESDAddress=ESDAddress-14;
    TimeToChange=60*(signed int)EEPTime;
    Item=EEPSaveData[ESDAddress][2];
    SwapData=EEPSaveData[ESDAddress][4];
    SwapData=SwapData<<8|EEPSaveData[ESDAddress][3];
    srand(SwapData); 
    StartData();
    
    //  
    while (1){
        //    
        if(SetProg==2){
            Item++;
            SetProg--;
            StartData();
        }
        //         EEPROM
        if((Countdown>=TimeToChange)&&(EEPTime<251)){
            do{
                Item=rand()%19;
            }while (Item==EEPSaveData[ESDAddress][2]);
            StartData();
            SaveData();
        }
        //    EEPROM  5    
        if((SetProg==1)&&(Countdown>=300)){
            SaveData();
            SetProg=0;
        }
        //    EEPROM  30   ,  ,   
        if((EEPTime>250)&&(Countdown>=1800)&&(Item>13)){
            SaveData();
            Countdown=0;
        }
        // 
        switch (Item){
            case 0:
            //  0
            // : /   
            case 1:
            //  1
            // :  / 
                PORTB^=0b00111111;
                delay_ms(2000);
            break;
            case 2:
            //  2
            //  :  
                Iteration1++;
                if(Iteration1>2)Iteration1=0;
                PORTB=StarLights[Iteration1];
                if(Iteration1==0)delay_ms(2000);
                delay_ms(100);
            break;
            case 3:
            //  3
            //  : 
                Iteration3++;
                if(Iteration3>5)Iteration3=2;
                PORTB=StarLights[Iteration3];
                if(Iteration3==5)delay_ms(300);
                delay_ms(150);
            break;
            case 4:
            //  4
            //  :  
                Iteration3--;
                if(Iteration3<2)Iteration3=5;
                PORTB=StarLights[Iteration3];
                if(Iteration3==5)delay_ms(300);
                delay_ms(150);
            break;
            case 5:
            //  5
            //  : 
                Iteration1=rand()%5+1;
                for (Iteration3=0;Iteration3<2;Iteration3++){
                    PORTB^=0b00000001;
                    delay_ms(70);
                    PORTB^=1<<Iteration1;
                    delay_ms(70);
                }
                delay_ms(200);
            break;
            case 6:
            //  6
            //  :  
                Iteration1++;
                Iteration2++;
                if(Iteration1>5)Iteration1=1;
                if(Iteration2>5)Iteration2=1;
                PORTB=0b00111111^(1<<Iteration1|1<<Iteration2);
                delay_ms(150);
            break;
            case 7:
            //  7
            //  : "" 
            case 8:
            //  8
            //  : "-2" 
                PORTB^=1<<Iteration1;
                Iteration1++;
                if(Iteration1>5){
                    Iteration1=1;
                    PORTB^=0b00000001;
                }
                PORTB^=1<<Iteration1;
                delay_ms(90);
            break;
            case 9:
            //  9
            //  : 
                if(Iteration2==Iteration3){
                    Iteration1^=1<<Iteration2;
                    PORTB=Iteration1;
                    Iteration2=0;
                    Iteration3--;
                    delay_ms(1000);
                }
                else{
                    PORTB=Iteration1|1<<Iteration2;
                    delay_ms(100);
                    Iteration2++;
                };
                if(Iteration3==0){
                    Iteration1=0;
                    Iteration2=0;
                    Iteration3=5;
                    PORTB=0b00111111;
                    delay_ms(1000);
                    PORTB=0b00000000;
                    delay_ms(500);
                }
            break;
            case 10:
            //  10
            //  : 
                Iteration1++;
                if(Iteration1>5)Iteration1=0;
                PORTB^=1<<Iteration1;
                delay_ms(100);
            break;
            case 11:
            //  11
            //  : -2
                Iteration1--;
                PORTB^=1<<Iteration1;
                if(Iteration1==0)Iteration1=6;
                delay_ms(100);
            break;
            case 12:
            //  12
            //  :  
                for (Iteration3=0;Iteration3<2;Iteration3++){
                    PORTB^=1<<Iteration1;
                    delay_ms(100);
                    PORTB^=0b00000001;
                    delay_ms(100);
                    PORTB^=1<<Iteration2;
                    delay_ms(100);
                }
                Iteration3=Iteration1;
                Iteration1=Iteration2;
                Iteration3--;
                Iteration2=Iteration3;
                if(Iteration2<1)Iteration2=5;
            break;
            case 13:
            //  13
            //  
                PORTB++;
                if(PORTB>63)PORTB=0;
                delay_ms(500);
            break;
            case 14:
            //  14
            // 
                PORTB^=0b01000000>>(rand()%6+1);
                delay_ms(1000);
            break;
            case 15:
            //  15
            // -2
                PORTB=rand()%64;
                delay_ms(1000);
            break;
            case 16:
            //  16
            //  (  )
                PORTB^=0b01000000>>(rand()%6+1);
                delay_ms(20);
                PORTB=0b00000000;
                delay_ms(1000);
            break;
            case 17:
            //  17
            //   (         )
                Iteration1=rand()%5+1;
                for (Iteration3=0;Iteration3<Iteration1;Iteration3++){
                    PORTB=0b01000000>>(rand()%6+1);
                    delay_ms(20);
                    PORTB=0b00000000;
                    delay_ms(50);
                }
                delay_ms(rand()%2500+500);
            break;
            case 18:
            //  18
            //    (         )
                Iteration1=rand()%2+2;
                for (Iteration3=0;Iteration3<Iteration1;Iteration3++){
                    PORTB=rand()%64;
                    delay_ms(20);
                    PORTB=0b00000000;
                    delay_ms(50);
                }
                delay_ms(rand()%1500+500);
            break;
        }; 
    }
}