/** \file pumprelay.h
 * \brief        
 *
 * \details
 *   ,    
 *        
 *  :
 * \li   ()  ;
 * \li       ;
 * \li    " ".
 *
 *  :
 * \li     ;
 * \li     ;
 * \li     .
 *
 *        
 * ,      .  
 *     .
 *
 *  Attiny13   ,   
 *  9,6 ,  BODLEVEL   .
 *
 * \author \b ARV
 * \date	11  2021 .
 * \copyright 2021  ARV. All rights reserved.
 *
 */

#ifndef PUMPRELAY_H_
#define PUMPRELAY_H_

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <avr/eeprom.h>
#include <util/delay.h>
#include <stdbool.h>
#include "avr_helper.h"

///    ( )    
///        
#define DEFAULT_WAIT	30

///   
#define PUMP_PIN	_BV(PB2)
///   
#define LED_PIN		_BV(PB3)
///   
#define POWER_PIN	_BV(PB0)
///         
#define LEVEL_CTRL	ADC_2
///       
#define WATER_PIN	_BV(PB1)

/*
 *    ,        .
 *        ,     
 */

///    
#define LO_1		500
///    
#define LO_2		525
///    
#define HI_1		240
///    
#define HI_2		260

/// 
typedef enum {
	STATE_ON,			//  
	STATE_OFF,			//  
	STATE_NO_WATER,		//  
	STATE_WAIT,			//   
	STATE_STOP,			// 
	STATE_DELAY,		//    
	STATE_INIT = 0xFF	// 
} state_t;

///   
typedef enum {
	LEVEL_LO,			//  
	LEVEL_HI,			//  
	LEVEL_UNKNOWN		//  
} level_t;

#endif /* PUMPRELAY_H_ */
