/*****************************************************
This program was produced by the
CodeWizardAVR V2.04.4a Advanced
Automatic Program Generator
 Copyright 1998-2009 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project : Timer simple
Version : 1
Date    : 10.09.2025
Author  : E.J.SanYo
Company : 
Comments: 
  . .  24 


Chip type               : ATmega8535
Program type            : Application
AVR Core Clock frequency: 1,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 128
*****************************************************/

#include <mega8535.h>
#include <delay.h>
#include <sleep.h>

//
#define ust1 28800 //8 
#define ust2 86400 //24 

unsigned long counter = 0;
unsigned char enable = 0;

// Timer2 output compare interrupt service routine
interrupt [TIM2_COMP] void timer2_comp_isr(void)
{
    PORTB.3 = 0; //   
    counter++;
    if (counter < ust1) //    
        PORTB.4 = 1; //. 
    else
        PORTB.4 = 0; // . 
    if (counter >= ust2)
        counter = 0;
}

void main(void)
{
    // Input/Output Ports initialization
    // Port A initialization
    // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
    // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
    PORTA=0x00;
    DDRA=0x00;

    // Port B initialization
    // Func7=In Func6=In Func5=In Func4=Out Func3=Out Func2=In Func1=In Func0=In 
    // State7=P State6=P State5=P State4=0 State3=0 State2=T State1=T State0=T 
    PORTB=0xE0;
    DDRB=0x18;

    // Port C initialization
    // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
    // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
    PORTC=0x00;
    DDRC=0x00;

    // Port D initialization
    // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
    // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
    PORTD=0x00;
    DDRD=0x00;

    // Timer/Counter 0 initialization
    // Clock source: System Clock
    // Clock value: Timer 0 Stopped
    // Mode: Normal top=FFh
    // OC0 output: Disconnected
    TCCR0=0x00;
    TCNT0=0x00;
    OCR0=0x00;

    // Timer/Counter 1 initialization
    // Clock source: System Clock
    // Clock value: Timer1 Stopped
    // Mode: Normal top=FFFFh
    // OC1A output: Discon.
    // OC1B output: Discon.
    // Noise Canceler: Off
    // Input Capture on Falling Edge
    // Timer1 Overflow Interrupt: Off
    // Input Capture Interrupt: Off
    // Compare A Match Interrupt: Off
    // Compare B Match Interrupt: Off
    TCCR1A=0x00;
    TCCR1B=0x00;
    TCNT1H=0x00;
    TCNT1L=0x00;
    ICR1H=0x00;
    ICR1L=0x00;
    OCR1AH=0x00;
    OCR1AL=0x00;
    OCR1BH=0x00;
    OCR1BL=0x00;

    // Timer/Counter 2 initialization
    // Clock source: TOSC1 pin
    // Clock value: PCK2/1024
    // Mode: CTC top=OCR2
    // OC2 output: Disconnected
    ASSR=0x08;
    TCCR2=0x0F;
    TCNT2=0x00;
    OCR2=0x1F; // 32768 / 1024 / (31 + 1) = 1 

    // External Interrupt(s) initialization
    // INT0: Off
    // INT1: Off
    // INT2: Off
    MCUCR=0x00;
    MCUCSR=0x00;

    // Timer(s)/Counter(s) Interrupt(s) initialization
    //TIMSK=0x80;
    TIMSK=0x00; //   

    // Analog Comparator initialization
    // Analog Comparator: Off
    // Analog Comparator Input Capture by Timer/Counter 1: Off
    ACSR=0x80;
    SFIOR=0x00;

    // Global enable interrupts
    #asm("sei")

    sleep_enable(); //  
    delay_ms(100); //   Timer2  

    while (1)
      {
      if (PINC.3 == 0) // 
      {
          do
          {
              delay_ms(1);
          }
          while (PINC.3 == 0); //    
          if (enable)
              counter = 0; //    
          else //    
          {
              TIFR = 0x80; //  
              TIMSK = 0x80; // 
              enable = 1;
          }
      }
      if (enable) //  
      {
          PORTB.3 = 1; //    
          powersave(); //  
      }
      };
}
