/*****************************************************
Chip type               : ATmega8
Program type            : Application
AVR Core Clock frequency: 16,000000 MHz
Memory model            : Small
External RAM size       : 0
Data Stack size         : 256
*****************************************************/

#include <mega8.h>
#include <delay.h>

#define EN  PORTD.5
#define M0  PORTD.6
#define M1  PORTD.7
#define M2  PORTB.0
#define RST PORTB.1
#define SLP PORTB.2
#define STP PORTB.3
#define DIR PORTB.4

volatile unsigned int sec    = 0;
volatile unsigned int hour   = 0;
volatile unsigned int uStep  = 0;
volatile unsigned int oborot = 0;
volatile bit cicle_end = 0;

// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)       
{
  // Reinitialize Timer 0 value 
  TCNT0=0x51;              //  700 

  STP^=1;                  //     

  if (++uStep > 3071) {    //   7,5 .
    if (++oborot > 83) {   // 360/7,5 = 48     
      oborot=0;            // 48*32=1536     1/32            
      DIR = 1;             //    ,      1536*2=3072  
      if (cicle_end) {     // 3072*0,0007 = 2,1504   
        TCCR0=0x00;        //  3      3   
        DIR = 0;           // 180/2,1504 ~ 84 
        cicle_end = 0;
        EN = 1;            //  
        TCCR1B=0x05;
      }
      cicle_end = 1;
    } 
    uStep = 0;
  }                                             
}

// Timer1 overflow interrupt service routine
interrupt [TIM1_OVF] void timer1_ovf_isr(void)        //   
{
  // Reinitialize Timer1 value 
  TCNT1H=0xC2;
  TCNT1L=0xF7;

  if (++sec > 3599) {      //    (3600 )    
    if (++hour > 7) {      //   8 ,     (3   , 3   )
      hour = 0;
      cicle_end = 0; 
      EN = 0;              //        
      TCCR0=0x03;
      TCCR1B=0x00;     
    }
    sec = 0;
  }
}

void main(void)
{
// Input/Output Ports initialization
// Port B initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTB=0x00;
DDRB=0xFF;

// Port C initialization
// Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTC=0x00;
DDRC=0x7F;

// Port D initialization
// Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State7=0 State6=0 State5=1 State4=0 State3=0 State2=0 State1=0 State0=0 
PORTD=0x20;
DDRD=0xFF;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 250,000 kHz
//TCCR0=0x03;
TCCR0=0x00;
TCNT0=0x51;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 15,625 kHz
// Mode: Normal top=0xFFFF
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: On
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0xC2;
TCNT1L=0xF7;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer2 Stopped
// Mode: Normal top=0xFF
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
MCUCR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x05;

// USART initialization
// USART disabled
UCSRB=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// ADC initialization
// ADC disabled
ADCSRA=0x00;

// SPI initialization
// SPI disabled
SPCR=0x00;

// TWI initialization
// TWI disabled
TWCR=0x00;

// Global enable interrupts
#asm("sei")

delay_ms(10); // <--------------------------
                                      // <--
RST = 1;      //   RESET       // <--
SLP = 1;      //            // <--       
EN  = 0;      //       // <--     7 
M0  = 1;      //                      // <--        
M1  = 1;      // 1/32             // <--
M2  = 1;      //                      // <--
                                      // <--
delay_ms(10); // <--------------------------

TCCR0=0x03;   // 

while (1)
      {  
         
      }
}
