/*
  CodeVisionAVR C Compiler
  (C) 2008, Samodelkin (Pervakov Danil), Ukraine, Crimea.

  Prototypes for the Dallas Semiconductors
  DS1307 TWI Bus Real Time Clock functions

  BEFORE #include -ING THIS FILE YOU
  MUST TWI (2-wire I2C) BUS IS CONNECTED

  EXAMPLE:

    #include <ds1307_twi.h>
*/

#ifndef _DS1307_TWI_INCLUDED_
#define _DS1307_TWI_INCLUDED_

#include <i2c.h>

#pragma used+

unsigned char rtc_read(unsigned char address);
void rtc_write(unsigned char address,unsigned char data);
void rtc_init(unsigned char rs,unsigned char sqwe,unsigned char out);
void rtc_get_time(unsigned char *hour,unsigned char *min,unsigned char *sec);
void rtc_set_time(unsigned char hour,unsigned char min,unsigned char sec);
void rtc_get_date(unsigned char *date,unsigned char *month,unsigned char *year);
void rtc_set_date(unsigned char date,unsigned char month,unsigned char year);

#pragma used-
#pragma library ds1307_twi.lib

#endif

