/*****************************************************
This program was produced by the
CodeWizardAVR V2.03.4 Standard

Project :  ( . RTC)      ( +- 59 .) +  ( DS18B20) + 
            (    .)
          
Version : 
Date    : 17.03.2008 (    Tiny 2313  . )
Author  : Samodelkin (Danil Pervakov)                            
Company :                            
Comments:    DS18B20 (   int  float)
           DS1307 ( -  -    
          - )

             :     
           (10 )   . (   
           2 .)

           : "+" -  .. - " +" 
                               -  .. - "  +"
                               -    -  
                               
                           "-" -  .  - " +"
                               -  .. - "  -"
                               -    -  
                               
                           "Sec" -     :
                                       :
                                   (  :  "" -    00,
                                      30  -  +1, 
                                    59 ,   +1)
                                   
                           "Set" -       
                                       :
                                   
                           "" -   .  .  ,
                                  0  0    -   00:00:00,  
                                  23  59    -   00:00:00,
                                        

Chip type           : ATmega8
Program type        : Application
Clock frequency     : 4,000000 MHz
Memory model        : Small
External SRAM size  : 0
Data Stack size     : 256
*****************************************************/
//
//  Fuse bit's SKSEL3..0 = 0011, SUT1..0 = 10 (Int RC = 4 MHz) 
//
//   DS18B20 - (PORTD bit 7)
//  
//  Realtime DS1307 - (TWI sda -  27, scl -  28)
//
//   -  (ADC0 -  23) - "+", "-", "Sec", "Set", "K"
//
//    (..)
//                   (PORTB - ) - a-bit0, b-bit2, c-bit4, d-bit6, e-bit7, f-bit1, g-bit3, dp-bit5
//                   (PORTD - ) - 1-bit0, 2-bit1, 3-bit2, 4-bit3                  
//

/*
EEPROM usage: 0 byte(s), 0,0% of EEPROM
Program size: 1522 words (3044 bytes), 37,2% of FLASH
*/

//  -          ,    IBM PC XT   Intel 8088 
#include <mega8.h>

// 1 Wire Bus functions (PORTD bit 7)
#asm
   .equ __w1_port=0x12
   .equ __w1_bit=7
#endasm

// DS18b20 Temperature Sensor functions
#include "ds18b20_.h"  

/*   TWI (I2C)    -      
// I2C Bus functions (PORTC bit's  4, 5)
#asm
   .equ __i2c_port=0x15
   .equ __sda_bit=4
   .equ __scl_bit=5
#endasm

// DS1307 Real Time Clock functions (I2C -  )
#include "ds1307_.h"
*/

// DS1307 Real Time Clock functions TWI (I2C - ) 
#include "ds1307_twi.h"


#include <delay.h> 
#include <bcd.h>

// ,   . 
#include "term_mega8.h"        

// -------------------------------------------------------------------------------------------------------------
//
// Timer 0 overflow interrupt service routine
//
//  -    (62500  / 256) = 244 
//       (244 / 4) = 61 
//
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
{
        PORTD|=0b00001111;                          //   (   "1" -  ..)
        PORTB=digits[digit_out[cur_dig]];           //   
        
        if (ind_ON == 1) PORTD&=(cursor[cur_dig]);  //    (   "0" -  ..)
          
        if ((zpt_ON == 1) && (cur_dig == 1)) PORTB.5=1;  //     ( .  )

        cur_dig++; if (cur_dig>=4) cur_dig=0;
}
// -------------------------------------------------------------------------------------------------------------



// -------------------------------------------------------------------------------------------------------------
//
// Timer 1 overflow interrupt service routine
// 
//  -     2 
// 
//  -   65536 (0xFFFF)  .
//     2  (  3906 )  3906  / 2  =  1953  . 
// -     65536 - 1953 = 63583 = 0xF85F  
//
interrupt [TIM1_OVF] void timer1_ovf_isr(void)
{
        //      ,   63583 = 0xF85F
        TCNT1H=0xF8; TCNT1L=0x5F;

        if (zpt_BLINK == 1) {
                if (zpt_ON == 0) {zpt_ON=1;} else {zpt_ON=0;} //  
        };

        if (ind_BLINK == 1) {
                if (ind_ON == 0) {ind_ON=1;} else {ind_ON=0;} //  
        };
}
// -------------------------------------------------------------------------------------------------------------


// --------------------------------  ADC ---------------------------------------------
// Read the 8 most significant bits of the AD conversion result
unsigned char read_adc(unsigned char adc_input) {
        ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
        // Delay needed for the stabilization of the ADC input voltage
        delay_us(10);
        // Start the AD conversion
        ADCSRA|=0x40;
        // Wait for the AD conversion to complete
        while ((ADCSRA & 0x10)==0);
        ADCSRA|=0x10;
        return ADCH;
}  //---------------------------------------------------------------------------------------


// ----------------------------    ------------------------------------
unsigned char read_key(void) {
        unsigned char key_adc;
        
        key_adc=read_adc(0);
                
        if                      (key_adc <=   3)  return KEY_PLUS; 
        if ((key_adc >= 124) && (key_adc <= 130)) return KEY_MINUS;
        if ((key_adc >= 167) && (key_adc <= 173)) return KEY_SEC;
        if ((key_adc >= 188) && (key_adc <= 194)) return KEY_SET;
        if ((key_adc >= 201) && (key_adc <= 207)) return KEY_K;
} // ---------------------------------------------------------------------------------------


// -----------------------------------------------------------------------------------------------------------------------------
void init_DS1307 (void) {
        unsigned char tmphour, tmpmin, tmpsec1, tmpsec2;
        
        //   (   )
        //myhour=0; mymin=0; mysec=0;     // 24-00-00
        //mydate=1; mymonth=1; myyear=7;  // 01.01.2007
        
        rtc_get_time(&tmphour, &tmpmin, &tmpsec1); //     
        delay_ms(1500);
        rtc_get_time(&tmphour, &tmpmin, &tmpsec2); //  1,5 .    

        if (tmpsec1 == tmpsec2) { //   1,5 .        
                rtc_set_time(0, 0, 0);  //  7 (CH)   DS1307     (0 - , 1 - )
                rtc_set_date(1, 1, 7);
                rtc_init(0, 0, 0);      //    DS1307     (   - : rs=0, sqwe=0, out=0)
                rtc_write(9,0);  //   - Corect
        }
}


// ------------------------------------------------    DS1307 ---------------------------------------------------
void read_time(void) {
        rtc_get_time(&myhour, &mymin, &mysec);
        
        if (myhour == 0x23) K=1; //     23 
        
        if ((K == 1) && (Corect != 0) && (myhour == hour_k) && (mymin == min_k) && (mysec == sec_k)) { 
                myhour=0; mymin=0; mysec=0;
                rtc_set_time(0, 0, 0);
                K=0;                        //        
        }
        //     23:59: ( - )      00:00:00  
        //       23  
} //------------------------------------------------------------------------------------------------------------------


// --------------------------------------        ? ----------------------------------------
void view_time(void) {
        unsigned char tmp;
              
        if ((indicate == IND_CLOCK) || (indicate == IND_SET)) {    //  : 
                digit_out[0] = myhour >> 4;
                digit_out[1] = myhour & 0x0F;
        
                digit_out[2] = mymin >> 4;
                digit_out[3] = mymin & 0x0F;
        }

        if (indicate == IND_SEC){                                   //  : 
                digit_out[0] = mymin >> 4;
                digit_out[1] = mymin & 0x0F;

                digit_out[2] = mysec >> 4;
                digit_out[3] = mysec & 0x0F;
        }

        if (indicate == IND_K){                                     //  . 
                tmp = bin2bcd(Corect);
                
                digit_out[0] = PROBEL;
                
                if (Znak == 0) digit_out[1] = PROBEL;
                else digit_out[1] = MINUS; 

                digit_out[2] = tmp >> 4;
                digit_out[3] = tmp & 0x0F;
        }
} //------------------------------------------------------------------------------------------------------------------------


// ------------------------------     ---------------------------------
void set_ind(void) {
        unsigned char key, tmp;
        key=read_key();

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_CLOCK){
                if (key == KEY_SEC) {
                        indicate = IND_SEC;
                        zpt_BLINK=0;
                        zpt_ON=1;
                        ind_BLINK=0;
                        ind_ON=1;
                }

                if (key == KEY_SET) {
                        indicate = IND_SET;
                        zpt_BLINK=1;
                        zpt_ON=1;
                        ind_BLINK=1;
                        ind_ON=1;                        
                }

                if (key == KEY_K) {
                        indicate = IND_K;
                        zpt_BLINK=0;
                        zpt_ON=0;
                        ind_BLINK=0;
                        ind_ON=1;
                        Corect=rtc_read(9); //   DS1307
                        Znak=rtc_read(10);
                }
                return;
        }
 
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SEC){
                if (key == KEY_SEC) {
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        zpt_ON=1;
                        ind_BLINK=0;
                        ind_ON=1;
                }

                if (key == KEY_K) {
                        if (bcd2bin(mysec) > 30) {  //   30 
                                tmp=bcd2bin(mymin);  //  +1
                                tmp++;
                                if (tmp >= 60) {  //   59 
                                        mymin=0;
                                        tmp=bcd2bin(myhour);
                                        tmp++;
                                        if (tmp >= 24) myhour=0; else myhour=bin2bcd(tmp); //   23  
                                } else mymin=bin2bcd(tmp);
                                        
                        }
                        rtc_set_time(myhour, mymin, 0);  //  00
                        view_time();
                }
                return;
        } 

        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_SET){
                if (key == KEY_PLUS) {
                        tmp=bcd2bin(myhour);
                        tmp++; if (tmp >= 24) tmp=0;
                        myhour=bin2bcd(tmp);
                        rtc_set_time(myhour, mymin, mysec);  //   +1
                        view_time();
                }
  
                if (key == KEY_MINUS) {
                        tmp=bcd2bin(mymin);
                        tmp++; if (tmp >= 60) tmp=0;
                        mymin=bin2bcd(tmp);
                        rtc_set_time(myhour, mymin, mysec);  //  +1
                        view_time();
                }
  
                if (key == KEY_SEC) {
                        indicate = IND_SEC;
                        zpt_BLINK=0;
                        zpt_ON=1;
                        ind_BLINK=0;
                        ind_ON=1;                        
                }

                if (key == KEY_SET) {
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        zpt_ON=1;
                        ind_BLINK=0;
                        ind_ON=1;
                }

                if (key == KEY_K) {
                        indicate = IND_K;
                        zpt_BLINK=0;
                        zpt_ON=0;
                        ind_BLINK=0;
                        ind_ON=1;
                }
                return;
        }

 
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        if (indicate == IND_K){
                if (Corect > 60) Corect=0; //    
 
                if (key == KEY_PLUS) {
                        if (Znak == 0) { //   
                                Corect++;
                                if (Corect >= 60) {Corect=59; Znak=1;} //      
                        }
                        else { //   
                                Corect--;
                                if (Corect == 0) Znak=0; //    0    
                        }
                }
  
                if (key == KEY_MINUS) {
                        if (Znak == 0) { //   
                                Corect--;
                                if (Corect == 0) Znak=1; //    0    
                        }
                        else { //   
                                Corect++;
                                if (Corect >= 60) {Corect=59; Znak=0;} //      
                        }
                }
  
                if ((key == KEY_SEC) || (key == KEY_SET) || (key == KEY_K)){
                        indicate = IND_CLOCK;
                        zpt_BLINK=1;
                        zpt_ON=1;
                        ind_BLINK=0;
                        ind_ON=1;
                        rtc_write(9,Corect); //  ()  DS1307
                        
                        // ----------    ------------
                        //  ()       00:00:00
                        if (Znak == 1) {hour_k=0x00; min_k=0x00; sec_k=bin2bcd(Corect);   } //  , .  00:00: -> 00:00:00   
                        else           {hour_k=0x23; min_k=0x59; sec_k=bin2bcd(60-Corect);} //  , .  23:59: -> 00:00:00  
                }
                
                return;
        }  
    
} // ------------------------------------------------------------------------------------------------




// ---------------------------------------------------------------------------------------------------
void view_term(void) {
        unsigned char celie, drob, tmp;
        unsigned int temp, celie_tmp, drob_tmp;
 
        temp = (unsigned int) temperature;                      
        
        if (temperature>=0) {
                digit_out[0]=PROBEL;       //   ()  
        } 
        else {        
                temp = ( ~temp ) + 0x0001; //       . 
                digit_out[0]=MINUS;        //     (   ..)
             };
        digit_out[3]=GRADUS; zpt_ON=1; 

        celie_tmp = temp >> 4;     //   
        drob_tmp  = temp & 0x000F; //      1/16 
                
        celie = (unsigned char) celie_tmp;  //     
        drob  = (unsigned char) ((drob_tmp * 10) / 16); //      "1/16 "      0,1  
        
        if (celie >= 100) { tmp=bin2bcd(celie-100); digit_out[0] = 1;} else tmp=bin2bcd(celie); //   
              
        if ((celie >= 100) || ((digit_out[0] == MINUS) && (celie >= 10))) { //    100,0 .   .  -10  1 .
                zpt_ON=0;
                digit_out[1] = tmp >> 4;    // 
                digit_out[2] = tmp & 0x0F;  //  
        }
        
        if ((digit_out[0] == MINUS) && (celie < 10)) { //  . 0   -10  0,1 .
                digit_out[1] = celie; // 
                digit_out[2] = drob;  //  
        }
        
        if ((digit_out[0] == PROBEL) && (celie < 100)) { //  .  100,0    0   0,1 .
                if (tmp >> 4) digit_out[0] = tmp >> 4; //  -       
                digit_out[1] = tmp & 0x0F;             // 
                digit_out[2] = drob;                   //  
        }
}  // -------------------------------------------------------------------------------------------------------


// ----------------------------------------------------------------------------------------------------------
void delay_100ms (unsigned char d) {
        while (d) {
                read_time();
                set_ind();
                delay_ms(90);
                d--;
        }
}


void main(void) { //===================================== main ==============================================
unsigned char i, devices;

// Input/Output Ports initialization
// Port B initialization
//   -  
//   , .    "0" 
DDRB=0xFF;
PORTB=0x00;

// Port C initialization
DDRC=0x00;  //  
PORTC=0x00; // ..  .

// Port D initialization
//   - 
//  7,6,5,4,  "0",   3,2,1,0,  "1", 
DDRD=0xFF;
PORTD=0x0F;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 62,500 kHz
TCCR0=0x03;
TCNT0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 3,906 kHz
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: On
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x05;
TCNT1H=0xF8;
TCNT1L=0x5F;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
MCUCR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
// Timer 0: On
// Timer 1: On
// Timer 2: Off
TIMSK=0x05;  // 0b00000101,
//                 |   | |
//                 |   | Timer0
//                 |   Timer1
//                 Timer2

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

// ADC initialization
// ADC Clock frequency: 1000,000 kHz
// ADC Voltage Reference: AVCC pin
// Only the 8 most significant bits of
// the AD conversion result are used
ADMUX=ADC_VREF_TYPE & 0xff;
ADCSRA=0x82; // ADC Clock frequency: 1000,000 kHz
//ADCSRA=0x87; // ADC Clock frequency: 31,250 kHz

// 2 Wire Bus initialization
// Generate Acknowledge Pulse: On
// 2 Wire Bus Slave Address: 68h
// General Call Recognition: Off
// Bit Rate: 100,000 kHz
TWSR=0x00;
TWBR=0x0C;
TWAR=0xD0;
TWCR=0x44;

// 1 Wire Bus initialization
w1_init();

// I2C Bus initialization
//i2c_init();

init_DS1307(); //  DS1307

Corect=rtc_read(9); //   DS1307
Znak=rtc_read(10);

//   ( )
devices=w1_search(0xf0,rom_code);

//    
indicate=IND_CLOCK;

// 
zpt_BLINK=0;
zpt_ON=0;
ind_BLINK=0;
ind_ON=1;

// Global enable interrupts
#asm("sei")

//  2     Fnd.'-  '
digit_out[0]=13;       // F
digit_out[1]=14;       // n
digit_out[2]=15;       // d.
digit_out[3]=devices;  // 'devices'
delay_ms(2000);

//   
zpt_BLINK=1;
zpt_ON=1;
    
 // --------------------------------   -----------------------------------
 while (1) {
        for (i=0;i<50;i++){ // 10 .   (50 * 0.2 .) 
                read_time();
                view_time();
                set_ind();
                delay_ms(200);
        }
                
        if ((devices >= 1) && (indicate == IND_CLOCK)) {  //           
                zpt_BLINK=0;
                zpt_ON=1;

                for (i=0;i<devices;) {
                        temperature=ds18b20_temperature(&rom_code[i++][0]); 
                        if (temperature!=-9999) view_term();
                        //delay_ms(2000);
                        delay_100ms(20);
                }

                zpt_BLINK=1;
        }
 } // -----------------------------   (end) -----------------------------------

} // =========================================== end main ==============================================





//
// -=-=-=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- The End -=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//