/**
  ******************************************************************************

  ******************************************************************************
  */ 

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x.h"
#include "stm32f10x_gpio.h"
#include "platform_config.h"

RCC_ClocksTypeDef RCC_Clocks;



/* Private function prototypes -----------------------------------------------*/
void GPIO_SPI1_Conf(uint16_t SPI_Mode);
void GPIO_SPI2_Conf(uint16_t SPI_Mode);
/* Private function prototypes -----------------------------------------------*/

/* Private variables ---------------------------------------------------------*/
GPIO_TypeDef* GPIO_PORT[OUTPPn] = { LED8_GPIO_PORT, LED9_GPIO_PORT ,LED10_GPIO_PORT,LED11_GPIO_PORT ,
									RS_LPH_GPIO_PORT, Res_LPH_GPIO_PORT, CS_LPH_GPIO_PORT};
const uint16_t GPIO_PIN[OUTPPn] = { LED8_PIN, LED9_PIN,LED10_PIN,LED11_PIN,
									RS_LPH_PIN, Res_LPH_PIN, CS_LPH_PIN };
const uint32_t GPIO_CLK[OUTPPn] = { LED8_GPIO_CLK, LED9_GPIO_CLK,LED10_GPIO_CLK,LED11_GPIO_CLK,
									RS_LPH_GPIO_CLK, Res_LPH_GPIO_CLK, CS_LPH_GPIO_CLK  };



/* Private functions ---------------------------------------------------------*/
void OUTPPInit(OUTPP_TypeDef OUTPP) {
	GPIO_InitTypeDef GPIO_InitStructure;

	/* Enable the GPIO_LED Clock */
	RCC_APB2PeriphClockCmd(GPIO_CLK[OUTPP], ENABLE);

	/* Configure the GPIO_LED pin */
	GPIO_InitStructure.GPIO_Pin = GPIO_PIN[OUTPP];

	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIO_PORT[OUTPP], &GPIO_InitStructure);
}

void MCOInit(void) {
RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);	// Тактуем порт
GPIO_InitTypeDef GPIO_InitStructure;
GPIO_InitStructure.GPIO_Pin = GPIO_Pin_8;
GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
GPIO_Init(GPIOA, &GPIO_InitStructure);			// Конфигурируем вывод MCO

RCC_MCOConfig(RCC_MCO_SYSCLK);			// Подаем на MCO сигнал с PLL/2
}


void SPI1_On(void)
{
	  GPIO_SPI1_Conf(SPI_Mode_Master);

  SPI_InitTypeDef   SPI_InitStruct;
	SPI_InitStruct.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStruct.SPI_Mode = SPI_Mode_Master;
	SPI_InitStruct.SPI_DataSize = SPI_DataSize_8b;
	SPI_InitStruct.SPI_CPOL = SPI_CPOL_Low;
	SPI_InitStruct.SPI_CPHA = SPI_CPHA_2Edge;
	SPI_InitStruct.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStruct.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_256;
	SPI_InitStruct.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStruct.SPI_CRCPolynomial = 7;
	   SPI_Init(SPI1, &SPI_InitStruct);
	   SPI_Cmd(SPI1, ENABLE);

}

void SPI2_On(void)
{
	  GPIO_SPI2_Conf(SPI_Mode_Master);

  SPI_InitTypeDef   SPI_InitStruct;
	SPI_InitStruct.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStruct.SPI_Mode = SPI_Mode_Master;
	SPI_InitStruct.SPI_DataSize = SPI_DataSize_8b;
	SPI_InitStruct.SPI_CPOL = SPI_CPOL_High;
	SPI_InitStruct.SPI_CPHA = SPI_CPHA_2Edge;
	SPI_InitStruct.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStruct.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_2;
	SPI_InitStruct.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStruct.SPI_CRCPolynomial = 7;
	   SPI_Init(SPI2, &SPI_InitStruct);
	   /*SPI_SSOutputCmd(SPI2, ENABLE);*/
	   SPI_Cmd(SPI2, ENABLE);



}


/**
  *
  */
void GPIO_SPI1_Conf(uint16_t SPI_Mode)
{
	/*   SPI1 NSS pin (PA.04)
	     SPI1 SCK pin (PA.05)
	     SPI1 MISO pin (PA.06)
	     SPI1 MOSI pin (PA.07)*/
	GPIO_InitTypeDef GPIO_InitStructure;


	  /* Configure SPIy pins: SCK, MISO and MOSI ---------------------------------*/
	  GPIO_InitStructure.GPIO_Pin = SPI1_PIN_SCK | SPI1_PIN_MOSI;// | SPI1_PIN_NSS;
	  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;

	  if(SPI_Mode == SPI_Mode_Master)
	  {
	    /* Configure SCK and MOSI pins as Alternate Function Push Pull */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	  }
	  else
	  {
	    /* Configure SCK and MOSI pins as Input Floating */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	  }
	  GPIO_Init(SPI1_GPIO, &GPIO_InitStructure);

	  GPIO_InitStructure.GPIO_Pin = SPI1_PIN_MISO;

	  if(SPI_Mode == SPI_Mode_Master)
	  {
	    /* Configure MISO pin as Input Floating  */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	  }
	  else
	  {
	    /* Configure MISO pin as Alternate Function Push Pull */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	  }
	  GPIO_Init(SPI1_GPIO, &GPIO_InitStructure);

}

void GPIO_SPI2_Conf(uint16_t SPI_Mode)
{
	/*   SPI2 NSS pin (PB.12)
	     SPI2 SCK pin (PB.13)
	     SPI2 MISO pin (PB.14)
	     SPI2 MOSI pin (PB.15)*/

	GPIO_InitTypeDef GPIO_InitStructure;


	  /* Configure SPIy pins: SCK, MISO and MOSI ---------------------------------*/
	  GPIO_InitStructure.GPIO_Pin = SPI2_PIN_SCK | SPI2_PIN_MOSI ;/*| SPI2_PIN_NSS;*/
	  GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;

	  if(SPI_Mode == SPI_Mode_Master)
	  {
	    /* Configure SCK and MOSI pins as Alternate Function Push Pull */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	  }
	  else
	  {
	    /* Configure SCK and MOSI pins as Input Floating */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	  }
	  GPIO_Init(SPI2_GPIO, &GPIO_InitStructure);

	  GPIO_InitStructure.GPIO_Pin = SPI2_PIN_MISO;

	  if(SPI_Mode == SPI_Mode_Master)
	  {
	    /* Configure MISO pin as Input Floating  */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IN_FLOATING;
	  }
	  else
	  {
	    /* Configure MISO pin as Alternate Function Push Pull */
	    GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	  }
	  GPIO_Init(SPI2_GPIO, &GPIO_InitStructure);

}

void RCC_Configuration(void)
{
  /* PCLK2 = HCLK/2 */
  RCC_PCLK2Config(RCC_HCLK_Div2);


  /* Enable SPIy clock and GPIO clock for SPI1,and GPIO clock for SPI2  */
  /* RCC_APB2PeriphClockCmd(SPI1_GPIO_CLK  | SPI1_CLK | SPI2_GPIO_CLK , ENABLE);*/
  RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA | RCC_APB2Periph_GPIOB | RCC_APB2Periph_SPI1 , ENABLE);

 /* Enable SPIy clock and GPIO clock for SPI2  */
RCC_APB1PeriphClockCmd( RCC_APB1Periph_SPI2, ENABLE);

}

void Delay_ms(uint32_t ms)
{
        volatile uint32_t nCount;
        RCC_ClocksTypeDef RCC_Clocks;
    RCC_GetClocksFreq (&RCC_Clocks);

        nCount=(RCC_Clocks.HCLK_Frequency/10000)*ms;
        for (; nCount!=0; nCount--);
}

void OUTPPOn(OUTPP_TypeDef OUTPP) {
	GPIO_PORT[OUTPP]->BSRR = GPIO_PIN[OUTPP];
}

void OUTPPOff(OUTPP_TypeDef OUTPP) {
	GPIO_PORT[OUTPP]->BRR = GPIO_PIN[OUTPP];
}
/*
И так, дисплей LPH9157-2 G5321272.
0x01 - Программный сброс. (не имеет параметров)
0x11 - Выход из спящего режима. (не имеет параметров)
0x29 - Включение дисплея. (не имеет параметров)
0x28 Display OFF
0x29 Display ON
0x2A - CASET - установка первого и последнего столбца записи в память.
Параметр 1 (8 бит) - xs - первый столбец
Параметр 2 - xe - последний столбец
0 <= xs <= xe <= 131
При вертикальном направлении записи производится установка строки, но границы значений не изменяются.
0x2B - PASET - Установка диапазона строк для записи в память (полностью аналогично CASET)
0 <= ys <= ye <= 175
0x2C - Начало записи в память. По команде "курсор" устанавливается в начальную позицию прямоугольника, заданного командами CASET и PASET. Далее вывод производится циклически. Начальная позиция - соотвественно пиксель, предшествующий все остальные в соответствии с выбранным направлением заполнения. Направление задается командой 0x36.
0x2D - Запись таблицы перекодирования цветов. Палитра раздельная для каждого канала.
16 байт 0bRRRRRXXX - палитра красного
16 байт 0bXXXXXXXX - назначение неизвестно.
16 байт 0bGGGGGGXX - палитра зеленого
16 байт 0bBBBBBXXX - палитра синего
Структура таблицы не зависит от установленной глубины цвета (0x3A). В 8-разрядном режиме используются первые 8 байт палитры красного канала, первые 8 байт палитры зеленого канала, и первые 4 байта палитры синего.

0x36 - Установка направлений заполнения прямоугольника CASET x PASET.
Один параметр 0bVHRXXXXX
V - направление заполнения по вертикали (0 - сверху вниз, 1 - снизу вверх),
H - направление заполнения по горизонтали {0 - слеванаправо, 1 - справаналево),
R - Меняются местами строки и столбцы (при этом заполнение остается сверху вниз, слева направо)
Дисплей экраном на нас, чип сверху контакты сзади внизу
V=0, H=0, R=0 точка скоординатами 0,0 верхний левый угол,
точка 131,175 --правый нижний,
 запись идет слева направо повдоль короткой стороны,
 потом отступ по длинной стороне и снова слева направо.,

0x3A - Установка глубины цвета.
Один параметр 0bXXXXXABC
ABC: 010 - 8bit/pixel (0bRRRGGGBB), 011 - 12bit/pixel (0bRRRRGGGG 0bBBBBRRRR 0bGGGGBBBB), 101 - 16bit/pixel (0bRRRRRGGG 0bGGGBBBBB)
Таблица перекодирования цветов в 16-разрядный формат загружается в дисплей командой 0x2D.
0xCA - Установка направления сканирования матрицы (по-простому, зеркальное отражение дисплея) - не влияет на процесс записи в графическую память!
Один параметр 0bXXXXXXHV
x - не имеет значения, V - бит отражения по вертикали, H - отражение по горизонтали.
*/
//-----------------------------------------------

#define DISP_W 131
#define DISP_H 175

void SendCmdLCD( uint8_t SendData)
{
	OUTPPOff(CS_LPH);
	OUTPPOff(RS_LPH);
  		while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);
  							{
  							SPI_I2S_SendData(SPI2, SendData);
  							}
  		while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) == SET);

  	OUTPPOn(CS_LPH);
}


void SendD8toLCD( uint8_t SendData)
{
	OUTPPOff(CS_LPH);
	OUTPPOn(RS_LPH);

  		while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);
  							{
  							SPI_I2S_SendData(SPI2, SendData);
  							}
  		while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) == SET);

  	OUTPPOff(RS_LPH);
  	OUTPPOn(CS_LPH);
}

 inline void SendD16toLCD( uint16_t SendData)
{
	uint8_t MData , LData ;
	 LData = SendData;
	 MData = SendData >>8;

	OUTPPOff(CS_LPH);
	OUTPPOn(RS_LPH);
  		while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);
  							{
  							SPI_I2S_SendData(SPI2, MData);
  							}
  		while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);
  							{
  							SPI_I2S_SendData(SPI2, LData);
   							}
  		while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) == SET);
  	OUTPPOff(RS_LPH);
  	OUTPPOn(CS_LPH);
}


 void InitLCD(void)
 {
 	OUTPPOn(CS_LPH);
 	OUTPPOff(RS_LPH);
 	OUTPPOff(Res_LPH);
 	Delay_ms(500);
   OUTPPOn(Res_LPH);
   Delay_ms(500);
   SendCmdLCD( 0x01);
   SendCmdLCD( 0x36); //Memory Access Control
   SendD8toLCD( 0b01000000);//0bVHRXXXXX
   // Дисплей будет чипом слева  заполнение будет
   // сверху вниз по короткой стороне потом шаг слева на право
   SendCmdLCD( 0x11); //Sleep out
   Delay_ms(5);
   SendCmdLCD( 0x3a); //Interfase pixel format
   SendD8toLCD( 0x55);
  // Delay_ms(20);
   SendCmdLCD( 0x29); //Display ON
 }


void PutPixel(uint8_t X, uint8_t Y, uint16_t Color)
{

  SendCmdLCD( 0x2a);
 SendD8toLCD( X);
  SendD8toLCD( X);
  SendCmdLCD( 0x2b);
  SendD8toLCD( Y);
  SendD8toLCD( Y);
  SendCmdLCD( 0x2c);
  SendD16toLCD(Color);

}

void PutRec(uint8_t XS, uint8_t XE, uint8_t YS,uint8_t YE, uint16_t Color)
{
 uint16_t PicCount;
 //0 <= xs <= xe <= 131
//	if (XE >131)  XE =131 ;
//	if (XS >XE)  XS = XE ;
	//0 <= ys <= ye <= 175
//	if (YE >175)  YE =175 ;
//	if (YS >YE)  YS = YE ;
	PicCount =((XE-XS)+1)* ((YE-YS)+1);
  SendCmdLCD( 0x2a);
  SendD8toLCD( XS);
  SendD8toLCD( XE);
  SendCmdLCD( 0x2b);
  SendD8toLCD( YS);
  SendD8toLCD( YE);
  SendCmdLCD( 0x2c);

  uint8_t MData , LData ;
  	 LData = Color;
  	 MData = Color >>8;

  	OUTPPOff(CS_LPH);
  	OUTPPOn(RS_LPH);


  for (; PicCount > 0; PicCount--)
  {
	  while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);
	{
	SPI_I2S_SendData(SPI2, MData);
	}
	while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);
	{
	SPI_I2S_SendData(SPI2, LData);
	}
  }
  while (SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_BSY) == SET);
  	    	OUTPPOff(RS_LPH);
  	    	OUTPPOn(CS_LPH);

}



#define CHAR_W 8
#define CHAR_H 11

unsigned int bgcolor=0x0000;  // цвет фона по умолчанию черный

/** массив символов
 *  только большие русские буквы и цифры
 */
const char ascii_tab[48][11]={
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //32

{0x00, 0x00, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0x00, 0x00, 0x00}, //45
{0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00}, //46
{0x00, 0x02, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x80, 0x00, 0x00}, //47
{0x00, 0x7C, 0xC6, 0xCE, 0xDE, 0xF6, 0xE6, 0xC6, 0xC6, 0x7C, 0x00}, //48
{0x00, 0x18, 0x38, 0x78, 0x18, 0x18, 0x18, 0x18, 0x18, 0x7E, 0x00}, //49
{0x00, 0x7C, 0xC6, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC6, 0xFE, 0x00}, //50
{0x00, 0x7C, 0xC6, 0x06, 0x06, 0x3C, 0x06, 0x06, 0xC6, 0x7C, 0x00}, //51
{0x00, 0x0C, 0x1C, 0x3C, 0x6C, 0xCC, 0xFE, 0x0C, 0x0C, 0x1E, 0x00}, //52
{0x00, 0xFE, 0xC0, 0xC0, 0xC0, 0xFC, 0x06, 0x06, 0xC6, 0x7C, 0x00}, //53
{0x00, 0x38, 0x60, 0xC0, 0xC0, 0xFC, 0xC6, 0xC6, 0xC6, 0x7C, 0x00}, //54
{0x00, 0xFE, 0xC6, 0x06, 0x0C, 0x18, 0x30, 0x30, 0x30, 0x30, 0x00}, //55
{0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0xC6, 0xC6, 0xC6, 0x7C, 0x00}, //56
{0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x06, 0x0C, 0x78, 0x00}, //57
{0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00}, //58

{0x38, 0x6C, 0x6C, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //176

{0x00, 0x1E, 0x36, 0x66, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0x00}, //192
{0x00, 0xFE, 0x62, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x66, 0xFC, 0x00}, //193
{0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x66, 0x66, 0x66, 0xFC, 0x00}, //194
{0x00, 0xFE, 0x62, 0x62, 0x60, 0x60, 0x60, 0x60, 0x60, 0xF0, 0x00}, //195
{0x00, 0x1E, 0x36, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0xFF, 0xC3}, //196
{0x00, 0xFE, 0x66, 0x62, 0x68, 0x78, 0x68, 0x62, 0x66, 0xFE, 0x00}, //197
{0x00, 0xD6, 0xD6, 0x54, 0x54, 0x7C, 0x54, 0xD6, 0xD6, 0xD6, 0x00}, //198
{0x00, 0x7C, 0xC6, 0x06, 0x06, 0x3C, 0x06, 0x06, 0xC6, 0x7C, 0x00}, //199
{0x00, 0xC6, 0xC6, 0xCE, 0xDE, 0xF6, 0xE6, 0xC6, 0xC6, 0xC6, 0x00}, //200
{0x38, 0xC6, 0xC6, 0xCE, 0xDE, 0xF6, 0xE6, 0xC6, 0xC6, 0xC6, 0x00}, //201
{0x00, 0xE6, 0x66, 0x6C, 0x6C, 0x78, 0x6C, 0x6C, 0x66, 0xE6, 0x00}, //202
{0x00, 0x1E, 0x36, 0x66, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00}, //203
{0x00, 0xC6, 0xEE, 0xFE, 0xFE, 0xD6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00}, //204
{0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0x00}, //205
{0x00, 0x7C, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7C, 0x00}, //206
{0x00, 0xFE, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x00}, //207
{0x00, 0xFC, 0x66, 0x66, 0x66, 0x7C, 0x60, 0x60, 0x60, 0xF0, 0x00}, //208
{0x00, 0x3C, 0x66, 0xC2, 0xC0, 0xC0, 0xC0, 0xC2, 0x66, 0x3C, 0x00}, //209
{0x00, 0x7E, 0x5A, 0x18, 0x18, 0x18, 0x18, 0x18, 0x18, 0x3C, 0x00}, //210
{0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0xC6, 0x7C, 0x00}, //211
{0x3C, 0x18, 0x7E, 0xDB, 0xDB, 0xDB, 0xDB, 0x7E, 0x18, 0x3C, 0x00}, //212
{0x00, 0xC6, 0xC6, 0x6C, 0x7C, 0x38, 0x7C, 0x6C, 0xC6, 0xC6, 0x00}, //213
{0x00, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xCC, 0xFE, 0x06}, //214
{0x00, 0xC6, 0xC6, 0xC6, 0xC6, 0xC6, 0x7E, 0x06, 0x06, 0x06, 0x00}, //215
{0x00, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xFF, 0x00}, //216
{0x00, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xDB, 0xFF, 0x03}, //217
{0x00, 0xF8, 0xB0, 0x30, 0x3C, 0x36, 0x36, 0x36, 0x36, 0x7C, 0x00}, //218
{0x00, 0xC3, 0xC3, 0xC3, 0xF3, 0xDB, 0xDB, 0xDB, 0xDB, 0xF3, 0x00}, //219
{0x00, 0xF0, 0x60, 0x60, 0x7C, 0x66, 0x66, 0x66, 0x66, 0xFC, 0x00}, //220
{0x00, 0x7C, 0xC6, 0x06, 0x26, 0x3E, 0x26, 0x06, 0xC6, 0x7C, 0x00}, //221
{0x00, 0xCE, 0xDB, 0xDB, 0xDB, 0xFB, 0xDB, 0xDB, 0xDB, 0xCE, 0x00}, //222
{0x00, 0x3F, 0x66, 0x66, 0x66, 0x3E, 0x3E, 0x66, 0x66, 0xE7, 0x00}  //223
};

/** поместить символ в графическую память дисплея
 *  m - масштаб текста. 1-самый маленький, 4 - самый большой
 *  x,y = координаты ; с -код символа
 *
 */
void put_char(uint8_t x, uint8_t y, uint8_t c, uint16_t color, uint8_t m) {

	uint8_t h,ch,p,mask,	w,tt,ind_ch; // char h,ch,p,mask,w,tt,ind_ch;
/* ПОДРАЗУМЕВАЕТСЯ ЧТО прямоугольник с изображением буквы
  в процессе записи в память дисплея будет отображаться
   сначала  сверху вниз  по короткой стороне
   потом шаг слева направо и снова сверху в низ
   При этом  x - Это короткая сторона экрана */

//Coord8=DISP_H - CHAR_H - Coord8;
  SendCmdLCD( 0x2a);
  SendD8toLCD( x);
  SendD8toLCD( x+CHAR_H*m-1);

    SendCmdLCD( 0x2b);
    SendD8toLCD( y);
    SendD8toLCD( y+CHAR_W*m-1);
 SendCmdLCD( 0x2c);
// В шрифте 11 байт каждый из которых есть строка пикселей
// Первй - верхняя, последний -нижняя.
 if (c == 32) {             	 	// Находим в массиве нужный набор
          ind_ch=0;
       }
       else if (c > 44 && c < 59) {
    	   ind_ch=c-44;
       }
       else if (c == 176) {
    	   ind_ch=15;
       }
       else if (c > 191) {
    	   ind_ch=c-176;
       }// Находим индекс нужного набора байт
 mask=0x80;						// Это маска для анализа бита-пикселя
 for(w=0;w<CHAR_W;w++) {
    for(tt=0;tt<m;tt++) {//Будем выводить столько раз какой масштаб
    	for (h=0; h<CHAR_H; h++)   {//Перебирая байты  посылаем биты по маске
    ch=ascii_tab[ind_ch][h]; //   ch=ascii_tab[ind_ch][CHAR_H-h];
    for (p=0; p<m; p++) {  // Посылаем столько раз, сколько масштаб
            if (ch&mask) {				// Наложили маску и сравнили
              SendD16toLCD(color);		// Бит включен -посылаем ЦВЕТ БУКВЫ
            }
            else {						// Бит вЫключен -посылаем фон
              SendD16toLCD(bgcolor);
                  }
    }						// Посылаем столько раз, сколько масштаб
    	}//Перебирая байты  посылаем биты по маске

    }//Будем выводить столько раз какой масштаб
mask=mask >>1;//  сдвигаем маску
 }
}

// вывести строку, начиная с координат x,y, цветом color
// m - масштаб текста. 1-самый маленький, 4 - самый большой
void put_string(uint8_t x, uint8_t y, char *str, uint16_t color, char m) {

	uint8_t j=0;
  while (j<strlen(str)) {
    put_char(x,y+j*CHAR_W*m,str[j],color,m);
    j++;
  }
}

