/**
  ******************************************************************************
  * @file    SPI/FullDuplex_SoftNSS/platform_config.h 
  * @author  MCD Application Team
  * @version V3.5.0
  * @date    08-April-2011
  * @brief   Evaluation board specific configuration file.
  ******************************************************************************
  * @attention
  *
  * THE PRESENT FIRMWARE WHICH IS FOR GUIDANCE ONLY AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING THEIR PRODUCTS IN ORDER FOR THEM TO SAVE
  * TIME. AS A RESULT, STMICROELECTRONICS SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES WITH RESPECT TO ANY CLAIMS ARISING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR THE USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN CONNECTION WITH THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2011 STMicroelectronics</center></h2>
  ******************************************************************************
  */ 

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __PLATFORM_CONFIG_H
#define __PLATFORM_CONFIG_H

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_conf.h"
/* Exported types ------------------------------------------------------------*/
typedef enum {
	LED8 = 0, LED9 = 1,LED10 = 2, LED11 = 3, RS_LPH = 4, Res_LPH = 5,CS_LPH =6
} OUTPP_TypeDef;
/* Exported constants --------------------------------------------------------*/
/* Uncomment the line corresponding to the STMicroelectronics evaluation board
   used to run the example */
//#if !defined (USE_STM32100B_EVAL) && !defined (USE_STM3210B_EVAL) &&  !defined (USE_STM3210E_EVAL) &&  !defined (USE_STM3210C_EVAL) &&  !defined (USE_STM32100E_EVAL)
 //#define USE_STM32100B_EVAL
 //#define USE_STM3210B_EVAL
 //#define USE_STM3210E_EVAL
 //#define USE_STM32100E_EVAL
// #define USE_STM3210C_EVAL
//#endif

/* Define the STM32F10x hardware depending on the used evaluation board */
//#if defined (USE_STM3210B_EVAL) || defined (USE_STM3210E_EVAL) || defined(USE_STM32100B_EVAL) || defined (USE_STM32100E_EVAL)
//  #define SPIy                   SPI1
  #define SPI1_CLK               RCC_APB2Periph_SPI1
  #define SPI1_GPIO              GPIOA
  #define SPI1_GPIO_CLK          RCC_APB2Periph_GPIOA
  #define SPI1_PIN_NSS			 GPIO_Pin_4
  #define SPI1_PIN_SCK           GPIO_Pin_5
  #define SPI1_PIN_MISO          GPIO_Pin_6
  #define SPI1_PIN_MOSI          GPIO_Pin_7
  

  #define SPI2_CLK                RCC_APB1Periph_SPI2
  #define SPI2_GPIO               GPIOB
  #define SPI2_GPIO_CLK           RCC_APB2Periph_GPIOB
  #define SPI2_PIN_SCK            GPIO_Pin_13
  #define SPI2_PIN_MISO           GPIO_Pin_14
  #define SPI2_PIN_MOSI           GPIO_Pin_15
  /*#define SPI2_PIN_NSS         	  GPIO_Pin_12*/
          
/*!   #elif defined (USE_STM3210C_EVAL)
  #define SPIy                   SPI3   // SPI pins are remapped by software
  #define SPIy_CLK               RCC_APB1Periph_SPI3
  #define SPIy_GPIO              GPIOC
  #define SPIy_GPIO_CLK          RCC_APB2Periph_GPIOC  
  #define SPIy_PIN_SCK           GPIO_Pin_10
  #define SPIy_PIN_MISO          GPIO_Pin_11
  #define SPIy_PIN_MOSI          GPIO_Pin_12
  
  #define SPIz                    SPI2
  #define SPIz_CLK                RCC_APB1Periph_SPI2
  #define SPIz_GPIO               GPIOB
  #define SPIz_GPIO_CLK           RCC_APB2Periph_GPIOB
  #define SPIz_PIN_SCK            GPIO_Pin_13
  #define SPIz_PIN_MISO           GPIO_Pin_14
  #define SPIz_PIN_MOSI           GPIO_Pin_15

 #endif
*/


#define OUTPPn                             7
#define LED8_PIN                         GPIO_Pin_8
#define LED8_GPIO_PORT                   GPIOB
#define LED8_GPIO_CLK                    RCC_APB2Periph_GPIOB

#define LED9_PIN                         GPIO_Pin_9
#define LED9_GPIO_PORT                   GPIOB
#define LED9_GPIO_CLK                    RCC_APB2Periph_GPIOB

#define LED10_PIN                         GPIO_Pin_10
#define LED10_GPIO_PORT                   GPIOB
#define LED10_GPIO_CLK                    RCC_APB2Periph_GPIOB

#define LED11_PIN                         GPIO_Pin_11
#define LED11_GPIO_PORT                   GPIOB
#define LED11_GPIO_CLK                    RCC_APB2Periph_GPIOB



#define RS_LPH_PIN                         		GPIO_Pin_9
#define RS_LPH_GPIO_PORT                   GPIOA
#define RS_LPH_GPIO_CLK                    RCC_APB2Periph_GPIOA

#define Res_LPH_PIN                         		GPIO_Pin_10
#define Res_LPH_GPIO_PORT                   GPIOA
#define Res_LPH_GPIO_CLK                    RCC_APB2Periph_GPIOA

#define CS_LPH_PIN                         		GPIO_Pin_12
#define CS_LPH_GPIO_PORT                   GPIOB
#define CS_LPH_GPIO_CLK                    RCC_APB2Periph_GPIOB


/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void RCC_Configuration(void);
//void GPIO_SPI1_Conf(uint16_t SPI_Mode);
void SPI1_On(void);
void SPI2_On(void);
void OUTPPInit(OUTPP_TypeDef OUTPP);
void MCOInit(void);
void OUTPPOn(OUTPP_TypeDef OUTPP);
void OUTPPOff(OUTPP_TypeDef OUTPP);
void PutPixel(uint8_t X, uint8_t Y, uint16_t Color);
inline void PutRec(uint8_t XS, uint8_t XE, uint8_t YS,uint8_t YE, uint16_t Color);
void put_string(uint8_t x, uint8_t y, char *str, uint16_t color, char m);
void InitLCD(void);
void Delay_ms(uint32_t ms);

#endif /* __PLATFORM_CONFIG_H */

/******************* (C) COPYRIGHT 2011 STMicroelectronics *****END OF FILE****/

