
;CodeVisionAVR C Compiler V1.25.9 Professional
;(C) Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATmega8
;Program type           : Application
;Clock frequency        : 8,000000 MHz
;Memory model           : Small
;Optimize for           : Speed
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External SRAM size     : 0
;Data Stack size        : 256 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : No
;char is unsigned       : Yes
;8 bit enums            : Yes
;Word align FLASH struct: No
;Enhanced core instructions    : On
;Smart register allocation : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega8
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1024
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

	.CSEG
	.ORG 0

	.INCLUDE "1wire.vec"
	.INCLUDE "1wire.inc"

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,13
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x400)
	LDI  R25,HIGH(0x400)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x45F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x45F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x160)
	LDI  R29,HIGH(0x160)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x160
;       1 /*****************************************************
;       2 This program was produced by the
;       3 CodeWizardAVR V1.25.9 Professional
;       4 Automatic Program Generator
;       5  Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;       6 http://www.hpinfotech.com
;       7 
;       8 Project : 1wire-slave 
;       9 Version : 1.01
;      10 Date    : 01.02.2013
;      11 Author  : oka275 aka alex08cb@mail.ru
;      12 Company : oka275 home studio
;      13 Comments: -    (  1wire),     1 .
;      14 Chip type           : ATmega8
;      15 Program type        : Application
;      16 Clock frequency     : 8,000000 MHz
;      17 Memory model        : Small
;      18 External SRAM size  : 0
;      19 Data Stack size     : 256
;      20 *****************************************************/
;      21 
;      22 #include <mega8.h>
;      23 	#ifndef __SLEEP_DEFINED__
	#ifndef __SLEEP_DEFINED__
;      24 	#define __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
;      25 	.EQU __se_bit=0x80
	.EQU __se_bit=0x80
;      26 	.EQU __sm_mask=0x70
	.EQU __sm_mask=0x70
;      27 	.EQU __sm_powerdown=0x20
	.EQU __sm_powerdown=0x20
;      28 	.EQU __sm_powersave=0x30
	.EQU __sm_powersave=0x30
;      29 	.EQU __sm_standby=0x60
	.EQU __sm_standby=0x60
;      30 	.EQU __sm_ext_standby=0x70
	.EQU __sm_ext_standby=0x70
;      31 	.EQU __sm_adc_noise_red=0x10
	.EQU __sm_adc_noise_red=0x10
;      32 	.SET power_ctrl_reg=mcucr
	.SET power_ctrl_reg=mcucr
;      33 	#endif
	#endif
;      34 #include <delay.h>
;      35 //#define LED PORTD.0
;      36 
;      37 #define PORTx PORTD.2 //  ,     1ware    LOW LEVEL
;      38 #define PINx  PIND.2   //  ,     1ware    LOW LEVEL
;      39 #define DDRx   DDRD.2   //,    (/) 
;      40 //     asm-  SetPortInput()!!!!!!!!!!!!!!
;      41 
;      42 unsigned char MY_ROM[]={0x1D,0,0,0,0,0,0x1,0}; // ROM!   ,  CRC (    !)
_MY_ROM:
	.BYTE 0x8
;      43 //unsigned char MY_ROM[]={0x28,0xE1,0x1F,0x36,0x04,0x00,0x00,0xCC}; // ROM   DS18b20 ( )
;      44 unsigned char ROM_INPUT[]={0,0,0,0,0,0,0,0};  //   ROM   Match ROM [55h]  .   MY_ROM
_ROM_INPUT:
	.BYTE 0x8
;      45 unsigned char INPUT_BUFFER[]={0,0,0,0,0,0,0,0}; //  
_INPUT_BUFFER:
	.BYTE 0x8
;      46 unsigned char OUTPUT_BUFFER[]={1,1,2,3,3,4,5,0};//  / .
_OUTPUT_BUFFER:
	.BYTE 0x8
;      47 
;      48 unsigned char crc,bytecnt;
;      49 bit mute_on;
;      50 unsigned char crc_recive_error=1;
;      51 
;      52 void SetPortInput()//     
;      53 {

	.CSEG
_SetPortInput:
;      54 DDRx=0;PORTx=1;delay_us(1);
	CBI  0x11,2
	SBI  0x12,2
	__DELAY_USB 3
;      55 }
	RET
;      56 
;      57 void SetPortOutput()//     
;      58 {
_SetPortOutput:
;      59 DDRx=1;PORTx=1;
	SBI  0x11,2
	SBI  0x12,2
;      60 }
	RET
;      61 
;      62 void DelayForUpDown() //       
;      63         {
_DelayForUpDown:
;      64 SetPortInput(); //     (   )
	RCALL _SetPortInput
;      65 
;      66  #asm
;      67 ;    (  )
;    (  )
;      68 ;!!!       ,  
;!!!       ,  
;      69 ;   .    sbis $10,2     
;   .    sbis $10,2      
;      70 ; sbic $10,2     .  10 -   ( 
; sbic $10,2     .  10 -   ( 
;      71 ;  ,  2 -  .     PORTD.2  ATMega8.
;  ,  2 -  .     PORTD.2  ATMega8.
;      72 

;      73 ldi r30,2      ;  
ldi r30,2      ;  
;      74 ldi r31,70     ;  
ldi r31,70     ;  
;      75 cpi r30,0      ;  ,     ..
cpi r30,0      ;  ,     ..
;      76 BRNE lab1      ;.. (    ,   )
BRNE lab1      ;.. (    ,   )
;      77 cpi r31,0
cpi r31,0   
;      78 BREQ ext1
BREQ ext1    
;      79 lab1: sbiw  R30,1
lab1: sbiw  R30,1 
;      80 ;       !!!
;       !!!
;      81 sbis $10,2  ; sbic -   $10(pinD)  2.   ,     ( )
sbis $10,2  ; sbic -   $10(pinD)  2.   ,     ( )
;      82 brne  lab1
brne  lab1   
;      83 ext1:
ext1:           
;      84 

;      85 ;     ( )
;     ( )
;      86 ;      ,      .
;      ,      .
;      87 ldi r30,2
ldi r30,2
;      88 ldi r31,70
ldi r31,70
;      89 cpi r30,0
cpi r30,0
;      90 BRNE lab2
BRNE lab2  
;      91 cpi r31,0
cpi r31,0   
;      92 BREQ ext2
BREQ ext2    
;      93 lab2: sbiw  R30,1
lab2: sbiw  R30,1 
;      94 ;       !!!
;       !!! 
;      95 sbic $10,2  ; sbic -   $10(pinD)  2.   ,     ( )
sbic $10,2  ; sbic -   $10(pinD)  2.   ,     ( )
;      96 brne  lab2
brne  lab2   
;      97 ext2:
ext2:           
;      98 
        
;      99 ;    
;    
;     100 ; ldi r17,1 ;35
; ldi r17,1 ;35
;     101 ; cc: subi  R17,1  ;    1
; cc: subi  R17,1  ;    1
;     102 ; cpi r17,0
; cpi r17,0
;     103 ; NOP
; NOP
;     104 ; brne cc    ;      ,     ( + 2    0.25)
; brne cc    ;      ,     ( + 2    0.25)
;     105  #endasm
;     106         }
	RET
;     107 
;     108 void SendPresense() //   
;     109         {
_SendPresense:
;     110         delay_us(15);
	__DELAY_USB 40
;     111         SetPortOutput();
	RCALL _SetPortOutput
;     112         PORTx=0;
	CBI  0x12,2
;     113         delay_us(100);
	__DELAY_USW 200
;     114         PORTx=1;
	SBI  0x12,2
;     115         SetPortInput();
	RCALL _SetPortInput
;     116         delay_us(20);
	__DELAY_USB 53
;     117         }
	RET
;     118 
;     119 unsigned int crc8(unsigned int seed, unsigned int inData)// CRC.
;     120 //: c=00; crc=0; for(c=0; c<7; c++) crc=crc8(crc,   );//
;     121 {
_crc8:
;     122   //  .     !!!  !!!
;     123 unsigned int bitsLeft=0;
;     124 unsigned int tempp=0;
;     125 
;     126 	for (bitsLeft=8;bitsLeft>0;bitsLeft--)
	RCALL __SAVELOCR4
;	seed -> Y+6
;	inData -> Y+4
;	bitsLeft -> R16,R17
;	tempp -> R18,R19
	LDI  R16,0
	LDI  R17,0
	LDI  R18,0
	LDI  R19,0
	__GETWRN 16,17,8
_0x13:
	CLR  R0
	CP   R0,R16
	CPC  R0,R17
	BRSH _0x14
;     127 	{
;     128 	tempp=((seed^inData)&0x01);
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	EOR  R26,R30
	EOR  R27,R31
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	AND  R30,R26
	AND  R31,R27
	MOVW R18,R30
;     129 	if(tempp==0) seed >>= 1;
	MOV  R0,R18
	OR   R0,R19
	BRNE _0x15
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	LSR  R31
	ROR  R30
	STD  Y+6,R30
	STD  Y+6+1,R31
;     130         	else
	RJMP _0x16
_0x15:
;     131 		{
;     132 		 seed ^=0x18;
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LDI  R30,LOW(24)
	LDI  R31,HIGH(24)
	EOR  R30,R26
	EOR  R31,R27
	STD  Y+6,R30
	STD  Y+6+1,R31
;     133 		 seed >>=1;
	LSR  R31
	ROR  R30
	STD  Y+6,R30
	STD  Y+6+1,R31
;     134 		 seed |=0x80;
	LDD  R30,Y+6
	ORI  R30,0x80
	STD  Y+6,R30
;     135 		}
_0x16:
;     136 		inData >>= 1;
	LDD  R30,Y+4
	LDD  R31,Y+4+1
	LSR  R31
	ROR  R30
	STD  Y+4,R30
	STD  Y+4+1,R31
;     137 	}
	__SUBWRN 16,17,1
	RJMP _0x13
_0x14:
;     138 	return seed;
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	RCALL __LOADLOCR4
	ADIW R28,8
	RET
;     139 }
;     140 
;     141 unsigned char get_byte() //    
;     142         {
_get_byte:
;     143 static unsigned char c=0;

	.DSEG

	.CSEG
;     144 static unsigned char GetByte=0;

	.DSEG

	.CSEG
;     145          for (c=0; c<8; c++)
	CLR  R6
_0x18:
	LDI  R30,LOW(8)
	CP   R6,R30
	BRSH _0x19
;     146            {
;     147            DelayForUpDown(); // 
	RCALL _DelayForUpDown
;     148            delay_us(25);     //     
	__DELAY_USB 67
;     149            GetByte>>=1;      //    1  ( )
	LSR  R9
;     150            GetByte|=PINx<<7; //        .
	LDI  R30,0
	SBIC 0x10,2
	LDI  R30,1
	ROR  R30
	LDI  R30,0
	ROR  R30
	OR   R9,R30
;     151            }
	INC  R6
	RJMP _0x18
_0x19:
;     152            return GetByte;   //  
	MOV  R30,R9
	RET
;     153         }
;     154 
;     155 void send_byte(unsigned char sndbyte) //    
;     156         {
_send_byte:
;     157 static unsigned char v=0;

	.DSEG

	.CSEG
;     158 
;     159 
;     160          for (v=0; v<8; v++)
;	sndbyte -> Y+0
	CLR  R8
_0x1B:
	LDI  R30,LOW(8)
	CP   R8,R30
	BRSH _0x1C
;     161            {
;     162            DelayForUpDown(); // 
	RCALL _DelayForUpDown
;     163            SetPortOutput();  //    
	RCALL _SetPortOutput
;     164            delay_us(6);      //,        
	__DELAY_USB 16
;     165            PORTx=sndbyte&0b00000001; //   ,    
	LD   R30,Y
	ANDI R30,LOW(0x1)
	BRNE _0x1D
	CBI  0x12,2
	RJMP _0x1E
_0x1D:
	SBI  0x12,2
_0x1E:
;     166            delay_us(33);     //     
	__DELAY_USB 88
;     167            PORTx=1;          // ,   
	SBI  0x12,2
;     168 
;     169            sndbyte>>=1;      //     
	LD   R30,Y
	LSR  R30
	ST   Y,R30
;     170           }
	INC  R8
	RJMP _0x1B
_0x1C:
;     171 
;     172         }
	ADIW R28,1
	RET
;     173 
;     174 void load_inbox_Match_ROM() // ROM,       " -  "
;     175 {
_load_inbox_Match_ROM:
;     176 static unsigned char c=0;

	.DSEG

	.CSEG
;     177 for (c=0; c<8; c++)   //   8.    8   ?
	CLR  R11
_0x22:
	LDI  R30,LOW(8)
	CP   R11,R30
	BRSH _0x23
;     178    {
;     179    ROM_INPUT[c]=get_byte(); //   
	MOV  R30,R11
	LDI  R31,0
	SUBI R30,LOW(-_ROM_INPUT)
	SBCI R31,HIGH(-_ROM_INPUT)
	PUSH R31
	PUSH R30
	RCALL _get_byte
	POP  R26
	POP  R27
	ST   X,R30
;     180    }
	INC  R11
	RJMP _0x22
_0x23:
;     181 }
	RET
;     182 
;     183 void get_MY_SCRATCHPAD() // SCRATCHPAD.        7(!) .
;     184 {                        //      INPUT_BUFFER[]    
_get_MY_SCRATCHPAD:
;     185 static unsigned char c=0;

	.DSEG

	.CSEG
;     186 for (c=0; c<8; c++) //   8.    8   ?
	CLR  R10
_0x25:
	LDI  R30,LOW(8)
	CP   R10,R30
	BRSH _0x26
;     187    {
;     188    INPUT_BUFFER[c]=get_byte(); //   .  .
	MOV  R30,R10
	LDI  R31,0
	SUBI R30,LOW(-_INPUT_BUFFER)
	SBCI R31,HIGH(-_INPUT_BUFFER)
	PUSH R31
	PUSH R30
	RCALL _get_byte
	POP  R26
	POP  R27
	ST   X,R30
;     189    }
	INC  R10
	RJMP _0x25
_0x26:
;     190 c=0;
	CLR  R10
;     191 for(c=0; c<7; c++)crc=crc8(crc,INPUT_BUFFER[c]); //  crc,  7 .
	CLR  R10
_0x28:
	LDI  R30,LOW(7)
	CP   R10,R30
	BRSH _0x29
	MOV  R30,R5
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R10
	LDI  R31,0
	SUBI R30,LOW(-_INPUT_BUFFER)
	SBCI R31,HIGH(-_INPUT_BUFFER)
	LD   R30,Z
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	RCALL _crc8
	MOV  R5,R30
;     192 crc_recive_error=crc-INPUT_BUFFER[7];           //  crc   ,  crc_recive_error=0
	INC  R10
	RJMP _0x28
_0x29:
	__GETB2MN _INPUT_BUFFER,7
	MOV  R30,R5
	SUB  R30,R26
	MOV  R7,R30
;     193 }
	RET
;     194 
;     195 void send_MY_SCRATCHPAD()// SCRATCHPAD.  18b20  .       7(!) .
;     196 {                        //      .
_send_MY_SCRATCHPAD:
;     197  unsigned char c=0;
;     198  crc=0;
	ST   -Y,R17
;	c -> R17
	LDI  R17,0
	CLR  R5
;     199  for(c=0; c<7; c++)crc=crc8(crc,OUTPUT_BUFFER[c]);// crc   7 .  crc,   .
	LDI  R17,LOW(0)
_0x2B:
	CPI  R17,7
	BRSH _0x2C
	MOV  R30,R5
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_OUTPUT_BUFFER)
	SBCI R31,HIGH(-_OUTPUT_BUFFER)
	LD   R30,Z
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	RCALL _crc8
	MOV  R5,R30
;     200  OUTPUT_BUFFER[7]=crc; // crc        ( )
	SUBI R17,-1
	RJMP _0x2B
_0x2C:
	__PUTBMRN _OUTPUT_BUFFER,7,5
;     201  for (c=0; c<8; c++)send_byte(OUTPUT_BUFFER[c]);   //  ,  .
	LDI  R17,LOW(0)
_0x2E:
	CPI  R17,8
	BRSH _0x2F
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_OUTPUT_BUFFER)
	SBCI R31,HIGH(-_OUTPUT_BUFFER)
	LD   R30,Z
	ST   -Y,R30
	RCALL _send_byte
;     202 }
	SUBI R17,-1
	RJMP _0x2E
_0x2F:
	LD   R17,Y+
	RET
;     203 
;     204 void send_MY_ROM() //   ROM_CODE (ROM-  slave-)
;     205 {
_send_MY_ROM:
;     206  static unsigned char c=0;

	.DSEG

	.CSEG
;     207  for (c=0; c<8; c++) send_byte(MY_ROM[c]);   //   MY_SCRATCHPAD
	CLR  R13
_0x31:
	LDI  R30,LOW(8)
	CP   R13,R30
	BRSH _0x32
	MOV  R30,R13
	LDI  R31,0
	SUBI R30,LOW(-_MY_ROM)
	SBCI R31,HIGH(-_MY_ROM)
	LD   R30,Z
	ST   -Y,R30
	RCALL _send_byte
;     208 }
	INC  R13
	RJMP _0x31
_0x32:
	RET
;     209 
;     210 /*
;     211 void LED_FLASH()
;     212 {
;     213 LED=0;
;     214 delay_ms(10);
;     215 LED=1;
;     216 }
;     217 */
;     218 
;     219 /*
;     220 void LED_PIN()
;     221 {
;     222 LED=0;
;     223 delay_us(1);
;     224 LED=1;
;     225 }
;     226 */
;     227 
;     228 unsigned char compare_Match_ROM()//  ROM (  )  .   ,    "0"
;     229 {
_compare_Match_ROM:
;     230  static unsigned char c=0;

	.DSEG

	.CSEG
;     231  static unsigned char compare=0;

	.DSEG
_compare_SB:
	.BYTE 0x1

	.CSEG
;     232  for (c=0; c<8; c++) if (ROM_INPUT[c]!=MY_ROM[c]) compare++; //    ROM-
	CLR  R12
_0x34:
	LDI  R30,LOW(8)
	CP   R12,R30
	BRSH _0x35
	MOV  R30,R12
	LDI  R31,0
	MOVW R0,R30
	SUBI R30,LOW(-_ROM_INPUT)
	SBCI R31,HIGH(-_ROM_INPUT)
	LD   R30,Z
	MOV  R26,R30
	MOVW R30,R0
	SUBI R30,LOW(-_MY_ROM)
	SBCI R31,HIGH(-_MY_ROM)
	LD   R30,Z
	CP   R30,R26
	BREQ _0x36
	LDS  R30,_compare_SB
	SUBI R30,-LOW(1)
	STS  _compare_SB,R30
;     233  return compare;
_0x36:
	INC  R12
	RJMP _0x34
_0x35:
	LDS  R30,_compare_SB
	RET
;     234 }
;     235 
;     236 void search_rom() //    0xF0 (SEARCH ROM)
;     237 {
_search_rom:
	PUSH R15
;     238 unsigned char byte_count,bit_count,snd_byte;
;     239 bit snd_bit;
;     240 #define delay 30 //  "0"  ,  
;     241 
;     242       for (byte_count=0; byte_count<8; byte_count++) //  8 ,     8   ROM-, ?
	RCALL __SAVELOCR4
;	byte_count -> R17
;	bit_count -> R16
;	snd_byte -> R19
;	snd_bit -> R15.0
	LDI  R17,LOW(0)
_0x38:
	CPI  R17,8
	BRSH _0x39
;     243              {
;     244              snd_byte=MY_ROM[byte_count]; //    ROM,       snd_byte
;	snd_bit -> R15.0
	MOV  R30,R17
	LDI  R31,0
	SUBI R30,LOW(-_MY_ROM)
	SBCI R31,HIGH(-_MY_ROM)
	LD   R19,Z
;     245              for (bit_count=0; bit_count<8; bit_count++) //   8 ,     8 , ?
	LDI  R16,LOW(0)
_0x3B:
	CPI  R16,8
	BRSH _0x3C
;     246                         {
;     247                            //      
;     248                            snd_bit=snd_byte&0b00000001; //       .     !
;	snd_bit -> R15.0
	BST  R19,0
	BLD  R15,0
;     249                            //  () :
;     250                            DelayForUpDown(); // 
	RCALL _DelayForUpDown
;     251                            SetPortOutput();  //    .         .
	RCALL _SetPortOutput
;     252                            if(!mute_on) PORTx=snd_bit; //   0,    ( "0" ).  1,   (  ,   "1")
	SBRC R2,0
	RJMP _0x3D
	SBRC R15,0
	RJMP _0x3E
	CBI  0x12,2
	RJMP _0x3F
_0x3E:
	SBI  0x12,2
_0x3F:
;     253                            delay_us(delay); // .  snd_bit=0,     .  1,      .
_0x3D:
	__DELAY_USB 80
;     254                            PORTx=1;       // .        1,     .
	SBI  0x12,2
;     255                            // .  mute_on  1,        .    
;     256                            //,       .   break,        .
;     257 
;     258                            //    ,  
;     259                            DelayForUpDown(); // 
	RCALL _DelayForUpDown
;     260                            SetPortOutput();   //    .         .
	RCALL _SetPortOutput
;     261                            if(!mute_on) PORTx=~snd_bit; //   ,    .
	SBRC R2,0
	RJMP _0x42
	SBRS R15,0
	RJMP _0x43
	CBI  0x12,2
	RJMP _0x44
_0x43:
	SBI  0x12,2
_0x44:
;     262                            delay_us(delay);  // .  snd_bit=0,     .  1,      .
_0x42:
	__DELAY_USB 80
;     263                            PORTx=1;        // .        1,     .
	SBI  0x12,2
;     264                            //  ,     .
;     265 
;     266                            //    .  ,       "" , 
;     267                            // ,      ,        .
;     268                            //      ,        
;     269                            //       .   () ()      .
;     270                            //, :
;     271                            DelayForUpDown(); // 
	RCALL _DelayForUpDown
;     272                            delay_us(5);      //    
	__DELAY_USB 13
;     273                            if((!PINx==snd_bit)&&(!mute_on)) mute_on=1; // .       ,    mute_on=1   .     
	LDI  R30,0
	SBIS 0x10,2
	LDI  R30,1
	MOV  R26,R30
	LDI  R30,0
	SBRC R15,0
	LDI  R30,1
	CP   R30,R26
	BRNE _0x48
	SBRS R2,0
	RJMP _0x49
_0x48:
	RJMP _0x47
_0x49:
	SET
	BLD  R2,0
;     274                            snd_byte>>=1;     //       1 .   7    6,
_0x47:
	LSR  R19
;     275                                              // 6    5    0.
;     276                         }
	SUBI R16,-1
	RJMP _0x3B
_0x3C:
;     277              }
	SUBI R17,-1
	RJMP _0x38
_0x39:
;     278         // DelayForUpDown(); //     .   ,     .     .
;     279 }
	RCALL __LOADLOCR4
	ADIW R28,4
	POP  R15
	RET
;     280 
;     281 
;     282 interrupt [EXT_INT0] void ext_int0_isr(void)
;     283 {// Place your code here
_ext_int0_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
;     284 unsigned char command=0;           //   
;     285 static unsigned char time_reset_count=0; //       

	.DSEG
_time_reset_count_SD:
	.BYTE 0x1

	.CSEG
;     286 start:
	ST   -Y,R17
;	command -> R17
	LDI  R17,0
_0x4A:
;     287 //  ( )  .
;     288 time_reset_count=0;  // ,     .
	LDI  R30,LOW(0)
	STS  _time_reset_count_SD,R30
;     289 mute_on=0;           //   (   SEARCH_ROM)
	CLT
	BLD  R2,0
;     290 
;     291 //,     ,        1.
;     292 while(!PINx){time_reset_count++;} //  ,   .      ()
_0x4B:
	SBIC 0x10,2
	RJMP _0x4D
	LDS  R30,_time_reset_count_SD
	SUBI R30,-LOW(1)
	STS  _time_reset_count_SD,R30
	RJMP _0x4B
_0x4D:
;     293 if(time_reset_count<8) goto exit;   //      480 (     480!)
	LDS  R26,_time_reset_count_SD
	CPI  R26,LOW(0x8)
	BRLO _0x4F
;     294                                     //      
;     295 
;     296 //   480,            
;     297 SendPresense();     //  ,     .
	RCALL _SendPresense
;     298 command=get_byte(); //  /    
	RCALL _get_byte
	MOV  R17,R30
;     299 
;     300 //   Match ROM [55h],        ROM-.
;     301 if(command==0x55)//    64   -     
	CPI  R17,85
	BRNE _0x50
;     302                 {// !!!!
;     303                 load_inbox_Match_ROM(); // Match ROM,   ,      (   ??)
	RCALL _load_inbox_Match_ROM
;     304                 if(!compare_Match_ROM()) //  ROM  .  0,     !     !
	RCALL _compare_Match_ROM
	CPI  R30,0
	BRNE _0x51
;     305                 {//   Match_ROM   ,     !!
;     306                 command=get_byte(); //   (  0xBE - Read Scratchpad [BEh])
	RCALL _get_byte
	MOV  R17,R30
;     307             if(command==0xBE) send_MY_SCRATCHPAD(); //   ,     Scratchpad,  ,      0xBE,  
	CPI  R17,190
	BRNE _0x52
	RCALL _send_MY_SCRATCHPAD
;     308             if(command==0x4E) get_MY_SCRATCHPAD();  //  Scratchpad   (8  )+ ccrc_recive_error
_0x52:
	CPI  R17,78
	BRNE _0x53
	RCALL _get_MY_SCRATCHPAD
;     309             if(command==0x4F) send_byte(crc_recive_error); //  "    ?" (get_MY_SCRATCHPAD();)
_0x53:
	CPI  R17,79
	BRNE _0x54
	ST   -Y,R7
	RCALL _send_byte
;     310                 //.      
;     311                 //.      
;     312                 }
_0x54:
;     313                 }// If (command==0x55)
_0x51:
;     314 
;     315 if(command==0xf0) //  "SEARCH ROM"
_0x50:
	CPI  R17,240
	BRNE _0x55
;     316                 {
;     317                 search_rom(); // 
	RCALL _search_rom
;     318                 delay_us(200); // ,         (       )
	__DELAY_USW 400
;     319                 goto start; //      
	RJMP _0x4A
;     320                 }
;     321 
;     322 if(command==0x33)//  READ ROM [33h] (  ROM )
_0x55:
	CPI  R17,51
	BRNE _0x56
;     323                 {
;     324                 send_MY_ROM(); //   ROM
	RCALL _send_MY_ROM
;     325                 }
;     326 
;     327 exit:
_0x56:
_0x4F:
;     328 }
	LD   R17,Y+
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;     329 
;     330 // Declare your global variables here
;     331 
;     332 
;     333 void main(void)
;     334 {
_main:
;     335 // Declare your local variables here
;     336 
;     337 // Input/Output Ports initialization
;     338 // Port B initialization
;     339 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;     340 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;     341 PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
;     342 DDRB=0x00;
	OUT  0x17,R30
;     343 
;     344 // Port C initialization
;     345 // Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;     346 // State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;     347 PORTC=0x00;
	OUT  0x15,R30
;     348 DDRC=0x00;
	OUT  0x14,R30
;     349 
;     350 // Port D initialization
;     351 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=In Func1=Out Func0=Out
;     352 // State7=1 State6=1 State5=1 State4=1 State3=1 State2=P State1=1 State0=1
;     353 PORTD=0xFF;
	LDI  R30,LOW(255)
	OUT  0x12,R30
;     354 DDRD=0xFB;
	LDI  R30,LOW(251)
	OUT  0x11,R30
;     355 
;     356 // Port D initialization
;     357 // Func7=In Func6=In Func5=In Func4=In Func3=Out Func2=In Func1=In Func0=Out
;     358 // State7=T State6=T State5=T State4=T State3=1 State2=P State1=T State0=1
;     359 //PORTD=0x0D;
;     360 //DDRD=0x09;
;     361 
;     362 // Timer/Counter 0 initialization
;     363 // Clock source: System Clock
;     364 // Clock value: Timer 0 Stopped
;     365 TCCR0=0x00;
	LDI  R30,LOW(0)
	OUT  0x33,R30
;     366 TCNT0=0x00;
	OUT  0x32,R30
;     367 
;     368 // Timer/Counter 1 initialization
;     369 // Clock source: System Clock
;     370 // Clock value: Timer 1 Stopped
;     371 // Mode: Normal top=FFFFh
;     372 // OC1A output: Discon.
;     373 // OC1B output: Discon.
;     374 // Noise Canceler: Off
;     375 // Input Capture on Falling Edge
;     376 // Timer 1 Overflow Interrupt: Off
;     377 // Input Capture Interrupt: Off
;     378 // Compare A Match Interrupt: Off
;     379 // Compare B Match Interrupt: Off
;     380 TCCR1A=0x00;
	OUT  0x2F,R30
;     381 TCCR1B=0x00;
	OUT  0x2E,R30
;     382 TCNT1H=0x00;
	OUT  0x2D,R30
;     383 TCNT1L=0x00;
	OUT  0x2C,R30
;     384 ICR1H=0x00;
	OUT  0x27,R30
;     385 ICR1L=0x00;
	OUT  0x26,R30
;     386 OCR1AH=0x00;
	OUT  0x2B,R30
;     387 OCR1AL=0x00;
	OUT  0x2A,R30
;     388 OCR1BH=0x00;
	OUT  0x29,R30
;     389 OCR1BL=0x00;
	OUT  0x28,R30
;     390 
;     391 // Timer/Counter 2 initialization
;     392 // Clock source: System Clock
;     393 // Clock value: Timer 2 Stopped
;     394 // Mode: Normal top=FFh
;     395 // OC2 output: Disconnected
;     396 ASSR=0x00;
	OUT  0x22,R30
;     397 TCCR2=0x00;
	OUT  0x25,R30
;     398 TCNT2=0x00;
	OUT  0x24,R30
;     399 OCR2=0x00;
	OUT  0x23,R30
;     400 
;     401 // External Interrupt(s) initialization
;     402 // INT0: On
;     403 // INT0 Mode: Low level
;     404 // INT1: Off
;     405 GICR|=0x40;
	IN   R30,0x3B
	ORI  R30,0x40
	OUT  0x3B,R30
;     406 MCUCR=0x00;
	LDI  R30,LOW(0)
	OUT  0x35,R30
;     407 GIFR=0x40;
	LDI  R30,LOW(64)
	OUT  0x3A,R30
;     408 
;     409 // Timer(s)/Counter(s) Interrupt(s) initialization
;     410 TIMSK=0x00;
	LDI  R30,LOW(0)
	OUT  0x39,R30
;     411 
;     412 // Analog Comparator initialization
;     413 // Analog Comparator: Off
;     414 // Analog Comparator Input Capture by Timer/Counter 1: Off
;     415 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
;     416 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
;     417 
;     418 // Global enable interrupts
;     419 #asm("sei")
	sei
;     420 
;     421 // crc  ROM,            
;     422 crc=0;
	CLR  R5
;     423 for(bytecnt=0; bytecnt<7; bytecnt++) crc=crc8(crc,MY_ROM[bytecnt]);// crc   7 .  crc.
	CLR  R4
_0x58:
	LDI  R30,LOW(7)
	CP   R4,R30
	BRSH _0x59
	MOV  R30,R5
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	MOV  R30,R4
	LDI  R31,0
	SUBI R30,LOW(-_MY_ROM)
	SBCI R31,HIGH(-_MY_ROM)
	LD   R30,Z
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	RCALL _crc8
	MOV  R5,R30
;     424 MY_ROM[7]=crc; // crc    ( )
	INC  R4
	RJMP _0x58
_0x59:
	__PUTBMRN _MY_ROM,7,5
;     425 //crc  ROM !!!
;     426 
;     427 
;     428 while (1)
_0x5A:
;     429       {
;     430 
;     431 //delay_ms(1000);
;     432 
;     433       };
	RJMP _0x5A
;     434 
;     435 
;     436 
;     437 }
_0x5D:
	RJMP _0x5D


__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

;END OF CODE MARKER
__END_OF_CODE:
