//  Device(s)...: ATMega128
//  Compiler....: Winavr-20100110
//  LCD Nokia6610 ( ONLY PCF8833 )
//******************************************************************************

#include "Nokia6610_lcd_lib.h"
#include <util/delay.h>             //  
#include "Nokia6610_fnt8x8.h"
//******************************************************************************
unsigned char VertDelta=0; //  


void nlcd_Init(void)   //    PCF8833
{	
//         LCD-
	// DDR_LCD |= (1<<SCLK_LCD_PIN)|(1<<SDA_LCD_PIN)|(1<<CS_LCD_PIN)|(1<<RST_LCD_PIN);
	DDR_SCLK |= (1<<SCLK_LCD_PIN);
	DDR_SDA |= (1<<SDA_LCD_PIN);
	DDR_CS |= (1<<CS_LCD_PIN);
	DDR_RST |= (1<<RST_LCD_PIN);
	
	
	CS_LCD_RESET;
	SDA_LCD_RESET;
	SCLK_LCD_SET;
	
	RST_LCD_SET;       //     ********************************************** 
	RST_LCD_RESET;    //     *                                             *

	_delay_ms(20);   //     *         *
	RST_LCD_SET;      //     *                                             *
    _delay_ms(20);    //     **********************************************
    SCLK_LCD_SET;
    SDA_LCD_SET;
    SCLK_LCD_SET;
	
 #ifndef USE_SOFT_SPI
// 	SPSR = (1 << SPI2X);
 #endif
	
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SWRESET);   //      
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SLEEPOUT);  //       
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_BSTRON);    //    .   
	_delay_ms(10);                                      //          
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_DISPON);    //     .  
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_NORON);     //      - .                                                       
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_PASET);     //              
	nlcd_SendByte(DATA_LCD_MODE,0);                     //                                                         
	nlcd_SendByte(DATA_LCD_MODE,0x83);                  //                                                         
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_CASET);     //             
	nlcd_SendByte(DATA_LCD_MODE,0);                     //                                                        
	nlcd_SendByte(DATA_LCD_MODE,0x83);                  // 
	_delay_ms(5);									 
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_RAMWR);     //        RAM 	
	_delay_ms(50);                                      //      
	
	#ifdef DISPLAY_INVERTING
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_INVON);    //       - 
    #else
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_INVOFF);    //       - 
	#endif
	                                                    //    ******************************************************
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_COLMOD);    //   *                :                          *
	nlcd_SendByte(DATA_LCD_MODE,0x03);                  //  *     12   - 4096  RGB 3:3:2          * 
/*
 nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_RGBSET);//Affectation palette de couleurs
   //Les 8 niveaux de rouge cods sur 4 bits
    // color table
    //RED
    nlcd_SendByte(DATA_LCD_MODE,0);
    nlcd_SendByte(DATA_LCD_MODE,2);
    nlcd_SendByte(DATA_LCD_MODE,4);
    nlcd_SendByte(DATA_LCD_MODE,6);
    nlcd_SendByte(DATA_LCD_MODE,8);
    nlcd_SendByte(DATA_LCD_MODE,10);
    nlcd_SendByte(DATA_LCD_MODE,12);
    nlcd_SendByte(DATA_LCD_MODE,15);
    // GREEN
    nlcd_SendByte(DATA_LCD_MODE,0);
    nlcd_SendByte(DATA_LCD_MODE,2);
    nlcd_SendByte(DATA_LCD_MODE,4);
    nlcd_SendByte(DATA_LCD_MODE,6);
    nlcd_SendByte(DATA_LCD_MODE,8);
    nlcd_SendByte(DATA_LCD_MODE,10);
    nlcd_SendByte(DATA_LCD_MODE,12);
    nlcd_SendByte(DATA_LCD_MODE,15);
    //BLUE
    nlcd_SendByte(DATA_LCD_MODE,0);
    nlcd_SendByte(DATA_LCD_MODE,4);
    nlcd_SendByte(DATA_LCD_MODE,9);
    nlcd_SendByte(DATA_LCD_MODE,15);
*/
	                                                    //  **********************************************************
														
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_MADCTL);    //          RAM 
    nlcd_SendByte(DATA_LCD_MODE,0x00);                  //   1-byte,   000 -    
	                                                    //                 . 43
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON);   //                                              
    nlcd_SendByte(DATA_LCD_MODE,45);                 //         0x00-min   0x3F-max 2d
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_DISPOFF);  //            
	nlcd_Box(0, 0, 131, 131, 1, BLACK);                //         -   
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_DISPON);   //      .
} 
void nlcdOff()
{
nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_BSTROFF);    //    .   
nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_DISPOFF);  //      
while(!(SPSR & (1<<SPIF))); // ,  
//SPCR |= (0<<SPIE)|(0<<SPE)|(0<<MSTR)|(0<<CPOL)|(0<<CPHA); //  SPI!
CS_LCD_SET;
SCLK_LCD_SET;
SDA_LCD_RESET;
RST_LCD_RESET;
// SPCR &= ~(1<<SPE); //  SPI!
SPCR = 0;
_delay_ms(5);
DDRB = 0;
PORTB = 0;
// DDRB |= (0 << DDB0)|(0 << DDB1)|(0 << DDB2)|(0 << DDB3);
// PORTB |= (0 << PB0)|(0 << PB1)|(0 << PB2)|(0 << PB3);
}	
   
//******************************************************************************
//    (  )  LCD-
//  mode: CMD_LCD_MODE  -  
//		  DATA_LCD_MODE -  
//  c:      
void nlcd_SendByte(char mode,unsigned char c)
{

    CS_LCD_RESET;
    SCLK_LCD_RESET;
    if(mode) SDA_LCD_SET;
	else     SDA_LCD_RESET;
    
	SCLK_LCD_SET;

#ifdef SOFTSPI
    for(unsigned char i=0;i<8;i++)
    {
    	SCLK_LCD_RESET;
        if(c & 0x80) SDA_LCD_SET;
        else	     SDA_LCD_RESET;
        SCLK_LCD_SET;
        c <<= 1;
        _delay_us(NLCD_MIN_DELAY);
    }

#else // SOFTSPI
	//DDR_SPI = (1<<DD_MOSI)|(1<<DD_SCK);

	SPCR = (0<<SPIE)|(1<<SPE)|(0<<DORD)|(1<<MSTR)|(1<<CPOL)|(1<<CPHA)|(0<<SPR1)|(0<<SPR0);	// Enable Hardware SPI
	SPSR |= (1<<SPI2X);

    SPDR = c;
    while(!(SPSR & (1<<SPIF)));
    SPCR = 0;
	c <<= 1;
	_delay_us(NLCD_MIN_DELAY);
#endif // SOFTSPI

    CS_LCD_SET;
}

//******************************************************************************
//	: 		 GotoXY(unsigned char x, unsigned char y)	 
// 	:       x, y
//           	 GotoXY( x, y)
//	:   x:  0-131
//			     y:  0-131
//  :		 GotoXY(32,17);        
//******************************************************************************
void nlcd_GotoXY(unsigned char x, unsigned char y)
{	
     //ymax = ymax+VertDelta; // Corr X px DOWN
	 //ymin = ymin+VertDelta; // Corr X px DOWN
   nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_PASET);   //    RAM
   nlcd_SendByte(DATA_LCD_MODE,x);                   // 
   nlcd_SendByte(DATA_LCD_MODE,x);                   // 
  
   nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_CASET);   //    RAM
   nlcd_SendByte(DATA_LCD_MODE,y);                   // 
   nlcd_SendByte(DATA_LCD_MODE,y);                   // 
}

//******************************************************************************
//	: 		 nlcd_Pixel(unsigned char x, unsigned char y, int color)	 
// 	:     Pixel   x, y,  color
//           	 nlcd_Pixel( x, y,color)
//	:   x:      0-131
//			     y:      0-131
//               color:  (12-bit . #define) 
//  :		 nlcd_Pixel(21,45,BLACK);
//******************************************************************************
void nlcd_Pixel(unsigned char x, unsigned char y, int color)
{
	x = x+VertDelta; // Corr X px DOWN
   
   nlcd_GotoXY(x,y);
   nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_RAMWR);                             
   CS_LCD_RESET;

   nlcd_SendByte(DATA_LCD_MODE,(color >> 4) & 0xFF );
   nlcd_SendByte(DATA_LCD_MODE,((color & 0xF) << 4) | ((color >> 8) & 0xF) );
   nlcd_SendByte(DATA_LCD_MODE,color & 0xFF);
  
 //  nlcd_SendByte(DATA_LCD_MODE, (unsigned char)((color>>4)& 0xff) );
 //  nlcd_SendByte(DATA_LCD_MODE, (unsigned char)((color&0xf)<<4)|0x00 );
   
   CS_LCD_SET;
   nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_NOP);
}

//******************************************************************************
//	: 		 nlcd_Line(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, int color)	 
// 	:        x0, y0   x1, y1  color
//           	 nlcd_Line(x0, y0, x1, y1, color)
//	:   x:      0-131
//			     y:      0-131
//               color:  (12-bit . #define) 
//  :		 nlcd_Line(25,60,25,80,RED);
//******************************************************************************
void nlcd_Line(unsigned char y0, unsigned char x0, unsigned char y1, unsigned char x1, int color)
{ 
	x0=x0+VertDelta;
	x1=x1+VertDelta;
   int dy = y1 - y0; 
   int dx = x1 - x0; 
   int stepx, stepy; 
   if (dy < 0) { dy = -dy;  stepy = -1; } else { stepy = 1; } 
   if (dx < 0) { dx = -dx;  stepx = -1; } else { stepx = 1; } 
 
   dy <<= 1;                              // dy is now 2*dy 
   dx <<= 1;                              // dx is now 2*dx 
 
 
   nlcd_Pixel(x0-VertDelta, y0, color); 
 
   if (dx > dy) 
   { 
       int fraction = dy - (dx >> 1);     // same as 2*dy - dx 
       while (x0 != x1) 
	   { 
 	       if (fraction >= 0) 
		   { 
 		       y0 += stepy; 
               fraction -= dx;            // same as fraction -= 2*dx 
 		   } 
 		   x0 += stepx; 
           fraction += dy;                // same as fraction -= 2*dy 
           nlcd_Pixel(x0-VertDelta, y0, color); 
       } 
   } 
 	else
    { 
 	    int fraction = dx - (dy >> 1); 
        while (y0 != y1) 
		{ 
 		    if (fraction >= 0) 
		    { 
 		        x0 += stepx; 
 				fraction -= dy; 
            } 
            y0 += stepy; 
 			fraction += dx; 
            nlcd_Pixel(x0-VertDelta, y0, color); 
       } 
 	} 
 
} 

//******************************************************************************
//	: 		 nlcd_Box(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned char fill, int color) 
// 	:        x0, y0   x1, y1    ,  color
//           	 nlcd_Line(x0, y0, x1, y1, fill, color)
//	:   x:      0-131
//			     y:      0-131
//               fill:  1- , 0- 
//               color:  (12-bit . #define) 
//  :		 nlcd_Box(20,30,40,50,1,RED);  //  
//******************************************************************************

void nlcd_Box(unsigned char x0, unsigned char y0, unsigned char x1, unsigned char y1, unsigned char fill, int color)
{ 
	unsigned char   xmin, xmax, ymin, ymax; 
	int   i;                                     
	y0=y0+VertDelta;
	y1=y1+VertDelta;
	if (fill == FILL)                                   //  ******************************************************
    {                                                   //  *  -        *              *
        ymin = (x0 <= x1) ? x0 : x1;                   //  *    2   1               *
 		ymax = (x0 > x1) ? x0 : x1;                    //  *     X  Y             *
		xmin = (y0 <= y1) ? y0 : y1;                   //  ******************************************************* 
		xmax = (y0 > y1) ? y0 : y1; 

//		xmax = xmax+VertDelta; // Corr X px DOWN

                                                            //    *****************************************************
		nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_PASET);    //   *               RAM                 *
		nlcd_SendByte(DATA_LCD_MODE,xmin);                 //   *         *
		nlcd_SendByte(DATA_LCD_MODE,xmax);                 //   *                                 *
		nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_CASET);    //   *               RAM                *
		nlcd_SendByte(DATA_LCD_MODE,ymin);                 //   *                                                    *
		nlcd_SendByte(DATA_LCD_MODE,ymax);                 //   ******************************************************
 
		nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_RAMWR);    //          RAM
		                                                   //
                                                           //           / 2 
											               //
	
														   
		for (i = 0; i < ((((xmax - xmin + 1) * (ymax - ymin + 1))/2 )+1 ); i++) 
		   { 
                  
  		      //      3   -  2  
              CS_LCD_RESET;
  		      nlcd_SendByte(DATA_LCD_MODE,(color >> 4) & 0xFF ); 
  		      nlcd_SendByte(DATA_LCD_MODE,((color & 0xF) << 4) | ((color >> 8) & 0xF) ); 
 		      nlcd_SendByte(DATA_LCD_MODE,color & 0xFF);
              CS_LCD_SET;
		   } 
           nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_NOP); 
	} 
    else 
	   {  
	  	y0=y0-VertDelta;
		y1=y1-VertDelta;

		  nlcd_Line(x0, y0, x1, y0, color);               //   
 	 	  nlcd_Line(x0, y1, x1, y1, color); 
 	 	  nlcd_Line(x0, y0, x0, y1, color); 
 	 	  nlcd_Line(x1, y0, x1, y1, color); 
       }
}

//******************************************************************************
//	: 		 nlcd_Circle(unsigned char x0, unsigned char y0, unsigned char radius, int color)	 
// 	:        x0, y0,     color
//           	 nlcd_Circle(x0, y0, radius, color)
//	:   x:        0-131
//			     y:        0-131
//               radius:    
//               color:  (12-bit . #define) 
//  :		 nlcd_Circle(10,55,2,BLUE);
//******************************************************************************
void nlcd_Circle(unsigned char y0, unsigned char x0, unsigned char radius, int color) 
{ 
    int f = 1 - radius; 
	int ddF_x = 0; 
    int ddF_y = -2 * radius; 
    unsigned char x = 0; 
    unsigned char y = radius; 
 
    nlcd_Pixel(x0, y0 + radius, color); 
    nlcd_Pixel(x0, y0 - radius, color); 
    nlcd_Pixel(x0 + radius, y0, color); 
    nlcd_Pixel(x0 - radius, y0, color); 
  
    while (x < y) 
	{ 
        if (f >= 0) 
		{ 
 
            y--; 
            ddF_y += 2; 
            f += ddF_y; 
        } 
		
    x++; 
    ddF_x += 2; 
    f += ddF_x + 1;
	
    nlcd_Pixel(x0 + x, y0 + y, color); 
    nlcd_Pixel(x0 - x, y0 + y, color); 
    nlcd_Pixel(x0 + x, y0 - y, color); 
    nlcd_Pixel(x0 - x, y0 - y, color); 
    nlcd_Pixel(x0 + y, y0 + x, color); 
    nlcd_Pixel(x0 - y, y0 + x, color); 
    nlcd_Pixel(x0 + y, y0 - x, color); 
    nlcd_Pixel(x0 - y, y0 - x, color); 

    } 
}

//******************************************************************************
//	: 		nlcd_Char(char c, unsigned char x, unsigned char y, int fColor, int bColor, char size)  	 
// 	:       x,y,  fcolor,   bcolor   	 
//	:  x:        0-131
//			    y:        0-131
//         fcolor:        (12-bit . #define)
//         bcolor:        (12-bit . #define)     
//  :	
//******************************************************************************  

void nlcd_Char(unsigned char c, unsigned char x, unsigned char y, int fColor, int bColor, unsigned char Fsize, unsigned char Font, unsigned char Alpha) 
{ 
   unsigned char  i; 
   unsigned char  j;
   unsigned char  k;
   unsigned char  l;
   unsigned char  m;
   unsigned char   Xoset=0;
   unsigned char   Yoset=0;
   unsigned char   Xc; 
   unsigned char   Yc; 
   unsigned char   printable; 
   
   unsigned int    nCols; 
   unsigned int    nRows; 
   unsigned int    nBytes; 
   unsigned char   PixelRow; 
   unsigned char   Mask; 
   unsigned int    Word0;
   unsigned char   *pFont;  
   unsigned char   *pChar;
   
   
   if (Fsize>15) Fsize=15; //.
   if (Fsize<1) Fsize=1; //  .
   

   
   if (c>127) c=c-64; 	             //      
						             //   (   0x80).   Chipper-   !
   
if (Font==8)
   pFont = (unsigned char *)Nokia6610_fnt8x8;   
else
   pFont = (unsigned char *)Nokia6610_fnt6x8;   
 
   nCols = pgm_read_byte(pFont); 
 
   nRows = pgm_read_byte(pFont + 1); 
 
   nBytes = pgm_read_byte(pFont + 2); 
   
   pChar = pFont + (nBytes * (c - 0x1F)); 
 
   for (i = 0; i<nCols; i++)
   {  
      PixelRow = pgm_read_byte(pChar++); 
      Mask = 0x80; 
	  
      for (j = 0; j < nRows; j +=1 ) 
	  {  
		 printable=1;
         if ((PixelRow & Mask) == 0) 
		 {
			if(Alpha) printable=0; 
         Word0 = bColor; 
		 }		 
         else 
         Word0 = fColor; 
	 l=0;
	 k=0;

	  do { 
	 

  do { 
	  if (Fsize >1) 
	  {
		 do {
			 
			 if(printable) { // 	 
			Xc=x+i+l+Yoset;
			Yc=y-j-k-Xoset-m-1-2;
			if ((Yc<132)&(Xc<132)) nlcd_Pixel(Yc,Xc, Word0);
			} //
			
			} while (m++ < (Fsize-2));
	  }	 	 
			 if(printable) { // 	 	
           Xc = x+i+l+Yoset;
		   Yc = y-j-k-Xoset-2;
		   if ((Yc<132)&(Xc<132)) nlcd_Pixel(Yc,Xc, Word0);
		   } //
	  l++;
	  m=0;	   
  } while (l < Fsize);
	  k++;
	  
	    } while (k < 1);
		 			
 		  Mask = Mask >> 1; 
Xoset += (Fsize-1);
      } 
Xoset=0;

Yoset += (Fsize-1);  	 	  
   } 


   nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_NOP);  
} 

//******************************************************************************
//	: 		nlcd_Text(char *ptext, unsigned char x, unsigned char  y,  int fColor, int bColor)  	 
// 	:       x, y,  fColor,   bColor	 
//	:  x:        0-131
//			    y:        0-131
//              fColor:   (12-bit . #define)
//              bColor:   (12-bit . #define)
//  :		nlcd_Text("Hello",40,12,WHITE,BLACK);
//****************************************************************************** 
/*
void nlcd_Text(char *ptext, unsigned char x, unsigned char  y,  int fColor, int bColor,  unsigned char Fz, unsigned char Font) 
{ 
unsigned char interval;
	if (Font==8) interval=8;
	else interval=6;
   while (*ptext != 0x00) 
   { 
      nlcd_Char(*ptext++, x, y, fColor, bColor, Fz, Font); 
      x=x+((interval*Fz)-(Fz-1));
      if (y > 131) break; 
   } 
} 
*/
void nlcd_Text(unsigned char ptext[22], unsigned char x, unsigned char  y,  int fColor, int bColor,  unsigned char Fz, unsigned char Font, unsigned char Alpha) 
{ 
char f=0;
unsigned char interval;
	if (Font==8) interval=8;
	else interval=6;
   while (ptext[f] != 0x00) 
   { 
      nlcd_Char(ptext[f], x, y, fColor, bColor, Fz, Font, Alpha); 
	  f++;
      x=x+((interval*Fz)-(Fz-1));
      if (y > 131) break; 
   } 
} 
//******************************************************************************
//	: 		 nlcd_Bitmap(unsigned char start_x, unsigned char start_y, unsigned char h_size, unsigned char v_size, unsigned char *bitmap_data) 	 
// 	:        x, y,(   ),       (  ),   	 
//	:   x:             0-131
//               y:             0-131
//               h_size:        0-131
//               v_size:        0-131   
//  :      nlcd_Bitmap (41, 41, 50 , 50, bitmap_data);
//******************************************************************************
//
//                           !
//           , ..  
//     .jpeg 1600768  100100 .bmp -  h_size  v_size   
//    100  100 ().     .
//		 
//******************************************************************************  
void nlcd_Bitmap(unsigned char start_y, unsigned char start_x, unsigned char v_size, unsigned char h_size, unsigned char *bitmap_data) 
{
    int i;
	start_x = start_x+VertDelta; // Corr X px DOWN
	unsigned char *pBitmap;
	//        
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_PASET);   //    RAM
    nlcd_SendByte(DATA_LCD_MODE,start_x);             // 
    nlcd_SendByte(DATA_LCD_MODE,start_x+h_size-1);    // 
  
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_CASET);   //    RAM
    nlcd_SendByte(DATA_LCD_MODE,start_y);             // 
    nlcd_SendByte(DATA_LCD_MODE,start_y+v_size-1);    // 

    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_RAMWR);   //   RAM
	
    pBitmap = (unsigned char *)bitmap_data;

	for (i = 0; i< (h_size*v_size)>>1  ; i++) 
	{ 
	    unsigned char bitmap;                  
        CS_LCD_RESET;
        
        bitmap = pgm_read_byte(pBitmap++);
		nlcd_SendByte(DATA_LCD_MODE,bitmap);
  		  bitmap =pgm_read_byte(pBitmap++);
		nlcd_SendByte(DATA_LCD_MODE,bitmap);  
  		  bitmap =pgm_read_byte(pBitmap++);
		nlcd_SendByte(DATA_LCD_MODE,bitmap); 
		  CS_LCD_SET;
	} 
    nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_NOP); 
	
}

