//***************************************************************************
//  Author(s)...: MadOrc (madorc@gmx.com)
//  Device(s)...: ATMega128
//  Compiler....: Winavr-20100110
//  Version.....: 2.2
//    1,1,130,130
//***************************************************************************

#define F_CPU 8000000UL
// #define SOFTSPI //   
// #define DISPLAY_INVERTING //   
// #define SET2SBM20 //  ,   - 

#include <avr/io.h>              //  -
#include <util/delay.h>          //  
#include "Nokia6610_lcd_lib.c"   // LCD Nokia6610 (  PCF8833 ) PHILIPS
#include <avr/pgmspace.h>        
#include <avr/interrupt.h>
#include <avr/eeprom.h>

#include "icons.h"               //     
#include "sound.h"               //     

unsigned char charging, tick=0;
volatile unsigned char svalue[22];
volatile unsigned int VoltLevel, VL;
volatile unsigned int hv_low;


#ifndef EEMEM
#define EEMEM__attribute__ ((section (".eeprom")))
#endif


//***************************************************************************
unsigned char k, inital_started=0;
unsigned int year=2013, date=20, month=6;
unsigned char hours=23, minute=00, second=50;
volatile unsigned char key, precise_type=0, precise_step=0;
unsigned char redraw, do_check_batt, redraw_partial=0, redraw_partial_add=0, refresh_by_second, sound_on=1;
unsigned char menuitem, menuscreen, w_old, gone_powerdown=0;
char *days[]={"","","","","","",""};
char *daysfull[]={"","","    ","      ","    ","    ","    "};

unsigned int selected_fg=BLACK;
unsigned int selected_bg=YELLOW;
unsigned char errtype, no_imp_error;
unsigned int unselected_fg=GREEN;
unsigned int unselected_bg=BLACK, volt_level_error, volt_level_shutdown;
unsigned int volt_level_error_threshold=356; //   
unsigned int volt_level_poweroff_threshold=290; //     

unsigned char menu_level0=1, menu_level1, menu_level2, menu_level3, punkt; //    
// level0 - main 0/1 level1 [0-4] etc...

// ***   

unsigned char	brightness=50, 
				contrast=70,
				imp_imp=4,
				ion=118;
				imp_idle=3, 
				imp_base=13, 
				brightness_dimm=10,
				sbm0_graph_type=1,
				sbm1_graph_type=2,
				snd_geiger=0, // 1  2  3  0 
				snd_keys=1; // 1  2  0 


unsigned long	sbm0_precise_gamma,
				sbm0_precise_betgamma,
				alarm_level=40, 
				sbm0_full_dose, //   
				sbm0_abs_max; //    
				

// volatile unsigned long sbm0_dose_day[33]={410,1290,310,330,5000,430,3167,319,1430,531,430,3031,410,1290,310,330,3000,430,3167,319,1430,531,430,2031}; //       !!!!!!!!!!!!!!!!!!!!!!!!
unsigned long sbm0_dose_day[33]; //     


unsigned int	beta_square,
				sleep_time=60, 

				awaken=30, 
				full_bright=15,

				sbm0_full_dose_days; //       


// ****// ***  
//unsigned char eeVar = 200;//byte
//unsigned short int eeWord EEMEM = 32768;//word

unsigned char	EEMEM  e_brightness=50, 
				EEMEM  e_contrast=70,
				EEMEM  e_imp_imp=4, 
				EEMEM  e_imp_idle=3, 
				EEMEM  e_imp_base=15, 
				EEMEM  e_brightness_dimm=10,
				EEMEM  e_sbm0_graph_type=1,
				EEMEM  e_sbm1_graph_type=2;
				EEMEM  e_snd_geiger=2, // 1  2  3  0 
				EEMEM  e_snd_keys=2; // 1  2  0 
				EEMEM  e_ion=118; // 1  2  0 

unsigned long	EEMEM  e_alarm_level=40, 
				EEMEM  e_sbm0_full_dose, //   
				EEMEM  e_sbm0_abs_max; //    

unsigned int	EEMEM  e_sleep_time=60, 
				EEMEM  e_sbm0_full_dose_days; //       


#ifdef SET2SBM20
unsigned int	EEMEM  e_beta_square=1080; // 10.8 cm2  
#else
unsigned int	EEMEM  e_beta_square=540; // 5.4 cm2  
#endif

unsigned long	EEMEM  e_sbm0_dose_day[33]; //     

//***************************************************************************
volatile unsigned long pcm_length, sample;
int soft_ovf, vibplay, rcf, sample_count;
unsigned char refresh_clock, refresh_fon, refresh_count_interval, flashlight;
unsigned long pompa;
unsigned char beep_enabled=0, geiger=0, beep=0, rad_click=0, rad_beep=0, rc;
unsigned char *melody;
unsigned int i, impulse_pump;
unsigned int delta_os;
volatile unsigned char alarm_cancelled=0, alarming=0, sleep_restricted=0, alarm_restricted=0;
unsigned char message_drawn=0, punkt_naznachenija=0; 


// volatile unsigned char imp_imp=3, imp_idle=3, imp_base=5; 

//  
volatile unsigned int sbm0[74]; //  . -20   5000 /,  - 
volatile unsigned int sbm1[74];

volatile unsigned long sbm0_per_second_rad_sum; //     .     . .

unsigned int sbm0_min[62]; //    

// volatile unsigned long sbm0_hour[26]={2500,34,56,45,21,2233,36,433,21,1043,65,45,21,12,23,36,21,56,34,32,6223,23,36,21}; //     NJKMRJ NTCN!!!!!!!!!
unsigned int sbm0_hour[26]; //    ,     


unsigned long sbm0_abs_max_today; //    

unsigned char sbm_counter;
unsigned char sbm1_count_time;
unsigned char sbm0_count_time;
volatile unsigned long rad;
unsigned char count_validate=73;

unsigned char digit[5];
unsigned char old_digit[5];
unsigned long div_graph_sbm0, div_graph_sbm1;
unsigned long raddisp, day_fon;

unsigned int sbm0_approx_fon_today;
char sbm0_day_fon_cntr;


unsigned char precise_counter_enable=0, precise_count_finished=0;;
unsigned int  precise_minutes=10, precise_seconds_counter;
volatile unsigned long precise_impulses;


// proto
void button(unsigned char button_number, unsigned char *bitmap);
unsigned char days_in_month(unsigned char monthnumber, unsigned int yar);
void Geiger_sound();
int WeekD(unsigned int zdate, unsigned int zmonth, unsigned int zyear);
void main_screen_fon_sbm0();
void check_alarm(unsigned int radlevel);
void(* resetMC) (void) = 0; // Reset MC 
void PinsOn();
void PinsOff();
	 
// /proto


// *************   .    
void ee_update_settings()
{
eeprom_update_dword(&e_alarm_level, alarm_level);
eeprom_update_word(&e_sleep_time, sleep_time);
eeprom_update_word(&e_beta_square, beta_square);

eeprom_update_byte(&e_brightness, brightness);
eeprom_update_byte(&e_contrast, contrast);
eeprom_update_byte(&e_imp_imp, imp_imp);
eeprom_update_byte(&e_imp_idle, imp_idle);
eeprom_update_byte(&e_imp_base, imp_base);
eeprom_update_byte(&e_brightness_dimm, brightness_dimm);
eeprom_update_byte(&e_ion, ion);
}	
				
void ee_update_doses_daily()
{
eeprom_update_byte(&e_sbm0_graph_type, sbm0_graph_type);
eeprom_update_byte(&e_sbm1_graph_type, sbm1_graph_type);
eeprom_update_byte(&e_snd_geiger, snd_geiger);
eeprom_update_byte(&e_snd_keys, snd_keys);

eeprom_update_dword(&e_sbm0_full_dose_days, sbm0_full_dose_days);
eeprom_update_dword(&e_sbm0_full_dose, sbm0_full_dose);
eeprom_update_dword(&e_sbm0_abs_max, sbm0_abs_max);

for (i=0;i<34;i++)
{
eeprom_update_dword(&e_sbm0_dose_day[i], sbm0_dose_day[i]);
}


}

void ee_read_settings()
{
alarm_level = eeprom_read_dword(&e_alarm_level);	
sleep_time = eeprom_read_word(&e_sleep_time);
beta_square = eeprom_read_word(&e_beta_square);
brightness = eeprom_read_byte(&e_brightness);
contrast = eeprom_read_byte(&e_contrast);
imp_imp = eeprom_read_byte(&e_imp_imp);
imp_idle = eeprom_read_byte(&e_imp_idle);
imp_base = eeprom_read_byte(&e_imp_base);
brightness_dimm = eeprom_read_byte(&e_brightness_dimm);
ion = eeprom_read_byte(&e_ion);
}	
				
void ee_read_doses_daily()
{
sbm0_graph_type = eeprom_read_byte(&e_sbm0_graph_type);
sbm1_graph_type = eeprom_read_byte(&e_sbm1_graph_type);
snd_geiger = eeprom_read_byte(&e_snd_geiger);
snd_keys = eeprom_read_byte(&e_snd_keys);

sbm0_full_dose_days = eeprom_read_dword(&e_sbm0_full_dose_days);
sbm0_full_dose = eeprom_read_dword(&e_sbm0_full_dose);
sbm0_abs_max = eeprom_read_dword(&e_sbm0_abs_max);

for (i=0;i<34;i++)
{
 sbm0_dose_day[i] = eeprom_read_dword(&e_sbm0_dose_day[i]);
}

}
// *************   .    
				
// 
//***********
ISR(INT0_vect) //  
{
	if (gone_powerdown) //   ,   
	{ 
	//  . 
	resetMC();
	}
	PinsOn();
	awaken=sleep_time+2;
	full_bright=brightness_dimm+2;
	// lcd on etc
	PORTC |= (1<<PC1); //  
    nlcd_Init();                                        // 
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast);
	OCR3A = brightness;
	MCUCR |= (0 << SE); //PowerSave Disable
    EIMSK &= ~(1<< INT0); //
	_delay_ms(1);
	redraw=1;
	display(); //  ,      
	// asm("wdr");	
}

ISR(INT1_vect) //    0
{
sbm0[0]++;

if (precise_counter_enable) 
 {
precise_impulses++;
 } 

if((PINC&(1 << PC0))==0 )//  400
{
	hv_low=0;
	impulse_pump=imp_base+(sbm0[0]*imp_imp);
//	rad_beep=1;
}
else
{
	hv_low++;
// rad_click=1;	
    impulse_pump=((hv_low*imp_base)+(sbm0[0]*imp_imp));

}

if (delta_os<hv_low) delta_os=hv_low; //  ""

    // 
    for(i=0;i<impulse_pump;i++)
    {
PORTD |= (1<<PD7);
        _delay_us(1);
PORTD &= ~(1<<PD7);
        _delay_us(8);
	}		

if (awaken) Geiger_sound(); //    
}

ISR (ADC_vect) //  
{
	VL=(ion*255)/((int)(ADCH-1)); // 1.213333  (    1.01  1.2      ADC_VALUE = V_BG * 255/Vcc)
}


ISR(TIMER0_COMP_vect)
{
if ((!sleep_restricted)&&(sleep_time))
{ // sleep_restricted
if (awaken) awaken--; //   
if (awaken==1)
	{

		// LCD off etc
	nlcdOff();	
	PinsOff();
	PORTC &= ~(1<<PC1); //   OFF
	PORTC &= ~(1<<PC2); //  
	OCR3A = 0; //  OFF
	MCUCR |= (0 << SM2)|(1 << SM1)|(1 << SM0)|(1 << SE); //PowerSave
//	TIMSK &= ~(1 << TOIE2); //    
	OCR1A = 0;
	beep_enabled=0;
	sample=0;
    menu_level0=1;
    menu_level1=0;
    menu_level2=0;
    EIMSK |= (1 << INT0); //
	}
if ((full_bright)&&(brightness_dimm)) full_bright--;	//    
if (full_bright==1) { OCR3A = 1; }; //  
} // sleep_restricted
else
{ //      	 
if ((sleep_time)&&(full_bright)&&(brightness_dimm)) full_bright--;	//    
if ((sleep_time)&&(full_bright==1)) { OCR3A = 2; }; //  
}
div_graph_sbm0=3; //  3     , 
div_graph_sbm1=3;
#ifdef SET2SBM20
    for(k=73;k>0;k--)
    {
    sbm0_per_second_rad_sum=sbm0_per_second_rad_sum+sbm0[k]; //    
	sbm0[k]=sbm0[k-1];
    if ((sbm0[k]>div_graph_sbm0)&&(k<61)) div_graph_sbm0=sbm0[k]; //  .     
	}
    sbm0[0]=0;
	sbm1[0]=0;
#else
    for(k=73;k>0;k--)
    {
    sbm0_per_second_rad_sum=sbm0_per_second_rad_sum+sbm0[k]; //    
	sbm0[k]=sbm0[k-1];
    if ((sbm0[k]>div_graph_sbm0)&&(k<61)) div_graph_sbm0=sbm0[k]; //  .     
	}
    sbm0[0]=0;
	sbm1[0]=0;
#endif
	
	if (count_validate>0) count_validate--;
	

second++;				//  
for (rc=1;rc<37;rc++) {rcf=rcf+sbm0[rc];};
#ifdef SET2SBM20
rcf=rcf/2;
#endif	
   if (alarm_level) check_alarm(rcf);
rcf=0;

if (precise_counter_enable) 
 {
 precise_seconds_counter--;
 if (precise_seconds_counter==0) 
       {
	   precise_counter_enable=0;
	   precise_count_finished=1;
	   }
 }
 
if(second == 60)        //  second = 60, second = 0
{  
   second = 0;
   #ifdef SET2SBM20
   sbm0_min[minute] = (sbm0_per_second_rad_sum/4)/60; //    72,   60 , 2 ,   18,  /4
   #else
   sbm0_min[minute] = (sbm0_per_second_rad_sum/2)/60; //   72    36,   60 ,  
   #endif
   if (!sbm0_per_second_rad_sum) {no_imp_error++; hv_low=100; } //       -  
   sbm0_per_second_rad_sum=0;
   if (sbm0_abs_max<sbm0_min[minute]) sbm0_abs_max=sbm0_min[minute];
   if (sbm0_abs_max_today<sbm0_min[minute]) sbm0_abs_max_today=sbm0_min[minute];
   minute++;            //  
   delta_os=0;
do_check_batt=1;
if (minute%5==0) alarm_cancelled=0; //   
if (VoltLevel<=volt_level_error_threshold) volt_level_error++;
if (VoltLevel<=volt_level_poweroff_threshold) volt_level_shutdown++;
}
if(minute == 60)        //  minute = 60, minute = 0
{  
minute = 0;
for(i=0;i<60;i++) sbm0_hour[hours]=sbm0_hour[hours]+sbm0_min[i];
sbm0_hour[hours]=(sbm0_hour[hours]/60); // 60   
sbm0_dose_day[0]=sbm0_dose_day[0]+sbm0_hour[hours];
sbm0_full_dose =sbm0_full_dose + sbm0_hour[hours]; //     
sbm0_approx_fon_today=sbm0_dose_day[0];
sbm0_approx_fon_today=sbm0_approx_fon_today/sbm0_day_fon_cntr;
sbm0_day_fon_cntr++;
   hours++;              //  
}
if(hours == 24)          //  hours = 24, hours = 0
{
hours = 0;

// calendar
date++;
if (date>days_in_month(month, year)) 
 {
 date=1; 
 month++; 
 if (month>12) month=1;
 } 
/// calendar

   sbm0_full_dose_days++; //  

   for(i=31;i>0;i=i-1)
    {
	sbm0_dose_day[i]=sbm0_dose_day[i-1]; //  
	}
    sbm0_dose_day[0]=0; //    0 - ,  1 , 2  
	
sbm0_day_fon_cntr=1;
sbm0_approx_fon_today=0;
sbm0_abs_max_today=0;
ee_update_doses_daily();
}
// refresh_fon=1;
refresh_by_second=1;
beep=1;

if ((hv_low)||((!sbm0[1])&&(!sbm0[2])&&(!sbm0[3])&&(!sbm0[4])&&(!sbm0[5]))) //    400       . 5 . -  
{
	
    // 
    for(i=0;i<(imp_base*hv_low+(hv_low*imp_idle));i++)
    {
PORTD |= (1<<PD7);
        _delay_us(1);
PORTD &= ~(1<<PD7);
        _delay_us(8);
//asm("wdr");
    }
      
}	 
}

ISR(TIMER2_OVF_vect)
{
// 
if (beep_enabled)
	{
          sample_count--;
          if (sample_count == 0) 
             {
              sample_count = 4;           
              if(sample>pcm_length)
				{ // 
				OCR1A = 0;
				beep_enabled=0;
				sample=0;
				}
				else OCR1A = pgm_read_byte(&melody[sample++]);
             }
	}	
if (vibplay) 
 vibplay--;

if ((vibplay<10)&&(vibplay>0)) PORTC &= ~(1<<PC2); //        
}


//  END
//***********


//  
//***********

void main_screen_clock()
{
unsigned char clockvalue[18];	
// if((!redraw)&&(!refresh_clock)) return;
// refresh_clock=0;
sprintf (clockvalue, "%02u:%02u %s %02u.%02u.%02u", hours, minute, days[WeekD(date, month, year)], date, month, year-(year/100)*100);
nlcd_Text(clockvalue, 3,10,WHITE,BLACK,1,6,0);  	
}

void main_screen_battery(unsigned int Volt)
{
 unsigned char w;
//  if((!redraw)&&(!redraw_partial)) return;
if ((PINB&(1 << PB6))==0)// 
    {
		charging=1;
	} else charging=0;

 if(charging) {nlcd_Bitmap(111,1,19,7,batt_charging); nlcd_Line(110,3,110,5,GREEN); w_old=100;}
 else
 {
	 if (Volt<360) Volt=360;
	 if (Volt>420) Volt=420;
	 
	 
	 //  360  420    1  17 
	 w=(((Volt-360)*17)/60);
if ((w!= w_old)||(redraw)||(redraw_partial)||(refresh_by_second))
	{
	 if (Volt>390)
	 nlcd_Bitmap(111,1,19,7,batt_green);
	 else if (Volt>370)
	 nlcd_Bitmap(111,1,19,7,batt_yellow);
	 else
	 nlcd_Bitmap(111,1,19,7,batt_red);

	 nlcd_Box(110,1,127-w,7,1,BLACK);
	 // nlcd_Line(124-w,3,124-w,5,GREEN);
	 
	 //  
	 nlcd_Line(110,3,110,5,GREEN);
	 nlcd_Line(111,1,111,7,GREEN);
	 nlcd_Line(111,7,130,7,GREEN);
	 nlcd_Line(111,1,130,1,GREEN);
	 nlcd_Line(130,1,130,7,GREEN);
	 w_old=w;
	}	 
 }
}

void main_screen_fon_sbm0()
{
unsigned char j, x=13,s; // y=39
unsigned char k, graph_x, graph_y, graph_y2,jf;
unsigned int color, color_marker=RED, displayint, div_bar_graph_sbm0;
div_bar_graph_sbm0=1;
// if((!redraw)&(!refresh_fon)) return;
//  refresh_fon=0;
rad=0;
#ifdef SET2SBM20
   //      2  
	for(k=1;k<37;k++) //  sbm[0] a ,  .
{
    rad=rad+sbm0[k];

    switch(k) // 
    {
    case 3:
        if(rad>1111) //   10 000 /   3 
        {
            rad*=9;
            k=37;
			if (sbm0_count_time!=3) count_validate=3;
            sbm0_count_time=3;
        }
        break;

    case 6:
        if(rad>2000) //   6 000 /   6 
        {
            rad*=3;
            k=37;
			if (sbm0_count_time!=6) count_validate=6;
            sbm0_count_time=6;
        }
        break;

    case 9:
        if(rad>750) //   1 500 /   9 
        {
            rad*=2;
            k=37;
			if (sbm0_count_time!=9) count_validate=9;
            sbm0_count_time=9;
			
        }
        break;

    case 18:
        if(rad>100) //   100 /   18 
        {
            k=37;
            if (sbm0_count_time!=18) count_validate=18;
			sbm0_count_time=18;
			
        }
        break;

    case 36:
			rad/=2;
			if (sbm0_count_time!=36) count_validate=36;
            sbm0_count_time=36; // .  .
        break;

    }
}
#else 
   //      1  
	for(k=1;k<73;k++) //  sbm[0] a ,  .
{
    rad=rad+sbm0[k];

    switch(k) // 
    {
    case 2:
        if(rad>555) //   10 000 /   2 
        {
            rad*=18;
            k=73;
			if (sbm0_count_time!=2) count_validate=2;
            sbm0_count_time=2;
        }
        break;

    case 4:
        if(rad>666) //   6 000 /   4 
        {
            rad*=9;
            k=73;
			if (sbm0_count_time!=4) count_validate=4;
            sbm0_count_time=4;
        }
        break;

    case 9:
        if(rad>375) //   1 500 /   9 
        {
            rad*=4;
            k=73;
			if (sbm0_count_time!=9) count_validate=9;
            sbm0_count_time=9;
			
        }
        break;

    case 12:
        if(rad>266) //   800 /   12 
        {
            rad*=3;
            k=73;
			if (sbm0_count_time!=12) count_validate=12;
            sbm0_count_time=12;
			
        }
        break;
    
    case 18:
        if(rad>150) //   300 /   18 
        {
            rad*=2;
            k=73;
            if (sbm0_count_time!=18) count_validate=18;
			sbm0_count_time=18;
			
        }
        break;

    case 36:
        if(rad>50) //   50 /   36 
        {
            // rad *1
            k=73;
			if (sbm0_count_time!=36) count_validate=36;
            sbm0_count_time=36;
			
        }
        break;
    case 72:
			rad/=2;
			if (sbm0_count_time!=72) count_validate=72;
            sbm0_count_time=72; // .  .
        break;

    }
}
#endif
//     
if (rad>90000) {raddisp=rad/10000; nlcd_Text("/ ", 100,48, WHITE, BLACK, 1,6,0); } else
	{ nlcd_Text("/", 100,48, WHITE, BLACK, 1,6,0); 	raddisp=rad; }


digit[0]=(raddisp%100000)/10000;
digit[1]=(raddisp%10000)/1000;
digit[2]=(raddisp%1000)/100;
digit[3]=(raddisp%100)/10;
digit[4]=raddisp%10;

for (j = 0; j < 5; j++ )
	{
if ((!(digit[j]==old_digit[j]))||(redraw)) //     ,     SPI 		
switch (digit[j]) 
		{
    case 0: nlcd_Bitmap(x,22,14,23,n0); break;
    case 1: nlcd_Bitmap(x,22,14,23,n1); break;
    case 2: nlcd_Bitmap(x,22,14,23,n2); break;
    case 3: nlcd_Bitmap(x,22,14,23,n3); break;
    case 4: nlcd_Bitmap(x,22,14,23,n4); break;
    case 5: nlcd_Bitmap(x,22,14,23,n5); break;
    case 6: nlcd_Bitmap(x,22,14,23,n6); break;
    case 7: nlcd_Bitmap(x,22,14,23,n7); break;
    case 8: nlcd_Bitmap(x,22,14,23,n8); break;
    case 9: nlcd_Bitmap(x,22,14,23,n9); break;
		}
		old_digit[j]=digit[j];
		x = x+15;		
	}	
sprintf(svalue, "t:%02u", sbm0_count_time);
// nlcd_Text(" ", 10,61,GREEN,BLACK,1,8,0);
nlcd_Text(svalue, 100,61,GREEN,BLACK,1,6,0);

if (rad<40)
nlcd_Text("     ", 1,111,BLACK,GREEN,1,8,0);
else if (rad<120)
nlcd_Text("     ", 1,111,BLACK,YELLOW,1,8,0);
else
nlcd_Text("   !    ", 1,111,WHITE,RED,1,8,0);

//   
if (count_validate>16)
color_marker=RED;
else if (count_validate>0)
color_marker=YELLOW;
else
color_marker=GREEN;
nlcd_Box(101,18,130,20,1,color_marker);

    switch(sbm0_graph_type) // 0 - , 1 , 2 
    {
    case 1:


//  type1
// !
graph_x=6;
graph_y=95;
nlcd_Box(6, graph_y-1, 124, graph_y-31, 1, BLACK);
for(j=1;j<60;j++)
{
graph_y2=graph_y-((sbm0[j]*30)/div_graph_sbm0)-1;

#ifdef SET2SBM20
if (sbm0[j]>6) color=RED; 
else if (sbm0[j]>=3) color=YELLOW;  
else color=GREEN;
#else
if (sbm0[j]>4) color=RED; 
else if (sbm0[j]>=2) color=YELLOW;  
else color=GREEN;
#endif

nlcd_Box(graph_x, graph_y, graph_x+1, graph_y2+1, 0, color);

graph_x=graph_x+2;
}


        break;

    case 2:

//  type2
// !
graph_x=6;
graph_y=95-((sbm0[1]*30)/div_graph_sbm0);
nlcd_Box(graph_x, 95, graph_x+2, 95-30, 1, BLACK);
for(j=1;j<60;j++)
{
graph_y2=95-((sbm0[j]*30)/div_graph_sbm0);



nlcd_Box(graph_x+1, 95, graph_x+2, 95-30, 1, BLACK);
nlcd_Line(graph_x, graph_y, graph_x+2, graph_y2, color);
graph_x=graph_x+2;

#ifdef SET2SBM20
if ((sbm0[j+1]>6)||(sbm0[j]>6)) color=RED; 
else if ((sbm0[j+1]>=3)||(sbm0[j]>=3)) color=YELLOW;  
else color=GREEN;
#else
if ((sbm0[j+1]>3)||(sbm0[j]>3)) color=RED; 
else if ((sbm0[j+1]>=2)||(sbm0[j]>=2)) color=YELLOW;  
else color=GREEN;
#endif




graph_y=95-((sbm0[j]*30)/div_graph_sbm0);
}


		break;
		
	case 3:
if ((!(second==1))&&(!redraw)) break; //    .   .

nlcd_Box(18,61,130,87,1,BLACK);	// 		
s=minute;
//   
for(jf=0;jf<5;jf++) // 
{
if (s==0) s=60;	
s--;
if ((sbm0_min[s]>div_bar_graph_sbm0)) div_bar_graph_sbm0=sbm0_min[s]; //  .
}
// *****
s=minute;
graph_x=17;
graph_y=1;
// k=61;



for(jf=0;jf<5;jf++) // position
{
	
if (s==0) s=60;	
s--;

	sprintf(svalue, "%02u", s);
if (s%5==0)	
	nlcd_Text(svalue, graph_x,101, YELLOW, BLACK, 1,8,0); // 5-  
else
	nlcd_Text(svalue, graph_x,101, GREEN, BLACK,1,8,0);
	

if (sbm0_min[s]>120) color=RED; 
else if (sbm0_min[s]>40) color=YELLOW;  
else color=GREEN;

nlcd_Box(graph_x-2,89,graph_x+15,88-((sbm0_min[s]*17)/div_bar_graph_sbm0),1,color);	// 		

	
	if (sbm0_min[s]<1000)
	   {
		   color=YELLOW;
		   displayint=sbm0_min[s];
	   }
	   else
	   {
		   color=RED;
		   displayint=sbm0_min[s]/1000;
	   }	

	sprintf(svalue, "%03u", displayint);
	nlcd_Text(svalue, graph_x-2,89-((sbm0_min[s]*17)/div_bar_graph_sbm0), color, BLACK,1,6,0); // 

	graph_x=graph_x+24;
	// if (j<4)nlcd_Box(graph_x-2,87,graph_x+15,87-18,1,BLACK);	//  X 
	
}

		break;




	case 4:
if ((!(second==1))&&(!redraw)) break; //    .   .

nlcd_Box(18,61,130,87,1,BLACK);	// 		
s=hours;
//   
for(jf=0;jf<5;jf++) // position
{
if (s==0) s=24;	
s--;
if ((sbm0_hour[s]>div_bar_graph_sbm0)) div_bar_graph_sbm0=sbm0_hour[s]; //  .
}
// *****
s=hours;
graph_x=17;
graph_y=1;



for(jf=0;jf<5;jf++) // position
{
	
if (s==0) s=24;	
s--;

	sprintf(svalue, "%02u", s);

	nlcd_Text(svalue, graph_x,101, YELLOW, BLACK, 1,8,0); //  
	
if (sbm0_hour[s]>120) color=RED; 
else if (sbm0_hour[s]>40) color=YELLOW;  
else color=GREEN;

nlcd_Box(graph_x-2,89,graph_x+15,88-((sbm0_hour[s]*17)/div_bar_graph_sbm0),1,color);	// 

	if (sbm0_hour[s]<1000)
	   {
		   color=YELLOW;
		   displayint=sbm0_hour[s];
	   }
	   else
	   {
		   color=RED;
		   displayint=sbm0_hour[s]/1000;
	   }	
	sprintf(svalue, "%03u", displayint);
	nlcd_Text(svalue, graph_x-2,89-((sbm0_hour[s]*17)/div_bar_graph_sbm0), color, BLACK,1,6,0); // 
	
	graph_x=graph_x+24;
	
	
}

		break;
		
		
	default: //  
	day_fon=0;
	
	nlcd_Text("   :", 1,70, GREEN, BLACK, 1,6,0); // 
	nlcd_Text(" :", 1,78, GREEN, BLACK, 1,6,0); // 
	nlcd_Text(" :", 1,86, GREEN, BLACK, 1,6,0); // 
	nlcd_Text("   :", 1,94, GREEN, BLACK, 1,6,0); // 
	s=hours;	
	if (s==0) s=24;	
	s--;


		
	if (sbm0_hour[s]<1000)
	sprintf(svalue, "%03u/", sbm0_hour[s]);
	else
	sprintf(svalue, "%03u /", (sbm0_hour[s]/1000));
	nlcd_Text(svalue, 79,70, YELLOW, BLACK,1,6,0); // 

	if (sbm0_approx_fon_today<1000)
	sprintf(svalue, "%03u/",sbm0_approx_fon_today);
	else
	sprintf(svalue, "%03u /", (sbm0_approx_fon_today/1000));
	nlcd_Text(svalue, 79,78, YELLOW, BLACK,1,6,0); // 
	
	
	
	if (sbm0_dose_day[0]<2000)
	sprintf(svalue, "%04u", sbm0_dose_day[0]);
	else
	sprintf(svalue, "%04u ", (sbm0_dose_day[0]/1000));
	nlcd_Text(svalue, 85,86, YELLOW, BLACK,1,6,0); // 

	if (sbm0_dose_day[1]<2000)
	sprintf(svalue, "%04u", sbm0_dose_day[1]);
	else
	sprintf(svalue, "%04u ", (sbm0_dose_day[1]/1000));
	nlcd_Text(svalue, 85,94, YELLOW, BLACK,1,6,0); // 

	sprintf(svalue, " %04u :", sbm0_full_dose_days);
	nlcd_Text(svalue, 1,102, GREEN, BLACK, 1,6,0); // 
	if (sbm0_full_dose<100000)
	sprintf(svalue, "%05u", sbm0_full_dose);
	else if (sbm0_full_dose<10000000)
	sprintf(svalue, "%05u ", (sbm0_full_dose/1000));
	else 
	sprintf(svalue, "%05u ", (sbm0_full_dose/1000000));
	nlcd_Text(svalue, 79,102, YELLOW, BLACK,1,6,0); // 
	
	
		break;
	} // switch
}

void display_message_clear_dose()
{
if ((!redraw)&&(!redraw_partial)) return;
nlcd_Box(1,112,130,130,1,BLACK);
nlcd_Box(3,20,127,80,1,GREEN);
nlcd_Box(5,32,125,78,1,BLACK);
	nlcd_Text("", 7,45, YELLOW, BLACK,1,6,0); // 
	nlcd_Text("   ?", 7,55, YELLOW, BLACK,1,6,0); // 
	nlcd_Text("      ?", 7,65, RED, BLACK,1,6,0); // 

  button(1, button_cancel);

  button(4, button_ok);
redraw=0;
redraw_partial=0;	
}

void display_message_clear_eeprom_dose()
{
if ((!redraw)&&(!redraw_partial)) return;
nlcd_Box(1,112,130,130,1,BLACK);
nlcd_Box(3,20,129,80,1,GREEN);
nlcd_Box(5,32,127,78,1,BLACK);
	nlcd_Text(" ", 7,45, YELLOW, BLACK,1,6,0); // 
	nlcd_Text(".  eeprom?", 7,55, YELLOW, BLACK,1,6,0); // 
	nlcd_Text("      ?", 7,65, RED, BLACK,1,6,0); // 

  button(1, button_cancel);

  button(4, button_ok);
redraw=0;
redraw_partial=0;	
}

void display_message_pwoff()
{
if ((!redraw)&&(!redraw_partial)) return;
nlcd_Box(1,112,130,130,1,BLACK);
nlcd_Box(3,20,127,80,1,GREEN);
nlcd_Box(5,32,125,78,1,BLACK);
	nlcd_Text(" ?", 7,45, YELLOW, BLACK,1,6,0); // 
	nlcd_Text("      ?", 7,65, RED, BLACK,1,6,0); // 

  button(1, button_cancel);
  button(4, button_ok);
redraw=0;
redraw_partial=0;	
}


void display_message_sbm0_error() //  errtype 0 -  , 1 -   
{
if ((!refresh_by_second)||(message_drawn)) return;
nlcd_Box(1,112,130,130,1,BLACK);
nlcd_Box(3,20,127,80,1,GREEN);
nlcd_Box(5,32,125,78,1,BLACK);
	nlcd_Text(" !", 7,45, RED, BLACK,1,6,0); // 
if (errtype)
	nlcd_Text(" !", 7,65, YELLOW, BLACK,1,6,0); // 
else
	nlcd_Text(" !", 7,65, YELLOW, BLACK,1,6,0); // 

  button(4, button_ok);
message_drawn=1;  
refresh_by_second=0;
}

void display_message_alarm() 
{
if ((!refresh_by_second)||(message_drawn)) return;
nlcd_Box(1,112,130,130,1,BLACK);
nlcd_Box(3,20,127,80,1,GREEN);
nlcd_Box(5,32,125,78,1,BLACK);
	nlcd_Text("      !", 7,45, RED, BLACK,1,6,0); // 
	nlcd_Text(" ", 7,55, YELLOW, BLACK,1,6,0); // 
	sprintf(svalue, " %04u /!", alarm_level);
	nlcd_Text(svalue, 7,65, YELLOW, BLACK,1,6,0); // 

  button(4, button_ok);
  message_drawn=1;
refresh_by_second=0;
}

void display_message_battery() 
{
if ((!refresh_by_second)||(message_drawn)) return;
nlcd_Box(1,112,130,130,1,BLACK);
nlcd_Box(3,20,127,80,1,GREEN);
nlcd_Box(5,32,125,78,1,BLACK);
	nlcd_Text("      !", 7,45, RED, BLACK,1,6,0); // 
	nlcd_Text("  < 5%", 7,55, YELLOW, BLACK,1,6,0); // 
	nlcd_Text(" ", 7,65, YELLOW, BLACK,1,6,0); // 

  button(4, button_ok);
  message_drawn=1;
refresh_by_second=0;
}

void display_welcome() 
{

nlcd_Box(1,1,130,130,1,BLACK);
nlcd_Bitmap(11,30,111,48,logo);
nlcd_Text("          () MadOrc", 7,92, YELLOW, BLACK, 1,6,0); // 

nlcd_Text("      MadOrc@Gmx.com", 7,100, YELLOW, BLACK, 1,6,0); // 
#ifdef SET2SBM20
nlcd_Text("   2 ", 7,120, GREEN, BLACK, 1,6,0); // 
#else
nlcd_Text("  1 ", 7,120, GREEN, BLACK, 1,6,0); // 
#endif
nlcd_Text("        2.1", 7,128, GREEN, BLACK, 1,6,0); // 

brightness_dimm=0;
hv_low=200;

sleep_restricted=1;	

// 5 
    //  
	pompa=0;
	
	
	
    while ((pompa<1000000)&&((PINC&(1 << PC0))!=0)) // 10      
    {
PORTD |= (1<<PD7);
        _delay_us(2);
PORTD &= ~(1<<PD7);
        _delay_us(8);
pompa++;
    }
// _delay_ms(3000); // 5 
sleep_restricted=0;
brightness_dimm = eeprom_read_byte(&e_brightness_dimm);
}

void main_screen()
{

if (redraw)  //   
{
//  _ 
nlcd_Bitmap(1,9,130,42,bkgr);

nlcd_Line(100,17,130,17,0x332);
nlcd_Box(101,18,130,20,1,RED);
nlcd_Line(100,21,130,21,0x654);

nlcd_Line(100,18,100,20,0x332);


//// L H
nlcd_Line(1,60,130,60,GREEN);

if ((sbm0_graph_type==1)||(sbm0_graph_type==2)) //  .     1  2
{
const char yy=60, yyl=100;	

nlcd_Line(5,yy,5,yy+3,GREEN);
nlcd_Line(4,yy,4,yy+2,GREEN);
nlcd_Line(3,yy,3,yy+1,GREEN);

nlcd_Line(125,yy,125,yy+3,GREEN);
nlcd_Line(126,yy,126,yy+2,GREEN);
nlcd_Line(127,yy,127,yy+1,GREEN);

nlcd_Line(35,yy,35,yy+3,GREEN);
nlcd_Line(65,yy,65,yy+3,GREEN);
nlcd_Line(95,yy,95,yy+3,GREEN);

nlcd_Line(15,yy,15,yy+2,GREEN);
nlcd_Line(25,yy,25,yy+2,GREEN);

nlcd_Line(45,yy,45,yy+2,GREEN);
nlcd_Line(55,yy,55,yy+2,GREEN);

nlcd_Line(75,yy,75,yy+2,GREEN);
nlcd_Line(85,yy,85,yy+2,GREEN);

nlcd_Line(105,yy,105,yy+2,GREEN);
nlcd_Line(115,yy,115,yy+2,GREEN);

// low

nlcd_Line(1,yyl,130,yyl,GREEN);

nlcd_Line(5,yyl,5,yyl-3,GREEN);
nlcd_Line(4,yyl,4,yyl-2,GREEN);
nlcd_Line(3,yyl,3,yyl-1,GREEN);

nlcd_Line(125,yyl,125,yyl-3,GREEN);
nlcd_Line(126,yyl,126,yyl-2,GREEN);
nlcd_Line(127,yyl,127,yyl-1,GREEN);

nlcd_Line(35,yyl,35,yyl-3,GREEN);
nlcd_Line(65,yyl,65,yyl-3,GREEN);
nlcd_Line(95,yyl,95,yyl-3,GREEN);

nlcd_Line(15,yyl,15,yyl-2,GREEN);
nlcd_Line(25,yyl,25,yyl-2,GREEN);

nlcd_Line(45,yyl,45,yyl-2,GREEN);
nlcd_Line(55,yyl,55,yyl-2,GREEN);

nlcd_Line(75,yyl,75,yyl-2,GREEN);
nlcd_Line(85,yyl,85,yyl-2,GREEN);

nlcd_Line(105,yyl,105,yyl-2,GREEN);
nlcd_Line(115,yyl,115,yyl-2,GREEN);

}
else if (sbm0_graph_type==3) //   
{
// for(i=91;i<101;i+=2) nlcd_Line(1,i,130,i,0x231);		
nlcd_Box(1,64,11,101,1,GREEN);
nlcd_Bitmap(2,66,9,8,rad_symbol);
nlcd_Line(2,75,10,75,BLACK);
nlcd_Text("", 4,85,BLACK,BLACK,1,6,1);
nlcd_Text("", 4,93,BLACK,BLACK,1,6,1);
nlcd_Text("", 4,101,BLACK,BLACK,1,6,1);

}
else if (sbm0_graph_type==4) //   
{
	

// for(i=91;i<101;i+=2) nlcd_Line(1,i,130,i,0x231);		
nlcd_Box(1,64,11,101,1,GREEN);
nlcd_Bitmap(2,66,9,8,rad_symbol);
nlcd_Line(2,75,10,75,BLACK);
nlcd_Text("", 4,85,BLACK,BLACK,1,6,1);
nlcd_Text("", 4,93,BLACK,BLACK,1,6,1);
nlcd_Text("", 4,101,BLACK,BLACK,1,6,1);

}

  button(1, button_power);
  button(2, button_dose);
  button(3, button_precise);
  button(4, button_settings);
//  _ 

old_digit[0]=0;
old_digit[1]=0;
old_digit[2]=0;
old_digit[3]=0;
old_digit[4]=0;
} // redraw

if ((!redraw)&&(!redraw_partial)&&(!refresh_by_second)) return;
//if (!redraw) main_screen_fon_sbm0(); //   
main_screen_fon_sbm0(); //
// main_screen_fon_sbm1();
main_screen_clock();
main_screen_battery(VoltLevel);

if (refresh_by_second) refresh_by_second=0;
redraw_partial=0;
redraw=0;
}

void menu_head(char head[11], unsigned char letters)
{
unsigned char x;
 if ((letters>11)||(letters<2)) letters=11;
	x=22+(((11-letters)/2)*8);
nlcd_Text(head, x,19,YELLOW,BLACK,1,8,0);
// L H
nlcd_Line(1,13,20,13,YELLOW);
nlcd_Line(1,14,18,14,YELLOW);
// R H
nlcd_Line(110,13,130,13,YELLOW);
nlcd_Line(112,14,130,14,YELLOW);

// LV
nlcd_Line(1,13,1,23,YELLOW);
nlcd_Line(2,13,2,22,YELLOW);
// RV
nlcd_Line(129,13,129,22,YELLOW);
nlcd_Line(130,13,130,23,YELLOW);

// LDV
nlcd_Line(1,93,1,109,YELLOW);
nlcd_Line(2,95,2,109,YELLOW);
// RDV
nlcd_Line(129,95,129,109,YELLOW);
nlcd_Line(130,93,130,109,YELLOW);

// DH
//nlcd_Line(1,108,130,108,YELLOW);
nlcd_Line(1,109,130,109,YELLOW);
}

void menu_line(char line[19], unsigned char place, unsigned char selected) //   1  8  ,    19, sel 0/1
{
unsigned char y_offset=11;

if ((place>8)||(place<1)) return;

if (selected)
	{
nlcd_Box(6, 10+y_offset*place, 125, 17+y_offset*place, 1, 0x231);
nlcd_Text(line, 12,19+y_offset*place,GREEN,0x231,1,6,0); //  20(19) 
nlcd_Text(" ", 6,19+y_offset*place,GREEN,0x231,1,6,0);
nlcd_Box(5, 9+y_offset*place, 126, 18+y_offset*place, 0, GREEN);
	} else  {
nlcd_Box(5, 9+y_offset*place, 126, 18+y_offset*place, 1, BLACK);		
nlcd_Text(line, 12,19+y_offset*place,GREEN,BLACK,1,6,0); //  20(19) 
			}
}

void menu_text_green(char line[20], unsigned char place) // 20    1-9  
{
unsigned char y_offset=8;	

if ((place>9)||(place<1)) return;

// nlcd_Box(5, 11+y_offset*place, 125, 18+y_offset*place, 1, 0x220);
nlcd_Text(line, 6,20+y_offset*place,GREEN,BLACK,1,6,0);
}

void menu_text(char line[20], unsigned char place) // 20    1-9  
{
unsigned char y_offset=8;	

if ((place>9)||(place<1)) return;

// nlcd_Box(5, 11+y_offset*place, 125, 18+y_offset*place, 1, 0x220);
nlcd_Text(line, 6,20+y_offset*place,YELLOW,BLACK,1,6,0);
}

void menu_power(unsigned int vl)
{
 
if (redraw) 
{
 menu_head("", 7);
  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
  button(4, button_ok);
} //redraw

if((!redraw)&&(!redraw_partial)) return;
main_screen_clock();
main_screen_battery(vl);

sprintf(svalue, ": %01u.%01u%01u V", ((vl%1000)/100), ((vl%100)/10), (vl%10));
menu_text(svalue, 1);
if (sleep_time) sprintf(svalue, "  %03u ", sleep_time);
  else			sprintf(svalue, "  ");
menu_text(svalue,2);

menu_line("  ",3,(punkt==0));

switch(flashlight)
 {
 case 0:	 
menu_line(" ",4,(punkt==1)); 
 break;
 case 1:	 
menu_line(" ",4,(punkt==1)); 
 break;
 }

menu_line(" -",5,(punkt==2));

 switch(snd_geiger)
 {
 case 0:	 
menu_line(": ",6,(punkt==3));	 
 break;
 case 1:	 
menu_line(": ",6,(punkt==3));	 
 break;
 case 2:	 
menu_line(": ",6,(punkt==3));	 
 break;
 case 3:	 
menu_line(": ",6,(punkt==3));	 
 break;
 }

menu_line(" ",7,(punkt==4));
menu_line("",8,(punkt==5));

redraw_partial=0;
redraw=0;
}

void menu_settings()
{
 if(redraw)
 {
menu_head("", 9);



  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
  button(4, button_ok);
} // redraw

 if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);
menu_line(" ",1,(punkt==0));

switch (snd_keys)
 {
 case 0:
menu_line(": ",2,(punkt==1));
 break;
 case 1:
menu_line(": ",2,(punkt==1));
 break;
 case 2:
menu_line(": ",2,(punkt==1));
 break;
 } 	
 switch(snd_geiger)
 {
 case 0:	 
menu_line(": ",3,(punkt==2));	 
 break;
 case 1:	 
menu_line(": ",3,(punkt==2));	 
 break;
 case 2:	 
menu_line(": ",3,(punkt==2));	 
 break;
 case 3:	 
menu_line(": ",3,(punkt==2));	 
 break;
 }


menu_line(" -",4,(punkt==3));
menu_line(" ",5,(punkt==4));
menu_line(" ",6,(punkt==5));
menu_line(". /",7,(punkt==6));
menu_line("Service menu",8,(punkt==7));

redraw=0;
redraw_partial=0; 
}


void menu_system()
{
unsigned int vll;
 if((!refresh_by_second)&&(!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);


sprintf(svalue, "<400v 1m: %03u", delta_os);
menu_text(svalue,3);
/*
sprintf(svalue, "u<400v 1s:  %03u", delta_oss);
menu_text(svalue,3);
*/
vll=VoltLevel;
sprintf(svalue, ": %01u.%01u%01u V", (char)((vll%1000)/100), (char)((vll%100)/10), (char)(vll%10));
menu_text(svalue,4);

if (refresh_by_second) refresh_by_second=0;

 if(!redraw_partial) return;
sprintf(svalue, ". %04u 2", beta_square);
menu_line(svalue,5,(punkt==0));

sprintf(svalue, ".. %02u", imp_imp);
menu_line(svalue,6,(punkt==1));

/*
sprintf(svalue, ".. %02u", imp_imp);
menu_line(svalue,5,(punkt==0));

sprintf(svalue, ".. %02u", imp_idle);
menu_line(svalue,6,(punkt==1));
*/
sprintf(svalue, " . %02u", imp_base);
menu_line(svalue,7,(punkt==2));

sprintf(svalue, ": %03u", ion);
menu_line(svalue,8,(punkt==3));

redraw_partial=0; 
 if(!redraw) return;
 
menu_head("Service", 7);

menu_text(" ,  ! ",1);



  button(1, button_ok);
  button(2, button_adjustL);
  button(3, button_adjustR);
  button(4, button_select);
 redraw=0;

}

void check_alarm(unsigned int radlevel)
{
	if ((radlevel>alarm_level)&&(!alarm_cancelled))
	{

	if (!awaken)	//   -       
	{
	awaken=sleep_time+2;
	full_bright=brightness_dimm+2;
	// sleep_restricted=1;	
	// lcd on etc
	PinsOn();
	PORTC |= (1<<PC1); //  
    nlcd_Init();                                        // 
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast);
	OCR3A = brightness;
	TIMSK |= (0 << TOIE2); //    
	MCUCR |= (0 << SE); //PowerSave Disable
    EIMSK &= ~(1<< INT0); //
	// redraw=1;
	_delay_ms(1);
	}
	
	alarming=1;		
	}
	else
	{
	
	alarming=0;
	}
}


void menu_dose()
{
unsigned char r, acc_days;
unsigned long accumulated_dose;

 if(redraw) 
{
menu_head("", 4);
  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
  button(4, button_ok);
 
} // redraw

 if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);


	if (sbm0_dose_day[0]<90000)
	sprintf(svalue, ": %05u", sbm0_dose_day[0]);
	else
	sprintf(svalue, ": %05u ", (sbm0_dose_day[0]/1000));
	menu_text(svalue,1);
	
accumulated_dose=0;
acc_days=0;
 for (r=0;r<33;r++)
  {
	  if (sbm0_dose_day[r])
	    {
		accumulated_dose = accumulated_dose + sbm0_dose_day[r];
		acc_days++;
		}		
  }  

	if (accumulated_dose<100000)
	sprintf(svalue, " %03u :%05u", acc_days,accumulated_dose);
	else if (accumulated_dose<10000000)
	sprintf(svalue, " %03u :%05u ", acc_days,(accumulated_dose/1000));
	else 
	sprintf(svalue, " %03u :%05u ", acc_days,(accumulated_dose/1000000));
	menu_text(svalue,2);

	if (sbm0_abs_max_today<1000)
	sprintf(svalue, "MAX  :%03u/", sbm0_abs_max_today);
	else if (sbm0_abs_max_today<1000000)
	sprintf(svalue, "MAX  :%03u/", (sbm0_abs_max_today/1000));
	else
	sprintf(svalue, "MAX  :%03u/", (sbm0_abs_max_today/1000000));
	menu_text(svalue,3);

	if (sbm0_full_dose<100000)
	sprintf(svalue, " %03u :%05u", sbm0_full_dose_days,sbm0_full_dose);
	else if (sbm0_full_dose<10000000)
	sprintf(svalue, " %03u :%05u ", sbm0_full_dose_days,(sbm0_full_dose/1000));
	else 
	sprintf(svalue, " %03u :%05u ", sbm0_full_dose_days,(sbm0_full_dose/1000000));
	menu_text_green(svalue,4);
	
	if (sbm0_abs_max<1000)
	sprintf(svalue, "MAX %03u .:%03u/", sbm0_full_dose_days, sbm0_abs_max);
	else if (sbm0_abs_max<1000000)
	sprintf(svalue, "MAX %03u .:%03u/", sbm0_full_dose_days, (sbm0_abs_max/1000));
	else
	sprintf(svalue, "MAX %03u .:%03u/", sbm0_full_dose_days, (sbm0_abs_max/1000000));
	menu_text_green(svalue,5);


menu_line(" ",5,(punkt==0));
menu_line("  ",6,(punkt==1));
menu_line(" ",7,(punkt==2));
menu_line("   eeprom",8,(punkt==3));

redraw=0;
redraw_partial=0; 
}

void display_stat_24h(unsigned char page)
{
unsigned char x_offset=7,ik,head_time_start, head_time_end;
unsigned int color,displayint, houcounter, houcounter_def;
unsigned long graph_divider;
  if((!redraw_partial)&&(!redraw)) return;
nlcd_Box(1,88,130,42,1,BLACK);  // clear work area
main_screen_clock();
main_screen_battery(VoltLevel);

houcounter=hours;


if(page) //  0-
{
	
for (ik=1; ik<((8*page)+1);ik++) //   
  {
//    
	if (houcounter==0) houcounter=24;
	houcounter--;
//    
  }
  
} 
houcounter_def=houcounter;
head_time_start=houcounter;

graph_divider=3;

for (ik=1;ik<9;ik++) //  
{
	if (sbm0_hour[houcounter]>graph_divider) graph_divider=sbm0_hour[houcounter];
	if (houcounter==0) houcounter=24;
	houcounter--;
}

houcounter=houcounter_def;

for (ik=1;ik<9;ik++) //
{
	if (sbm0_hour[houcounter]<1000) //       
	   {
		   color=YELLOW;
		   displayint=sbm0_hour[houcounter];
	   }
	   else
	   {
		   color=RED;
		   displayint=sbm0_hour[houcounter]/1000;
	   }
	   
	if (ik%2==0)
	{
	sprintf(svalue, "%03u", displayint);
	nlcd_Text(svalue,x_offset-3,32,color,BLACK,1,6,0);
	}	
	else
	{
	sprintf(svalue, "%03u", displayint);
	nlcd_Text(svalue,x_offset-1,42,color,BLACK,1,6,0);
	}	
	
if (sbm0_hour[houcounter]<40) // 40mkR/h 
color=GREEN;
else if (sbm0_hour[houcounter]<120) // 120
color=YELLOW;
else
color=RED;

	if (ik%2==0)
	{
	nlcd_Line(x_offset+9,88,x_offset+9,80-49,color);
	}
	else
	{
	nlcd_Line(x_offset+9,88,x_offset+9,80-39,color);
	}	
	nlcd_Box(x_offset,88,x_offset+10,88-((sbm0_hour[houcounter]*46)/graph_divider),1,color);
	
	sprintf(svalue, "%02u", houcounter);
	nlcd_Text(svalue,x_offset,100,WHITE,BLACK,1,6,0);
	head_time_end=houcounter;
	if (houcounter==0) houcounter=24;
	houcounter--;
	x_offset = x_offset + 15;
}


sprintf(svalue, "%02u:00-%02u:00", head_time_start, head_time_end);
menu_head(svalue, 11);

nlcd_Box(65,111,130,130,1,BLACK);  // clear button area
  if (punkt>0) button(3, button_adjustL);
  if (punkt<2) button(4, button_adjustR);

redraw_partial=0; 
 if(!redraw) return;
	nlcd_Text("XXX - ",11,109,YELLOW,BLACK,1,6,0);
	nlcd_Text("XXX - ",74,109,RED,BLACK,1,6,0);
 
  button(1, button_cancel);
  //button(2, button_down);
 redraw=0;

}

void display_stat_month(unsigned char page) //   . []
{ 
//   
unsigned char x_offset=7,ik,daycounter, monthcounter,head_date_start, head_month_start,head_date_end,head_month_end,massive_ik;
unsigned int graph_divider=0,yearcounter,color,displayint;
  if((!redraw_partial)&&(!redraw)) return;
nlcd_Box(1,80,130,42,1,BLACK);  // clear work area
main_screen_clock();
main_screen_battery(VoltLevel);

daycounter=date;
monthcounter=month;
yearcounter=year;

//    
daycounter--;
if (daycounter<1) //  
    {
	monthcounter--;
	if (monthcounter<1) // 
			{
			monthcounter=12;
			yearcounter--;
			}
	daycounter=days_in_month(monthcounter,yearcounter);
	}

//    


massive_ik=0;

if(page) //  0-
{
	
for (ik=1; ik<((8*page)+1);ik++) //   
  {
//    
daycounter--;
if (daycounter<1) //  
    {
	monthcounter--;
	if (monthcounter<1) // 
			{
			monthcounter=12;
			yearcounter--;
			}
	daycounter=days_in_month(monthcounter,yearcounter);
	}
//    
massive_ik++;
  }
  
} 


head_date_start=daycounter;
head_month_start=monthcounter;

for (ik=massive_ik+1;ik<massive_ik+9;ik++) //  
{
	if (sbm0_dose_day[ik]>graph_divider) graph_divider=sbm0_dose_day[ik];
}

//	sprintf(svalue, "%03u", sbm0_dose_day[ik]);




for (ik=massive_ik+1;ik<massive_ik+9;ik++)
{
	
	if (sbm0_dose_day[ik]<10000) //       
	   {
		   color=YELLOW;
		   displayint=sbm0_dose_day[ik];
	   }
	   else
	   {
		   color=RED;
		   displayint=sbm0_dose_day[ik]/1000;
	   }
	   
	if (ik%2==0)
	{
	sprintf(svalue, "%04u", displayint);
	nlcd_Text(svalue,x_offset-8,32,color,BLACK,1,6,0);
	}	
	else
	{
	sprintf(svalue, "%04u", displayint);
	nlcd_Text(svalue,x_offset-2,42,color,BLACK,1,6,0);
	}	
	
/// 	nlcd_Box(x_offset,80,x_offset+10,43,1,GREEN);
if (sbm0_dose_day[ik]<960) // 40mkR/h *24
color=GREEN;
else if (sbm0_dose_day[ik]<2880) // 120 * 24
color=YELLOW;
else
color=RED;
	if (ik%2==0)
	{
	nlcd_Line(x_offset+9,80,x_offset+9,80-49,color);
	}
	else
	{
	nlcd_Line(x_offset+9,80,x_offset+9,80-39,color);
	}	
	nlcd_Box(x_offset,80,x_offset+10,80-((sbm0_dose_day[ik]*38)/graph_divider),1,color);
	
	sprintf(svalue, "%02u", daycounter);
	nlcd_Text(svalue,x_offset,91,WHITE,BLACK,1,6,0);
	sprintf(svalue, "%s", days[WeekD(daycounter, monthcounter, yearcounter)]);
	nlcd_Text(svalue,x_offset,100,WHITE,BLACK,1,6,0);
	nlcd_Text("XXX - ",11,109,YELLOW,BLACK,1,6,0);
	nlcd_Text("XXX - ",74,109,RED,BLACK,1,6,0);
	x_offset = x_offset+15;
	head_date_end=daycounter;
	head_month_end=monthcounter;
//    
daycounter--;
if (daycounter<1) //  
    {
	monthcounter--;
	if (monthcounter<1) // 
			{
			monthcounter=12;
			yearcounter--;
			}
	daycounter=days_in_month(monthcounter,yearcounter);
	}
//    

}

sprintf(svalue, "%02u.%02u-%02u.%02u", head_date_start, head_month_start, head_date_end,head_month_end);
menu_head(svalue, 11);

nlcd_Box(65,111,130,130,1,BLACK);  // clear button area
if (punkt>0) button(3, button_adjustL);
if (punkt<3) button(4, button_adjustR);

redraw_partial=0; 
 if(!redraw) return;
 

  button(1, button_cancel);
  //button(2, button_down);
 redraw=0;

}


void menu_graph_type()
{
  if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

	 if (sbm0_graph_type==0) menu_line("[ ]",3,(punkt==0)); else menu_line("  ",3,(punkt==0));
	 if (sbm0_graph_type==1) menu_line("[. ]",4,(punkt==1)); else menu_line(" . ",4,(punkt==1));
     if (sbm0_graph_type==2) menu_line("[.  ]",5,(punkt==2)); else menu_line(" .  ",5,(punkt==2));
	 if (sbm0_graph_type==3) menu_line("[ -5 ]",6,(punkt==3)); else menu_line("  -5 ",6,(punkt==3));
	 if (sbm0_graph_type==4) menu_line("[ -5 ]",7,(punkt==4)); else menu_line("  -5 ",7,(punkt==4));

redraw_partial=0; 
 if(!redraw) return;
 
menu_head(" ", 11);

menu_text("  .",2);

  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
  button(4, button_ok);
 redraw=0;

}

void menu_alarm_level()
{
  if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

	 if (alarm_level==0) menu_line("[       ]",1,(punkt==0)); else menu_line("        ",1,(punkt==0));
	if (alarm_level==40) menu_line("[   40 /   ]",2,(punkt==1)); else menu_line("    40 /   ",2,(punkt==1));
   if (alarm_level==120) menu_line("[  120 /   ]",3,(punkt==2)); else menu_line("   120 /   ",3,(punkt==2));
   if (alarm_level==300) menu_line("[  300 /   ]",4,(punkt==3)); else menu_line("   300 /   ",4,(punkt==3));
   if (alarm_level==500) menu_line("[  500 /   ]",5,(punkt==4)); else menu_line("   500 /   ",5,(punkt==4));
  if (alarm_level==1200) menu_line("[ 1200 /   ]",6,(punkt==5)); else menu_line("  1200 /   ",6,(punkt==5));
  if (alarm_level==3000) menu_line("[    3 /   ]",7,(punkt==6)); else menu_line("      3 /   ",7,(punkt==6));

redraw_partial=0; 
 if(!redraw) return;
 
menu_head("", 7);

  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
  button(4, button_ok);
 redraw=0;

}

void menu_sleep_set()
{
  if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

	 if (sleep_time==0) menu_line("[   ]",1,(punkt==0)); else menu_line("    ",1,(punkt==0));
	if (sleep_time==15) menu_line("[    15    ]",2,(punkt==1)); else menu_line("     15    ",2,(punkt==1));
	if (sleep_time==30) menu_line("[    30    ]",3,(punkt==2)); else menu_line("     30    ",3,(punkt==2));
	if (sleep_time==60) menu_line("[     1    ]",4,(punkt==3)); else menu_line("      1    ",4,(punkt==3));
   if (sleep_time==180) menu_line("[     3    ]",5,(punkt==4)); else menu_line("      3    ",5,(punkt==4));
   if (sleep_time==300) menu_line("[     5     ]",6,(punkt==5)); else menu_line("      5     ",6,(punkt==5));

	  if (brightness_dimm)
	  sprintf(svalue, " %02u .", brightness_dimm);
	  else
	  sprintf(svalue, " .", brightness_dimm);
	  menu_line(svalue,8,(punkt==6));
	  
  if (punkt==6) { button(4, button_adjust); }
  else  { button(4, button_ok); }


redraw_partial=0; 
 if(!redraw) return;
 
menu_head(" ", 9);

menu_line(" :",7,0);

  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
 redraw=0;

}

void precise_count_beta_close()
{
 if(redraw) 
 {
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);


  button(1, button_cancel);
  button(4, button_ok);
 } //redraw
 if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

menu_text(" ",2);
menu_text(" .",3);
menu_text(" ",4);
menu_text("  .",5);
menu_text(" .",7);
redraw=0;
redraw_partial=0; 
}

void precise_count_beta_open()
{
 if(redraw) 
 {
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);


  button(1, button_cancel);
  button(4, button_ok);
 } //redraw
 if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

menu_text(" ",2);
menu_text(" .",3);
menu_text(" ",4);
menu_text("  .",5);
menu_text(" .",7);
sbm0_precise_gamma=precise_impulses;
precise_impulses=0;

redraw=0;
redraw_partial=0; 
}

void precise_count_type_select()
{
 if(redraw) 
 {
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);


  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
  button(4, button_ok);
 } //redraw
 if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

menu_text("  ",2);
// menu_text("",3);
menu_text_green("    *  ",4);
menu_text_green("  ",5);
menu_text_green("      ",6);

menu_line(" ",7,(punkt==0));
menu_line(".  ",8,(punkt==1));


redraw=0;
redraw_partial=0; 
}

void precise_count_select()
{
 if(redraw) 
 {
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);


  button(1, button_cancel);
  button(2, button_down);
  button(3, button_up);
  button(4, button_ok);
 } //redraw
 if((!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

menu_text(" ",2);
menu_text("            ",3);
menu_text("( ~= )",4);

menu_line("    5 ",5,(punkt==0));
menu_line("   10 ",6,(punkt==1));
menu_line("   20 ",7,(punkt==2));
menu_line("   30 ",8,(punkt==3));

redraw=0;
redraw_partial=0; 
}

void precise_count()
{
unsigned int pointer_x;
unsigned long prom_fon;
 if((!refresh_by_second)&&(!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);
alarm_cancelled=1; //     
nlcd_Box(9,85,119,93,1,BLACK);

// pointer_x=18+(72-((precise_seconds_counter*72)/(precise_minutes*60))); //    
pointer_x=16+(75-((precise_seconds_counter/precise_minutes)*125)/100); //     
nlcd_Bitmap(pointer_x,90,12,6,pointer); 

if (second%2==0) nlcd_Text(" ...", 10, 34,YELLOW,BLACK,1,6,0); else nlcd_Text("                ", 10, 34,YELLOW,BLACK,1,6,0);

#ifdef SET2SBM20
prom_fon=(precise_impulses*36/((precise_minutes*60)-precise_seconds_counter))/2;
#else
prom_fon=(precise_impulses*36/((precise_minutes*60)-precise_seconds_counter));
#endif

if (prom_fon<100000)
{
sprintf(svalue, "%05u", prom_fon);
nlcd_Text("/", 87, 65,GREEN,BLACK,1,8,0);
}
else
{
sprintf(svalue, "%05u", prom_fon/1000);
nlcd_Text("/", 87, 65,GREEN,BLACK,1,8,0);
}

nlcd_Text(svalue, 9, 65,GREEN,BLACK,2,8,0);

//nlcd_Bitmap(17,90,12,6,pointer); // 0%
//nlcd_Bitmap(92,90,12,6,pointer); // 100%

if (refresh_by_second) refresh_by_second=0;
redraw_partial=0; 
 if(!redraw) return;
 
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);

const char yyl=103;	

// low

nlcd_Box(6,yyl,125,yyl+1,1,YELLOW);
nlcd_Text(":", 10, 46,GREEN,BLACK,1,6,0);
sprintf(svalue, " %02u ", precise_minutes);
nlcd_Text(svalue, 23, 83,YELLOW,BLACK,1,6,0);

nlcd_Box(23,yyl,25,yyl-5,1,YELLOW);
nlcd_Box(35,yyl,37,yyl-3,1,YELLOW);
nlcd_Box(47,yyl,49,yyl-5,1,YELLOW);
nlcd_Box(59,yyl,61,yyl-3,1,YELLOW);
nlcd_Box(71,yyl,73,yyl-5,1,YELLOW);
nlcd_Box(83,yyl,85,yyl-3,1,YELLOW);
nlcd_Box(95,yyl,97,yyl-5,1,YELLOW);
nlcd_Text("0%", 6, 103,YELLOW,BLACK,1,6,0);
nlcd_Text("100%", 103, 103,YELLOW,BLACK,1,6,0);


  button(1, button_cancel);
  //button(2, button_down);
  //button(3, button_up);
  //button(4, button_ok);
 redraw=0;
	
}

void precise_count_beta1()
{
unsigned int pointer_x;
unsigned long prom_fon=0;
 if((!refresh_by_second)&&(!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);
alarm_cancelled=1; //     
nlcd_Box(9,85,119,93,1,BLACK);

// pointer_x=18+(72-((precise_seconds_counter*72)/(precise_minutes*60))); //    
pointer_x=16+(75-((precise_seconds_counter/precise_minutes)*125)/100); //     
nlcd_Bitmap(pointer_x,90,12,6,pointer); 

if (second%2==0) nlcd_Text("  ...", 7, 34,YELLOW,BLACK,1,6,0); else nlcd_Text("                   ", 7, 34,YELLOW,BLACK,1,6,0);

#ifdef SET2SBM20
prom_fon=(precise_impulses*36/((precise_minutes*60)-precise_seconds_counter))/2;
#else
prom_fon=(precise_impulses*36/((precise_minutes*60)-precise_seconds_counter));
#endif

if (prom_fon<100000)
{
sprintf(svalue, "%05u", prom_fon);
nlcd_Text("/", 87, 65,GREEN,BLACK,1,8,0);
}
else
{
sprintf(svalue, "%05u", prom_fon/1000);
nlcd_Text("/", 87, 65,GREEN,BLACK,1,8,0);
}

nlcd_Text(svalue, 9, 65,GREEN,BLACK,2,8,0);

//nlcd_Bitmap(17,90,12,6,pointer); // 0%
//nlcd_Bitmap(92,90,12,6,pointer); // 100%

if (refresh_by_second) refresh_by_second=0;
redraw_partial=0; 
 if(!redraw) return;
 
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);

const char yyl=103;	

// low

nlcd_Box(6,yyl,125,yyl+1,1,YELLOW);
nlcd_Text(":", 10, 46,GREEN,BLACK,1,6,0);
sprintf(svalue, " %02u ", precise_minutes);
nlcd_Text(svalue, 23, 83,YELLOW,BLACK,1,6,0);

nlcd_Box(23,yyl,25,yyl-5,1,YELLOW);
nlcd_Box(35,yyl,37,yyl-3,1,YELLOW);
nlcd_Box(47,yyl,49,yyl-5,1,YELLOW);
nlcd_Box(59,yyl,61,yyl-3,1,YELLOW);
nlcd_Box(71,yyl,73,yyl-5,1,YELLOW);
nlcd_Box(83,yyl,85,yyl-3,1,YELLOW);
nlcd_Box(95,yyl,97,yyl-5,1,YELLOW);
nlcd_Text("0%", 6, 103,YELLOW,BLACK,1,6,0);
nlcd_Text("100%", 103, 103,YELLOW,BLACK,1,6,0);


  button(1, button_cancel);
  //button(2, button_down);
  //button(3, button_up);
  //button(4, button_ok);
 redraw=0;
	
}

void precise_count_beta2()
{
unsigned int pointer_x;
unsigned long prom_fon=0;
 if((!refresh_by_second)&&(!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);
alarm_cancelled=1; //     
nlcd_Box(9,85,119,93,1,BLACK);

// pointer_x=18+(72-((precise_seconds_counter*72)/(precise_minutes*60))); //    
pointer_x=16+(75-((precise_seconds_counter/precise_minutes)*125)/100); //     
nlcd_Bitmap(pointer_x,90,12,6,pointer); 

if (second%2==0) nlcd_Text(" +...", 8, 34,YELLOW,BLACK,1,6,0); else nlcd_Text("                   ", 8, 34,YELLOW,BLACK,1,6,0);

#ifdef SET2SBM20
prom_fon=(precise_impulses*36/((precise_minutes*60)-precise_seconds_counter))/2;
#else
prom_fon=(precise_impulses*36/((precise_minutes*60)-precise_seconds_counter));
#endif

if (prom_fon<100000)
{
sprintf(svalue, "%05u", prom_fon);
nlcd_Text("/", 87, 65,GREEN,BLACK,1,8,0);
}
else
{
sprintf(svalue, "%05u", prom_fon/1000);
nlcd_Text("/", 87, 65,GREEN,BLACK,1,8,0);
}

nlcd_Text(svalue, 9, 65,GREEN,BLACK,2,8,0);

//nlcd_Bitmap(17,90,12,6,pointer); // 0%
//nlcd_Bitmap(92,90,12,6,pointer); // 100%

if (refresh_by_second) refresh_by_second=0;
redraw_partial=0; 
 if(!redraw) return;
 
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);

const char yyl=103;	

// low

nlcd_Box(6,yyl,125,yyl+1,1,YELLOW);
nlcd_Text(":", 10, 46,GREEN,BLACK,1,6,0);
sprintf(svalue, " %02u ", precise_minutes);
nlcd_Text(svalue, 23, 83,YELLOW,BLACK,1,6,0);

nlcd_Box(23,yyl,25,yyl-5,1,YELLOW);
nlcd_Box(35,yyl,37,yyl-3,1,YELLOW);
nlcd_Box(47,yyl,49,yyl-5,1,YELLOW);
nlcd_Box(59,yyl,61,yyl-3,1,YELLOW);
nlcd_Box(71,yyl,73,yyl-5,1,YELLOW);
nlcd_Box(83,yyl,85,yyl-3,1,YELLOW);
nlcd_Box(95,yyl,97,yyl-5,1,YELLOW);
nlcd_Text("0%", 6, 103,YELLOW,BLACK,1,6,0);
nlcd_Text("100%", 103, 103,YELLOW,BLACK,1,6,0);


  button(1, button_cancel);
  //button(2, button_down);
  //button(3, button_up);
  //button(4, button_ok);
 redraw=0;
	
}

void precise_count_beta_result()
{
unsigned long prec_fon=0;
 if((!refresh_by_second)&&(!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);
sbm0_precise_betgamma=precise_impulses;
 
nlcd_Text(" ", 9,38,YELLOW,BLACK,1,6,0);
nlcd_Text("-", 9,46,YELLOW,BLACK,1,6,0);
nlcd_Text("  :", 9,54,YELLOW,BLACK,1,6,0);
if (sbm0_precise_betgamma>sbm0_precise_gamma)
{
prec_fon=(sbm0_precise_betgamma-sbm0_precise_gamma)/precise_minutes/(beta_square/100);
}
else
prec_fon=0;



sprintf(svalue, "%09u", prec_fon);	
nlcd_Text(" *2/", 9, 81,WHITE,BLACK,1,6,0);
nlcd_Text(svalue, 9, 72,WHITE,BLACK,2,6,0);


if (refresh_by_second) refresh_by_second=0;
redraw_partial=0; 
 if(!redraw) return;
alarm_cancelled=0; //  ,   
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);

sprintf(svalue, "  %02u .", precise_minutes);
nlcd_Text(svalue, 10, 93,YELLOW,BLACK,1,6,0);

  //button(1, button_cancel);
  //button(2, button_down);
  //button(3, button_up);
  button(4, button_ok);
 redraw=0;
	
}

void precise_count_result()
{
unsigned long prec_fon=0;
 if((!refresh_by_second)&&(!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

 
nlcd_Text("   :", 9,50,YELLOW,BLACK,1,6,0);
#ifdef SET2SBM20
 prec_fon=((precise_impulses*3600)/(precise_minutes*60))/2;
#else
 prec_fon=((precise_impulses*3600)/(precise_minutes*60));
#endif

if (prec_fon<100000000) // , , 20     ,      :)
{
sprintf(svalue, "%07u.%02u", (int)(prec_fon/100), (int)(prec_fon%100));	
nlcd_Text("  -/", 9, 77,WHITE,BLACK,1,6,0);
}
else
{
sprintf(svalue, "%07u.%02u", (int)((prec_fon/1000)/100), (int)((prec_fon/1000)%100));
nlcd_Text("  -/", 9, 77,RED,BLACK,1,6,0);
}
nlcd_Text(svalue, 9, 68,WHITE,BLACK,2,6,0);


if (refresh_by_second) refresh_by_second=0;
redraw_partial=0; 
 if(!redraw) return;
alarm_cancelled=0; //  ,   
menu_head("", 1);
nlcd_Text(" ", 16,19,YELLOW,BLACK,1,8,0);

sprintf(svalue, "  %02u .", precise_minutes);
nlcd_Text(svalue, 10, 89,YELLOW,BLACK,1,6,0);

  //button(1, button_cancel);
  //button(2, button_down);
  //button(3, button_up);
  button(4, button_ok);
 redraw=0;
	
}

void menu_set_datetime()
{
 if((!redraw_partial_add)&&(!redraw_partial)&&(!redraw)) return;
main_screen_clock();
main_screen_battery(VoltLevel);

	sprintf(svalue, "%02u:%02u", hours, minute);
	nlcd_Text(svalue, 26,32, YELLOW, BLACK,1,8,0); // 
	sprintf(svalue, "%02u.%02u.%04u", date, month, year);
	nlcd_Text(svalue, 26,41, YELLOW, BLACK,1,8,0); // 
	sprintf(svalue, "%s",daysfull[WeekD(date, month, year)]);
	nlcd_Text(svalue, 26,50, YELLOW, BLACK,1,8,0); // 

redraw_partial=0; 
 if((!redraw_partial_add)&&(!redraw)) return;

menu_line("   <<  >>",4,(punkt==0));
menu_line("  <<  >>",5,(punkt==1));
menu_line("   <<  >>",6,(punkt==2));
menu_line("   <<  >>",7,(punkt==3));
menu_line("    <<  >>",8,(punkt==4));
redraw_partial_add=0;
if(!redraw) return; 
menu_head("/", 10);

  button(1, button_ok);
  button(2, button_adjustL);
  button(3, button_adjustR);
  button(4, button_select);
 redraw=0;

}

void menu_settings_display()
{
unsigned char x,y, percent;
unsigned int colorize;

if (redraw)
{
menu_head("", 7);

nlcd_Bitmap(6,20,120,20,spectrum);

  button(1, button_ok);
  button(2, button_adjustL);
  button(3, button_adjustR);
  button(4, button_select);
} // redraw


 if((!redraw_partial)&&(!redraw)) return;
 
main_screen_clock();
main_screen_battery(VoltLevel);

percent=((contrast-30)/5)*10;
// 
y=0;
for (x = 0; x<101; x=x+10)
   {
if (x <= percent) colorize=GREEN; else colorize=0x231;
nlcd_Box(12+x, 63, 12+x+8, 63-y, 1, colorize);
y =y+2;
   }	

menu_line("",5,(punkt==0));



percent=((brightness)/7)*10;
// 
y=0;
for (x = 0; x<101; x=x+10)
   {
if (x <= percent) colorize=GREEN; else colorize=0x231;
nlcd_Box(12+x, 96, 12+x+8, 96-y, 1, colorize);
y =y+2;
   }	
menu_line("",8,(punkt==1));

// 

redraw_partial=0;
redraw=0;	
}

//   END
//***********

void Play(unsigned long len, unsigned char *sound)
{
if ((sample)||(!sound_on))	return;

pcm_length = len;
melody=(unsigned char *)sound;
     OCR1A = 0;
	 beep_enabled=1;
	 sample_count = 4;           
	 sample=0;
}

int WeekD(unsigned int zdate, unsigned int zmonth, unsigned int zyear)
{
unsigned int wd;
	//  ,   , ;%  
  if (zmonth < 3)
  {
	zmonth=zmonth+12;
    zyear--;
  }   
wd=((zdate+(zmonth+1)*26/10)+zyear+zyear/4+6*(zyear/100)+zyear/400-1)%7;
return wd;
}

//***************************************************************************

void button(unsigned char button_number, unsigned char *bitmap)
{
unsigned int colr=GREEN;
unsigned char x=0;
unsigned char y=112;
switch (button_number) 
	{
    case 1: x=3;  break;
    case 2: x=35; break;
    case 3: x=67; break;
    case 4: x=99; break;
	}	

nlcd_Line( x+2, y, x+27, y, colr);	
nlcd_Line( x+2, y+17, x+27, y+17, colr);	
nlcd_Line( x, y+2, x, y+15, colr);	
nlcd_Line( x+29, y+2, x+29, y+15, colr);	
nlcd_Pixel(y+1, x+1, colr);	
nlcd_Pixel(y+1, x+28, colr);	
nlcd_Pixel(y+16, x+1, colr);	
nlcd_Pixel(y+16, x+28, colr);	
nlcd_Bitmap (x+2, y+1, 26 , 16, bitmap);
}


void read_keys()
{
//unsigned char dr,i;
if (key) return; //    ,   

if((PIND&(1 << PD0))==0 )//   1 
{
			  key=1;
}		  
else if((PIND&(1 << PD4))==0 )//   2 
{
			  key=2;
}
else if((PIND&(1 << PD5))==0 )//   3 
{
			  key=3;
}
else if((PIND&(1 << PD6))==0 )//   4 
{       
			  key=4;
}		  
 // asm("wdr");
}

void display() //     
{
//if ((menu_level2==15)||(menu_level2==16)||(menu_level2==7)||(menu_level2==30)||(menu_level2==25)) //     
if ((menu_level2==15)||(menu_level2==16)||(menu_level2==7)||(menu_level2==18)||(menu_level2==19)||(menu_level2==40)||(menu_level2==41)||(menu_level2==42)) //     
sleep_restricted=1; else sleep_restricted=0;
if (redraw)	{nlcd_Box(1,1,130,130,1,BLACK);punkt=punkt_naznachenija;} //   
if (menu_level0)
{ 
main_screen();
}
else
{ // 
	switch (menu_level1)
	 {
		case 0://   level2
		   switch (menu_level2)
		     {
				 case 1: //   
				 menu_graph_type();
				 break;	 //   
				 case 3: //  
				 menu_sleep_set();
				 break;	 //  
				 case 4: //   
				 menu_settings_display();
				 break;	 //   
 				 case 5: //   
				 menu_alarm_level();
				 break;	 //   
 				 case 6: //  
				 menu_set_datetime();
				 break;	 //  
 				 case 7: //  system
				 menu_system();
				 break;	 //  system
				 case 10: //    
				 display_stat_month(punkt); 
				 break;	 //    
 				 case 11: //    
				 display_stat_24h(punkt); 
				 break;	 //    
 				 case 12: //    
				 display_message_clear_dose();
				 break;	 //    
 				 case 13: //     eeprom
				 display_message_clear_eeprom_dose();
				 break;	 //     eeprom
 				 case 15: //    
				 precise_count();
				 break;	 //     
 				 case 16: //    
				 precise_count_result();
				 break;	 //     
  				 case 17: //     
				 precise_count_select();
				 break;	 //      
 				 case 18: //    
				 precise_count_beta1();
				 break;	 //     
 				 case 19: //    
				 precise_count_beta2();
				 break;	 //     

 				 case 20: //   
				 display_message_pwoff();
				 break;	 //   
 				 case 25: //  
				 display_message_alarm();
				 break;	 //  
  				 case 26: //   
				 display_message_battery();
				 break;	 //   
				 case 30: //   
				 display_message_sbm0_error();
				 break;	 //   

  				 case 40: //   
				 precise_count_beta_close();
				 break;	 //    
  				 case 41: //   
				 precise_count_beta_open();
				 break;	 //    
  				 case 42: //    
				 precise_count_beta_result();
				 break;	 //     


			 }
		break; // level2
		 
		 case 1:
		 menu_power(VoltLevel);
		 break;
		 
		 case 2:
		 //  
		 menu_dose();
		 break;
		 case 3:
		 //  
		 precise_count_type_select();
		 break;
		 case 4:
		 menu_settings();
		 //  
		 break;
	 }
	
}

}

void PinsOn()
{
//    LTC  
DDRB |= (0 << PB6);
PORTB |= (1 << PB6);
	
// , 	
	PORTE |= (0 << PE3);
	DDRE |=  (1 << DDE3);


//   
	PORTB |= (0 << PB5);
	DDRB |=  (1 << DDB5);


// 
	DDRC |=  (1 << DDC2);
	PORTC |= (0 << PC2);


}

void volatile PinsOff()
{

// , 	
	DDRE &= ~ (1<<DDE3);
	PORTE &= ~ (1<<PE3);


//   
	DDRB &= ~ (1<<DDB5);
	PORTB &= ~ (1<<PB5);
//

// 
	DDRC &= ~ (1 << DDC2);
	PORTC &= ~ (1 << PC2);



}

void PlayVib (unsigned int duration)
{
if (!awaken)	return;
PORTC |= (1<<PC2); // .   
vibplay=duration; //  
}	

unsigned char days_in_month(unsigned char monthnumber, unsigned int yar)
{
const unsigned char num_in_month[12]={31,28,31,30,31,30,31,31,30,31,30,31};
if (monthnumber==2) //  
{
if (((yar%4==0)&&(!(yar%100==0)))||(yar%400==0))
	return 29;
	else return 28;
}
else
return num_in_month[(monthnumber-1)];
}

void Geiger_sound ()
{
	if (!snd_geiger) return;
	else if (snd_geiger==1) Play(sizeof(geiger_beep), geiger_beep);
	else if (snd_geiger==3) PlayVib(500);
	else Play(sizeof(geiger_click), geiger_click);
	
}


void react_key() 
//   
{
//if (flashlight) PORTC |= (1<<PC3); else PORTC &= ~(1<<PC3);

	awaken=sleep_time+2;
	full_bright=brightness_dimm+2;
	OCR3A = brightness;
	
	if (snd_keys==1) Play(sizeof(click), click);
	else if (snd_keys==2) PlayVib(800);


if (menu_level0)
{ //
	redraw=1; //  
switch (key)
	{
		case 1: //   
		menu_level0=0;
		menu_level1=1;
		break;

		case 2: //   
		menu_level0=0;
		menu_level1=2;
		break;

		case 3: //    
		menu_level0=0;
		menu_level1=3;
		break;

		case 4: //   
		menu_level0=0;
		menu_level1=4;
		break;
	}
key=0;		
return;
} // / 

else
{
switch (menu_level1)
	{
		case 0://   level2
		   switch (menu_level2)
		     {
				 case 1: //   
		switch (key)
		 {	
			case 1: //  
			menu_level0=1;
			menu_level1=0;
			menu_level2=0;
			menu_level3=0;
			redraw=1; //  
			punkt_naznachenija=0;
			break;
			
			case 2: //  
			if (punkt<4) punkt++; else punkt=0; // 0-6
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--; else punkt=4; // 0-6
			redraw_partial=1;
			break;
			case 4: //  
				switch (punkt)
				  {
				  case 0:
				  sbm0_graph_type=0;
				  break;
				  case 1:
				  sbm0_graph_type=1;
				  break;
				  case 2:
				  sbm0_graph_type=2;
				  break;
				  case 3:
				  sbm0_graph_type=3;
				  break;
				  case 4:
				  sbm0_graph_type=4;
				  break;
				  }
				  redraw_partial=1;
				  break;
				  }		// 
				 break;
		case 3: //   C
		switch (key)
		 {	
			case 1: //  
			ee_update_settings();
			menu_level0=0;
			menu_level1=4;
			menu_level2=0;
			menu_level3=0;
			redraw=1; //  
			punkt_naznachenija=3;
			break;
			
			case 2: //  
			if (punkt<6) punkt++;  else punkt=0;// 0-6
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--;  else punkt=6;// 0-6
			redraw_partial=1;
			break;
			case 4: //  
				switch (punkt)
				  {
				  case 0:
				  sleep_time=0;
				  break;
				  case 1:
				  sleep_time=15;
				  break;
				  case 2:
				  sleep_time=30;
				  break;
				  case 3:
				  sleep_time=60;
				  break;
				  case 4:
				  sleep_time=180;
				  break;
				  case 5:
				  sleep_time=300;
				  break;
				  case 6:
				  brightness_dimm=brightness_dimm+5;
				  if (brightness_dimm>35) brightness_dimm=0;
				  break;
				  }
				  redraw_partial=1;
				  break;
				  }		// 
				 break; // 
				 case 4: //   
				 		switch (key)
						 {	
						case 1: // 
						ee_update_settings();
						menu_level0=0;
						menu_level1=4;
						menu_level2=0;
						punkt_naznachenija=4;
						redraw=1;
						break;
						case 2://  
						if (punkt==0) // contrast
						{ if (contrast>30) contrast--; nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast); }
						else // bright
						{ if (brightness>2) brightness=brightness-3;  OCR3A = brightness;}
							redraw_partial=1;
						break;
						case 3://  
						if (punkt==0) // contrast
						{ if (contrast<80) contrast++; nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast); }
						else // bright
						{ if (brightness<72) brightness=brightness+3; OCR3A = brightness;}
							redraw_partial=1;
						break;
						case 4: //  
				        punkt++;
    	 		        if (punkt>1) punkt=0; // 0-1
			            redraw_partial=1;
						break;
						 }
				 break;//   

				 case 5: //   
		switch (key)
		 {	
			case 1: //  
			ee_update_settings();
			menu_level0=0;
			menu_level1=4;
			menu_level2=0;
			redraw=1;
			punkt_naznachenija=5;
			break;
			
			case 2: //  
			if (punkt<6) punkt++;  else punkt=0;// 0-7
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--;  else punkt=6;// 0-7
			redraw_partial=1;
			break;
			case 4: //  
				switch (punkt)
				  {
				  case 0:
				  alarm_level=0;
				  break;
				  case 1:
				  alarm_level=40;
				  break;
				  case 2:
				  alarm_level=120;
				  break;
				  case 3:
				  alarm_level=300;
				  break;
				  case 4:
				  alarm_level=500;
				  break;
				  case 5:
				  alarm_level=1200;
				  break;
				  case 6:
				  alarm_level=3000;
				  break;
				  }
				  redraw_partial=1;
				  break;
				  }		// 
				  break; // alarma
				 
 				 case 6: //  
				  if (date>days_in_month(month, year)) date=days_in_month(month, year); //    
				 		switch (key)
						 {	
						case 1: // 
						ee_update_settings();
						menu_level0=0;
						menu_level1=4;
						menu_level2=0;
						redraw=1;
						punkt_naznachenija=6;
						break;
						case 2://  
								switch (punkt) //  
								{
								case 0: //
								if (hours>0) hours--;
								second=0;
								break;
								case 1: //
								if (minute>0) minute--;
								second=0;
								break;
								case 2: //
								if (date>1) date--;
								break;
								case 3: //
								if (month>1) month--;
								break;
								case 4: //
								if (year>2013) year--;
								break;
								}
						redraw_partial=1;
						break;
						case 3://  
								switch (punkt) //  
								{
								case 0: //
								if (hours<23) hours++;
								second=0;
								break;
								case 1: //
								if (minute<59) minute++;
								second=0;
								break;
								case 2: //
								date++;
								if (date>days_in_month(month, year)) date=days_in_month(month, year);
								break;
								case 3: //
								if (month<12) month++;
								break;
								case 4: //
								if (year<2100) year++;
								break;
								}
							redraw_partial=1;
						break;
						case 4: //  
				        punkt++;
    	 		        if (punkt>4) punkt=0; // 0-4
						redraw_partial_add=1;
						break;
						 }
				 break;//  

				 case 7: //   
				 		switch (key)
						 {	
						case 1: // 
						ee_update_settings();
						menu_level0=0;
						menu_level1=4;
						menu_level2=0;
						redraw=1;
						punkt_naznachenija=7;
						break;
						case 2://  
						switch (punkt) // 
						{
						case 0: //     
						if (beta_square>40) beta_square--;
						break;	
						case 1: //     
						if (imp_imp>0) imp_imp--;
						break;	
						case 2: //   
						if (imp_base>0) imp_base--;
						break;
						case 3: //   
						if (ion>110) ion--;
						do_check_batt=1;
						break;	

						}						
							redraw_partial=1;
						break;
						case 3://  
						switch (punkt) // 
						{
						case 0: //     
						if (beta_square<1800) beta_square++;
						break;	
						case 1: //     
						if (imp_imp<20) imp_imp++;
						break;	
						case 2: //   
						if (imp_base<60) imp_base++;
						break;	
						case 3: //   
						if (ion<123) ion++;
						do_check_batt=1;
						break;	
						}						
							redraw_partial=1;
						break;
						case 4: //  
				        punkt++;
    	 		        if (punkt>3) punkt=0; // 
			            redraw_partial=1;
						break;
						 }
				 break;//   
				 				 
				 case 10: //    
				 		switch (key)
						 {	
						case 1: // 
						menu_level0=0;
						menu_level1=2;
						menu_level2=0;
						redraw=1;
						punkt_naznachenija=0;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://  
						if (punkt>0) punkt--;
							redraw_partial=1;
						break;
						case 4: //  
				        if (punkt<3) punkt++;
			            redraw_partial=1;
						break;
						 }
				 break;//    
 				 case 11: //    
				 		switch (key)
						 {	
						case 1: // 
						menu_level0=0;
						menu_level1=2;
						menu_level2=0;
						redraw=1;
						punkt_naznachenija=1;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://  
						if (punkt>0) punkt--;
							redraw_partial=1;
						break;
						case 4: //  
				        if (punkt<2) punkt++;
			            redraw_partial=1;
						break;
						 }
				 break;//    

 				 case 12: //   
				 		switch (key)
						 {	
						case 1: // 
						menu_level0=0;
						menu_level1=2;
						menu_level2=0;
						redraw=1;
						punkt_naznachenija=2;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
				        sbm0_abs_max=0;
						sbm0_full_dose_days=0;
						sbm0_full_dose=0;
						
						menu_level0=0;
						menu_level1=2;
						menu_level2=0;
						redraw=1;
						break;
						 }
				 break;//   

 				 case 13: //    eeprom
				 		switch (key)
						 {	
						case 1: // 
						menu_level0=0;
						menu_level1=2;
						menu_level2=0;
						redraw=1;
						punkt_naznachenija=3;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
for (i=0;i<34;i++)
{
sbm0_dose_day[i]=0;
}
//   ,  00:00  

						menu_level0=0;
						menu_level1=2;
						menu_level2=0;
						redraw=1;
						break;
						 }
				 break;//    eeprom 
				 
 				 case 15: //   
				 		switch (key)
						 {	
						case 1: // 
						precise_counter_enable=0;
						precise_seconds_counter=0;
						menu_level0=0;
						menu_level1=3;
						menu_level2=0;
						redraw=1;
						alarm_restricted=0; 
						punkt_naznachenija=0;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4://   
							redraw_partial=1;
						break;
						 }
				 break;//   
 				 case 16: //    
				 		switch (key)
						 {	
						case 1://   
							redraw_partial=1;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: // 
						precise_counter_enable=0;
						precise_seconds_counter=0;
						menu_level0=0;
						menu_level1=3;
						menu_level2=0;
						punkt_naznachenija=0;
						alarm_restricted=0; 
						redraw=1;
						break;
						 }
				 break;//   
		case 17: //   
		switch (key) //
		 {	
			case 1: //  
			menu_level0=0;
			menu_level1=3;
			menu_level2=0;
			menu_level3=0;
			punkt_naznachenija=0;
			alarm_restricted=0; 
			redraw=1; //  
			break;
			
			case 2: //  
			if (punkt<3) punkt++;  else punkt=0;// 
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--;  else punkt=3;// 
			redraw_partial=1;
			break;
			case 4: //  
			alarm_restricted=1; 
				switch (punkt)
				  {
				  case 0: //  5 
				    precise_minutes=5; //// 5
					precise_seconds_counter=precise_minutes*60;
					precise_impulses=0;
					precise_count_finished=0;
					menu_level0=0;
					menu_level1=0;
					
					if (precise_type) 
					menu_level2=40;
					else
					{
						precise_counter_enable=1;
						menu_level2=15;
					}					
					menu_level3=0;
					redraw=1;
				  break;
				  case 1: //  10 
				    precise_minutes=10; //// 10
					precise_seconds_counter=precise_minutes*60;
					precise_impulses=0;
					precise_count_finished=0;
					menu_level0=0;
					menu_level1=0;
					if (precise_type) 
					menu_level2=40;
					else
					{
						precise_counter_enable=1;
						menu_level2=15;
					}
					menu_level3=0;
					redraw=1;
				  break;
				  case 2: //  20 
					precise_minutes=20;
					precise_seconds_counter=precise_minutes*60;
					precise_impulses=0;
					precise_count_finished=0;
					menu_level0=0;
					menu_level1=0;
					if (precise_type) 
					menu_level2=40;
					else
					{
						precise_counter_enable=1;
						menu_level2=15;
					}
					menu_level3=0;
					redraw=1;				  
				  break;
  				  case 3: //  30 
					precise_minutes=30;
					precise_seconds_counter=precise_minutes*60;
					precise_impulses=0;
					precise_count_finished=0;
					menu_level0=0;
					menu_level1=0;
					if (precise_type) 
					menu_level2=40;
					else
					{
						precise_counter_enable=1;
						menu_level2=15;
					}
					
					menu_level3=0;
					redraw=1;				  
				  break;
				  }				  
			break;
		 }		// 
		break;

		 
				 
				 
				 case 20: // poweroff
				 				 		switch (key)
						 {	
						case 1: //  ->  
						menu_level0=0;
						menu_level1=1;
						menu_level2=0;
						punkt_naznachenija=5;
						redraw=1;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
	nlcdOff();
	MCUCR = (0 << SM2)|(1 << SM1)|(0 << SM0)|(1 << SE); //PowerDown
	PinsOff();
	PORTC &= ~(1<<PC1); //   OFF
	PORTC &= ~(1<<PC2); //  
	OCR3A = 0; //  OFF
//	TIMSK &= ~(1 << TOIE2); //    
	OCR1A = 0;
	beep_enabled=0;
	sample=0;
    menu_level0=1;
    menu_level1=0;
    menu_level2=0;
	gone_powerdown=1;
	EIMSK &= ~(1<< INT1); //
	EIMSK |= (1 << INT0); //		
	asm("sleep");		  
						break;
						 }

				 break; // poweroff
				 case 25: // 
				 				 		switch (key)
						 {	
						case 1: //   
							redraw_partial=1;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
						menu_level0=1;
						menu_level1=0;
						menu_level2=0;
						sleep_restricted=0;	//   -  
						alarm_cancelled=1; 
						key=0; 
						alarming=0; 
						//  
						punkt_naznachenija=0;
						redraw=1;
						message_drawn=0; 
						break;
						 }

				 break; // 
				 case 26: // 
				 				 		switch (key)
						 {	
						case 1: //   
							redraw_partial=1;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
						menu_level0=1;
						menu_level1=0;
						menu_level2=0;
						sleep_restricted=0;	//   -  
						volt_level_error=0; //  .   -  
						key=0; 
						//  
						punkt_naznachenija=0;
						redraw=1;
						message_drawn=0; 
						break;
						 }

				 break; // 
				 case 30: //  
				 				 		switch (key)
						 {	
						case 1: //   
							redraw_partial=1;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
						menu_level0=1;
						menu_level1=0;
						menu_level2=0;
						sleep_restricted=0;	//   -  
						no_imp_error=0; //  
						delta_os=0; //  
						hv_low=0; //   
						redraw=1;
						message_drawn=0; 
						punkt_naznachenija=0;
						break;
						 }
				 break; //  

				 case 40: //  ...
				 	switch (key)
						 {	
						case 1: // 
						precise_counter_enable=0;
						precise_seconds_counter=0;
						precise_step=0;
						menu_level0=0;
						menu_level1=3;
						menu_level2=0;
						redraw=1;
						alarm_restricted=0; 
						punkt_naznachenija=0;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
						menu_level0=0;
						menu_level1=0;
						menu_level2=18;
						redraw=1;
						precise_impulses=0;
						precise_count_finished=0;
						precise_counter_enable=1;
						precise_step=0;
						break;
						 }
				 break; //  ...
				 
				 
				 
				 case 41: //  ...
				 	switch (key)
						 {	
						case 1: // 
						precise_counter_enable=0;
						precise_seconds_counter=0;
						menu_level0=0;
						menu_level1=3;
						menu_level2=0;
						precise_step=0;
						redraw=1;
						alarm_restricted=0; 
						punkt_naznachenija=0;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: //  
						menu_level0=0;
						menu_level1=0;
						menu_level2=19;
						precise_impulses=0;
						precise_count_finished=0;
						precise_counter_enable=1;
						redraw=1;
						break;
						 }
				 break; //  ...
 				 case 42: //     
				 		switch (key)
						 {	
						case 1://   
							redraw_partial=1;
						break;
						case 2://   
							redraw_partial=1;
						break;
						case 3://   
							redraw_partial=1;
						break;
						case 4: // 
						precise_counter_enable=0;
						precise_seconds_counter=0;
						menu_level0=0;
						menu_level1=3;
						menu_level2=0;
						punkt_naznachenija=0;
						redraw=1;
						alarm_restricted=0; 
						break;
						 }
				 break;//     
				 

			 }
		break;
		case 1: //  
		switch (key)
		 {	
			case 1: //  
			menu_level0=1;
			menu_level1=0;
			menu_level2=0;
			menu_level3=0;
			redraw=1; //  
			punkt_naznachenija=0;
			break;
			
			case 2: //  
			if (punkt<5) punkt++;  else punkt=0;// 0  1   2    3 
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--;  else punkt=5;// 0  1   2    3 
			redraw_partial=1;
			break;
			case 4: //  
				switch (punkt)
				  {
				  case 0:
				  // Sleep NOW
				  		// LCD off etc
	awaken=0;
	nlcdOff();
	PinsOff();
	PORTC &= ~(1<<PC1); //   OFF
	PORTC &= ~(1<<PC2); //  
	OCR3A = 0; //  OFF
	MCUCR |= (0 << SM2)|(1 << SM1)|(1 << SM0)|(1 << SE); //PowerSave
//	TIMSK &= ~(1 << TOIE2); //    
	OCR1A = 0;
	beep_enabled=0;
	sample=0;
    menu_level0=1;
    menu_level1=0;
    menu_level2=0;
	EIMSK |= (1 << INT0); //
				  break;
  				  case 1: // 
				  if (flashlight) flashlight=0; else flashlight=1;
				  if (flashlight) PORTC |= (1<<PC3); else PORTC &= ~(1<<PC3);
				  redraw_partial=1;
				  break;
				  case 2: //    
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=3;
				  menu_level3=0;
				  redraw=1;
				  break;
  				  case 3: //   
				  // // volatile char snd_geiger=1; // 1  2  3  0 
				  ///volatile char snd_keys=1; // 1  2  0 
				  snd_geiger++;
				  if (snd_geiger>3) snd_geiger=0;
				  redraw_partial=1;
				  break;
				  case 4:
				  // GOTO Bright/contrast
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=4;
				  menu_level3=0;
				  redraw=1;
				  break;
				  case 5:
					// pwoff y/n
  					menu_level0=0;
					menu_level1=0;
					menu_level2=20;
					menu_level3=0;
					redraw_partial=1;				  
				  break;
				  }				  
			break;
		 }		// case1 level1 
		break;
		case 2: //  
		switch (key)
		 {	
			case 1: //  
			menu_level0=1;
			menu_level1=0;
			menu_level2=0;
			menu_level3=0;
			punkt_naznachenija=0;
			redraw=1; //  
			break;
			
			case 2: //  
			if (punkt<3) punkt++;  else punkt=0;// 
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--;  else punkt=3;// 
			redraw_partial=1;
			break;
			case 4: //  
				switch (punkt)
				  {
				  case 0: //   
					menu_level0=0;
					menu_level1=0;
					menu_level2=10;
					menu_level3=0;
					redraw=1;
				  break;
				  case 1: //   
					menu_level0=0;
					menu_level1=0;
					menu_level2=11;
					menu_level3=0;
					redraw=1;				  
				  break;
  				  case 2: //  
					menu_level0=0;
					menu_level1=0;
					menu_level2=12;
					menu_level3=0;
					redraw_partial=1;				  
				  break;
  				  case 3: //   eeprom
					menu_level0=0;
					menu_level1=0;
					menu_level2=13;
					menu_level3=0;
					redraw_partial=1;				  
				  break;
				  }				  
			break;
		 }		// case1 level1 		
		break;
		case 3: //  
		switch (key) //
		 {	
			case 1: //  
			menu_level0=1;
			menu_level1=0;
			menu_level2=0;
			menu_level3=0;
			punkt_naznachenija=0;
			redraw=1; //  
			break;
			
			case 2: //  
			if (punkt<1) punkt++;  else punkt=0;// 
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--;  else punkt=1;// 
			redraw_partial=1;
			break;
			case 4: //  
				switch (punkt)
				  {
				  case 0: // 
				    precise_type=0; // -
					menu_level0=0;
					menu_level1=0;
					menu_level2=17;
					menu_level3=0;
					redraw=1;
				  break;
				  case 1: // 
				    precise_type=1; // -
					menu_level0=0;
					menu_level1=0;
					menu_level2=17;
					menu_level3=0;
					redraw=1;
				  break;
				  }				  
			break;
		 }		// 
		break;
		case 4: //  
				switch (key)
		 {	
			case 1: //  
			eeprom_update_byte(&e_sbm0_graph_type, sbm0_graph_type);
			eeprom_update_byte(&e_sbm1_graph_type, sbm1_graph_type);
			eeprom_update_byte(&e_snd_geiger, snd_geiger);
			eeprom_update_byte(&e_snd_keys, snd_keys);
			menu_level0=1;
			menu_level1=0;
			menu_level2=0;
			menu_level3=0;
			punkt_naznachenija=0;
			redraw=1; //  
			break;
			
			case 2: //  
			if (punkt<7) punkt++;  else punkt=0;// 0-6
			redraw_partial=1;
			break;
			
			case 3: //  
			if (punkt>0) punkt--;  else punkt=7;// 0-6
			redraw_partial=1;
			break;
			case 4: //  
				switch (punkt)
				  {
				  case 0: //  
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=1;
				  menu_level3=0;
				  punkt_naznachenija=sbm0_graph_type;
				  redraw=1;
				  break;
				  case 1: //  
				  // // volatile char snd_geiger=1; // 1  2  3  0 
				  ///volatile char snd_keys=1; // 1  2  0 
				  snd_keys++;
				  if (snd_keys>2) snd_keys=0;
				  redraw_partial=1;
				  break;
				  case 2: //   
				  // // volatile char snd_geiger=1; // 1  2  3  0 
				  ///volatile char snd_keys=1; // 1  2  0 
				  snd_geiger++;
				  if (snd_geiger>3) snd_geiger=0;
				  redraw_partial=1;
				  break;
				  case 3: //  
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=3;
				  menu_level3=0;
				  switch (sleep_time)
					{
					case 0: punkt_naznachenija = 0; break;	
					case 15: punkt_naznachenija = 1; break;	
					case 30: punkt_naznachenija = 2; break;	
					case 60: punkt_naznachenija = 3; break;	
					case 180: punkt_naznachenija = 4; break;	
					case 300: punkt_naznachenija = 5; break;	
					}					
				  redraw=1;
				  break;
				  case 4:  // . 
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=4;
				  menu_level3=0;
				  punkt_naznachenija=0;
				  redraw=1;
				  break;
				  case 5:  //  
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=5;
				  menu_level3=0;
  				  switch (alarm_level)
					{
					case 0: punkt_naznachenija = 0; break;	
					case 40: punkt_naznachenija = 1; break;	
					case 120: punkt_naznachenija = 2; break;	
					case 300: punkt_naznachenija = 3; break;	
					case 500: punkt_naznachenija = 4; break;	
					case 1200: punkt_naznachenija = 5; break;	
					case 3000: punkt_naznachenija = 6; break;	
					}					
				  redraw=1;
				  break;
  				  case 6:  //  
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=6;
				  menu_level3=0;
				  punkt_naznachenija=0;
				  redraw=1;
				  break;

  				  case 7:  //  
				  menu_level0=0;
				  menu_level1=0;
				  menu_level2=7;
				  menu_level3=0;
				  redraw_partial=1;
				  redraw=1;
				  punkt_naznachenija=0;
				  break;

				  }				  
			break;
		 }		// case1 level1 

		break; // 

	}	


key=0;		
}
}

void check_accumulator()
{
unsigned char MCUCR_status;	
unsigned int temporary_VL;
if ((PINB&(1 << PB6))==0)// 
    {
		charging=1;
	} else charging=0;
// * * ** **
ADCSRA |=	(1 << ADEN) // 
			|(0 << ADSC) //  
			|(0 << ADFR) //  
			|(1 << ADIE) //  
			|(1 << ADPS2)|(1 << ADPS1)|(0 << ADPS0); //   64 (  125kHz   8mHz)

ADMUX |= (0 << REFS1)|(1 << REFS0) //  AVCC
		|(1 << ADLAR) //     , ADCL  
		|(0 << MUX0)|(1 << MUX1)|(1 << MUX2)|(1 << MUX3)|(1 << MUX4); //  .  1.23v
		MCUCR_status=MCUCR;
		MCUCR = (1 << SE)|(1 << SM0)|(0 << SM1)|(0 << SM2); //     		
_delay_us(125); //    
 //TIMSK = 0x00;
// TIMSK |= (0 << OCIE0);

for (i=0; i<65; i++) // 9 ,  5-8 
{
ADCSRA |= (1 << ADSC);    // 
 asm("sleep"); //-
while (ADIF == 0); //   
temporary_VL += VL;
}
VoltLevel=(temporary_VL>>6);
// TIMSK |= (1 << OCIE0);
//		MCUCR = (0 << SE)|(0 << SM0)|(0 << SM1)|(0 << SM2); // 	
		MCUCR=MCUCR_status;
ADCSRA |=	(0 << ADEN); // 
if (VoltLevel>volt_level_error_threshold) volt_level_error=0; //  
if (VoltLevel>volt_level_poweroff_threshold) volt_level_shutdown=0; //  

}

int main(void)
{

PinsOn();

	  ee_read_doses_daily();
	  ee_read_settings();

//  
	DDRC |=  (1 << DDC1);
	PORTC |= (0 << PC1);

//  
	DDRD |=  (1 << DDD7);
	PORTD |= (0 << PD7); 
	
//  0  
DDRD |= (0 << PD1);
PORTD |= (0 << PD1);

//  1
// DDRD |= (0 << PD2);
// PORTD |= (1 << PD2);

// 
	DDRC |=  (1 << DDC3);
	PORTC |= (0 << PC3);

//     
DDRC |= (0 << PC0);
PORTC |= (1 << PC0);

DDRD |= (0 << PD0); //  0  
PORTD |= (1 << PD0);

//   
DDRD |= ((0 << PD4)|(0 << PD5)|(0 << PD6));
PORTD |= ((1 << PD4)|(1 << PD5)|(1 << PD6));


	  cli();
	  
//
ASSR|=(1<<AS0); // 
TCCR0|=(1<<CS00)|(1<<CS01)|(1<<CS02)|(1<<WGM01)|(0<<WGM00); // 32768/1024 =32hz  2 
OCR0=31; //  32-1

//  
     TCCR3A = (1 << COM3A1)|(1 << WGM30);
     TCCR3B = (1 << WGM32)|(1 << CS30);
     OCR3A = 0;
   
//
      TCCR2 |= (0 << CS22)|(0 << CS21)|(1 << CS20); // 8mHz / 1
      TCNT2=0;

 /* 
     clear OC1A on compare match 
     OC1A  BOTTOM, non-inverting mode
 */
     TCCR1A = (1 << COM1A1)|(1 << WGM10);
     /* 
     , 8bit
     : clk/1 = 8MHz
       = 8MHz / (255 + 1) = 31.25kHz
     */
     TCCR1B = (1 << WGM12)|(1 << CS10);
     OCR1A = 0;
 
	  
	  TIMSK |= (1 << TOIE2)|(1 << OCIE0);
	  
	PORTC |= (1<<PC1); //  
    nlcd_Init();                                        // 
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast);
	OCR3A = brightness;
display_welcome();
	
redraw=1;
sbm0_day_fon_cntr=1;
do_check_batt=1;
//      _delay_us(150); //       
//	  display_welcome();
	  
	  EICRA |= (0 << ISC11)|(0 << ISC10)|(0 << ISC01)|(0 << ISC00); //|(0 << ISC21)|(0 << ISC20);
	  EIMSK |= (1 << INT1); //|(1 << INT2);
	  sei();                 //   


while(1) 
   {

if (do_check_batt)
{
do_check_batt=0;
check_accumulator();
}

if (awaken)
{ // awaken


//   
read_keys();
if(key){EIMSK  &= ~(1<< INT1); react_key(); EIMSK |= (1 << INT1);};
if (precise_count_finished) 
		{
		if(precise_type) // beta
		  if (precise_step)
		  {
		  		Play(sizeof(count_finished), count_finished);
		EIMSK &= ~(1<< INT1);
		precise_count_finished=0;
		precise_step=0;
	   	precise_seconds_counter=precise_minutes*60;
		menu_level0=0;
		menu_level1=0;
		menu_level2=42; //   
	    menu_level3=0;
	    redraw=1;
		EIMSK |= (1 << INT1);
		  } 
		  else
		  {
		Play(sizeof(count_finished), count_finished);
		EIMSK &= ~(1<< INT1);
		precise_count_finished=0;
		precise_step=0;
	   	precise_seconds_counter=precise_minutes*60;
		menu_level0=0;
		menu_level1=0;
		precise_step=1;
		menu_level2=41; //   
	    menu_level3=0;
	    redraw=1;
		EIMSK |= (1 << INT1);
		  }			
		 
		else // gamma
		{

		Play(sizeof(count_finished), count_finished);
		EIMSK &= ~(1<< INT1);
		precise_count_finished=0;
	   	precise_seconds_counter=precise_minutes*60;
		menu_level0=0;
		menu_level1=0;
		menu_level2=16; //   
	    menu_level3=0;
	    redraw=1;
		EIMSK |= (1 << INT1);
		}			
		}
if ((alarming)&&(second%2)&&(!alarm_restricted))
 {
	 			//   
	Play(sizeof(rad_alarm), rad_alarm);
	PlayVib(1500);
		menu_level0=0;
		menu_level1=0;
		menu_level2=25; // 
	    menu_level3=0;
 }
//   

display();
} //awaken
else
{
	// 
	asm("sleep");
}	
if ((no_imp_error>5)||(delta_os>500))  //    
// 3    -  
//       10,   500   
		{

	if (!awaken)	//   -       
	{
	awaken=sleep_time+2;
	full_bright=brightness_dimm+2;
	//sleep_restricted=1;	
	// lcd on etc
	PinsOn();
	PORTC |= (1<<PC1); //  
    nlcd_Init();                                        // 
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast);
	OCR3A = brightness;
	TIMSK |= (0 << TOIE2); //    
	MCUCR |= (0 << SE); //PowerSave Disable
    EIMSK &= ~(1<< INT0); //
	}

		Play(sizeof(sensor_error), sensor_error);
		EIMSK &= ~(1<< INT1);
		menu_level0=0;
		menu_level1=0;
		if (no_imp_error>5) errtype=0; else errtype=1;//  
		menu_level2=30; //  
	    menu_level3=0;
		EIMSK |= (1 << INT1);
		redraw_partial=1;
		}

if ((volt_level_error>4)&&(minute%10==0)) //      10 
  //    
//    
		{

	if (!awaken)	//   -   
	{
	awaken=sleep_time+2;
	full_bright=brightness_dimm+2;
	// sleep_restricted=1;	
	// lcd on etc
	PinsOn();
	PORTC |= (1<<PC1); //  
    nlcd_Init();                                        // 
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast);
	OCR3A = brightness;
	TIMSK |= (0 << TOIE2); //    
	MCUCR |= (0 << SE); //PowerSave Disable
    EIMSK &= ~(1<< INT0); //
	}

		Play(sizeof(batt_lo), batt_lo);
		EIMSK &= ~(1<< INT1);
		menu_level0=0;
		menu_level1=0;
		menu_level2=26; //  
	    menu_level3=0;
		EIMSK |= (1 << INT1);
		redraw_partial=1;
		}


if (volt_level_shutdown>10) //    
//     -  
		{

	if (!awaken)	//   -   
	{
	awaken=sleep_time+2;
	full_bright=brightness_dimm+2;
	// sleep_restricted=1;	
	// lcd on etc
	PinsOn();
	PORTC |= (1<<PC1); //  
    nlcd_Init();                                        // 
	nlcd_SendByte(CMD_LCD_MODE,LCD_PHILLIPS_SETCON); nlcd_SendByte(DATA_LCD_MODE,contrast);
	OCR3A = brightness;
	TIMSK |= (0 << TOIE2); //    
	MCUCR |= (0 << SE); //PowerSave Disable
    EIMSK &= ~(1<< INT0); //
	}

		Play(sizeof(batt_lo), batt_lo);
	nlcdOff();	
	MCUCR = (0 << SM2)|(1 << SM1)|(0 << SM0)|(1 << SE); //PowerDown
	PinsOff();		
	PORTC &= ~(1<<PC1); //   OFF
	PORTC &= ~(1<<PC2); //  
	OCR3A = 0; //  OFF
//	TIMSK &= ~(1 << TOIE2); //    
	OCR1A = 0;
	beep_enabled=0;
	sample=0;
    menu_level0=1;
    menu_level1=0;
    menu_level2=0;
	gone_powerdown=1;
	EIMSK &= ~(1<< INT1); //
	EIMSK |= (1 << INT0); //
	asm("sleep");		  
		}

   } 
}


