/*****************************************************
Project : MicroTAC LED display test
Date    : 19.12.2013
Author  : Sergey Kozlov                         
Company : Intellekt Dialog                

Chip type           : ATmega88
Clock frequency     : 16,000000 MHz
*****************************************************/

#include <mega88.h>
#include <stdint.h>
#include <delay.h>
 
#include "fnt5x7.c"

//LED screen pins definitions
#define PIN_LOAD	PORTD.2
#define PIN_DATA	PORTD.1
#define PIN_CLK	PORTD.0  
//
//LED screen commands
#define CMD_CLEAR	0b11000000   //clear display
#define CMD_BRIGHT	0b11100100   //20% brightness
#define CMD_DIG_ADR	0b10100000   //digit adress mask
//

#define SCR_BUF_LEN	7

const uint8_t str[]="Hello World! ";
uint8_t scr_buf[ SCR_BUF_LEN ] = {' ',' ',' ',' ',' ',' ',' '};
 
//-----------------------------------------------------------
// Send byte to LED screen
//-----------------------------------------------------------
void led_tx_byte( uint8_t data )
{
	uint8_t i;
	
	PIN_LOAD = 0;
	
	for( i=0; i<8; i++ )
		{
		delay_us(1);
		PIN_CLK = 0;
		if( data & (1<<i) )
			PIN_DATA = 1;
		else
			PIN_DATA = 0;
		delay_us(1);
		PIN_CLK = 1;
		delay_us(1);
		}

	PIN_LOAD = 1;
	PIN_CLK = 0;
	
	delay_us(1);
}

//-----------------------------------------------------------
// Print single char
// Arguments:
//char,
//symbol position(0-7)
//-----------------------------------------------------------
void led_putchar( uint8_t c, uint8_t adr )
{    
	uint8_t i;
	const uint8_t *fnt_ptr;
	
	led_tx_byte( adr | CMD_DIG_ADR ); 
	
	c -= ' ';
	fnt_ptr = &fnt5x7[ ((uint16_t)c)*7 ];
	
	for( i=0; i<7; i++ )
		{
		led_tx_byte( *fnt_ptr++ );
		};
	
}
 
//-----------------------------------------------------------
// Send scr_buf to LED screen
//-----------------------------------------------------------
void led_update()
{
	uint8_t i;
	
	for( i=0; i<SCR_BUF_LEN; i++ )
		{ 
		led_putchar( scr_buf[i], i );
		};	
}
 
//-----------------------------------------------------------
// Shift string buffer left
//-----------------------------------------------------------
void buf_shift( void )
{
	uint8_t i;
	
	for( i=0; i<(SCR_BUF_LEN-1); i++ )
		{
		scr_buf[ i ] = scr_buf[ i+1 ];
		};
	scr_buf[ SCR_BUF_LEN-1 ] = ' ';
}

//-----------------------------------------------------------
// Scroll text buf string for 1 char
//-----------------------------------------------------------
void buf_scroll( void )
{ 
	static uint8_t str_cnt = 0;
	
	buf_shift();
	
	if( str_cnt < (sizeof(str)-1) )
		{
		scr_buf[ SCR_BUF_LEN-1 ] = str[ str_cnt++ ];
		}
	else
		{ 
		str_cnt = 0;
		};	
}


void main(void)
{
// Declare your local variables here

// Crystal Oscillator division factor: 1
#pragma optsize-
CLKPR=0x80;
CLKPR=0x00;
#ifdef _OPTIMIZE_SIZE_
#pragma optsize+
#endif

// Input/Output Ports initialization
// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTB=0x00;
DDRB=0x00;

// Port C initialization
// Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out 
// State6=1 State5=1 State4=1 State3=1 State2=1 State1=1 State0=1 
PORTC=0x00;
DDRC=0x00;

// Port D initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTD=0xFF;
DDRD=0xFF;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: Timer 0 Stopped
// Mode: Normal top=FFh
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x00;
TCNT0=0x00;
OCR0A=0x00;
OCR0B=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer 1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2A output: Disconnected
// OC2B output: Disconnected
ASSR=0x00;
TCCR2A=0x00;
TCCR2B=0x00;
TCNT2=0x00;
OCR2A=0x00;
OCR2B=0x00;

// External Interrupt(s) initialization
// INT0: Off
// INT1: Off
// Interrupt on any change on pins PCINT0-7: Off
// Interrupt on any change on pins PCINT8-14: Off
// Interrupt on any change on pins PCINT16-23: Off
EICRA=0x00;
EIMSK=0x00;
PCICR=0x00;

// Timer/Counter 0 Interrupt(s) initialization
TIMSK0=0x00;
// Timer/Counter 1 Interrupt(s) initialization
TIMSK1=0x00;
// Timer/Counter 2 Interrupt(s) initialization
TIMSK2=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
ADCSRB=0x00;

//LED screen init
led_tx_byte( CMD_CLEAR );
led_tx_byte( CMD_BRIGHT );

while (1)
      {
      // Place your code here
      delay_ms( 200 );
      buf_scroll();
      led_update();
      };
}
