        LIST        P=12F629
        __CONFIG    0X3F84
        INCLUDE     "P12F629.INC"
;---------------------------------------
RESW	EQU		0X20
RESS	EQU		0X21
GP_PREV	EQU		0X22
MEM_WR	EQU		0X23
;---------------------------------------
		ORG     0
		BSF     STATUS, RP0		;BANK 1
        MOVLW   B'00000111'		;PRESCALER VARIABLE
        GOTO    INIT
;---------------------------------------
        ORG     4   			;INTERRUPT
		MOVWF	RESW
		MOVF	STATUS, W
		MOVWF	RESS

		BTFSC	GP_PREV, 3		;TEST BUTTON 3
		BTFSC	GPIO, 3
		GOTO	GPTEST4
		BTFSS	GP_PREV, 2		;BUTTON 3 IS PRESSED
		BSF		GPIO, 2
		BTFSC	GP_PREV, 2
		BCF		GPIO, 2
		BSF		MEM_WR, 0		;SAVE OUTPUTS STATE

GPTEST4	BTFSC	GP_PREV, 4		;TEST BUTTON 2
		BTFSC	GPIO, 4
		GOTO	GPTEST5
		BTFSS	GP_PREV, 1		;BUTTON 2 IS PRESSED
		BSF		GPIO, 1
		BTFSC	GP_PREV, 1
		BCF		GPIO, 1
		BSF		MEM_WR, 0		;SAVE OUTPUTS STATE

GPTEST5	BTFSC	GP_PREV, 5		;TEST BUTTON 1
		BTFSC	GPIO, 5
		GOTO	ENDPROC
		BTFSS	GP_PREV, 0		;BUTTON 1 IS PRESSED
		BSF		GPIO, 0
		BTFSC	GP_PREV, 0
		BCF		GPIO, 0
		BSF		MEM_WR, 0		;SAVE OUTPUTS STATE
		
ENDPROC	MOVF	GPIO, W
		MOVWF	GP_PREV			;SAVE GPIO
		BCF		INTCON, T0IF	;CLEAR INTERRUPT FLAG

;-------SAVE TO EEPROM--------------------------------
		BTFSS	MEM_WR, 0		;IF OUTPUTS IS NOT CHANGED
		GOTO	EXIT			;THEN EXIT
								;ELSE SAVE OUTPUTS STATE
		BSF		STATUS, RP0		;BANK 1
		CLRF	EEADR
		MOVWF	EEDAT			;IN WREG IS GPIO!
		BSF		EECON1,WREN		;ENABLE WRITE
		MOVLW	0X55			;Unlock write
		MOVWF	EECON2			;
		MOVLW	0XAA			;
		MOVWF	EECON2			;
		BSF		EECON1, WR		;Start the write
		BCF		STATUS, RP0		;BANK 0

EXIT	MOVF	RESS, W
		MOVWF	STATUS
		MOVF	RESW, W
		RETFIE
;---------------------------------------
INIT	MOVWF   OPTION_REG		;TMR0 PRESCALER IS 1:256
		MOVLW   B'10100000'		;INTERRUPN ON
        MOVWF   INTCON			;TMR0 ONLY
        MOVLW   B'00111000'		;GP0..2 DIGITAL OUT
        MOVWF   TRISIO			;GP3..5 DIGITAL IN
		MOVLW	B'00110000'		;PULL-UP FOR GP4, GP5
		MOVWF	WPU

		CLRF	EEADR			;EEPROM ADDRESS IS 0
		BSF		EECON1, RD		;READ EEPROM
		MOVLW	B'00000111'
		ANDWF	EEDAT, W		;CUT 4..7th BITS
		MOVWF	GPIO

		BCF		STATUS, RP0		;BANK 0
		MOVLW	B'00000111'
		MOVWF	CMCON			;COMPARATOR OFF
		MOVF	GPIO, W
		MOVWF	GP_PREV			;SAVE GPIO

LOOP	NOP
		GOTO	LOOP			;INFINITY CYCLE

		END