


#include "stm32f10x.h"
#include "stm32f10x_rcc.h"

void __attribute__ ((weak)) _init(void)  {};

#define SYSCLK_FREQ  32000000

uint32_t SystemCoreClock         = SYSCLK_FREQ;        /*!< System Clock Frequency (Core Clock) */

static void SetSysClockTo24(void);

void SystemInit (void)
{
	/* Reset the RCC clock configuration to the default reset state(for debug purpose) */
	/* Set HSION bit */
	RCC->CR |= (uint32_t)0x00000001;
	/* Reset SW, HPRE, PPRE1, PPRE2, ADCPRE and MCO bits */
	RCC->CFGR &= (uint32_t)0xF0FF0000;

	/* Reset HSEON, CSSON and PLLON bits */
	RCC->CR &= (uint32_t)0xFEF6FFFF;

	/* Reset HSEBYP bit */
	RCC->CR &= (uint32_t)0xFFFBFFFF;

	/* Reset PLLSRC, PLLXTPRE, PLLMUL and USBPRE/OTGFSPRE bits */
	RCC->CFGR &= (uint32_t)0xFF80FFFF;

	/* Disable all interrupts and clear pending bits  */
	RCC->CIR = 0x009F0000;

	SetSysClockTo24();
}

static void SetSysClockTo24(void)
{
	__IO uint32_t StartUpCounter = 0, HSEStatus = 0;

	/* Enable HSE */
	RCC->CR |= ((uint32_t)RCC_CR_HSEON);
	while( (RCC->CR & RCC_CR_HSERDY) == 0);

	/* HCLK = SYSCLK */ 	/* PCLK2 = HCLK */ /* PCLK1 = HCLK */
	RCC->CFGR |= RCC_CFGR_HPRE_DIV1|RCC_CFGR_PPRE2_DIV1|RCC_CFGR_PPRE1_DIV1;

	/*  PLL configuration:  = (HSE / 2) * 4 = 24 MHz */
	RCC->CFGR &= (uint32_t)((uint32_t)~(RCC_CFGR_PLLSRC |RCC_CFGR_PLLMULL|RCC_CFGR_PLLXTPRE));
	RCC->CFGR |= (uint32_t)(RCC_CFGR_PLLSRC | RCC_CFGR_PLLMULL16);//2*16 = 32M
	RCC->CFGR2 = 5; // 12/(5+1) = 2MHz

	/* Enable PLL */
	RCC->CR |= RCC_CR_PLLON;

	/* Wait till PLL is ready */
	while((RCC->CR & RCC_CR_PLLRDY) == 0) {}

	/* Select PLL as system clock source */
	RCC->CFGR &= (uint32_t)((uint32_t)~(RCC_CFGR_SW));
	RCC->CFGR |= (uint32_t)RCC_CFGR_SW_PLL;

	/* Wait till PLL is used as system clock source */
	while ((RCC->CFGR & (uint32_t)RCC_CFGR_SWS) != (uint32_t)0x08) {}

}
