//----------------------------------------------------------------------------

//  

//-----------------------  : ------------------------------

//  F1  F2    IO.
//      (keyboard.cpp).
//   (). 
//     
//    :
//-   
//-  
//-   
//-     
//       F1, F2  GND
//-      
//       .
//      .  
//  ,      (  
// )  4  .
//   .   
//      ENC_MAX_V,
//       .

//----------------------------------------------------------------------------

#include "main.h"
#include "encoder.h"
#include "data.h"

//------------------------------- : ---------------------------------

#define ENC_MAX_V  14 //  ,   
#define ENC_V_TM  100 //   , mS
#define ENC_R_TM   10 //   , mS

#define ENC_MAX_VC (ENC_MAX_V * 4 / (1000 / ENC_V_TM))

//----------------------------------------------------------------------------
//----------------------------  TEncoder: -------------------------------
//----------------------------------------------------------------------------

//----------------------------- : ---------------------------------

TEncoder::TEncoder(void)
{
  Pin_F1.Init(IN_PULL, PULL_UP);
  Pin_F2.Init(IN_PULL, PULL_UP);
  Message = ENC_NOP;
  EncPrev = STATE_0;
  EncPrevPrev = STATE_0;
#if ENC_FLT > 1 
  for(char i = 0; i < ENC_FLT; i++)
    EncF[i] = STATE_0;
  FPtr = 0;
#endif  
  EncV = 0; EncS = 0;
  EncTimer = new TSoftTimer(ENC_V_TM);
  EncTimer->Autoreload = 1;
  RevTimer = new TSoftTimer(ENC_R_TM);
  RevTimer->Force();
  Dir = 0;
  Rev = 0;
}

//----------------------------  : -------------------------------

void TEncoder::Execute(void)
{
  if(EncTimer->Over())                //  
  {
    EncV = EncS;                      //  
    EncS = 0;
  }
  EncCur = STATE_0;
  if(Rev)
  {
    if(!Pin_F1) EncCur  = STATE_A;    //  1
    if(!Pin_F2) EncCur |= STATE_B;    //  2
  }
  else
  {
    if(!Pin_F1) EncCur  = STATE_B;    //  1
    if(!Pin_F2) EncCur |= STATE_A;    //  2
  }
#if ENC_FLT > 1 
  EncF[FPtr] = EncCur;                //  
  if(++FPtr == ENC_FLT) FPtr = 0;     // 
  for(char i = 0; i < ENC_FLT; i++)
    if(EncF[i] != EncCur)             //    ,
      EncCur = EncPrev;               //  
#endif
  if(EncCur != EncPrev)               //  ,
  {
    if(EncCur != EncPrevPrev)
      EncS++;                         //    
    if(EncPrev == STATE_AB)
    {
      if(EncCur == STATE_A &&
         EncPrevPrev == STATE_B)
      {
        if(Dir || RevTimer->Over())
        {
          if(EncV >= ENC_MAX_V)       //   , 
            Message = ENC_FAST_STEP;  //  
              else                    //
                Message = ENC_STEP;   // 
          Dir = 1;
        }
        RevTimer->Start();
      }
      if(EncCur == STATE_B &&
         EncPrevPrev == STATE_A)
      {
        if(!Dir || RevTimer->Over())
        {
          if(EncV >= ENC_MAX_V)       //   , 
            Message = -ENC_FAST_STEP; //  ,
              else                    //
                Message = -ENC_STEP;  // 
          Dir = 0;
        }
        RevTimer->Start();
      }
    }
    EncPrevPrev = EncPrev;            // - 
    EncPrev = EncCur;                 //  
  }
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
