//----------------------------------------------------------------------------

// ,  

//----------------------------------------------------------------------------

#ifndef MAIN_H
#define MAIN_H

//----------------------------------------------------------------------------

#include <stdint.h>
#include "stm32f10x.h"
#include "gpio.h"
#include "systimer.h"

//------------------   : -----------------------

// 1 (VBAT): +3.3V
// 2 (PC13):  
// 3 (PC14):  
// 4 (PC15):  
// 5 (PD0):   
// 6 (PD1):   
// 7 (NRST): RESET
// 8 (VSSA): GND
// 9 (VDDA): +3.3VA
//10 (PA0):   EF1  (  - )
//11 (PA1):   EF2  (  - )
//12 (PA2/USART2 TX):  OWPO  1-Wire 
//13 (PA3/USART2 RX):  OWPI  1-Wire 
//14 (PA4/DAC1 + DMA CH2 + TIM3):   SET_I
//15 (PA5/DAC2 + DMA CH3 + TIM3):   SET_V
//16 (PA6/ADC6 + DMA CH5 + TIM2):   GET_I
//17 (PA7/ADC7 + DMA CH7 + TIM2):   GET_V
//18 (PB0):     CC/CV
//19 (PB1):     ON (  - )
//20 (PB2/BOOT1): GND
//21 (PB10):    BT_OUT (  - )
//22 (PB11):    BT_FINE (  - )
//23 (VSS):  GND
//24 (VDD):  +3.3V
//25 (PB12):    BT_SET_I (  - )
//26 (PB13/TIM1 CH1N):   SND (  - )
//27 (PB14/TIM15 CH1):    FAN (  - )
//28 (PB15):    BT_SET_V (  - )
//29 (PA8):   SB (  - )
//30 (PA9/USART1 TXD):   TXD
//31 (PA10/USART1 RXD):   RXD
//32 (PA11):  
//33 (PA12):   PVG (  - )
//34 (PA13/SWDIO): SWDIO
//35 (VSS):  GND
//36 (VDD):  +3.3V
//37 (PA14/SWCL): SWCL
//38 (PA15):  
//39 (PB3/SPI1 SCK):  SCLK  SPI  
//40 (PB4):   
//41 (PB5/SPI1 MOSI):  SDATA  SPI  
//42 (PB6):   LOAD   (  - )
//43 (PB7):   OE   (  - )
//44 (BOOT0): BOOT0
//45 (PB8 + TIM16):  SCL  I2C  EEPROM 24C04
//46 (PB9 + TIM16):  SDA  I2C  EEPROM 24C04
//47 (VSS):  GND
//48 (VDD):  +3.3V

//----------------------------------------------------------------------------

//   Linker->Extra options: --basic_heap

//-------------------------   firmware: ---------------------------

#define DEVICE_NAME "PSL-3604" // 
#define VERSION     2.00       // 

//--------------------------- : ------------------------------

#define LO(x)    ((uint8_t)((x) & 0xFF))
#define HI(x)    ((uint8_t)(((x) >> 8) & 0xFF))
#define BYTE1(x) (LO(x))
#define BYTE2(x) (HI(x))
#define BYTE3(x) ((uint8_t)(((uint32_t)(x) >> 16) & 0xFF))
#define BYTE4(x) ((uint8_t)(((uint32_t)(x) >> 24) & 0xFF))

#define WORD(b1,b0)        (((uint16_t)(b1) << 8) | (b0))
#define DWORD(b3,b2,b1,b0) (((uint32_t)WORD(b3,b2) << 16) | WORD(b1,b0))

#define ABS(x) ((x < 0)? -x : x)

#ifndef NULL
  #define NULL _NULL
#endif

//----------------------------------------------------------------------------

#endif
