/*
 * nanit.c
 *
 * Created: 2014
 * Author: MadOrc
 * 
 *  2.1 
 */ 

#define F_CPU 8000000UL

#define SI19 33
#define SBM20 34
#define SBM21 35
#define SBM10 36
#define SBM21_2 37 // 2  -21


//   ! SI19  SBM20  SBM21  SBM10
#define COUNTER SBM10

//   -    ,   -  3 
#define LI_ION

//  ,        ,  ,   
//#define DOSE

//  ,     
//#define MIRR

const unsigned char alarm_snooze_time=5; //   ,           

const unsigned char impulse_threshold=10; //   "  ", ..   1    ,    +impulse_threshold  X-impulse_threshold -   

#ifdef LI_ION
const unsigned int batt_warn=280; //   " "   
#else
const unsigned char batt_warn=245; //   " "
#endif



#include <avr/io.h>
//#include <stdio.h>
#include <util/delay.h>          //  
#include <avr/interrupt.h>
#include "nokia1100_lcd_lib.h"
#include <avr/eeprom.h>


#define BEEP_1_ON     PORTC |= (1<<PORTC2)
#define BEEP_1_OFF  PORTC &= ~(1<<PORTC2)
#define BEEP_2_ON     PORTC |= (1<<PORTC3)
#define BEEP_2_OFF  PORTC &= ~(1<<PORTC3)

const uint32_t  pow10Table32[]=
{
	1000000000ul,
	100000000ul,
	10000000ul,
	1000000ul,
	100000ul,
	10000ul,
	1000ul,
	100ul,
	10ul,
	1ul
};


#ifndef EEMEM
#define EEMEM__attribute__ ((section (".eeprom")))
#endif


volatile unsigned char hv_status, batt=0, count_flag=0;
char txt[7];
unsigned char awaken=30, light=30, go_to_bed=0, out_of_bed=0, alarm_snooze=0, alarm_beep=0, fonerr=0, displaying_dose=0, go_shutdown=0, do_shutdown=0, recount=0; // alarm=0, 
unsigned char second=0, minute=0, hour=12, battery_percent, redraw_LCD=0, blink_status=0, piip=0, scr=0, key=0, punkt=1;
volatile unsigned int pumpbreak;
unsigned char rad_counted=0, idle_pump=0;

#if (COUNTER == SBM21)
unsigned int sbm[142]; //  . 
unsigned int sbm_count_time=420, count_validate=420;
#elif (COUNTER == SBM21_2)
unsigned int sbm[110]; //  .
unsigned char sbm_count_time=216, count_validate=216;
#elif (COUNTER == SI19)
unsigned int sbm[50]; //  . 
unsigned char sbm_count_time=64, count_validate=64;
#elif (COUNTER == SBM20)
unsigned int sbm[50]; //  .
unsigned char sbm_count_time=44, count_validate=44;
#elif (COUNTER == SBM10)
unsigned int sbm[112]; //  . 
unsigned char sbm_count_time=220, count_validate=220;
#else
#error ***    /GM tube type not defined ***
#endif

unsigned long fon=0, rad=0;
unsigned long fon_daily=0, fonall=0, fonsecond=0, div_graph_sbm=1, radmax=0;
unsigned int beep_counter=0, beep_length, days=0;
volatile unsigned int VL;
unsigned int VoltLevel;

unsigned char light_level=30, sleep_level=60, beep_level=1, ion=109, inverse_level=0, contrast_level=0x99, impulse=2; // mirror=1, 
unsigned int alarm_level=100;

unsigned char EEMEM e_light_level=30, e_sleep_level=60, e_beep_level=1, e_ion=109, e_inverse_level=0, e_contrast_level=0x99, e_impulse=2; // e_mirror=1, 
unsigned int EEMEM e_alarm_level=100;

//////////////////////
void PinsOn();
void PinsOff();
void CheckKey();
void Draw_Screen();
void Count_Rad();
void Beep(unsigned char tone, unsigned char duration);
static void Pump();
void CheckBatt();

//   *buffer    valu (  10 ), number_size -     (1-10), leading_zero: 0 -   , 1 -  
// unsigned char *int_to_str(char *buffer, uint32_t valu, unsigned char number_size, unsigned char leading_zero);

void(* resetMC) (void) = 0; // Reset MC 
//////////////////////

ISR (ADC_vect) // 
{
	VL += (int)((ion*255)/(int)(ADCH-1)); // 1.1       ADC_VALUE = V_BG * 255/Vcc)
}

ISR(INT0_vect) // 1
	{
	SMCR &=~ (1 << SE); //  
		if (do_shutdown)
		{
			do_shutdown=0;
			resetMC();
		}
	if (sleep_level) awaken=sleep_level+1; else awaken=61;
	if (light_level) light=light_level+1; else light=61;
	//if ((scr==1)||(scr==2)) scr=0; //     -   
	out_of_bed=1;
	key=5; //  ,     ,    
	}		

ISR(INT1_vect) //    0
	{
		 PORTB &= ~(1<<PORTB0); // ...
sbm[0]++;
//sbcnt++;
//blink_g=1;
//if (sbm[0] > 40) Pump(); //        , .   (80 /)
//else
//_delay_us(10); //  -10 64 ,     2 , 8 -     ,   ,   ,    40 

//if (!alarm) 
piip=1;

	}


ISR(TIMER2_OVF_vect)	//     2
{                       
		PORTB &= ~(1<<PORTB0); // ...

TCNT2 = 0xE0; // 

second++;				//  

if (awaken==1) go_to_bed=1; // !
if (light==1) {PORTC &=~ (1<<PORTC1); }//  
	
if ((awaken)&&(sleep_level)) awaken--; //   
if ((light)&&(light_level)) light--; //    


if (count_validate>0) count_validate--;
if (sbm_count_time-count_validate > 3) //  ,        ,      1
{
	if ((sbm[1]>sbm[3])&&((sbm[1]-sbm[3])>impulse_threshold)) count_validate=sbm_count_time;
	if ((sbm[1]<sbm[3])&&((sbm[3]-sbm[1])>impulse_threshold)) count_validate=sbm_count_time;
}



#if (COUNTER == SBM21)     // 3!! 
if (!count_flag) // 0
{
div_graph_sbm=1;
		for(unsigned char i=139;i>0;i--) // k -     [49]!
		{
			sbm[i]=sbm[i-1];
			if ((sbm[i]>div_graph_sbm)&&(i<49)) div_graph_sbm=sbm[i]; //  .
		}
		sbm[0]=0;
	}
	if (count_flag<2) count_flag++; else count_flag=0;
#elif (COUNTER == SBM21_2) // 2!! 
if (count_flag)
{
	div_graph_sbm=1;
	for(unsigned char i=107;i>0;i--) // k -     [49]!
	{
		sbm[i]=sbm[i-1];
		if ((sbm[i]>div_graph_sbm)&&(i<49)) div_graph_sbm=sbm[i]; //  .
	}
	sbm[0]=0;
}
if (count_flag) count_flag=0; else count_flag=1;
#elif (COUNTER == SI19) // 2 
if (count_flag)
{
	div_graph_sbm=1;
	for(unsigned char i=50;i>0;i--) // k -     [49]!
	{
		sbm[i]=sbm[i-1];
		if ((sbm[i]>div_graph_sbm)&&(i<49)) div_graph_sbm=sbm[i]; //  .
	}
	sbm[0]=0;
}
if (count_flag) count_flag=0; else count_flag=1;
#elif (COUNTER == SBM10)   // 2 
if (count_flag)
{
	div_graph_sbm=1;
	for(unsigned char i=109;i>0;i--) // k -     [49]!
	{
		sbm[i]=sbm[i-1];
		if ((sbm[i]>div_graph_sbm)&&(i<49)) div_graph_sbm=sbm[i]; //  .
	}
	sbm[0]=0;
}
if (count_flag) count_flag=0; else count_flag=1;
#elif (COUNTER == SBM20) // 1!!! 
//	if (count_flag)
//	{
div_graph_sbm=1;
for(unsigned char i=50;i>0;i--) // k -     [49]!
{
	sbm[i]=sbm[i-1];
	if ((sbm[i]>div_graph_sbm)&&(i<49)) div_graph_sbm=sbm[i]; //  .
}
sbm[0]=0;
//	}
//	if (count_flag) count_flag=0; else count_flag=1;
#else
#error ***    /GM tube type not defined ***
#endif

//		if ((count_validate*100/sbm_count_time)==0) //  ,    
//		{
// if (rad>radmax) radmax=rad;
if ((rad>radmax)&&(!count_validate)) radmax=rad; //  -  .
//			if ((rad<radmin)||(radmin==0)) radmin=rad;
//		}		
fonsecond += rad; // 
fon_daily=(fon_daily+fonsecond)/3600;
if(second == 60)        //  second = 60, second = 0
{  // second
   second = 0;
   minute++;            //  
   if (alarm_snooze) alarm_snooze--;
   if (!rad) fonerr++;
   if ((fonerr>10)&&(!alarm_snooze)) { nlcd_Clear(); scr=5; alarm_beep=2; fonerr=0;} //  ,   
//   if ((pumpbreak>300)&&(!alarm_snooze)) { nlcd_Clear(); Beep(150, 254); scr=6;} //  ,    ""      
   batt=1;
  // fon_daily=(fon_daily+fonsecond)/3600;

if(minute == 60)        //  minute = 60, minute = 0
{  // minute
   minute = 0;
   hour++;              //  
   //fon_daily+=fonsecond;
   //fonsecond=0;

if(hour == 24)          //  hour = 24, hour = 0
{ // hour
	hour = 0;
	days++;
	fonall+=fon_daily;
	fonsecond=0;
	fon_daily=0;
	radmax=0;
} // hour

} // minute


} //second



if (second%2==0) Pump();
// else if (sbm[0] > 5) Pump(); //        , .  
//p_imp=0;
//TIMSK1 |= (1 << OCIE1A);
//OCR1A=4;

//if (second%2 == 0) pump_ok=0;
redraw_LCD=1;
recount=1;
}

ISR(TIMER0_COMPA_vect)
{ //sound

	if (blink_status) 
	{
	BEEP_2_OFF;
	BEEP_1_ON;
	blink_status=0;
	}
	else
	{
	BEEP_1_OFF;
	BEEP_2_ON;
	blink_status=1;
	}

if (beep_counter++>beep_length)	// 
	{ 
	TIMSK0 &=~ (1 << OCIE0A); 
	PORTC &= ~ (1<<PORTC2); 
	PORTC &= ~ (1<<PORTC3); 
	beep_counter=0; 
	if (alarm_beep==2)	{alarm_beep=0; Beep(20, 254);}
	}

}

/*
ISR(TIMER1_COMPA_vect)
{ //PUMP
if (!pump_ok) { PORTB |= (1<<PORTB1); _delay_us(6); PORTB &=~ (1<<PORTB1); }
}
*/
//  Stop

char *int_to_str(char *buffer, uint32_t valu, unsigned char number_size, unsigned char leading_zero)
{
	char *ptr = buffer;
//_delay_us(5);
	uint8_t i = (10-number_size);
	do
	{
		uint32_t pow10 = pow10Table32[i++];
		uint8_t count = 0;
		while(valu >= pow10)
		{
			count ++;
			valu -= pow10;
		}
		*ptr++ = count + '0';
	}while(i < 10);
	*ptr = 0;
	//   
if (!leading_zero) 
	{
	while(buffer[0] == '0') { if (buffer[1]) buffer[0] = ' '; ++buffer; }
	}
	else
	{
	while(buffer[0] == '0') ++buffer;	
	}
	return buffer;
}

void Beep(unsigned char tone, unsigned char duration)
{
if (beep_counter) return;
// #warning "testpoint"

beep_counter=0;
beep_length=duration*10;
OCR0A=tone;
TIMSK0 |= (1 << OCIE0A);
}

static void Pump()
{
unsigned int pumpa;

if (impulse>11) impulse=11;
if (impulse<1) impulse=1;

	pumpbreak=0;
// pumpa

// impulse=7;
pumpa=0;
do
{
pumpbreak++;
PORTB |= (1<<PORTB0);
for (unsigned char r=0; r<impulse; r++) asm("nop");
PORTB &= ~(1<<PORTB0);

TCNT1=0;
_delay_us(34);
hv_status=TCNT1;

if (hv_status) { PORTB &= ~(1<<PORTB0); pumpa=800; } //  //7
}
while (pumpa++<800);

PORTB &= ~(1<<PORTB0);
///pumpa 
}


void Count_Rad()
{
volatile unsigned long fon=0;

#if (COUNTER == SBM21)
const unsigned int counter_base=1400; //   / 3 * 10
//    SBM[] 3()  !!!
for (unsigned char i=1; i<141;i++)
{
	fon+=sbm[i];

	switch(i) // 
	{
		case 5:
		if(fon>1800) //   46800 /   15 
		{
			fon*=28;
			if (sbm_count_time!=15) count_validate=15;
			sbm_count_time=15;
			i=142; //  ,  
		}
		break;
		case 28:
		if(fon>200) //    1000 /   84 
		{
			fon*=5;
			if (sbm_count_time!=84) count_validate=84;
			sbm_count_time=84;
			i=142; //  ,  
		}
		break;
		case 140:
		if(fon>0) // : 420 
		{
			if (sbm_count_time!=420) count_validate=420;
			sbm_count_time=420;
			i=142; //  ,  
		}
		break;
		
	}
}
#elif (COUNTER == SBM21_2)
const unsigned int counter_base=1080; //   /2 * 10
//    SBM[] 2() !!!
for (unsigned char i=1; i<109;i++)
{
	fon+=sbm[i];

	switch(i) // 
	{
		case 12:
		if(fon>1800) //  16 200 /   24 
		{
			fon*=9; //
			if (sbm_count_time!=24) count_validate=24;
			sbm_count_time=24;
			i=110; //  ,  
		}
		break;
		case 18:
		if(fon>200) //   1200 /    36 
		{
			fon*=6;
			if (sbm_count_time!=36) count_validate=36;
			sbm_count_time=36;
			i=110; //  ,  
		}
		break;
		case 54:
		if(fon>100)//   200 /    108 
		{
			fon*=2;
			if (sbm_count_time!=108) count_validate=108;
			sbm_count_time=108;
			i=110; //  ,  
		}
		break;
		case 108:
		if(fon>0) //  216 
		{
			if (sbm_count_time!=216) count_validate=216;
			sbm_count_time=216;
			i=110; //  ,  
		}
		break;
		
	}
}
#elif (COUNTER == SI19)
const unsigned int counter_base=320; //   /2 * 10
//    SBM[] 2() 
for (unsigned char i=1; i<33;i++)
{
	fon+=sbm[i];

	switch(i) // 
	{
		case 2:
		if(fon>700) //   14000 /   4 
		{
			fon*=20;
			if (sbm_count_time!=4) count_validate=4;
			sbm_count_time=4;
			i=34; //  ,  
		}
		break;
		case 8:
		if(fon>300) //   1200 /   16 
		{
			fon*=4;
			if (sbm_count_time!=16) count_validate=16;
			sbm_count_time=16;
			i=34; //  ,  
		}
		break;
		case 16:
		if(fon>50) //   100 /   32 
		{
			fon*=2;
			if (sbm_count_time!=32) count_validate=32;
			sbm_count_time=32;
			i=34; //  ,  
		}
		break;
		case 32:
		if(fon>0) //  64 
		{
			if (sbm_count_time!=64) count_validate=64;
			sbm_count_time=64;
			i=34; //  ,  
		}
		break;
		
	}
}
#elif (COUNTER == SBM20)
const unsigned int counter_base=440; //   /2 * 10
// -20      () 20 - 44 
//    SBM[] 2() 
for (unsigned char i=1; i<45;i++)
{
	fon+=sbm[i];

	switch(i) // 
	{
		case 6:
		if(fon>2000)//   5500 .   4 
		{
			fon*=11;
			if (sbm_count_time!=6) count_validate=6;
			sbm_count_time=6;
			i=46; //  ,  
		}
		break;
		case 22:
		if(fon>100) //    100 .   22 
		{
			fon*=2;
			if (sbm_count_time!=22) count_validate=22;
			sbm_count_time=22;
			i=46; //  ,  
		}
		break;
		case 44:
		if(fon>0) //  44 
		{
			if (sbm_count_time!=44) count_validate=44;
			sbm_count_time=44;
			i=46; //  ,  
		}
		break;
	}
}
#elif (COUNTER == SBM10)
const unsigned int counter_base=1100; //   / 2 * 10
// -10      -      () 10 - 220 [78(    -20)/12(  -10)*34(  20  - )]
//               

//    SBM[] 2()  220
for (unsigned char i=1; i<111;i++)
{
	fon+=sbm[i];

	switch(i) // 
	{
		case 10:
		if(fon>18181) //   200 000 /   20 
		{
			fon*=11; //
			if (sbm_count_time!=20) count_validate=20;
			sbm_count_time=20;
			i=112; //  ,  
		}
		break;
		case 28:
		if(fon>20000) //   80 000 /   55 
		{
			fon*=4;
			if (sbm_count_time!=55) count_validate=55;
			sbm_count_time=55;
			i=112; //  ,  
		}
		break;
		case 55:
		if(fon>250) //   500 /   110 
		{
			fon*=2;
			if (sbm_count_time!=110) count_validate=110;
			sbm_count_time=110;
			i=112; //  ,  
		}
		break;
		case 110:
		if(fon>0) // 
		{
			if (sbm_count_time!=220) count_validate=220;
			sbm_count_time=220;
			i=112; //  ,  
		}
		break;
		
	}
}
#else
#error ***    /GM tube type not defined ***
#endif

#if (COUNTER == SBM21)  // 3  !!!
if (count_validate && (sbm_count_time-count_validate>4)) //  0   ,    ,    - 
{
	unsigned char approx=(sbm_count_time-count_validate)/3;
	fon=0;
	for (unsigned char i=1; i<approx+3;i++)
	{
		fon = fon + sbm[i];
	}
	fon=fon*counter_base/approx; //   * 10 - 8  ,    ,    ,  "" 10 
	fon=fon/10; //   
}
#elif (COUNTER == SBM20)  // 1  !!!
if (count_validate && (sbm_count_time-count_validate>4)) //  0   ,    ,    - 
{
	unsigned char approx=(sbm_count_time-count_validate);
	fon=0;
	for (unsigned char i=1; i<approx+1;i++)
	{
		fon = fon + sbm[i];
	}
	fon=fon*counter_base/approx; //   * 10 - 8  ,    ,    ,  "" 10 
	fon=fon/10; //   
}
#else // 2 
if (count_validate && (sbm_count_time-count_validate>4)) //  0   ,    ,    - 
{
	unsigned char approx=(sbm_count_time-count_validate)/2;
	fon=0;
	for (unsigned char i=1; i<approx+2;i++)
	{
		fon = fon + sbm[i];
	}
	fon=fon*counter_base/approx; //   * 10 - 8  ,    ,    ,  "" 10 
	fon=fon/10; //   
}
#endif



rad=fon;

#ifdef DOSE
if ((fon_daily/1000>alarm_level)&&(!alarm_snooze)&&(alarm_level))
#else
if ((rad>alarm_level)&&(!alarm_snooze)&&(alarm_level)&&((!count_validate)||(sbm_count_time-count_validate>5)))
#endif
{
	if (!awaken) //   - ڨ!
	{
		SMCR &=~ (1 << SE); //  
			awaken=61;
			light=light_level+1;
		   	PinsOn();
		   	EIMSK &=~ (1 << INT0);
		   	PORTB &= ~(1<<PORTB0); // ...
		   	PORTC |= (1<<PORTC0); //   
		   	if (light_level!=2) PORTC |= (1<<PORTC1); //  
		   	//	scr=0;
		   	punkt=1;
		   	nlcd_Init(contrast_level);
		   	nlcd_Clear();
		   	nlcd_Inverse(inverse_level);
//			nlcd_mirror(mirror);
#ifdef MIRR
nlcd_SendByte(CMD_LCD_MODE,0xA0);
#else
nlcd_SendByte(CMD_LCD_MODE,0xA1);
#endif

	}
	alarm_beep=2; Beep(20, 254);
	if (scr!=3) nlcd_Clear();
		scr=3;
		redraw_LCD=1;
//	}
	//alarm=1;
}


}

void Draw_Graph()
{
	unsigned char a, val, line_lo, line_mid, line_hi;

/*
	nlcd_Print("(",0,0,0);
	nlcd_Print(")",66,0,0);

if ((count_validate)&&(second%2==0))
	nlcd_Print("    ",72,0,0);
	else
	{
		nlcd_Print("",90,0,0);
		int_to_str(txt, sbm_count_time, 3, 0);
		nlcd_Print(txt,72,0,0);
	}
	
	for (a=0; a < 60-(count_validate*60/sbm_count_time); a++)
	{
nlcd_GotoXY(5+a,0);

if (a%5)
{
nlcd_SendByte(DATA_LCD_MODE,0b00111110);
}
else
nlcd_SendByte(DATA_LCD_MODE,0b00000000);

	}
*/
//   ,  Shodan   ;)
unsigned char  a_cnt=1;

	for (a=1; a < 49; a++)
	{

line_lo=0xff;
line_mid=0xff;
line_hi=0xff;

val=(sbm[a]*22/div_graph_sbm);

val=22-val;

line_hi=line_hi<<(val+2);
if (val>8) line_mid=line_mid<<(val-8);
if (val>16) line_lo=line_lo<<(val-16);

/*
if(val<9)
{
	if(val==0) line_lo=line_lo<<8;
	else line_lo=line_lo<<(8-val);

line_hi=0b00000000;
line_mid=0b00000000;
}
else if (val<17)
{
	line_mid=line_mid<<(8-(val-8));
line_lo=0b11111111;
line_hi=0b00000000;
}
else
{
	line_hi=line_hi<<(16-(val-7));
	line_lo=0b11111111;
	line_mid=0b11111111;
}
*/

line_lo&=0x7f; //   

nlcd_GotoXY(a_cnt,6);
nlcd_SendByte(DATA_LCD_MODE,line_lo);

nlcd_GotoXY(a_cnt,5);
nlcd_SendByte(DATA_LCD_MODE,line_mid);

nlcd_GotoXY(a_cnt,4);
nlcd_SendByte(DATA_LCD_MODE,line_hi);

a_cnt++;
nlcd_GotoXY(a_cnt,6);
nlcd_SendByte(DATA_LCD_MODE,line_lo);

nlcd_GotoXY(a_cnt,5);
nlcd_SendByte(DATA_LCD_MODE,line_mid);

nlcd_GotoXY(a_cnt,4);
nlcd_SendByte(DATA_LCD_MODE,line_hi);

a_cnt++;

/*
switch(val)
		{
			  case 0: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01000000);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b00000000); break;
			  case 1: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01100000);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b00000000); break;
			  case 2: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01110000);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b00000000); break;
			  case 3: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111000);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b00000000); break;
			  case 4: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111100);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b00000000); break;
			  case 5: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111110);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b00000000); break;
			  case 6: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b00000000); break;
			  case 7: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b10000000); break;
			  case 8: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b11000000); break;
			  case 9: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b11100000); break;
			 case 10: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b11110000); break;
			 case 11: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b11111000); break;
			 case 12: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b11111100); break;
			 case 13: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b11111110); break;
			 default: 	nlcd_GotoXY(0,5); nlcd_SendByte(DATA_LCD_MODE,0b01111111);  nlcd_GotoXY(0,4); nlcd_SendByte(DATA_LCD_MODE,0b11111111); break;
		}
*/

	}

}
void Draw_Screen()
{
	switch(scr)
	{
		case 0: // 
		default:
		

nlcd_Print("",74,2,0);
		// nlcd_Print(".",27,2,0);
/////if (((count_validate*100/sbm_count_time)>0)&&(second%2==0)) 
/////{ 
/////	nlcd_PrintBig("     ",5,1); 
			/*
			// 	nlcd_PrintBig("     ",1,1);
			// 	nlcd_PrintBig("     ",31,1); 
			// 	nlcd_PrintBig("     ",44,1);
			*/
/////} 
/////else 
/////{ 
	if (rad<99999) 
	{ 
	int_to_str(txt, rad, 5, 0);
	nlcd_Print("",74,1,0);
			/*	int_to_str(txt, (rad/100), 2, 0);
			nlcd_PrintBig(txt,1,1);
			int_to_str(txt, ((rad%100)/10), 1, 1);
			nlcd_PrintBig(txt,31,1);
			int_to_str(txt, (rad%10), 1, 1);
			nlcd_PrintBig(txt,44,1);
			nlcd_Print("/",58,2,0);*/
			} 
			else 
			{ 
			/*	rad=rad/1000;
			int_to_str(txt, (rad/100), 2, 0);
			nlcd_PrintBig(txt,1,1);
			int_to_str(txt, ((rad%100)/10), 1, 1);
			nlcd_PrintBig(txt,31,1);
			int_to_str(txt, (rad%10), 1, 1);
			nlcd_PrintBig(txt,44,1);
			nlcd_Print("/",64,2,0);	*/
	int_to_str(txt, (rad/1000), 5, 0);
	nlcd_Print(" ",74,1,0); 
	}
nlcd_PrintBig(txt,5,1);	
/////}



nlcd_Print("(000/000.)",28,3,0);
if ((count_validate)&&(second%2==0))
{
nlcd_Print("",4,3,1);
}
else
{
nlcd_Print("",4,3,0);
}
//nlcd_Print("(000/000.000%)",4,3,0);
int_to_str(txt, sbm_count_time-count_validate, 3, 0);
nlcd_Print(txt,34,3,0);

int_to_str(txt, sbm_count_time, 3, 0);
nlcd_Print(txt,58,3,0);

//int_to_str(txt, 100-(count_validate*100/sbm_count_time), 3, 0);
//nlcd_Print(txt,64,3,0);


switch (displaying_dose)
		{ //dd
case 0:
/*
int_to_str(txt, hour, 2, 0);
nlcd_Print(txt,4,7,0);
nlcd_Print(":  :     ",17,7,0);
int_to_str(txt, minute, 2, 1);
nlcd_Print(txt,22,7,0);
int_to_str(txt, second, 2, 1);
nlcd_Print(txt,40,7,0);
*/
nlcd_Print("00:00:00  ",4,7,0);
int_to_str(txt, hour, 2, 1);
nlcd_Print(txt,4,7,0);
int_to_str(txt, minute, 2, 1);
nlcd_Print(txt,22,7,0);
int_to_str(txt, second, 2, 1);
nlcd_Print(txt,40,7,0);


nlcd_Print("#100%$",59,7,0);
int_to_str(txt, battery_percent, 3, 1);
nlcd_Print(txt,65,7,0);
//			else sprintf(txt, "#%1u.%1u$", VoltLevel/100, ((VoltLevel%100)/10));
break;
case 1:
nlcd_Print(" ",4,7,0);
if (fon_daily<9999)
{
	nlcd_Print("0000",52,7,0);
	int_to_str(txt, fon_daily, 4, 0);
	nlcd_Print(txt,52,7,0);
}
else
{
	nlcd_Print("0000 ",52,7,0);
	int_to_str(txt, fon_daily/1000, 4, 0);
	nlcd_Print(txt,52,7,0);
}
break;			
case 2:
default:
if ((fonall+fon_daily)<9999)
{
	nlcd_Print(" 000.0000", 4,7,0);
	int_to_str(txt, days, 3, 0);
	nlcd_Print(txt,21,7,0);
	int_to_str(txt, fonall, 4, 0);
	nlcd_Print(txt,52,7,0);
}
else
{
	nlcd_Print(" 000.0000 ", 4,7,0);
	int_to_str(txt, days, 3, 0);
	nlcd_Print(txt,21,7,0);
	int_to_str(txt, fonall/1000, 4, 0);
	nlcd_Print(txt,52,7,0);
}
break;

case 3:
	nlcd_Print(".  ",4,7,0);
if (radmax<999)
{
	nlcd_Print("000/",46,7,0);
	int_to_str(txt, radmax, 3, 0);
	nlcd_Print(txt,46,7,0);
}
else
{
	nlcd_Print("000 /",46,7,0);
	int_to_str(txt, radmax/1000, 3, 0);
	nlcd_Print(txt,46,7,0);
}
break;
/*
case 3:
	nlcd_Print(".   ",4,6,0);
if (radmin<999)
{
	nlcd_Print("000/",46,6,0);
	int_to_str(txt, radmin, 3, 0);
	nlcd_Print(txt,46,6,0);
}
else
{
	nlcd_Print("000 /",46,6,0);
	int_to_str(txt, radmin/1000, 3, 0);
	nlcd_Print(txt,46,6,0);
}
break;
*/
		} // dd
	
		break;  


		case 1: //  

nlcd_Print("(  )",20,0,1); 

if (alarm_level) 
	{
		#ifdef DOSE
		nlcd_Print("   00 ",4,1,(punkt==1));
		int_to_str(txt, alarm_level, 4, 0);
		nlcd_Print(txt,46,1,(punkt==1));
		#else
		nlcd_Print(".0000/",4,1,(punkt==1)); 
		int_to_str(txt, alarm_level, 4, 0);
		nlcd_Print(txt,34,1,(punkt==1));
		#endif
		
		
	}
	else 
	{
	nlcd_Print(" . ",4,1,(punkt==1)); 	
	}
	

if (light_level==2)
{
	nlcd_Print(". .",4,2,(punkt==2));
}

else if (light_level)
{
	nlcd_Print(". 000.",4,2,(punkt==2));
	int_to_str(txt, light_level, 3, 0);
	nlcd_Print(txt,46,2,(punkt==2));
}
else 
{
	nlcd_Print(".  .",4,2,(punkt==2));
}
	

if (sleep_level) 
		{
			nlcd_Print(" 000.",4,3,(punkt==3));
			int_to_str(txt, sleep_level, 3, 0);
			nlcd_Print(txt,28,3,(punkt==3));
		}
		else
		    nlcd_Print(" .",4,3,(punkt==3));




if (beep_level) 
	nlcd_Print(" ",4,4,(punkt==4));
	else 
	nlcd_Print(" ",4,4,(punkt==4));


	nlcd_Print(" &&&&",4,5,(punkt==5));


	nlcd_Print(" !",4,6,(punkt==6));
	

	nlcd_Print("     ",4,7,(punkt==7));
	

		break;
		case 2: // 
nlcd_Print("  ",10,0,1);
/*		
if (hv_status>2) nlcd_Print(":     (0)",0,0,1);
else if (hv_status>0) nlcd_Print(":.  (0)",0,0,1);
else nlcd_Print(":    (0)",0,0,1);
*/
//int_to_str(txt, hv_status, 1, 1);
//nlcd_Print(txt,84,0,1);

nlcd_Print(".:(000)",0,1,0);
int_to_str(txt, pumpbreak, 3, 0);
nlcd_Print(txt,72,1,0);

//if (mirror)
//nlcd_Print("      ",4,2,(punkt==1));
//else
//nlcd_Print("   ",4,2,(punkt==1));


nlcd_Print(": 00:00:00", 4,3,0);
int_to_str(txt, hour, 2, 0);
nlcd_Print(txt,40,3,(punkt==2));


int_to_str(txt, minute, 2, 1);
nlcd_Print(txt,58,3,(punkt==3));


int_to_str(txt, second, 2, 1);
nlcd_Print(txt,76,3,0);


//if (inverse_level)
nlcd_Print("      ",4,4,(punkt==4));
//else
//nlcd_Print("   ",4,4,(punkt==4));


nlcd_Print(": 000 ",4,5,(punkt==5));
int_to_str(txt, (16-(contrast_level-144)), 3, 0);
nlcd_Print(txt,64,5,(punkt==5));

nlcd_Print(" 000: 0.00",4,6,(punkt==6));

int_to_str(txt, ion, 3, 0);
nlcd_Print(txt,28,6,(punkt==6));

int_to_str(txt, (char)((VoltLevel%1000)/100), 1, 0);
nlcd_Print(txt,58,6,(punkt==6));

int_to_str(txt, (char)((VoltLevel%100)/10), 1, 0);
nlcd_Print(txt,70,6,(punkt==6));

int_to_str(txt, (char)(VoltLevel%10), 1, 0);
nlcd_Print(txt,76,6,(punkt==6));

nlcd_Print("(2):00 ",4,7,(punkt==7));
int_to_str(txt, impulse, 2, 0);
nlcd_Print(txt,70,7,(punkt==7));


	
		break;
		case 3:
	#ifdef DOSE
		nlcd_Print("!",20,2,0);
		nlcd_Print(" ",4,4,0);
		nlcd_Print("000000 !",9,5,0);
		int_to_str(txt, alarm_level, 6, 0);
		nlcd_Print(txt, 9, 5, 0);
		break;
	#else
		nlcd_Print("!",20,2,0);
		nlcd_Print(" ",4,4,0);
		nlcd_Print("000000 /!",9,5,0);
		int_to_str(txt, alarm_level, 6, 0);
		nlcd_Print(txt, 9, 5, 0);
	#endif	

/*
		nlcd_Print(" :",4,4,0);
		if (rad<999999)
		{
			nlcd_Print("000000 /!",9,5,0);
			int_to_str(txt, rad, 6, 0);
			nlcd_Print(txt, 9, 5, 0);
		}
		else
		{
			nlcd_Print("000000 /!",9,5,0);
			int_to_str(txt, rad/1000, 6, 0);
			nlcd_Print(txt, 9, 5, 0);
		}
*/		
		break; 
		case 4:
#ifdef LI_ION
		nlcd_Print("",20,3,0);
		nlcd_Print("!",30,4,0);
#else
		nlcd_Print("",20,3,0);
		nlcd_Print("!",24,4,0);
#endif
		break;
		case 5:
		nlcd_Print(" ",8,3,0);
		nlcd_Print(" !",8,4,0);
		break;

/*		case 6:
		//nlcd_Print("!",3,3,1);
		nlcd_Print(" ",10,3,0);
		nlcd_Print("  300!",30,4,0);
		break;
*/

		case 10:
//		nlcd_Print("/",3,1,0);
		nlcd_Print("",25,2,0);
		nlcd_Print("",35,4,0);
//		nlcd_Print("MadOrc@gmx.com  ",3,5,0);
		nlcd_Print(" 2.0",15,6,0);
		
#if (COUNTER == SBM21)
		nlcd_Print(" -21",11,7,0);
#elif (COUNTER == SBM21_4)
		nlcd_Print("4  -21",1,7,0);
#elif (COUNTER == SI19)
		nlcd_Print(" -19",11,7,0);
#elif (COUNTER == SBM20)
		nlcd_Print(" -20",11,7,0);
#elif (COUNTER == SBM10)
		nlcd_Print(" -10",11,7,0);
#else
#error ***    /GM tube type not defined ***
#endif		

break;
	}
}
void CheckKey()
{
if (key) return; //    ,   

if((PIND&(1 << PORTD2))==0 )//   1 
{
			  key=1;
			  
Beep(22, 20);
}
else if((PIND&(1 << PORTD1))==0)//   2 
{
			  key=2;
Beep(18, 20);
}
	
}


void ReactKey()
{
	if (sleep_level) awaken=sleep_level+1; else awaken=61; 

	if (light_level) light=light_level+1; else light=61;
	if (light_level!=2) PORTC |= (1<<PORTC1); //  
	
	switch (scr)
	{
		case 0: //   
			switch(key)
				{
					case 1:
					//   ,  
					displaying_dose++;
					if (displaying_dose>3) displaying_dose=0; 
					break;
					case 2: //  
					scr=1;
					nlcd_Clear();
					redraw_LCD=1;
					break;

				}
		break;

		case 1: //   
			switch(key)
				{
					case 1:
					//   
							switch (punkt)
							 {
								 case 1: //
										switch (alarm_level)
											{
										#ifdef DOSE
											case 0:
											alarm_level=50;
											break;
											case 50:
											alarm_level=100;
											break;
											case 100:
											alarm_level=200;
											break;
											case 200:
											alarm_level=300;
											break;
											case 300:
											alarm_level=500;
											break;
											case 500:
											alarm_level=1000;
											break;
										#else
											case 0:
											alarm_level=40;
											break;
											case 40:
											alarm_level=80;
											break;
											case 80:
											alarm_level=120;
											break;
											case 120:
											alarm_level=500;
											break;
											case 500:
											alarm_level=1000;
											break;
											case 1000:
											alarm_level=3000;
											break;
										#endif
											default: //  3000     -> 0
											alarm_level=0;
											break;
											}
								 break;
								 case 2: //
										switch (light_level)
											{
											case 0:
											light_level=2;
											break;
											case 2:
											light_level=10;
											break;
											case 10:
											light_level=30;
											break;
											case 30:
											light_level=60;
											break;
											default:
											light_level=0;
											break;
											}											
								 break;
								 case 3: // 
										switch (sleep_level)
											{
											case 0:
											sleep_level=30;
											break;
											case 30:
											sleep_level=60;
											break;
											case 60:
											sleep_level=120;
											break;
											default:
											sleep_level=0;
											break;
											}											
								 break;
								 case 4: // 
											if (beep_level) beep_level=0; else beep_level=1;
								 break;
								 case 5: //  
									scr=2;
									punkt=1;
									nlcd_Clear();
								 break;
								 case 6: // 
											//radmin=0;
											//radmax=0;
											fonsecond=0;
											fon_daily=0;
											fonall=0;
											days=0;
											punkt=1;
											scr=0;
											nlcd_Clear();
								 break;
								 case 7: //
								 go_shutdown=1;
								 break;
							 }
					break;
					case 2: //   
						if (punkt <7)	punkt++;
							else { // 
									cli();
									eeprom_update_byte(&e_light_level, light_level);
									eeprom_update_byte(&e_beep_level, beep_level);
									eeprom_update_byte(&e_sleep_level, sleep_level);
									eeprom_update_word(&e_alarm_level, alarm_level);
									sei();
									scr=0;
									punkt=1;
									nlcd_Clear();
								 }
					break;
				}
					redraw_LCD=1;
		break;
		case 2: //   
		switch(key)
		{
			case 1:
							switch (punkt)
							{
//							 case 1: //  
//							 if (mirror) mirror=0; else mirror=1;
//							 nlcd_mirror(mirror);
//							 break;
							 case 2: //
							 if (hour<23) hour++; else hour=0;
							 second=0;
							 break;
							 case 3: //
							 if (minute<59) minute++; else minute=0;
							 second=0;
							 break;
							 case 4: //
							 if (inverse_level) inverse_level=0; else inverse_level=1;
							 nlcd_Inverse(inverse_level);
							 break;
							 case 5: //
							 if (contrast_level>0x90) contrast_level--; else contrast_level=0x9f;
							 nlcd_SendByte(CMD_LCD_MODE,contrast_level); //
							 second=0;
							 break;
							 case 6: // 
							 if ((ion<124)&&(ion>99)) ion++; else ion=100;
							 // CheckBatt();
							 batt=1;
							 break;
							 case 7: // 
							 if ((impulse<11)&&(impulse>0)) impulse++; else impulse=1;
							 break;
                             
							}
			break;
			case 2: //   
			if (punkt <7)	punkt++;
			else { // 
						cli();
									eeprom_update_byte(&e_ion, ion);
									eeprom_update_byte(&e_inverse_level, inverse_level);
									eeprom_update_byte(&e_contrast_level, contrast_level);
									eeprom_update_byte(&e_impulse, impulse);
//									eeprom_update_byte(&e_mirror, mirror);
						sei();
						scr=0;
						punkt=1;
						nlcd_Clear();
				}
			break;
		}
				redraw_LCD=1;
		break;

		
		case 3: // 
		case 4: // , 
		case 5: //  
		case 6: //    
					scr=0;
					nlcd_Clear();
					// alarm=0; 
					alarm_snooze=alarm_snooze_time; //       
					redraw_LCD=1;
		break;
	}
_delay_ms(400);
key=0;
}

void CheckBatt()
{
unsigned char MCUCR_status;
unsigned int VLcc;	


// * * ** **
ADCSRA |=	(1 << ADEN) // 
			|(0 << ADSC) //  
			|(1 << ADIE) //  
			|(1 << ADPS2)|(1 << ADPS1)|(0 << ADPS0); //   64 (  125kHz   8mHz)

ADMUX |= (0 << REFS1)|(1 << REFS0) //  AVCC
		|(1 << ADLAR) //     , ADCL  
		|(0 << MUX0)|(1 << MUX1)|(1 << MUX2)|(1 << MUX3); //   . 
		MCUCR_status=SMCR;
		SMCR = (1 << SE)|(1 << SM0)|(0 << SM1)|(0 << SM2); //     		
_delay_us(190); //    
ADCSRA |= (1 << ADSC);    // 
 asm("sleep"); //-
while (ADIF == 0){;} //   
//	  EIMSK &=~ (1 << INT1);
VL=0;
for (unsigned char z=0; z<64; z++) //
{
ADCSRA |= (1 << ADSC);    // 
 asm("sleep"); //-
while (ADIF == 0){;} //   
}
//	  EIMSK |= (1 << INT1);
ADCSRA &=~ (1 << ADEN)|(1 << ADIE); // 

		VoltLevel=(int)(VL>>6);
		VLcc=(int)VoltLevel;
		SMCR=MCUCR_status;

if ((VLcc<batt_warn)&&(!alarm_snooze)) { nlcd_Clear(); alarm_beep=2; scr=4; } //    ,    ""    

#ifdef LI_ION
if (VLcc<280) VLcc=280;
if (VLcc>420) VLcc=420;
battery_percent=(VLcc-280)*100/140;
#else
if (VLcc<245) VLcc=245;
if (VLcc>300) VLcc=300;
battery_percent=(VLcc-245)*100/55;
#endif
// batt_measured=1;

}

void PinsOn()
{
PRR = (0<<PRTIM0)|(0<<PRADC)|(0<<PRSPI);

		// 
		DDRC |=  (1 << DDC1);
		PORTC |= (0 << PORTC1);


		//  
		DDRC |=  (1 << DDC0);
		PORTC |= (0 << PORTC0);

		// 
		DDRC |=  (1 << DDC2)|(1 << DDC3);
		PORTC |= (0 << PORTC2)|(0 << PORTC3);
		
		//   
//		DDRB |= (0 << DDB1);
//		PORTB |= (1 << PORTB1);

	DDRD |=  (0 << DDD1);
	PORTD |= (1 << PORTD1);


// CheckBatt();
}

void PinsOff()
{
nlcd_SendByte(CMD_LCD_MODE,0xAE);

TIMSK0 &=~ (1 << OCIE0A);
while(ASSR&(1<<TCN2UB)); //   
while(!(SPSR & (1<<SPIF))); // ,   . SPI
SPCR = (0 << SPE);

while (ADIF == 0); //           
ADCSRA = (0 << ADEN); // 

  //TCCR0A = 0x00;
 // TCCR0B = 0x00;


//        TRI-Z    vcc/2    .
//PORTC = (0<<PORTC0); //vcc LCD
//PORTC = (0<<PORTC1); //vcc LED
//PORTC = (0 << PORTC2)|(0 << PORTC3); //buzzer OFF

//SPCR = 0;

		 // lcd
DDRB =  (0 << DDB2)|(0 << DDB3)|(0 << DDB4)|(0 << DDB5);
PORTB = (0 << PORTB2)|(0 << PORTB3)|(0 << PORTB4)|(0 << PORTB5);

//DDRB &=~  (1 << DDB2)|(1 << DDB3)|(1 << DDB4)|(1 << DDB5);
//PORTB &=~ (1 << PORTB2)|(1 << PORTB3)|(1 << PORTB4)|(1 << PORTB5);

		// 
PORTC = (0 << PORTC1);
DDRC = (0 << DDC1);


	//  
PORTC = (0 << PORTC0);
DDRC = (0 << DDC0);

	// 
	DDRC = (0 << DDC2)|(0 << DDC3);
	PORTC = (0 << PORTC2)|(0 << PORTC3);


	
//   
//DDRB =   (0 << DDB1);
//PORTB =   (0 << PORTB1);
//DDRD =  (0 << DDD1);
//PORTD = (0 << PORTD1);

beep_counter=0;


// 
	// 
	DDRB |=  (1 << DDB0);
	PORTB |= (0 << PORTB0);


	//  0
	DDRD |=  (0 << DDD3);
	PORTD |= (1 << PORTD3);

	//  1
	DDRD |=  (0 << DDD2);
	PORTD |= (1 << PORTD2);




SMCR = (1 << SM1)|(1 << SM0)|(1 << SE); //  
PRR |= (1 << PRADC)|(1 << PRSPI)|(1 << PRTIM0); //  , ,  
EIMSK |= (1 << INT0); // wake button
awaken=0;
}

int main(void)
{
//for (unsigned char f=0; f<237; f++) sbm[f]=0; //   
	// 
	DDRB |=  (1 << DDB0);
	PORTB |= (0 << PORTB0);
	
		// 
		DDRC |=  (1 << DDC2)|(1 << DDC3);
		PORTC &=~ (1 << PORTC2)|(1 << PORTC3);

//  0
DDRD |=  (0 << DDD3);
PORTD |= (1 << PORTD3);

// OC
//DDRD |=  (0 << DDD5);
//PORTD |= (1 << PORTD5);


	//  1
	DDRD |=  (0 << DDD2);
	PORTD |= (1 << PORTD2);
PinsOn();	

TCCR2B = 0x00;
ASSR|=(1<<AS2); // 

	TCNT2 = 0xE0; 						//presetup (-0x1F)
	OCR2A = 0x20;						// 32768/1024=32=0x20 for 1s.
	OCR2B = 0x00;
	TCCR2A = 0x00; 
	TCCR2B = 0x07; 						//start /1024
	TIMSK2 = 0x01; 						//timer2 ovf interrupt enable



  /* */
/*
  ACSR = (1<<ACD);
  ACSR = (1<<ACD)|(1<<ACBG)|(1<<ACI)|(1<<ACIE)|(1<<ACIS1)|(0<<ACIS0);
  ACSR &= ~(1<<ACD);
// ADCSRB |= (1<<ACME);
ADCSRB &=~ (1<<ADEN)|(1<<ACME);
ACSR &=~ (1<<ACD)|(1<<ACBG)|(1<<ACIE)|(1<<ACIC); //  ,  
ACSR |= (1<<ACIS1)|(1<<ACIS0); //   1,    

DIDR1 |= (1<<AIN1D)|(1<<AIN0D); //      
*/

//     FlyBack  T1   
TCCR1A = 0x00; 
TCCR1B |= (1<<CS12)|(1<<CS11);
TCCR1B &=~ (1<<CS10);

/*
TCCR1B = 0x00; 
TCCR1B |= (1<<ICES1);
*/
//TCCR1B |= (1<<ICES1);
//TIMSK1 |= (1<<ICIE1); //  

// PRR &=~ (1<<PRTIM1);
/*
TCCR1A |= (1<<WGM10)|(1<<COM1A0);
TCCR1A &= ~ (1<<WGM11)|(1<<COM1A1);
TCCR1B |= (1<<WGM13)|(1<<CS11);
TCCR1B &=~ (1<<CS12)|(1<<CS10)|(1<<WGM12);
OCR1A=3; //   
*/
// TCCR1A |= ;
//  TCCR1A |= (1<<WGM01);

/*
  TCCR1A = 0x00;
//  TCCR1A &= ~(1<<WGM10)|(1<<WGM11);
  TCCR1B |=  (1<<CS12)|(1<<CS10)|(1<<WGM12); // /8 = 1 mHz
  TCCR1B &=~ (1<<CS11)|(1<<WGM13);
  OCR1A=1;
  TCNT1=0;
TIMSK1 |= (1 << OCIE1A);
*/


///
PRR &=~ (1<<PRTIM0)|(1<<PRADC);
  TCCR0A |= (1<<WGM01);
 // TCCR0A &= ~(1<<WGM00);
  TCCR0B |= (1<<CS00) | (1<<CS01);
//  TCCR0B &=~ 1<<CS01;

OCR0A=195;
TCNT0=0;
  
  
PORTC |= (1<<PORTC0); //   

impulse=eeprom_read_byte(&e_impulse);
inverse_level=eeprom_read_byte(&e_inverse_level);
//mirror=eeprom_read_byte(&e_mirror);
light_level=eeprom_read_byte(&e_light_level);
beep_level=eeprom_read_byte(&e_beep_level);
ion=eeprom_read_byte(&e_ion);
sleep_level=eeprom_read_byte(&e_sleep_level);
contrast_level=eeprom_read_byte(&e_contrast_level);
alarm_level=eeprom_read_word(&e_alarm_level);


//CheckBatt();
batt=1;

	  EICRA = (0 << ISC00)|(0 << ISC01)| //   
			  (0 << ISC10)|(1 << ISC11); //   .        , ..  !!!


//			   (0 << ISC10)|(1 << ISC11); //   
//			   (1 << ISC10)|(1 << ISC11); //   

	  EIMSK |= (1 << INT1);

if (light_level!=2) PORTC |= (1<<PORTC1); //  


nlcd_Init(contrast_level);
nlcd_Clear();
nlcd_Inverse(inverse_level);
// nlcd_mirror(mirror);
#ifdef MIRR
nlcd_SendByte(CMD_LCD_MODE,0xA0);
#else
nlcd_SendByte(CMD_LCD_MODE,0xA1);
#endif

scr=10;
Draw_Screen();
scr=0;
_delay_ms(4000);
//if(((PINB&(1 << PORTB1))==0)||((PIND&(1 << PORTD1))==0)) scr=7;//   2  -  
nlcd_Clear();
/*
//    
unsigned char pumpsteps=0;
while ((hv_status<6)||(pumpsteps++<20)) Pump();
*/
sei();


    while(1)
    {
		
if (go_shutdown)
	{
	 go_shutdown=0;
	 //  .    .
	 EIMSK=0x01;  // wake button
	 TIMSK0=0x00;
	 TIMSK1=0x00;
	 TIMSK2=0x00;
	 PORTB=0x00;
	 PORTC=0x00;
	 PORTD=0x04;  //  wake button
	 DDRB=0x00;
	 DDRC=0x00;
	 DDRD=0x00;
	 SMCR = (1 << SE)|(0 << SM0)|(1 << SM1)|(0 << SM2); //  
	 PRR |= (1 << PRADC)|(1 << PRSPI)|(1 << PRTIM0); //  , ,  
	 // EIMSK |= (1 << INT0); 
	 do_shutdown=1;
	 asm("sleep");
	}
if (go_to_bed)	{go_to_bed=0; PinsOff();}
if (out_of_bed)
   {
	out_of_bed=0;
   	PinsOn();
	EIMSK &=~ (1 << INT0);
	PORTB &= ~(1<<PORTB0); // ...
	PORTC |= (1<<PORTC0); //   
if (light_level!=2) PORTC |= (1<<PORTC1); //  
//	scr=0;
	punkt=1;
nlcd_Init(contrast_level);
nlcd_Clear();
nlcd_Inverse(inverse_level);
// nlcd_mirror(mirror);
#ifdef MIRR
nlcd_SendByte(CMD_LCD_MODE,0xA0);
#else
nlcd_SendByte(CMD_LCD_MODE,0xA1);
#endif

redraw_LCD=1;
   }

if (!do_shutdown)
{ // POWER OFF		

if (recount)
{
recount=0;
Count_Rad();
}

if ((awaken)&&(redraw_LCD)) 
{
redraw_LCD=0;
Draw_Screen();
if (!scr) Draw_Graph();
}


if ((batt)&&(awaken)) {batt=0; CheckBatt();}


if (awaken) {CheckKey(); if (key) ReactKey();}
if ((piip)&&(awaken)&&(beep_level)) {piip=0; Beep(14, 65);	}
	
} // POWER OFF


if ((!awaken)||(do_shutdown)) asm("sleep");
    }
}