#ifndef EEPROM_H
#define EEPROM_H

#include <inttypes.h>

#define EEPROM_ALARM_HOUR			0x00
#define EEPROM_ALARM_MIN			0x01
#define EEPROM_ALARM_MON			0x02

#define EEPROM_HOURSIGNAL			0x09
#define EEPROM_SCREEN_ROTATE		0x0A
#define EEPROM_BIGNUM				0x0B
#define EEPROM_HOURZERO				0x0C
#define EEPROM_SCROLL_INTERVAL		0x0D

#define EEPROM_BR_MAX				0x0E
#define EEPROM_SENS_MASK			0x0F

/* Text labels (maximum 15 byte followed by \0) */
#define EEPROM_LABELS				0x10

/* Big numbers font (10 * 5 bytes) */
#define EEPROM_BIG_NUM_FONT			0x1C0
/* Extra numbers font (10 * 6 bytes) */
#define EEPROM_EXTRA_NUM_FONT		0x180

#define EEPROM_SIZE					0x200

enum {
	LABEL_MONDAY,
	LABEL_TUESDAY,
	LABEL_WEDNESDAY,
	LABEL_THURSDAY,
	LABEL_FRIDAY,
	LABEL_SATURDAY,
	LABEL_SUNDAY,

	LABEL_MO,
	LABEL_TU,
	LABEL_WE,
	LABEL_TH,
	LABEL_FR,
	LABEL_SA,
	LABEL_SU,

	LABEL_DECEMBER,
	LABEL_JANUARY,
	LABEL_FEBRUARY,
	LABEL_MARCH,
	LABEL_APRIL,
	LABEL_MAY,
	LABEL_JUNE,
	LABEL_JULY,
	LABEL_AUGUST,
	LABEL_SEPTEMBER,
	LABEL_OCTOBER,
	LABEL_NOVEMBER,

	LABEL_SECOND,
	LABEL_MINUTE,
	LABEL_HOUR,
	LABEL_WEEK,
	LABEL_DATA,
	LABEL_MONTH,
	LABEL_YEAR,
	LABEL_Y,

	LABEL_TEMPERATURE,
	LABEL_DEGREE,
	LABEL_TEMP1,
	LABEL_TEMP2,
	LABEL_TEMP3,
	LABEL_TEMP4,

	LABEL_PRESSURE,
	LABEL_MMHG,
	LABEL_KPA,

	LABEL_HUMIDITY,
	LABEL_PERCENT,
	LABEL_BRIGHTNESS,

	LABEL_END
};

#endif /* EEPROM_H */
