/*****************************************************
Project : 
Version :
Date    : 07.11.2009
Author  :  
Company : ---
Comments:     
  Savage

Chip type           : ATmega8
Program type        : Application
Clock frequency     : 4,000000 MHz
Memory model        : Small
External RAM size   : 0
Data Stack size     : 256

*****************************************************/


//==============================================================
// 
//==============================================================
#include <mega8.h>

// I2C -----------------------
#asm
   .equ __i2c_port=0x15 ;PORTC
   .equ __sda_bit=2
   .equ __scl_bit=1
#endasm
#include <i2c.h>

// DS1307 --------------------
#include <ds1307.h>

// 1 Wire --------------------
#asm
   .equ __w1_port=0x15 ;PORTC
   .equ __w1_bit=0
#endasm
#include <1wire.h>

// DS18B20 -------------------
#include <ds18B20.h>

// LCD -----------------------
#asm
   .equ __lcd_port=0x12 ;PORTD
#endasm
#include <lcd.h>

// 
#include <delay.h>
//  -
#include <stdio.h>
#include <stdlib.h>

//==============================================================
// GLOBAL DEFINES
//==============================================================
#define scan_delay 15               //      = n*16,3ms

#define temp_max 300                //    = n/10  * 5
#define temp_min 80                 //    = n/10

#define hyst 2                      //   = 0.n

                                    //  :
//#define btn_plus   btn_tsk & 0x01   // "+"
//#define btn_minus  btn_tsk & 0x02   // "-"
//#define btn_right  btn_tsk & 0x08   // ">"
//#define btn_left   btn_tsk & 0x04   // "<"
//#define btn_ok     btn_tsk & 0x10   // "ok"

#define btn_plus   btn_tsk & 0x08   // "+"
#define btn_minus  btn_tsk & 0x04   // "-"
#define btn_right  btn_tsk & 0x01   // ">"
#define btn_left   btn_tsk & 0x02   // "<"
#define btn_ok     btn_tsk & 0x10   // "ok"



//==============================================================
//  
//==============================================================
void clk_adj (char cur_pos); //   
void compare (void); //       
void define_char(unsigned char flash *pc,unsigned char char_code); //    
void e_get_temp (char direction); //        
void e_temp_adj (char cur_pos); // /  .  . 
void get_day_map (char day, char direction); //     
char get_interval (void); //         
char get_mas_pos (char n); //         
void get_temp (void); //     DS18B20
char get_temp_status (char interval); //         
void init (void); //  
void int1_dis (void); //   
void int1_en (void); //   
void interval_adj (char cur_pos); //   
void m_check (void); //    30,29,28 
void m_menu (void);  //   ()
char not_leap (void); //    
void relay (char s); //   (0-., 1...255-.)
void start_conv (void); //        -
void t1_start (void); //   1
void t1_stop (void);  //   1
void temp_adj (char cur_pos); //    
void tsk_clr (void); //  
char wd_calc (void); //    (.  )
void y_check (void); //      2- 


//==============================================================
//  
//==============================================================
flash char d_map [7][4]= //    
{
    {'B','C','K'},		// 0.
    {0xA8,'O','H'},		// 1.
    {'B','T','O'},		// 2.
    {'C','P','E'},		// 3.
    {0xAB,'E','T'},		// 4.
    {0xA8,0xB1,'T'},	// 5.
    {'C',0xA9,0xA0}		// 6.
};
flash unsigned char m_map [12][4]= //    
{
    {0xB1,'H','B'},		//  0.
    {0xAA,'E','B'},		//  1.
    {'M','A','P'},		//  2.
    {'A',0xA8,'P'},		//  3.
    {'M','A',0xA6},		//  4.
    {0xA5,0xB0,'H'},	//  5.
    {0xA5,0xB0,0xA7},	//  6.
    {'A','B',0xA1},		//  7.
    {'C','E','H'},		//  8.
    {'O','K','T'},		//  9.
    {'H','O',0xB1},		// 10.
    {0xE0,'E','K'}		// 11.
};

flash char str_11[11]={0xE0,'a',0xBF,'a','/',0xB3,'p','e',0xBC,0xC7}; // "/"
flash char str_12[7]={0xA1,'p','a',0xE4,0xB8,0xBA}; // ""
flash char str_13[12]={'T','e',0xBC,0xBE,'e','p','a',0xBF,'y','p',0xC3}; // ""
flash char str_14[6]={'B',0xC3,'x','o',0xE3}; // ""

flash unsigned char c_degree[8]= //  
{
0b01110,   //| ooo |
0b01010,   //| o o |
0b01110,   //| ooo |
0b00000,   //|     |
0b00000,   //|     |
0b00000,   //|     |
0b00000,   //|     |
0b00000    //|     |
};
flash unsigned char c_term[8]= //  
{
0b01110,   //| ooo |
0b01010,   //| o o |
0b01010,   //| o o |
0b01110,   //| ooo |
0b01110,   //| ooo |
0b11101,   //|ooo o|
0b01110,   //| ooo |
0b00000    //|     |
};
flash unsigned char c_fire[8]= //  
{
0b00100,   //|  o  |
0b10101,   //|o o o|
0b01110,   //| ooo |
0b11011,   //|oo oo|
0b01110,   //| ooo |
0b10101,   //|o o o|
0b00100,   //|  o  |
0b00000    //|     |


};
flash unsigned char c_moon[8]= //  
{
0b00100,   //|  o  |
0b01000,   //| o   |
0b11000,   //|oo   |
0b11000,   //|oo   |
0b11000,   //|oo   |
0b01100,   //| oo  |
0b00011,   //|   oo|
0b00000    //|     |


};


//  (, , )
struct time_str
{
	char hour;
	char min;
	char sec;
} t;
//  (, , )
struct date_str
{
	char day;
    char month;
    char year;
} d;

//  
signed int temp;
//  
signed int temp2=150;

// .  
signed int temp_hi;
// .  
signed int temp_low;

// 
char btn_tsk;
/*
  PB2-"+"
  PB3-"-"
  PB0-">"
  PB1-"<"
  PB4-"ok"
*/

//    "1"-. "0"-.
//char relay_pos=0;

//  
char cur_int;

//   
char a_frz;

//   
struct menu_str
{
	char deep;    //   (0-. )
    char smenu;   // 
    char q_temp;  //    
    char state;   //   

    char day_sel; //    
    char int_sel; //
} menu;

char lcd_buf[33]; //     162 (32 . + NULL)

char day_int_map[19]; //     

//      
// S-, H-, M-
eeprom char intervals[7][19]=
{
// 00:00                                                       24:00
// |                                                           |
// | -> 1 -> |    2 -> |    3 -> |    4 -> |    5 -> |    6 -> |
// | S  H  M | S  H  M | S  H  M | S  H  M | S  H  M | S  H  M |
	{1,07,00,  1,11,00,  1,14,00,  1,15,00,  1,16,00,  0,23,00}, // .
    {1,07,00,  0,11,00,  0,14,00,  0,15,00,  1,16,00,  0,23,00}, // .
    {1,07,00,  0,11,00,  0,14,00,  0,15,00,  1,16,00,  0,23,00}, // .
    {1,07,00,  0,11,00,  0,14,00,  0,15,00,  1,16,00,  0,23,00}, // .
    {1,07,00,  0,11,00,  0,14,00,  0,15,00,  1,16,00,  0,23,00}, // .
    {1,07,00,  0,11,00,  0,14,00,  0,15,00,  1,16,00,  0,23,00}, // .
    {1,07,00,  1,11,00,  1,14,00,  1,15,00,  1,16,00,  0,23,00}  // .
};

eeprom int e_temp[2]={190,230}; //    
eeprom int af_temp=80; //    ( )
eeprom char e_a_frz=0; //    


//==============================================================
// External Interrupt 1
//==============================================================
//   DS1307 
interrupt [EXT_INT1] void ext_int1_isr(void)
{
    static char temp_status, temp_char;
    char temp_sign;

    get_temp(); //  
    start_conv(); //   

    rtc_get_date(&d.day,&d.month,&d.year); //    
    rtc_get_time(&t.hour,&t.min,&t.sec);   //

    if (t.hour==0 && t.min==0 && t.sec==0) //     
    {
    	get_day_map(wd_calc(),0); //      
        menu.q_temp=0; //    
    }
    else if (cur_int<get_interval()) //     
         {
             menu.q_temp=0; //    
         };


    cur_int=get_interval(); //      
    temp_status=get_temp_status(cur_int); //      

    //     
    //--------------------------------------
    if(menu.q_temp==0 && a_frz==0) //        
    {
        if(temp_status)  //  .  
        {
            temp_char=0x03;
            temp2=temp_hi; //   
        }
        else             //  .  
        {
            temp_char=0x04;
            temp2=temp_low; //   
        };
    }
    else if(menu.q_temp) //  .    
    {
    	if(temp_status)  //  .  
        {
        	if(temp2>temp_hi) temp_char=0xD9;      //     
            else if(temp2<temp_hi) temp_char=0xDA;
                 else if(temp2==temp_hi)           //       
                      {
                          temp_char=0x03;
                          menu.q_temp=0;
                      };
        }
        else             //  .  
        {
           if(temp2>temp_low) temp_char=0xD9;      //     
           else if(temp2<temp_low) temp_char=0xDA;
                else if(temp2==temp_low)           //       
                     {
                         temp_char=0x04;
                         menu.q_temp=0;
                     };
        };
    }
    else if(a_frz) //  .  
    {
    	temp_char=0xEE;
    };

    //   
    if(__ds18b20_scratch_pad.temp_msb & 0xF8)
    {
        temp_sign='-';
    }
    else
    {
        temp_sign='+';
    };

    // :
    //  
    sprintf (&lcd_buf[0],"%c%c%02i.%i%c %u%c%+03i.%i%c",0x02,temp_sign,abs(temp/10),abs(temp%10),0x01,cur_int,temp_char,temp2/10,abs(temp2%10),0x01);
    lcd_clear();
    lcd_puts(&lcd_buf[0]);

    //  
    sprintf (&lcd_buf[0],"  %p %02u:%02u:%02u",&d_map[wd_calc()][0],t.hour,t.min,t.sec);
    lcd_gotoxy(0,1);
    lcd_puts(&lcd_buf[0]);

    compare(); //  
}

//==============================================================
// Timer 0 overflow interrupt
//==============================================================
//    :
// -> 4MHz/256 -> 15'625Hz/256=61.035Hz  : t=0.0163s=16.3ms
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
{
static char comb1,comb2,stat,delay=1;  // stat=0- ; stat=1- 

    if (--delay==0) // 
    {
        delay=1;

        if (stat==0) //     
        {
            comb1=((~PINB) & 0x1F);
        };

        if (stat==1) //   
        {
            comb2=((~PINB) & 0x1F); //     ,     
            if (comb1==comb2) //   
            {
            btn_tsk=comb2;    //   ,  
            delay=scan_delay; //     . 
            };
        stat=0;           //  
        comb1=0; comb2=0; //  
        };

        if (comb1!=0) //   ,  .  
        {
        stat=1;
        };
    };
}

//==============================================================
// Timer 1 overflow interrupt
//==============================================================
interrupt [TIM1_OVF] void timer1_ovf_isr(void)
{
	t1_stop();         //  
	tsk_clr();         // 

    //***************
//    lcd_gotoxy(15,1);  // !!!     
//    lcd_putchar('*');  //   
//    delay_ms(500);
//    lcd_gotoxy(15,1);
//    lcd_putchar(' ');
    //***************

    //     ...
    if(menu.q_temp==1 || a_frz==1)
    {
    	btn_tsk=0x10;
    };
    //   ...
    if(menu.deep==1)
    {
    	menu.smenu=4;
    	btn_tsk=0x10;
    };
    //   /, , 
    if(menu.deep==3)
    {
    	btn_tsk=0x10;
    };

}

//==============================================================
//   !!!
//==============================================================
void init (void)
{
// Input/Output Ports initialization
// Port B initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
// State7=P State6=P State5=P State4=P State3=P State2=P State1=P State0=P
PORTB=0xFF;
DDRB=0x00;

// Port C initialization
// Func6=In Func5=Out Func4=Out Func3=Out Func2=In Func1=In Func0=In
// State6=T State5=0 State4=0 State3=0 State2=T State1=T State0=T
PORTC=0x00;
DDRC=0x38;

// Port D initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
PORTD=0x00;
DDRD=0x00;

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 15,625 kHz
TCCR0=0x04;
TCNT0=0x00;

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: Timer 1 Stopped
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: Off
// Compare A Match Interrupt: Off
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: Timer 2 Stopped
// Mode: Normal top=FFh
// OC2 output: Disconnected
ASSR=0x00;
TCCR2=0x00;
TCNT2=0x00;
OCR2=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x05;

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

	//relay(0); //  

// LCD module initialization
	lcd_init(16);

//   
    define_char(&c_degree[0],0x01); //   001
    define_char(&c_term[0],0x02); //  002
    define_char(&c_fire[0],0x03); //  003
    define_char(&c_moon[0],0x04);//  004

// I2C Bus initialization
	i2c_init();

// DS1307 Real Time Clock initialization
// Square wave output on pin SQW/OUT: On
// Square wave frequency: 1Hz
	rtc_init(0,1,0);

// 1 Wire Bus initialization
	w1_init();

	ds18b20_init(0,-20,35,DS18B20_12BIT_RES); //  0.0625 12-. t.=800ms

    start_conv(); //   

	lcd_clear();                 //    1,5 .
    lcd_putsf("   Ver.:1.3.6.s");
    delay_ms(1500);
    
   
    rtc_get_time(&t.hour,&t.min,&t.sec);   //       RTC
    rtc_get_date(&d.day,&d.month,&d.year);
    get_day_map(wd_calc(),0);  //       EEPROM

    cur_int=get_interval(); //     

    e_get_temp(0); //      

    a_frz=e_a_frz; //   EEPROM   

    if(a_frz) temp2=af_temp; //  .  ,   

    //   
    GICR|=0x80;
    MCUCR=0x08;
    GIFR=0x80;

#asm ("sei")
}

//==============================================================
//     ,   
//==============================================================
char wd_calc (void)
{
unsigned int a,y,m;

    a=((14-d.month)/12);
    y=(d.year-a);
    m=(d.month+(12*a)-2);

    return (char)((7000+(d.day+y+(y/4)-(y/100)+(y/400)+((31*m)/12)))%7);
    // : 0-. 1-. 2-. 3-. 4-. 5-. 6-.
}

//==============================================================
//   DS18B20
//==============================================================
void get_temp (void)
{
char integer;
int frac;

ds18b20_read_spd(0); //  scratcpad

	if (__ds18b20_scratch_pad.temp_msb & 0xF8) //   ,  "-"  
    {
    integer=((((~__ds18b20_scratch_pad.temp_msb) & 0x07)<<4)|((~__ds18b20_scratch_pad.temp_lsb)>>4));
    frac=(10000-((__ds18b20_scratch_pad.temp_lsb & 0x0F)*625));
        if (frac==10000)
        {
        	integer++;
            frac=0;
        };
        if (integer>=50)
        {
        	integer=50;
        	frac=0;
        };
        temp=0-(((int)integer)*10+frac/1000);
    }
    else
    {
    integer=(((__ds18b20_scratch_pad.temp_msb & 0x07)<<4)|(__ds18b20_scratch_pad.temp_lsb>>4));
	frac=((__ds18b20_scratch_pad.temp_lsb & 0x0F)*625);
        if (integer>=99)
        {
        	integer=99;
        	frac=0;
        };
        temp=(((int)integer)*10+frac/1000);
    };
}

//==============================================================
//    CGRAM
//==============================================================
void define_char(unsigned char flash *pc,unsigned char char_code)
{
unsigned char j,a;
a=(char_code<<3)|0x40;
for (j=0; j<8; j++)
	{
		lcd_write_byte(a++,*pc++);
    };
}

//==============================================================
//   DS18B20
//==============================================================
void start_conv (void)
{
    while(w1_init()==0)
    {
		lcd_clear();
		lcd_putsf("1W ERROR!");
        relay(0);
		delay_ms(1000);
	}

	w1_init(); // 1W ,  
	w1_write(0xCC); //  ROM
	w1_write(0x44); //  
}

//==============================================================
//  
//==============================================================
void tsk_clr (void)
{
btn_tsk=0x00;
}

//==============================================================
//  
//==============================================================
void relay (char s)
{
    if (s)
    {
	PORTC &= ~0x20;    

    }
    else
    {
	PORTC |= 0x20;    
    };
}

//==============================================================
//     
//==============================================================
void compare (void)
{

	if ((temp2-hyst)>=temp) //  -   - . 
	{
    	relay(1);
    }
    else if (temp>=(temp2+hyst)) //  -   - . 
    {
    	relay(0);
    };
}

//==============================================================
//   1
//==============================================================
void t1_start (void)
{
TCNT1H=0x00; //  
TCNT1L=0x00;
TCCR1A=0x00; //  
TCCR1B=0x05; // F_osc./1024
}

//==============================================================
//   1
//==============================================================
void t1_stop (void)
{
TCCR1A=0x00; //  
TCCR1B=0x00;
}

//==============================================================
//    
//==============================================================
char not_leap (void)
{
	int year;

    year=2000+(int)d.year;

    if (!(year%100))
            return (char)(year%400);
        else
            return (char)(year%4);
}

//==============================================================
//   30-, 29-, 28- 
//==============================================================
void m_check (void)
{
    if (d.day>30 && (d.month==4 || d.month==6 || d.month==9 || d.month==11)) d.day=30;
    else if(d.day>28 && d.month==2 && not_leap() ) d.day=28;
         else if (d.day>29 && d.month==2) d.day=29;
}
void y_check (void)
{
	if (d.month==2 && d.day>28 && not_leap() ) d.day=28;
	else if (d.month==2 && d.day>29) d.day=29;
}

//==============================================================
//    INT1
//==============================================================
void int1_en (void)
{
GICR |=0x80; //   INT1
}
void int1_dis (void)
{
GICR &=0x7F; //   INT1
}

//==============================================================
//     
//==============================================================
char get_mas_pos (char n)
{
	return ((n-1)*3);
}

//==============================================================
//       .   EEPROM
// day -  ; direction -  (1-, 0-)
//==============================================================
void get_day_map (char day, char direction)
{
    char i;
    eeprom char *eep;
    char *ram;

    eep=&intervals[day][0]; //   
    ram=&day_int_map[0];    // EEPROM  RAM

    #asm ("cli")
    for(i=0;i<18;i++)
    {
    	if (direction) // Direction == 1
        {
        	*eep++=*ram++; //  18   EEPROM
        }
        else           // Direction == 0
        {
        	*ram++=*eep++; //  18     (day_int_map)
        };
    };
    #asm ("sei")
}

//==============================================================
//        -  EEPROM
// direction -  (1-, 0-)
//==============================================================
void e_get_temp (char direction)
{
    #asm ("cli")
    if(direction)
    {
        e_temp[0]=temp_low;
        e_temp[1]=temp_hi;
    }
    else
    {
    	temp_low=e_temp[0];
        temp_hi=e_temp[1];
    };
    #asm ("sei")
};

//==============================================================
//   ,    0...6
//==============================================================
char get_interval (void)
{
	char n=1;
    char status=1;
    char hour,min;

    while(status)
    {
    	hour=day_int_map[get_mas_pos(n)+1];
        min=day_int_map[get_mas_pos(n)+2];

        if(hour>t.hour) status=0;
        else if(hour==t.hour &&  min>t.min) status=0;
             else if(++n==7)
                  {
                      status=0;
                  };
    };
    return n-1;
}

//==============================================================
//     , 
//  (1-., 0-.),   
//==============================================================
char get_temp_status (char interval)
{
    char day;
    eeprom char *eep;

	if(interval==0)       //    "0"   
    {                     //  "6"-    
    	day=wd_calc();
    	if((--day)==255) day=6;
        eep=&intervals[day][15];
        return *eep;
    }
    else
    {
    	return day_int_map[get_mas_pos(interval)];
    };
}


//                   
//           ----------------------------------------
//==============================================================
//   
//==============================================================
void temp_adj (char cur_pos)
{
char status;

if(a_frz==0) status='A';
else status='P';

sprintf (&lcd_buf[0],"t%+03i.%i%cC <%c>",temp2/10,abs(temp2%10),0x01,status);
lcd_clear();
lcd_gotoxy(2,0);
lcd_puts(&lcd_buf[0]);

if(cur_pos==1) lcd_gotoxy(2,0);
else if(cur_pos==2) lcd_gotoxy(12,0);

_lcd_ready();              // .  
_lcd_write_data(0x0D);
}

//==============================================================
//  
//==============================================================
void m_menu (void)
{
sprintf(&lcd_buf[0],"MEH%c:        %u/4",0xB0,menu.smenu);
lcd_clear();
lcd_puts(&lcd_buf[0]);
lcd_gotoxy(0,1);

if (menu.smenu==1) lcd_putsf(str_11);
else if(menu.smenu==2) lcd_putsf(str_12);
	 else if(menu.smenu==3) lcd_putsf(str_13);
          else if(menu.smenu==4) lcd_putsf(str_14);
}

//==============================================================
//     DS1307
//==============================================================
void clk_adj (char cur_pos)
{

rtc_get_time(&t.hour,&t.min,&t.sec);
rtc_get_date(&d.day,&d.month,&d.year);

sprintf(&lcd_buf[0],"%02u:%02u:%02u",t.hour,t.min,t.sec); //  
lcd_clear();
lcd_gotoxy(4,0);
lcd_puts(&lcd_buf[0]);

sprintf(&lcd_buf[0],"%02u-%p.-%02u",d.day,&m_map[d.month-1][0],d.year); //  
lcd_gotoxy(3,1);
lcd_puts(&lcd_buf[0]);

if(cur_pos==1) lcd_gotoxy(4,0);
else if(cur_pos==2) lcd_gotoxy(7,0);
     else if(cur_pos==3) lcd_gotoxy(3,1);
          else if(cur_pos==4) lcd_gotoxy(6,1);
               else if(cur_pos==5) lcd_gotoxy(11,1);

_lcd_ready();              // .  
_lcd_write_data(0x0D);
}

//==============================================================
//   
//==============================================================
void interval_adj (char cur_pos)
{
char symbol,hour,min;

if(get_temp_status(menu.int_sel)) symbol=0x03;
else symbol=0x04;

hour=day_int_map[get_mas_pos(menu.int_sel)+1];
min=day_int_map[get_mas_pos(menu.int_sel)+2];

sprintf(&lcd_buf[0]," %p.\n %u: <%c> %02u:%02u",&d_map[menu.day_sel][0],menu.int_sel,symbol,hour,min);
lcd_clear();
lcd_puts(&lcd_buf[0]);

if(cur_pos==1) lcd_gotoxy(1,0);
else if(cur_pos==2) lcd_gotoxy(1,1);
     else if(cur_pos==3) lcd_gotoxy(5,1);
          else if(cur_pos==4) lcd_gotoxy(8,1);
               else if(cur_pos==5) lcd_gotoxy(11,1);

_lcd_ready();              // .  
_lcd_write_data(0x0D);
}

//==============================================================
//  
//==============================================================
void e_temp_adj (char cur_pos)
{
sprintf(&lcd_buf[0],"%c:%+03i.%i%cC\n%c:%+03i.%i%cC",0x03,temp_hi/10,abs(temp_hi%10),0x01,0x04,temp_low/10,abs(temp_low%10),0x01);
lcd_clear();
lcd_puts(&lcd_buf[0]);

if(cur_pos==1) lcd_gotoxy(9,0);
else if(cur_pos==2) lcd_gotoxy(9,1);

_lcd_ready();              // .  
_lcd_write_data(0x0D);
}

//==============================================================
//                            MAIN !!!
//==============================================================
void main(void)
{
init(); //  

while (1)
{
while(!btn_tsk);

    //==========================================================
	//     
    //    . "+"  "-"
    //==========================================================
    if ((btn_plus || btn_minus) && menu.deep==0)
    {
    int1_dis(); //   
    menu.q_temp=1; //     .   
    menu.state=1;

    t1_start(); //    

        while (!(btn_ok)) //   ""  
        {
            #asm ("cli")
            if(btn_right) //  ""
            {
            	if(++menu.state==3) menu.state=1;
                tsk_clr();
            	t1_start();
        		temp_adj(menu.state);
            };

            if(btn_left) //  ""
            {
                if(--menu.state==0) menu.state=2;
                tsk_clr();
            	t1_start();
        		temp_adj(menu.state);
            };

        	if (btn_plus) //  ""
            {

                if(menu.state==1)
                {
                    if (temp2>=temp_max) {} //  - >= t_max    
                    else //     0.5
                    {
                        temp2+=5;
                    };
                    if(a_frz) menu.q_temp=0;

                }
                else if(menu.state==2)
                     {
                         a_frz=1;
                         e_a_frz=a_frz;
                         menu.q_temp=0;
                     };

            tsk_clr();
            t1_start();
        	temp_adj(menu.state);
        	};

            if (btn_minus) //  ""
            {

                if(menu.state==1)
                {
                    if (temp2<=temp_min) {} //  - <= t_min    
                    else //     0.5
                    {
                        temp2-=5;
                    };
                    if(a_frz) menu.q_temp=0;
                }
                else if(menu.state==2)
                     {
                         a_frz=0;
                         e_a_frz=a_frz;
                         menu.q_temp=1;
                     };
            tsk_clr();
            t1_start();
        	temp_adj(menu.state);
            };
            #asm ("sei")
        };
        //    ""
        #asm ("cli")
        if(a_frz) af_temp=temp2;
        rtc_get_date(&d.day,&d.month,&d.year); //      
        get_day_map(wd_calc(),0);
        #asm ("sei")
    	tsk_clr();
        t1_stop();
    	int1_en(); //   
    };

    //==========================================================
    //    
    //    . "OK"
    //==========================================================
    if (btn_ok && menu.deep==0)
    {
    	if(a_frz)
    	{
            #asm ("cli")
        	a_frz=0;
            e_a_frz=a_frz;
            tsk_clr();
            #asm ("sei")
    	}
    	else
    	{
        int1_dis(); //   
        tsk_clr();
        t1_start();
        menu.deep=1;
        menu.smenu=1;
        m_menu();

            while (!(btn_ok)) //   ""  
            {
                #asm ("cli")
                if(btn_right) //  ""
                {
                    if(++menu.smenu==5) menu.smenu=1;
                    tsk_clr();
                    t1_start();
                    m_menu();
                };

                if(btn_left) //  ""
                {
                    if(--menu.smenu==0) menu.smenu=4;
                    tsk_clr();
                    t1_start();
                    m_menu();
                };
                #asm ("sei")
            };
            //    ""
            tsk_clr();
            t1_stop();
            menu.deep=2;
        }
    };

    //----------------------------------------------------------
    // "/"
    //----------------------------------------------------------
    if (menu.deep==2 && menu.smenu==1)
    {
    	tsk_clr();
        t1_start();
        menu.deep=3;
        menu.state=1;
        clk_adj(menu.state); //   

    	while (!(btn_ok))
        {
            clk_adj(menu.state);
            delay_ms(200);
        	#asm ("cli")
            if(btn_right) //  ""
            {
            	if(++menu.state==6) menu.state=1;
                tsk_clr();
                t1_start();
                clk_adj(menu.state);
            };

            if(btn_left) //  ""
            {
            	if(--menu.state==0) menu.state=5;
                tsk_clr();
                t1_start();
                clk_adj(menu.state);
            };

            if(btn_plus) //  ""
            {
            	if(menu.state==1) // *
                {
                	if(++t.hour>23) t.hour=0;
                    t.sec=0;
                }
                else if(menu.state==2) // *
                     {
                     	 if(++t.min>59) t.min=0;
                         t.sec=0;
                     }
                     else if(menu.state==3) // *
                          {
                              if(++d.day>31) d.day=1;
                              else if(d.day>30 && (d.month==4 || d.month==6 || d.month==9 ||d.month==11)) d.day=1;
                                   else if(d.day>29 && d.month==2) d.day=1;
                                        else if (d.day>28 && d.month==2 && not_leap() ) d.day=1;
                          }
                          else if(menu.state==4) // *
                               {
                                   if(++d.month==13) d.month=1;
                                   else m_check();
                               }
                               else if(menu.state==5) // *
                                    {
                                        if(++d.year==99) d.year=0;
                                        y_check();
                                    };

            tsk_clr();
            t1_start();
            rtc_set_time(t.hour,t.min,t.sec);   //   
            rtc_set_date(d.day,d.month,d.year);
            clk_adj(menu.state); //   
            };

            if(btn_minus) //  ""
            {
            	if(menu.state==1) // *

                {
                	if(--t.hour==255) t.hour=23;
                    t.sec=0;
                }
                else if(menu.state==2) // *
                     {
                         if(--t.min==255) t.min=59;
                         t.sec=0;
                     }
                     else if(menu.state==3) // *
                          {
                              if(--d.day==0)
                              {
                                  d.day=31;
                                  if(d.month==4 || d.month==6 || d.month==9 || d.month==11) d.day=30;
                                  else if(d.month==2 && not_leap() ) d.day=28;
                                       else if(d.month==2) d.day=29;
                              };
                          }
                          else if(menu.state==4) // *
                               {
                                   if(--d.month==0) d.month=12;
                                   else m_check();

                               }
                               else if(menu.state==5) // *
                                    {
                                        if(--d.year==255) d.year=99;
                                        y_check();
                                    };

            tsk_clr();
            t1_start();
            rtc_set_time(t.hour,t.min,t.sec);   //   
            rtc_set_date(d.day,d.month,d.year);
            clk_adj(menu.state); //   
            };
            #asm ("sei")

        };
        t1_stop();
        menu.deep=0;
    };

    //----------------------------------------------------------
    // ""
    //----------------------------------------------------------
    if (menu.deep==2 && menu.smenu==2)
    {
        tsk_clr();
        t1_start();
        menu.deep=3;
        menu.state=1;
        menu.day_sel=1;
        menu.int_sel=1;

        get_day_map(menu.day_sel,0);
        interval_adj(menu.state);

    	while(!(btn_ok))
        {
            #asm ("cli")
            if(btn_right) // ""
            {
            	if(++menu.state==6) menu.state=1;
                tsk_clr();
                t1_start();
                interval_adj(menu.state);
            };

            if(btn_left) // ""
            {
                if(--menu.state==0) menu.state=5;
                tsk_clr();
                t1_start();
                interval_adj(menu.state);
            };

        	if(btn_plus) // ""
            {
            	if(menu.state==1) // * 
                {
                    get_day_map(menu.day_sel,1);

                	if(++menu.day_sel==7) menu.day_sel=0;
                    get_day_map(menu.day_sel,0);
                }
                else if(menu.state==2) // *
                     {
                     if(++menu.int_sel==7) menu.int_sel=1;
                     }
                     else if(menu.state==3) // *
                          {
                              day_int_map[get_mas_pos(menu.int_sel)]=1;
                          }
                          else if(menu.state==4) // *
                               {
                                   if(menu.int_sel==6)
                                   {
                                   if(++day_int_map[get_mas_pos(menu.int_sel)+1]==24) day_int_map[get_mas_pos(menu.int_sel)+1] =23;
                                   }
                                   else if(++day_int_map[get_mas_pos(menu.int_sel)+1] < day_int_map[get_mas_pos(menu.int_sel+1)+1]) {}
                                        else
                                        {
                                            --day_int_map[get_mas_pos(menu.int_sel)+1];
                                        };
                               }
                               else if(menu.state==5) // *
                                    {
                                        if(++day_int_map[get_mas_pos(menu.int_sel)+2]==60) day_int_map[get_mas_pos(menu.int_sel)+2]=0;
                                    };
        		tsk_clr();
                t1_start();
                interval_adj(menu.state);
            };

            if(btn_minus) // ""
            {
                if(menu.state==1) // * 
                {
                    get_day_map(menu.day_sel,1);

                	if(--menu.day_sel==255) menu.day_sel=6;
                    get_day_map(menu.day_sel,0);
                }
                else if(menu.state==2) // *
                     {
                     if(--menu.int_sel==0) menu.int_sel=6;
                     }
                     else if(menu.state==3) // *
                          {
                              day_int_map[get_mas_pos(menu.int_sel)]=0;
                          }
                          else if(menu.state==4) // *
                               {
                                   if(menu.int_sel==1)
                                   {
                                   if(--day_int_map[get_mas_pos(menu.int_sel)+1]==255) day_int_map[get_mas_pos(menu.int_sel)+1]=0;
                                   }
                                   else if( --day_int_map[get_mas_pos(menu.int_sel)+1] > day_int_map[get_mas_pos(menu.int_sel-1)+1] ) {}
                                        else
                                        {
                                            ++day_int_map[get_mas_pos(menu.int_sel)+1];
                                        };
                               }
                               else if(menu.state==5) // *
                                    {
                                        if(--day_int_map[get_mas_pos(menu.int_sel)+2]==255) day_int_map[get_mas_pos(menu.int_sel)+2]=59;
                                    };
        		tsk_clr();
                t1_start();
                interval_adj(menu.state);
            };
            #asm ("sei")
        };
        t1_stop();
        get_day_map(menu.day_sel,1); //    
        menu.deep=0;
    };

    //----------------------------------------------------------
    // ""
    //----------------------------------------------------------
    if (menu.deep==2 && menu.smenu==3)
    {
        tsk_clr();
        t1_start();
        menu.deep=3;
        menu.state=1;
        e_get_temp(0); //  -  EEPROM
        e_temp_adj(menu.state);

    	while(!(btn_ok)) //  ""
        {
            #asm ("cli")
            if(btn_left) //  ""
            {
            	if(--menu.state==0) menu.state=2;
                tsk_clr();
        		t1_start();
                e_temp_adj(menu.state);
            };

            if(btn_right) //  ""
            {
                if(++menu.state==3) menu.state=1;
                tsk_clr();
        		t1_start();
                e_temp_adj(menu.state);
            };

            if(btn_plus) //  ""
            {
            	if(menu.state==1) //  
                {
                	if(temp_hi>=temp_max) {}
                    else temp_hi+=5;
                }
                else if(menu.state==2) //  
                     {
                         if(temp_low>=temp_max) {}
                         else temp_low+=5;
                     };

                tsk_clr();
        		t1_start();
                e_temp_adj(menu.state);
            };

            if(btn_minus) //  ""
            {
                if(menu.state==1) //  
                {
                    if(temp_hi<=temp_min) {}
                    else temp_hi-=5;
                }
                else if(menu.state==2) //  
                     {
                         if(temp_low<=temp_min) {}
                         else temp_low-=5;
                     };

                tsk_clr();
        		t1_start();
                e_temp_adj(menu.state);
            };
            #asm ("sei")

        };
        t1_stop();
        e_get_temp(1); //  -  EEPROM
        menu.deep=0;
    };

    //----------------------------------------------------------
    // ""
    //----------------------------------------------------------
    if (menu.deep==2 && menu.smenu==4)
    {
    menu.deep=0; //   
    menu.smenu=0;
    menu.q_temp=0; //   .  
    rtc_get_date(&d.day,&d.month,&d.year);
    get_day_map(wd_calc(),0);
    int1_en(); //   
    };
};

}