

/*
 * _595_TRENIROVKA.asm
 *
 *  Created: 17.03.2018 14:08:08
 *   Author: User
 */ 
.INCLUDE   "tn13Adef.inc"   ;    LOW = 7A , HIGH = FF
.list
.equ	Fo=4800000

.equ SCK=0	;11  74595  
.equ DOUT=1	;14  74595  
.equ LOAD=2	;12  74595 ٨
.equ NOGA11=0 ;11  74595  
.equ NOGA14=1 ;14  74595  
.equ NOGA12=2 ;12  74595 ٨
.equ PB=PortB

.equ	a=Exp2(0)
.equ	b=Exp2(1)
.equ	c=Exp2(2)
.equ	d=Exp2(3)
.equ	e=Exp2(4)
.equ	f=Exp2(5)
.equ	g=Exp2(6)
.equ	h=Exp2(7)

.def	BIN_HOUR=R19
.def	H10=R20
.def	H1=R21
.def	M10=R22
.def	M1=R23
.def	S10=R24
.def	S1=R25
  .CSEG 
 .ORG 0
;-------------------------------------------------------------------------
 ;  

START:
     RJMP INIT   ;   
TB_DIG:
	.DB	a+b+c+d+e+f,	b+c			;0,1
	.DB	a+b+d+e+f+g,	a+b+c+d+g	;2,3
	.DB	b+c+f+g,		a+c+d+f+g	;4,5
	.DB	a+c+d+e+f+g,	a+b+c		;6,7
	.DB	a+b+c+d+e+f+g,	a+b+c+d+f+g	;8,9
 .ORG 6
;\ר 0 , ()
	IN	R19,SREG
	SBIW	YL,1
	BRNE	T0_COMP_OUT

	LDI	YH,HIGH(Fo/250)
	LDI	YL,LOW(Fo/250)

	SBR	R19,0b01000000	;  T-   1 
T0_COMP_OUT:
	OUT	SREG,R19
	RETI
;-----------------------------------------------------------------
INIT:
;     
;LDI R16,LOW(RAMEND) ;   
;OUT SPL,R16         ;    

 ; 
	CLR	ZH		;     0

	SER	R16
	OUT	DDRB,R16

	SBI	ACSR,ACD

	LDI	YH,HIGH(Fo/250)
	LDI	YL,LOW(Fo/250)
;    
	RJMP	TIME_BEGIN
GO:
	LDI	R16,1<<SE
	OUT	MCUCR,R16		; SLEEP IDLE

	LDI	R16,250-1
	OUT	OCR0A,R16

	LDI	R16,1<<WGM01
	OUT	TCCR0A,R16		;  CTC

	LDI	R16,1<<OCIE0A
	OUT	TIMSK0,R16
	OUT	TIFR0,R16

	LDI	R16,1<<CS00
	OUT	TCCR0B,R16

	CLT
	SEI
WAIT_1SEC:
	SLEEP
	BRTC	WAIT_1SEC
;   
TEST:
	INC	S1
	CPI	S1,10
	BRLO	TIME_OUT
	CLR	S1

	INC	S10
	CPI	S10,6
	BRLO	TIME_OUT
	CLR	S10

	INC	M1
	CPI	M1,10
	BRLO	TIME_OUT
	CLR	M1

	INC	M10
	CPI	M10,6
	BRLO	TIME_OUT
	CLR	M10
;
	INC	BIN_HOUR
	CPI	BIN_HOUR,24
	BRLO	PC+2
	RJMP	TIME_BEGIN

	INC	H1
	CPI	H1,10
	BRLO	TIME_OUT
	CLR	H1

	INC	H10
	CPI	H10,2
	BRLO	TIME_OUT
	CPI	H1,4
	BRLO	TIME_OUT
TIME_BEGIN:
	CLR	BIN_HOUR
	CLR	H10
	CLR	H1
	CLR	M10
	CLR	M1
	CLR	S10
	CLR	S1

TIME_OUT:
	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,H10
	LPM	R5,Z

	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,H1
	LPM	R6,Z

	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,M10
	LPM	R7,Z

	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,M1
	LPM	R8,Z

	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,S10
	LPM	R9,Z

	LDI	ZL,LOW(TB_DIG*2)
	ADD	ZL,S1
	LPM	R10,Z

	LDI	R16,6*8

TRANS_595:
; 
	LSR	R10
	ROR	R9
	ROR	R8
	ROR	R7
	ROR	R6
	ROR	R5

	CBI	PORTB,DOUT
	BRCC	PC+2
	SBI	PORTB,DOUT
	NOP
	NOP
	SBI	PORTB,SCK
	NOP
	NOP
	CBI	PORTB,SCK

	DEC	R16
	BRNE	TRANS_595
	CBI	PORTB,DOUT

	SBI	PORTB,LOAD
	NOP
	NOP
	CBI	PORTB,LOAD

	RJMP	GO
.EXIT
