
;CodeVisionAVR C Compiler V2.05.0 Evaluation
;(C) Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type                : ATmega8
;Program type             : Application
;Clock frequency          : 8,000000 MHz
;Memory model             : Small
;Optimize for             : Size
;(s)printf features       : int, width
;(s)scanf features        : int, width
;External RAM size        : 0
;Data Stack size          : 512 byte(s)
;Heap size                : 0 byte(s)
;Promote 'char' to 'int'  : Yes
;'char' is unsigned       : Yes
;8 bit enums              : Yes
;global 'const' stored in FLASH: No
;Enhanced core instructions    : On
;Smart register allocation     : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega8
	#pragma AVRPART MEMORY PROG_FLASH 8192
	#pragma AVRPART MEMORY EEPROM 512
	#pragma AVRPART MEMORY INT_SRAM SIZE 1119
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.LISTMAC
	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __SRAM_START=0x0060
	.EQU __SRAM_END=0x045F
	.EQU __DSTACK_SIZE=0x0200
	.EQU __HEAP_SIZE=0x0000
	.EQU __CLEAR_SRAM_SIZE=__SRAM_END-__SRAM_START+1

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM

	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM

	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+(@1)
	ANDI R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ANDI R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ANDD2N
	ANDI R26,LOW(@0)
	ANDI R27,HIGH(@0)
	ANDI R24,BYTE3(@0)
	ANDI R25,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+(@1)
	ORI  R30,LOW(@2)
	STS  @0+(@1),R30
	LDS  R30,@0+(@1)+1
	ORI  R30,HIGH(@2)
	STS  @0+(@1)+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD2N
	ORI  R26,LOW(@0)
	ORI  R27,HIGH(@0)
	ORI  R24,BYTE3(@0)
	ORI  R25,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __CLRD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+(@1))
	LDI  R31,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	LDI  R22,BYTE3(2*@0+(@1))
	LDI  R23,BYTE4(2*@0+(@1))
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+(@1))
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+(@2))
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+(@3))
	LDI  R@1,HIGH(@2+(@3))
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+(@3))
	LDI  R@1,HIGH(@2*2+(@3))
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+(@1)
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+(@1)
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	LDS  R22,@0+(@1)+2
	LDS  R23,@0+(@1)+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+(@2)
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+(@3)
	LDS  R@1,@2+(@3)+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+(@1)
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+(@1)
	LDS  R27,@0+(@1)+1
	LDS  R24,@0+(@1)+2
	LDS  R25,@0+(@1)+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+(@1),R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+(@1),R30
	STS  @0+(@1)+1,R31
	STS  @0+(@1)+2,R22
	STS  @0+(@1)+3,R23
	.ENDM

	.MACRO __PUTB1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRB
	.ENDM

	.MACRO __PUTW1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRW
	.ENDM

	.MACRO __PUTD1EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMWRD
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+(@1),R0
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+(@1),R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+(@1),R@2
	STS  @0+(@1)+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTBSR
	STD  Y+@1,R@0
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+(@1)
	LDS  R31,@0+(@1)+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+(@1))
	LDI  R31,HIGH(2*@0+(@1))
	RCALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+(@1))
	LDI  R27,HIGH(@0+(@1))
	RCALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __GETD1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X+
	LD   R22,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	RCALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	RCALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __GETBRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	LD   R@0,X
	.ENDM

	.MACRO __GETWRSX2
	MOVW R26,R28
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	LD   R@0,X+
	LD   R@1,X
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __CLRD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R30
	ST   X+,R30
	ST   X,R30
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	ST   Z,R@0
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

;NAME DEFINITIONS FOR GLOBAL VARIABLES ALLOCATED TO REGISTERS
	.DEF _cur_dig=R5
	.DEF _ff=R6
	.DEF _f=R8
	.DEF _h=R10
	.DEF _z=R12

	.CSEG
	.ORG 0x00

;START OF CODE MARKER
__START_OF_CODE:

;INTERRUPT VECTORS
	RJMP __RESET
	RJMP 0x00
	RJMP 0x00
	RJMP _timer2_comp_isr
	RJMP _timer2_ovf_isr
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00
	RJMP 0x00

_digits_G000:
	.DB  0x0,0x1,0x2,0x3,0x4,0x5,0x6,0x7
	.DB  0x8,0x9,0xA,0xB,0xC,0xD,0xE,0xF

_0x28:
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x5,0x0
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x5,0x0
	.DB  0x8,0x0,0x8,0x0,0x5,0x0,0x2,0x0
	.DB  0x5,0x0,0x8,0x0,0x5,0x0,0x2,0x0
	.DB  0x5,0x0,0x8,0x0,0x8,0x0,0x5,0x0
	.DB  0x2,0x0,0x5,0x0,0x8,0x0,0x5,0x0
	.DB  0x2,0x0,0x5,0x0,0x8,0x0,0x8,0x0
	.DB  0x5,0x0,0x2,0x0,0x5,0x0,0x8,0x0
	.DB  0x5,0x0,0x2,0x0,0x5,0x0,0x8,0x0
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x5,0x0
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x5,0x0
	.DB  0x8,0x0
_0x2F:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0xF,0x0,0xF,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0x0,0x0
	.DB  0x0,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0x0,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0x0,0x0
_0x36:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0xC,0x0
	.DB  0xE,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xE,0x0,0xC,0x0,0x8,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x1,0x0,0x3,0x0,0x7,0x0
	.DB  0xF,0x0,0x7,0x0,0x3,0x0,0x1,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0
	.DB  0x3,0x0,0x7,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0x7,0x0
	.DB  0x3,0x0,0x1,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0,0x7,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0x7,0x0,0x2,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0xC,0x0
	.DB  0xE,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xE,0x0,0xC,0x0,0x8,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0
_0x3D:
	.DB  0x8,0x0,0x0,0x0,0xF,0x0,0x8,0x0
	.DB  0xF,0x0,0x0,0x0,0xF,0x0,0x8,0x0
	.DB  0xF,0x0,0x8,0x0,0xF,0x0,0x8,0x0
	.DB  0xF,0x0,0x8,0x0,0x0,0x0,0x8,0x0
	.DB  0xF,0x0,0x8,0x0,0x0,0x0,0xF,0x0
	.DB  0xF,0x0,0x8,0x0,0x0,0x0,0xF,0x0
	.DB  0x8,0x0
_0x44:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0xD,0x0,0xD,0x0,0xD,0x0
	.DB  0xD,0x0,0xD,0x0,0xF,0x0,0xD,0x0
	.DB  0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0xD,0x0,0xD,0x0
	.DB  0xD,0x0,0xD,0x0,0xD,0x0,0xF,0x0
	.DB  0xF,0x0,0xD,0x0,0x8,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0xD,0x0
	.DB  0xD,0x0,0xD,0x0,0xD,0x0,0xD,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xD,0x0
	.DB  0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0xD,0x0,0xD,0x0,0xD,0x0,0xD,0x0
	.DB  0xD,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xD,0x0,0x8,0x0,0x0,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0xD,0x0,0xD,0x0,0xD,0x0
	.DB  0xD,0x0,0xD,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xD,0x0
	.DB  0x8,0x0,0x0,0x0
_0x4B:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0
	.DB  0xE,0x0,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0
	.DB  0xE,0x0,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0
	.DB  0xE,0x0,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x0
	.DB  0xE,0x0,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0xE,0x0,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x3,0x0
_0x52:
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x2,0x0,0x4,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x1,0x0,0x8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x8,0x0,0x1,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x0
	.DB  0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x4,0x0,0x1,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x1,0x0,0x4,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x4,0x0,0x1,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x1,0x0,0x4,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x4,0x0
	.DB  0x1,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0
	.DB  0x2,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x1,0x0,0x4,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x4,0x0,0x1,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x2,0x0
_0x59:
	.DB  0x0,0x0,0xE,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0xC,0x0
	.DB  0xE,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0x3,0x0,0x3,0x0,0xB,0x0
	.DB  0xB,0x0,0xF,0x0,0x0,0x0,0x2,0x0
	.DB  0x3,0x0,0x3,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x0,0x3,0x0,0x3,0x0,0x3,0x0
	.DB  0x3,0x0,0x3,0x0,0x3,0x0,0xB,0x0
	.DB  0xB,0x0,0xB,0x0,0xB,0x0,0xB,0x0
	.DB  0xB,0x0,0xF,0x0,0x8,0x0,0x8,0x0
	.DB  0xE,0x0,0xF,0x0,0xF,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0xC,0x0,0xE,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xE,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x8,0x0,0xC,0x0,0xE,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0x0,0x0,0x8,0x0,0x8,0x0,0xE,0x0
	.DB  0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0xE,0x0,0xF,0x0
	.DB  0xF,0x0
_0x60:
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x8,0x0
	.DB  0x5,0x0,0x2,0x0,0x8,0x0,0x5,0x0
	.DB  0x2,0x0,0x8,0x0,0x5,0x0,0x2,0x0
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x8,0x0
	.DB  0x5,0x0,0x2,0x0,0x8,0x0,0x5,0x0
	.DB  0x2,0x0,0x8,0x0,0x5,0x0,0x2,0x0
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x8,0x0
	.DB  0x5,0x0,0x2,0x0
_0x67:
	.DB  0x1,0x0,0x6,0x0,0x8,0x0,0x0,0x0
	.DB  0x0,0x0,0xC,0x0,0x3,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0
	.DB  0x8,0x0,0x5,0x0,0x2,0x0,0x2,0x0
	.DB  0x5,0x0,0x8,0x0,0x0,0x0,0x0,0x0
	.DB  0x0,0x0,0x0,0x0,0x8,0x0,0x5,0x0
	.DB  0x2,0x0
_0x6E:
	.DB  0x0,0x0,0x1,0x0,0x7,0x0,0xF,0x0
	.DB  0xF,0x0,0xF,0x0,0x0,0x0,0xC,0x0
	.DB  0xF,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0
	.DB  0xD,0x0,0xF,0x0,0x0,0x0,0x2,0x0
	.DB  0x7,0x0,0xF,0x0,0xF,0x0,0xF,0x0
	.DB  0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0
	.DB  0xD,0x0,0xF,0x0
_0x75:
	.DB  0x8,0x0,0x1,0x0,0x2,0x0,0x4,0x0
	.DB  0x8,0x0,0x4,0x0,0x2,0x0,0x1,0x0
	.DB  0x8,0x0,0x8,0x0,0x1,0x0,0x2,0x0
	.DB  0x4,0x0,0x8,0x0,0x4,0x0,0x2,0x0
	.DB  0x1,0x0,0x8,0x0,0x8,0x0,0x1,0x0
	.DB  0x2,0x0,0x4,0x0,0x8,0x0,0x4,0x0
	.DB  0x2,0x0,0x1,0x0,0x8,0x0,0x8,0x0
	.DB  0x1,0x0,0x2,0x0,0x4,0x0,0x8,0x0
	.DB  0x4,0x0,0x2,0x0,0x1,0x0,0x8,0x0
	.DB  0x8,0x0,0x1,0x0,0x2,0x0,0x4,0x0
	.DB  0x8,0x0,0x4,0x0,0x2,0x0,0x1,0x0
	.DB  0x8,0x0
_0x7C:
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0xF,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0xF,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0xF,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0xF,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0xF,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0xF,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0xF,0x0
	.DB  0x8,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0xF,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0xF,0x0,0x8,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0xF,0x0,0x8,0x0,0x8,0x0
	.DB  0x8,0x0,0x8,0x0
_0x81:
	.DB  0x32,0x0,0x2C,0x1,0x6,0x0,0x64,0x0

__GLOBAL_INI_TBL:
	.DW  0x08
	.DW  0x06
	.DW  _0x81*2

_0xFFFFFFFF:
	.DW  0

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,(14-2)+1
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(__CLEAR_SRAM_SIZE)
	LDI  R25,HIGH(__CLEAR_SRAM_SIZE)
	LDI  R26,__SRAM_START
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;HARDWARE STACK POINTER INITIALIZATION
	LDI  R30,LOW(__SRAM_END-__HEAP_SIZE)
	OUT  SPL,R30
	LDI  R30,HIGH(__SRAM_END-__HEAP_SIZE)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(__SRAM_START+__DSTACK_SIZE)
	LDI  R29,HIGH(__SRAM_START+__DSTACK_SIZE)

	RJMP _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x260

	.CSEG
;/*****************************************************
;This program was produced by the
;CodeWizardAVR V2.05.0 Professional
;Automatic Program Generator
; Copyright 1998-2010 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;
;Project : zvezda
;Version : luchshaay
;Date    : 12.12.2018
;Author  : Serzh
;Company :
;Comments:
;
;
;Chip type               : ATmega8
;Program type            : Application
;AVR Core Clock frequency: 8,000000 MHz
;Memory model            : Small
;External RAM size       : 0
;Data Stack size         : 256
;*****************************************************/
;
;/*      Danko,   .
;https://radiokot.ru/forum/viewtopic.php?f=57&t=21235   */
;
;#include <mega8.h>
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x80
	.EQU __sm_mask=0x70
	.EQU __sm_powerdown=0x20
	.EQU __sm_powersave=0x30
	.EQU __sm_standby=0x60
	.EQU __sm_ext_standby=0x70
	.EQU __sm_adc_noise_red=0x10
	.SET power_ctrl_reg=mcucr
	#endif
;
;#include <delay.h>
;
;unsigned char digit_out[5], //   (  0  4 a)
;                   cur_dig; // .  ()
;
;unsigned int  ff=50,    //   c 
;              f=300,    //  
;              h=6,      //   
;              z=100,    // ms    
;              yarkost;  // 
;
;
;static flash unsigned char digits[] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
;
;
;
;
;
;
;// ---------------- Timer 2 overflow interrupt service routine -----------------------------
;
;
;interrupt [TIM2_OVF] void timer2_ovf_isr(void){
; 0000 0033 interrupt [5] void timer2_ovf_isr(void){

	.CSEG
_timer2_ovf_isr:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R26
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
; 0000 0034 
; 0000 0035      PORTC&=0b00000000;                  //   ( - off)
	IN   R30,0x15
	ANDI R30,LOW(0x0)
	OUT  0x15,R30
; 0000 0036 
; 0000 0037      PORTD=~digits[digit_out[cur_dig]];
	MOV  R30,R5
	LDI  R31,0
	SUBI R30,LOW(-_digit_out)
	SBCI R31,HIGH(-_digit_out)
	LD   R30,Z
	LDI  R31,0
	SUBI R30,LOW(-_digits_G000*2)
	SBCI R31,HIGH(-_digits_G000*2)
	LPM  R30,Z
	COM  R30
	OUT  0x12,R30
; 0000 0038 
; 0000 0039      PORTC |= (1<<cur_dig);            //    (  - on)
	IN   R1,21
	MOV  R30,R5
	LDI  R26,LOW(1)
	RCALL __LSLB12
	OR   R30,R1
	OUT  0x15,R30
; 0000 003A 
; 0000 003B          cur_dig++; if (cur_dig >= 5) {
	INC  R5
	LDI  R30,LOW(5)
	CP   R5,R30
	BRLO _0x3
; 0000 003C         cur_dig = 0;
	CLR  R5
; 0000 003D        OCR2 = yarkost;
	LDS  R30,_yarkost
	OUT  0x23,R30
; 0000 003E     }
; 0000 003F 
; 0000 0040 }// ----------------------------------------------------------------------------------------
_0x3:
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R26,Y+
	LD   R1,Y+
	LD   R0,Y+
	RETI
;
;// ------------------ Timer2 output compare interrupt service routine ----------------------
;
;interrupt [TIM2_COMP] void timer2_comp_isr(void){
; 0000 0044 interrupt [4] void timer2_comp_isr(void){
_timer2_comp_isr:
	ST   -Y,R30
	IN   R30,SREG
	ST   -Y,R30
; 0000 0045    PORTC&=0b00000000;
	IN   R30,0x15
	ANDI R30,LOW(0x0)
	OUT  0x15,R30
; 0000 0046  //  PORTD=0b11111111;
; 0000 0047 
; 0000 0048 
; 0000 0049 }// ----------------------------------------------------------------------------------------
	LD   R30,Y+
	OUT  SREG,R30
	LD   R30,Y+
	RETI
;
;// ----------------------------------------------------------------------------------------
;
;void view_pauza(void) {
; 0000 004D void view_pauza(void) {
_view_pauza:
; 0000 004E 
; 0000 004F     yarkost=255;
	RCALL SUBOPT_0x0
; 0000 0050 
; 0000 0051     digit_out[0] = 15;
	RCALL SUBOPT_0x1
; 0000 0052     digit_out[1] = 15;
; 0000 0053     digit_out[2] = 15;
; 0000 0054     digit_out[3] = 15;
; 0000 0055     digit_out[4] = 15;
; 0000 0056 
; 0000 0057            while(yarkost<0xFF)
_0x4:
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x3
	BRSH _0x6
; 0000 0058             {
; 0000 0059             yarkost++;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x5
; 0000 005A             delay_ms(5);
; 0000 005B             }
	RJMP _0x4
_0x6:
; 0000 005C                  while(yarkost>0)
_0x7:
	RCALL SUBOPT_0x6
	BRSH _0x9
; 0000 005D             { yarkost--;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x7
; 0000 005E              delay_ms(5);
; 0000 005F             }
	RJMP _0x7
_0x9:
; 0000 0060 
; 0000 0061        delay_ms(z);
	RJMP _0x2000003
; 0000 0062        }
;// ----------------------------------------------------------------------------------------
;
;void view_pauza_1(void) {
; 0000 0065 void view_pauza_1(void) {
_view_pauza_1:
; 0000 0066 
; 0000 0067     yarkost=0;
	LDI  R30,LOW(0)
	STS  _yarkost,R30
	STS  _yarkost+1,R30
; 0000 0068 
; 0000 0069     digit_out[0] = 15;
	RCALL SUBOPT_0x1
; 0000 006A     digit_out[1] = 15;
; 0000 006B     digit_out[2] = 15;
; 0000 006C     digit_out[3] = 15;
; 0000 006D     digit_out[4] = 15;
; 0000 006E 
; 0000 006F            while(yarkost<0xFF)
_0xA:
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x3
	BRSH _0xC
; 0000 0070             {
; 0000 0071             yarkost++;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x5
; 0000 0072             delay_ms(5);
; 0000 0073             }
	RJMP _0xA
_0xC:
; 0000 0074                  while(yarkost>0)
_0xD:
	RCALL SUBOPT_0x6
	BRSH _0xF
; 0000 0075             { yarkost--;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x7
; 0000 0076              delay_ms(5);
; 0000 0077             }
	RJMP _0xD
_0xF:
; 0000 0078 
; 0000 0079        delay_ms(z);
_0x2000003:
	ST   -Y,R13
	ST   -Y,R12
	RCALL _delay_ms
; 0000 007A        }
	RET
;
;// ----------------------------------------------------------------------------------------
;void view_yarkost(void) {
; 0000 007D void view_yarkost(void) {
_view_yarkost:
; 0000 007E 
; 0000 007F             while(yarkost<0xFF)
_0x10:
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x3
	BRSH _0x12
; 0000 0080             {
; 0000 0081             yarkost+=5;
	RCALL SUBOPT_0x8
	ADIW R30,5
	RCALL SUBOPT_0x9
; 0000 0082             delay_ms(3);
; 0000 0083             }
	RJMP _0x10
_0x12:
; 0000 0084              while(yarkost>0)
_0x13:
	RCALL SUBOPT_0x6
	BRSH _0x15
; 0000 0085             {
; 0000 0086             yarkost-=5;
	RCALL SUBOPT_0x8
	SBIW R30,5
	RCALL SUBOPT_0x9
; 0000 0087             delay_ms(3);
; 0000 0088             }
	RJMP _0x13
_0x15:
; 0000 0089  }
	RET
;// ----------------------------------------------------------------------------------------
;
;// ----------------------------------------------------------------------------------------
;void view_yarkost_ubyvanie(void) {
; 0000 008D void view_yarkost_ubyvanie(void) {
_view_yarkost_ubyvanie:
; 0000 008E 
; 0000 008F 
; 0000 0090              while(yarkost>0)
_0x16:
	RCALL SUBOPT_0x6
	BRSH _0x18
; 0000 0091             {
; 0000 0092             yarkost-=5;
	RCALL SUBOPT_0x8
	SBIW R30,5
	RCALL SUBOPT_0x9
; 0000 0093             delay_ms(3);
; 0000 0094             }
	RJMP _0x16
_0x18:
; 0000 0095  }
	RET
;// ----------------------------------------------------------------------------------------
;
;void view_flasher(void) {
; 0000 0098 void view_flasher(void) {
_view_flasher:
; 0000 0099      int j;
; 0000 009A 
; 0000 009B    for (j =0; j<h;++j){
	RCALL __SAVELOCR2
;	j -> R16,R17
	RCALL SUBOPT_0xA
_0x1A:
	__CPWRR 16,17,10,11
	BRSH _0x1B
; 0000 009C 
; 0000 009D 
; 0000 009E 
; 0000 009F     digit_out[0] = 15;
	RCALL SUBOPT_0x1
; 0000 00A0     digit_out[1] = 15;
; 0000 00A1     digit_out[2] = 15;
; 0000 00A2     digit_out[3] = 15;
; 0000 00A3     digit_out[4] = 15;
; 0000 00A4 
; 0000 00A5              while(yarkost<0xFF)
_0x1C:
	RCALL SUBOPT_0x2
	RCALL SUBOPT_0x3
	BRSH _0x1E
; 0000 00A6             {
; 0000 00A7             yarkost++;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x5
; 0000 00A8             delay_ms(5);
; 0000 00A9             }
	RJMP _0x1C
_0x1E:
; 0000 00AA               delay_ms(400);
	LDI  R30,LOW(400)
	LDI  R31,HIGH(400)
	RCALL SUBOPT_0xB
; 0000 00AB              while(yarkost>0)
_0x1F:
	RCALL SUBOPT_0x6
	BRSH _0x21
; 0000 00AC             { yarkost--;
	RCALL SUBOPT_0x4
	RCALL SUBOPT_0x7
; 0000 00AD              delay_ms(5);
; 0000 00AE             }
	RJMP _0x1F
_0x21:
; 0000 00AF 
; 0000 00B0         delay_ms(ff);
	RCALL SUBOPT_0xC
; 0000 00B1      }
	RCALL SUBOPT_0xD
	RJMP _0x1A
_0x1B:
; 0000 00B2 
; 0000 00B3   }
	RCALL __LOADLOCR2P
	RET
;
;
;// ----------------------------------------------------------------------------------------
;
;void view_flasher_1(void) {
; 0000 00B8 void view_flasher_1(void) {
_view_flasher_1:
; 0000 00B9      int i,j;
; 0000 00BA    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x23:
	RCALL SUBOPT_0xF
	BRSH _0x24
; 0000 00BB 
; 0000 00BC    for (i =0; i<9;++i){
	RCALL SUBOPT_0xA
_0x26:
	__CPWRN 16,17,9
	BRGE _0x27
; 0000 00BD 
; 0000 00BE      unsigned int A[] = {8,5,2,5,8,5,2,5,8};
; 0000 00BF      unsigned int B[] = {8,5,2,5,8,5,2,5,8};
; 0000 00C0      unsigned int C[] = {8,5,2,5,8,5,2,5,8};
; 0000 00C1      unsigned int D[] = {8,5,2,5,8,5,2,5,8};
; 0000 00C2      unsigned int E[] = {8,5,2,5,8,5,2,5,8};
; 0000 00C3 
; 0000 00C4     digit_out[0] = A[i];
	RCALL SUBOPT_0x10
	LDI  R30,LOW(_0x28*2)
	LDI  R31,HIGH(_0x28*2)
	RCALL __INITLOCB
;	A -> Y+72
;	B -> Y+54
;	C -> Y+36
;	D -> Y+18
;	E -> Y+0
	RCALL SUBOPT_0x11
	RCALL SUBOPT_0x12
; 0000 00C5     digit_out[1] = B[i];
	RCALL SUBOPT_0x13
; 0000 00C6     digit_out[2] = C[i];
; 0000 00C7     digit_out[3] = D[i];
; 0000 00C8     digit_out[4] = E[i];
; 0000 00C9 
; 0000 00CA         view_yarkost();
; 0000 00CB         delay_ms(ff);
; 0000 00CC      }
	ADIW R28,63
	ADIW R28,27
	RCALL SUBOPT_0xD
	RJMP _0x26
_0x27:
; 0000 00CD 
; 0000 00CE   }
	RCALL SUBOPT_0x14
	RJMP _0x23
_0x24:
; 0000 00CF   view_pauza();
	RCALL _view_pauza
; 0000 00D0 }
	RJMP _0x2000002
;
;
;// ----------------------------------------------------------------------------------------
;
;void view_flasher_2(void) {
; 0000 00D5 void view_flasher_2(void) {
_view_flasher_2:
; 0000 00D6      int i,j;
; 0000 00D7    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x2A:
	RCALL SUBOPT_0xF
	BRSH _0x2B
; 0000 00D8 
; 0000 00D9    for (i =0; i<15;++i){
	RCALL SUBOPT_0xA
_0x2D:
	__CPWRN 16,17,15
	BRGE _0x2E
; 0000 00DA 
; 0000 00DB      unsigned int A[] = {15,15,15,15,15, 0, 0, 0, 0,0,15,15,15,15,15,0};
; 0000 00DC      unsigned int B[] = { 0,15,15,15,15,15, 0, 0, 0,0, 0,15,15,15,15,0};
; 0000 00DD      unsigned int C[] = { 0, 0,15,15,15,15,15, 0, 0,0, 0, 0,15,15,15,0};
; 0000 00DE      unsigned int D[] = { 0, 0, 0,15,15,15,15,15, 0,0, 0, 0, 0,15,15,0};
; 0000 00DF      unsigned int E[] = { 0, 0, 0, 0,15,15,15,15,15,0, 0, 0, 0, 0,15,0};
; 0000 00E0 
; 0000 00E1 
; 0000 00E2     digit_out[0] = A[i];
	SBIW R28,63
	SBIW R28,63
	SBIW R28,34
	LDI  R24,160
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x2F*2)
	LDI  R31,HIGH(_0x2F*2)
	RCALL __INITLOCB
;	A -> Y+128
;	B -> Y+96
;	C -> Y+64
;	D -> Y+32
;	E -> Y+0
	MOVW R30,R16
	MOVW R26,R28
	SUBI R26,LOW(-(128))
	SBCI R27,HIGH(-(128))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x12
; 0000 00E3     digit_out[1] = B[i];
	MOVW R26,R28
	SUBI R26,LOW(-(96))
	SBCI R27,HIGH(-(96))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 00E4     digit_out[2] = C[i];
	MOVW R26,R28
	SUBI R26,LOW(-(64))
	SBCI R27,HIGH(-(64))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 00E5     digit_out[3] = D[i];
	MOVW R26,R28
	ADIW R26,32
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 00E6     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 00E7 
; 0000 00E8         yarkost=255;
; 0000 00E9         delay_ms(f);
	RCALL SUBOPT_0x1B
; 0000 00EA     }
	ADIW R28,63
	ADIW R28,63
	ADIW R28,34
	RCALL SUBOPT_0xD
	RJMP _0x2D
_0x2E:
; 0000 00EB  }
	RCALL SUBOPT_0x14
	RJMP _0x2A
_0x2B:
; 0000 00EC        view_pauza();
	RCALL _view_pauza
; 0000 00ED    }
	RJMP _0x2000002
;
;   // ----------------------------------------------------------------------------------------
;
;void view_flasher_3(void) {
; 0000 00F1 void view_flasher_3(void) {
_view_flasher_3:
; 0000 00F2      int i,j;
; 0000 00F3    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x31:
	RCALL SUBOPT_0xF
	BRSH _0x32
; 0000 00F4 
; 0000 00F5    for (i =0; i<22;++i){
	RCALL SUBOPT_0xA
_0x34:
	__CPWRN 16,17,22
	BRGE _0x35
; 0000 00F6 
; 0000 00F7      unsigned int A[] = {0,0,8,12,14,15,15,15,15,15 ,15,15,15,15,15,15,14,12, 8,0,0,0};
; 0000 00F8      unsigned int B[] = {2,7,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,7,2,0};
; 0000 00F9      unsigned int C[] = {0,0,0,1,3,7,15,15,15,15    ,15,15,15,15,15, 7 ,3 ,1 ,0,0,0,0};
; 0000 00FA      unsigned int D[] = {0,0,0,0,0,0,0,1,3,7        ,15,7,  3, 1 ,0 ,0 ,0 ,0 ,0,0,0,0};
; 0000 00FB      unsigned int E[] = {0,0,0,0,0,0,8,12,14,15     ,15,15,14,12 ,8 ,0 ,0 ,0 ,0,0,0,0};
; 0000 00FC 
; 0000 00FD 
; 0000 00FE     digit_out[0] = A[i];
	SBIW R28,63
	SBIW R28,63
	SBIW R28,63
	SBIW R28,31
	LDI  R24,220
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x36*2)
	LDI  R31,HIGH(_0x36*2)
	RCALL __INITLOCB
;	A -> Y+176
;	B -> Y+132
;	C -> Y+88
;	D -> Y+44
;	E -> Y+0
	MOVW R30,R16
	MOVW R26,R28
	SUBI R26,LOW(-(176))
	SBCI R27,HIGH(-(176))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x12
; 0000 00FF     digit_out[1] = B[i];
	MOVW R26,R28
	SUBI R26,LOW(-(132))
	SBCI R27,HIGH(-(132))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 0100     digit_out[2] = C[i];
	MOVW R26,R28
	SUBI R26,LOW(-(88))
	SBCI R27,HIGH(-(88))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 0101     digit_out[3] = D[i];
	MOVW R26,R28
	ADIW R26,44
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 0102     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 0103 
; 0000 0104         yarkost=255;
; 0000 0105         delay_ms(200);
	LDI  R30,LOW(200)
	LDI  R31,HIGH(200)
	RCALL SUBOPT_0xB
; 0000 0106     }
	ADIW R28,63
	ADIW R28,63
	ADIW R28,63
	ADIW R28,31
	RCALL SUBOPT_0xD
	RJMP _0x34
_0x35:
; 0000 0107 
; 0000 0108   }
	RCALL SUBOPT_0x14
	RJMP _0x31
_0x32:
; 0000 0109    view_pauza_1();
	RJMP _0x2000001
; 0000 010A }
;
;   // ----------------------------------------------------------------------------------------
;
;void view_flasher_4(void) {
; 0000 010E void view_flasher_4(void) {
_view_flasher_4:
; 0000 010F      int i,j;
; 0000 0110    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x38:
	RCALL SUBOPT_0xF
	BRSH _0x39
; 0000 0111 
; 0000 0112    for (i =0; i<5;++i){
	RCALL SUBOPT_0xA
_0x3B:
	__CPWRN 16,17,5
	BRGE _0x3C
; 0000 0113 
; 0000 0114      unsigned int A[] = {15, 8, 0,15, 8};
; 0000 0115      unsigned int B[] = { 8,15, 8, 0,15};
; 0000 0116      unsigned int C[] = {15, 8,15, 8, 0};
; 0000 0117      unsigned int D[] = { 0,15, 8,15, 8};
; 0000 0118      unsigned int E[] = { 8, 0,15, 8,15};
; 0000 0119 
; 0000 011A 
; 0000 011B     digit_out[0] = A[i];
	SBIW R28,50
	LDI  R24,50
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x3D*2)
	LDI  R31,HIGH(_0x3D*2)
	RCALL __INITLOCB
;	A -> Y+40
;	B -> Y+30
;	C -> Y+20
;	D -> Y+10
;	E -> Y+0
	RCALL SUBOPT_0x1C
	RCALL SUBOPT_0x12
; 0000 011C     digit_out[1] = B[i];
	MOVW R26,R28
	ADIW R26,30
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 011D     digit_out[2] = C[i];
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x18
; 0000 011E     digit_out[3] = D[i];
	MOVW R26,R28
	ADIW R26,10
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 011F     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 0120 
; 0000 0121         yarkost=255;
; 0000 0122         delay_ms(f);
	RCALL SUBOPT_0x1B
; 0000 0123     }
	ADIW R28,50
	RCALL SUBOPT_0xD
	RJMP _0x3B
_0x3C:
; 0000 0124 
; 0000 0125   }
	RCALL SUBOPT_0x14
	RJMP _0x38
_0x39:
; 0000 0126    view_pauza();
	RCALL _view_pauza
; 0000 0127 }
	RJMP _0x2000002
;
;
;   // ----------------------------------------------------------------------------------------
;
;void view_flasher_5(void) {
; 0000 012C void view_flasher_5(void) {
_view_flasher_5:
; 0000 012D      int i,j;
; 0000 012E    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x3F:
	RCALL SUBOPT_0xF
	BRSH _0x40
; 0000 012F 
; 0000 0130    for (i =0; i<18;++i){
	RCALL SUBOPT_0xA
_0x42:
	__CPWRN 16,17,18
	BRGE _0x43
; 0000 0131 
; 0000 0132      unsigned int A[] = {8,8,8,8,8,13,13,13,13,13,15,15,15,15,15,13,8,0};
; 0000 0133      unsigned int B[] = {0,8,8,8,8, 8,13,13,13,13,13,15,15,15,15,13,8,0};
; 0000 0134      unsigned int C[] = {0,0,8,8,8, 8, 8,13,13,13,13,13,15,15,15,13,8,0};
; 0000 0135      unsigned int D[] = {0,0,0,8,8, 8, 8, 8,13,13,13,13,13,15,15,13,8,0};
; 0000 0136      unsigned int E[] = {0,0,0,0,8, 8, 8, 8, 8,13,13,13,13,13,15,13,8,0};
; 0000 0137 
; 0000 0138 
; 0000 0139     digit_out[0] = A[i];
	SBIW R28,63
	SBIW R28,63
	SBIW R28,54
	LDI  R24,180
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x44*2)
	LDI  R31,HIGH(_0x44*2)
	RCALL __INITLOCB
;	A -> Y+144
;	B -> Y+108
;	C -> Y+72
;	D -> Y+36
;	E -> Y+0
	MOVW R30,R16
	MOVW R26,R28
	SUBI R26,LOW(-(144))
	SBCI R27,HIGH(-(144))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x12
; 0000 013A     digit_out[1] = B[i];
	MOVW R26,R28
	SUBI R26,LOW(-(108))
	SBCI R27,HIGH(-(108))
	RCALL SUBOPT_0x16
	__PUTB1MN _digit_out,1
; 0000 013B     digit_out[2] = C[i];
	RCALL SUBOPT_0x11
	RCALL SUBOPT_0x18
; 0000 013C     digit_out[3] = D[i];
	RCALL SUBOPT_0x1E
	RCALL SUBOPT_0x19
; 0000 013D     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 013E 
; 0000 013F         yarkost=255;
; 0000 0140         delay_ms(f);
	RCALL SUBOPT_0x1B
; 0000 0141     }
	ADIW R28,63
	ADIW R28,63
	ADIW R28,54
	RCALL SUBOPT_0xD
	RJMP _0x42
_0x43:
; 0000 0142 
; 0000 0143   }
	RCALL SUBOPT_0x14
	RJMP _0x3F
_0x40:
; 0000 0144    view_pauza_1();
	RJMP _0x2000001
; 0000 0145 }
;
;
;   // ----------------------------------------------------------------------------------------
;
;void view_flasher_6(void) {
; 0000 014A void view_flasher_6(void) {
_view_flasher_6:
; 0000 014B      int i,j;
; 0000 014C    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x46:
	RCALL SUBOPT_0xF
	BRSH _0x47
; 0000 014D 
; 0000 014E    for (i =0; i<10;++i){
	RCALL SUBOPT_0xA
_0x49:
	__CPWRN 16,17,10
	BRGE _0x4A
; 0000 014F 
; 0000 0150      unsigned int A[] = {14,8,0,0,0,0,0,0,0,3};
; 0000 0151      unsigned int B[] = {0,3,14,8,0,0,0,0,0,0};
; 0000 0152      unsigned int C[] = {0,0,0,3,14,8,0,0,0,0};
; 0000 0153      unsigned int D[] = {0,0,0,0,0,3,14,8,0,0};
; 0000 0154      unsigned int E[] = {0,0,0,0,0,0,0,3,14,8};
; 0000 0155 
; 0000 0156 
; 0000 0157     digit_out[0] = A[i];
	RCALL SUBOPT_0x1F
	LDI  R30,LOW(_0x4B*2)
	LDI  R31,HIGH(_0x4B*2)
	RCALL __INITLOCB
;	A -> Y+80
;	B -> Y+60
;	C -> Y+40
;	D -> Y+20
;	E -> Y+0
	RCALL SUBOPT_0x20
	RCALL SUBOPT_0x12
; 0000 0158     digit_out[1] = B[i];
	MOVW R26,R28
	ADIW R26,60
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 0159     digit_out[2] = C[i];
	MOVW R26,R28
	ADIW R26,40
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 015A     digit_out[3] = D[i];
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x19
; 0000 015B     digit_out[4] = E[i];
	RCALL SUBOPT_0x21
; 0000 015C 
; 0000 015D         view_yarkost();
; 0000 015E         delay_ms(ff);
; 0000 015F     }
	ADIW R28,63
	ADIW R28,37
	RCALL SUBOPT_0xD
	RJMP _0x49
_0x4A:
; 0000 0160 
; 0000 0161   }
	RCALL SUBOPT_0x14
	RJMP _0x46
_0x47:
; 0000 0162    view_pauza_1();
	RJMP _0x2000001
; 0000 0163 }
;
;  // ----------------------------------------------------------------------------------------
;void view_flasher_7(void) {
; 0000 0166 void view_flasher_7(void) {
_view_flasher_7:
; 0000 0167      int i,j;
; 0000 0168    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x4D:
	RCALL SUBOPT_0xF
	BRSH _0x4E
; 0000 0169 
; 0000 016A    for (i =0; i<40;++i){
	RCALL SUBOPT_0xA
_0x50:
	__CPWRN 16,17,40
	BRGE _0x51
; 0000 016B 
; 0000 016C      unsigned int A[] = {2,0,0,0,0,0,1,4,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,8,0,0,0,0,0,0,0,0,4,1,0,0,0,0,2};
; 0000 016D      unsigned int B[] = {0,2,0,0,0,0,0,0,1,4,0,0,0,0,0,0,0,8,0,0,0,0,8,0,0,0,0,0,0,0,4,1,0,0,0,0,0,2,0};
; 0000 016E      unsigned int C[] = {0,0,2,0,0,0,0,0,0,0,1,4,0,0,0,0,0,0,8,0,0,8,0,0,0,0,0,0,4,1,0,0,0,0,0,0,2,0,0};
; 0000 016F      unsigned int D[] = {0,0,0,2,0,0,0,0,0,0,0,0,1,4,0,0,0,0,0,8,8,0,0,0,0,0,4,1,0,0,0,0,0,0,0,2,0,0,0};
; 0000 0170      unsigned int E[] = {0,0,0,0,2,4,0,0,0,0,0,0,0,0,1,8,0,0,0,0,0,0,0,0,8,1,0,0,0,0,0,0,0,0,2,0,0,0,0};
; 0000 0171 
; 0000 0172 
; 0000 0173     digit_out[0] = A[i];
	SBIW R28,63
	SBIW R28,63
	SBIW R28,8
	SUBI R29,1
	__GETWRN 24,25,390
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x52*2)
	LDI  R31,HIGH(_0x52*2)
	RCALL __INITLOCW
;	A -> Y+312
;	B -> Y+234
;	C -> Y+156
;	D -> Y+78
;	E -> Y+0
	MOVW R30,R16
	MOVW R26,R28
	SUBI R26,LOW(-(312))
	SBCI R27,HIGH(-(312))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x12
; 0000 0174     digit_out[1] = B[i];
	MOVW R26,R28
	SUBI R26,LOW(-(234))
	SBCI R27,HIGH(-(234))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 0175     digit_out[2] = C[i];
	MOVW R26,R28
	SUBI R26,LOW(-(156))
	SBCI R27,HIGH(-(156))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 0176     digit_out[3] = D[i];
	MOVW R26,R28
	SUBI R26,LOW(-(78))
	SBCI R27,HIGH(-(78))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 0177     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 0178 
; 0000 0179         yarkost=255;
; 0000 017A         delay_ms(80);
	LDI  R30,LOW(80)
	LDI  R31,HIGH(80)
	RCALL SUBOPT_0xB
; 0000 017B     }
	ADIW R28,63
	ADIW R28,63
	ADIW R28,8
	SUBI R29,-1
	RCALL SUBOPT_0xD
	RJMP _0x50
_0x51:
; 0000 017C 
; 0000 017D   }
	RCALL SUBOPT_0x14
	RJMP _0x4D
_0x4E:
; 0000 017E    view_pauza_1();
	RJMP _0x2000001
; 0000 017F }
;
;  // ----------------------------------------------------------------------------------------
;
;void view_flasher_8(void) {
; 0000 0183 void view_flasher_8(void) {
_view_flasher_8:
; 0000 0184      int i,j;
; 0000 0185    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x54:
	RCALL SUBOPT_0xF
	BRSH _0x55
; 0000 0186 
; 0000 0187    for (i =0; i<25;++i){
	RCALL SUBOPT_0xA
_0x57:
	__CPWRN 16,17,25
	BRGE _0x58
; 0000 0188 
; 0000 0189      unsigned int A[] = {0,8,8,14,15,0,0,0,0,0,0,0,0,8,8,8,8,8,8,8,8,8,14,15,15};
; 0000 018A      unsigned int B[] = {14,15,15,15,15,0,0,0,0,8,12,14,15,15,15,15,15,15,15,15,15,15,15,15,15};
; 0000 018B      unsigned int C[] = {8,8,14,15,15,0,0,0,8,8,8,8,8,8,8,8,8,8,8,12,14,15,15,15,15};
; 0000 018C      unsigned int D[] = {3,3,11,11,15,0,2,3,3,3,3,3,3,3,3,3,3,3,11,11,11,11,11,11,15};
; 0000 018D      unsigned int E[] = {0,14,15,15,15,0,0,0,0,0,0,0,0,0,8,12,14,15,15,15,15,15,15,15,15};
; 0000 018E 
; 0000 018F 
; 0000 0190     digit_out[0] = A[i];
	SBIW R28,63
	SBIW R28,63
	SBIW R28,63
	SBIW R28,61
	LDI  R24,250
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x59*2)
	LDI  R31,HIGH(_0x59*2)
	RCALL __INITLOCB
;	A -> Y+200
;	B -> Y+150
;	C -> Y+100
;	D -> Y+50
;	E -> Y+0
	MOVW R30,R16
	MOVW R26,R28
	SUBI R26,LOW(-(200))
	SBCI R27,HIGH(-(200))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x12
; 0000 0191     digit_out[1] = B[i];
	MOVW R26,R28
	SUBI R26,LOW(-(150))
	SBCI R27,HIGH(-(150))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 0192     digit_out[2] = C[i];
	MOVW R26,R28
	SUBI R26,LOW(-(100))
	SBCI R27,HIGH(-(100))
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 0193     digit_out[3] = D[i];
	MOVW R26,R28
	ADIW R26,50
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 0194     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 0195 
; 0000 0196         yarkost=255;
; 0000 0197         delay_ms(f);
	RCALL SUBOPT_0x1B
; 0000 0198     }
	ADIW R28,63
	ADIW R28,63
	ADIW R28,63
	ADIW R28,61
	RCALL SUBOPT_0xD
	RJMP _0x57
_0x58:
; 0000 0199 
; 0000 019A   }
	RCALL SUBOPT_0x14
	RJMP _0x54
_0x55:
; 0000 019B    view_pauza();
	RCALL _view_pauza
; 0000 019C }
	RJMP _0x2000002
;
;  // ----------------------------------------------------------------------------------------
;
;void view_flasher_9(void) {
; 0000 01A0 void view_flasher_9(void) {
_view_flasher_9:
; 0000 01A1      int i,j;
; 0000 01A2    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x5B:
	RCALL SUBOPT_0xF
	BRSH _0x5C
; 0000 01A3 
; 0000 01A4    for (i =0; i<6;++i){
	RCALL SUBOPT_0xA
_0x5E:
	__CPWRN 16,17,6
	BRGE _0x5F
; 0000 01A5 
; 0000 01A6      unsigned int A[] = {8,5,2,8,5,2};
; 0000 01A7      unsigned int B[] = {8,5,2,8,5,2};
; 0000 01A8      unsigned int C[] = {8,5,2,8,5,2};
; 0000 01A9      unsigned int D[] = {8,5,2,8,5,2};
; 0000 01AA      unsigned int E[] = {8,5,2,8,5,2};
; 0000 01AB 
; 0000 01AC 
; 0000 01AD     digit_out[0] = A[i];
	SBIW R28,60
	LDI  R24,60
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x60*2)
	LDI  R31,HIGH(_0x60*2)
	RCALL __INITLOCB
;	A -> Y+48
;	B -> Y+36
;	C -> Y+24
;	D -> Y+12
;	E -> Y+0
	RCALL SUBOPT_0x22
	RCALL SUBOPT_0x12
; 0000 01AE     digit_out[1] = B[i];
	RCALL SUBOPT_0x1E
	RCALL SUBOPT_0x17
; 0000 01AF     digit_out[2] = C[i];
	MOVW R26,R28
	ADIW R26,24
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 01B0     digit_out[3] = D[i];
	MOVW R26,R28
	ADIW R26,12
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 01B1     digit_out[4] = E[i];
	RCALL SUBOPT_0x21
; 0000 01B2 
; 0000 01B3 
; 0000 01B4         view_yarkost();
; 0000 01B5         delay_ms(ff);
; 0000 01B6     }
	ADIW R28,60
	RCALL SUBOPT_0xD
	RJMP _0x5E
_0x5F:
; 0000 01B7 
; 0000 01B8   }
	RCALL SUBOPT_0x14
	RJMP _0x5B
_0x5C:
; 0000 01B9    view_pauza_1();
	RJMP _0x2000001
; 0000 01BA }
;
;  // ----------------------------------------------------------------------------------------
;
;void view_flasher_10(void) {
; 0000 01BE void view_flasher_10(void) {
_view_flasher_10:
; 0000 01BF      int i,j;
; 0000 01C0    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x62:
	RCALL SUBOPT_0xF
	BRSH _0x63
; 0000 01C1 
; 0000 01C2    for (i =0; i<5;++i){
	RCALL SUBOPT_0xA
_0x65:
	__CPWRN 16,17,5
	BRGE _0x66
; 0000 01C3 
; 0000 01C4      unsigned int A[] = {0, 0,8,5,2};
; 0000 01C5      unsigned int B[] = {2, 5,8,0,0};
; 0000 01C6      unsigned int C[] = {0, 0,8,5,2};
; 0000 01C7      unsigned int D[] = {12,3,0,0,0};
; 0000 01C8      unsigned int E[] = {1, 6,8,0,0};
; 0000 01C9 
; 0000 01CA 
; 0000 01CB     digit_out[0] = A[i];
	SBIW R28,50
	LDI  R24,50
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x67*2)
	LDI  R31,HIGH(_0x67*2)
	RCALL __INITLOCB
;	A -> Y+40
;	B -> Y+30
;	C -> Y+20
;	D -> Y+10
;	E -> Y+0
	RCALL SUBOPT_0x1C
	RCALL SUBOPT_0x12
; 0000 01CC     digit_out[1] = B[i];
	MOVW R26,R28
	ADIW R26,30
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 01CD     digit_out[2] = C[i];
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x18
; 0000 01CE     digit_out[3] = D[i];
	MOVW R26,R28
	ADIW R26,10
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 01CF     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 01D0 
; 0000 01D1         yarkost=255;
; 0000 01D2         delay_ms(f);
	RCALL SUBOPT_0x1B
; 0000 01D3     }
	ADIW R28,50
	RCALL SUBOPT_0xD
	RJMP _0x65
_0x66:
; 0000 01D4 
; 0000 01D5   }
	RCALL SUBOPT_0x14
	RJMP _0x62
_0x63:
; 0000 01D6    view_pauza();
	RCALL _view_pauza
; 0000 01D7 }
	RJMP _0x2000002
;
;  // ----------------------------------------------------------------------------------------
;
;void view_flasher_11(void) {
; 0000 01DB void view_flasher_11(void) {
_view_flasher_11:
; 0000 01DC      int i,j;
; 0000 01DD    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x69:
	RCALL SUBOPT_0xF
	BRSH _0x6A
; 0000 01DE 
; 0000 01DF    for (i =0; i<6;++i){
	RCALL SUBOPT_0xA
_0x6C:
	__CPWRN 16,17,6
	BRGE _0x6D
; 0000 01E0 
; 0000 01E1      unsigned int A[] = {0, 0,  0, 8,13,15};
; 0000 01E2      unsigned int B[] = {0, 2,  7,15,15,15};
; 0000 01E3      unsigned int C[] = {0, 0,  0, 8,13,15};
; 0000 01E4      unsigned int D[] = {0,12,15,15,15,15};
; 0000 01E5      unsigned int E[] = {0, 1,  7,15,15,15};
; 0000 01E6 
; 0000 01E7 
; 0000 01E8     digit_out[0] = A[i];
	SBIW R28,60
	LDI  R24,60
	RCALL SUBOPT_0x15
	LDI  R30,LOW(_0x6E*2)
	LDI  R31,HIGH(_0x6E*2)
	RCALL __INITLOCB
;	A -> Y+48
;	B -> Y+36
;	C -> Y+24
;	D -> Y+12
;	E -> Y+0
	RCALL SUBOPT_0x22
	RCALL SUBOPT_0x12
; 0000 01E9     digit_out[1] = B[i];
	RCALL SUBOPT_0x1E
	RCALL SUBOPT_0x17
; 0000 01EA     digit_out[2] = C[i];
	MOVW R26,R28
	ADIW R26,24
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 01EB     digit_out[3] = D[i];
	MOVW R26,R28
	ADIW R26,12
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x19
; 0000 01EC     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 01ED 
; 0000 01EE         yarkost=255;
; 0000 01EF         delay_ms(f);
	RCALL SUBOPT_0x1B
; 0000 01F0     }
	ADIW R28,60
	RCALL SUBOPT_0xD
	RJMP _0x6C
_0x6D:
; 0000 01F1 
; 0000 01F2   }
	RCALL SUBOPT_0x14
	RJMP _0x69
_0x6A:
; 0000 01F3    view_pauza();
	RCALL _view_pauza
; 0000 01F4 }
	RJMP _0x2000002
;
;// ----------------------------------------------------------------------------------------
;
;void view_flasher_12(void) {
; 0000 01F8 void view_flasher_12(void) {
_view_flasher_12:
; 0000 01F9      int i,j;
; 0000 01FA    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x70:
	RCALL SUBOPT_0xF
	BRSH _0x71
; 0000 01FB 
; 0000 01FC    for (i =0; i<9;++i){
	RCALL SUBOPT_0xA
_0x73:
	__CPWRN 16,17,9
	BRGE _0x74
; 0000 01FD 
; 0000 01FE      unsigned int A[] = {8,1,2,4,8,4,2,1,8};
; 0000 01FF      unsigned int B[] = {8,1,2,4,8,4,2,1,8};
; 0000 0200      unsigned int C[] = {8,1,2,4,8,4,2,1,8};
; 0000 0201      unsigned int D[] = {8,1,2,4,8,4,2,1,8};
; 0000 0202      unsigned int E[] = {8,1,2,4,8,4,2,1,8};
; 0000 0203 
; 0000 0204 
; 0000 0205     digit_out[0] = A[i];
	RCALL SUBOPT_0x10
	LDI  R30,LOW(_0x75*2)
	LDI  R31,HIGH(_0x75*2)
	RCALL __INITLOCB
;	A -> Y+72
;	B -> Y+54
;	C -> Y+36
;	D -> Y+18
;	E -> Y+0
	RCALL SUBOPT_0x11
	RCALL SUBOPT_0x12
; 0000 0206     digit_out[1] = B[i];
	RCALL SUBOPT_0x13
; 0000 0207     digit_out[2] = C[i];
; 0000 0208     digit_out[3] = D[i];
; 0000 0209     digit_out[4] = E[i];
; 0000 020A 
; 0000 020B         view_yarkost();
; 0000 020C         delay_ms(ff);
; 0000 020D     }
	ADIW R28,63
	ADIW R28,27
	RCALL SUBOPT_0xD
	RJMP _0x73
_0x74:
; 0000 020E 
; 0000 020F  }
	RCALL SUBOPT_0x14
	RJMP _0x70
_0x71:
; 0000 0210      view_pauza_1();
	RJMP _0x2000001
; 0000 0211    }
;  // ----------------------------------------------------------------------------------------
;
;void view_flasher_13(void) {
; 0000 0214 void view_flasher_13(void) {
_view_flasher_13:
; 0000 0215      int i,j;
; 0000 0216    for (j =0; j<h;++j){
	RCALL SUBOPT_0xE
;	i -> R16,R17
;	j -> R18,R19
_0x77:
	RCALL SUBOPT_0xF
	BRSH _0x78
; 0000 0217 
; 0000 0218    for (i =0; i<10;++i){
	RCALL SUBOPT_0xA
_0x7A:
	__CPWRN 16,17,10
	BRGE _0x7B
; 0000 0219 
; 0000 021A      unsigned int A[] = {15, 8, 8, 8, 8,15, 8, 8, 8, 8};
; 0000 021B      unsigned int B[] = { 8,15, 8, 8, 8, 8,15, 8, 8, 8};
; 0000 021C      unsigned int C[] = { 8, 8,15, 8, 8, 8, 8,15, 8, 8};
; 0000 021D      unsigned int D[] = { 8, 8, 8,15, 8, 8, 8, 8,15, 8};
; 0000 021E      unsigned int E[] = { 8, 8, 8, 8,15, 8, 8, 8, 8,15};
; 0000 021F 
; 0000 0220 
; 0000 0221     digit_out[0] = A[i];
	RCALL SUBOPT_0x1F
	LDI  R30,LOW(_0x7C*2)
	LDI  R31,HIGH(_0x7C*2)
	RCALL __INITLOCB
;	A -> Y+80
;	B -> Y+60
;	C -> Y+40
;	D -> Y+20
;	E -> Y+0
	RCALL SUBOPT_0x20
	RCALL SUBOPT_0x12
; 0000 0222     digit_out[1] = B[i];
	MOVW R26,R28
	ADIW R26,60
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x17
; 0000 0223     digit_out[2] = C[i];
	MOVW R26,R28
	ADIW R26,40
	RCALL SUBOPT_0x16
	RCALL SUBOPT_0x18
; 0000 0224     digit_out[3] = D[i];
	RCALL SUBOPT_0x1D
	RCALL SUBOPT_0x19
; 0000 0225     digit_out[4] = E[i];
	RCALL SUBOPT_0x1A
; 0000 0226 
; 0000 0227         yarkost=255;
; 0000 0228         view_yarkost_ubyvanie();
	RCALL _view_yarkost_ubyvanie
; 0000 0229         delay_ms(ff);
	RCALL SUBOPT_0xC
; 0000 022A     }
	ADIW R28,63
	ADIW R28,37
	RCALL SUBOPT_0xD
	RJMP _0x7A
_0x7B:
; 0000 022B 
; 0000 022C   }
	RCALL SUBOPT_0x14
	RJMP _0x77
_0x78:
; 0000 022D     view_pauza_1();
_0x2000001:
	RCALL _view_pauza_1
; 0000 022E    }
_0x2000002:
	RCALL __LOADLOCR4
	ADIW R28,4
	RET
;
;//===================================== main ==============================================
;
;// 
;void main(void){
; 0000 0233 void main(void){
_main:
; 0000 0234 
; 0000 0235    digit_out[0]=0;   //  
	LDI  R30,LOW(0)
	STS  _digit_out,R30
; 0000 0236    digit_out[1]=0;
	__PUTB1MN _digit_out,1
; 0000 0237    digit_out[2]=0;
	__PUTB1MN _digit_out,2
; 0000 0238    digit_out[3]=0;
	__PUTB1MN _digit_out,3
; 0000 0239    digit_out[4]=0;
	__PUTB1MN _digit_out,4
; 0000 023A 
; 0000 023B 
; 0000 023C // 
; 0000 023D PORTB=0b00000000;
	OUT  0x18,R30
; 0000 023E  DDRB=0b00000000;
	OUT  0x17,R30
; 0000 023F PORTC=0b00000000;   //  4    1
	OUT  0x15,R30
; 0000 0240  DDRC=0b00011111;   //  4    
	LDI  R30,LOW(31)
	OUT  0x14,R30
; 0000 0241 PORTD=0b00000000;  // D      0
	LDI  R30,LOW(0)
	OUT  0x12,R30
; 0000 0242  DDRD=0b00001111;  // D    
	LDI  R30,LOW(15)
	OUT  0x11,R30
; 0000 0243 
; 0000 0244 TCCR2=0x04;
	LDI  R30,LOW(4)
	OUT  0x25,R30
; 0000 0245 TIMSK=0b11000000;
	LDI  R30,LOW(192)
	OUT  0x39,R30
; 0000 0246 //              0b11000001
; 0000 0247 //                ||   | |
; 0000 0248 //                ||   | Timer0
; 0000 0249 //                ||   Timer1
; 0000 024A //                |Timer2
; 0000 024B //
; 0000 024C #asm("sei")   //   
	sei
; 0000 024D 
; 0000 024E // --------------------------------   ------------------------------------------
; 0000 024F  while (1) {
_0x7D:
; 0000 0250 
; 0000 0251 
; 0000 0252   view_flasher();
	RCALL _view_flasher
; 0000 0253   view_flasher_1();
	RCALL _view_flasher_1
; 0000 0254   view_flasher_2();
	RCALL _view_flasher_2
; 0000 0255   view_flasher_3();
	RCALL _view_flasher_3
; 0000 0256   view_flasher_4();
	RCALL _view_flasher_4
; 0000 0257   view_flasher_5();
	RCALL _view_flasher_5
; 0000 0258   view_flasher_6();
	RCALL _view_flasher_6
; 0000 0259   view_flasher_7();
	RCALL _view_flasher_7
; 0000 025A   view_flasher_8();
	RCALL _view_flasher_8
; 0000 025B   view_flasher_9();
	RCALL _view_flasher_9
; 0000 025C   view_flasher_10();
	RCALL _view_flasher_10
; 0000 025D   view_flasher_11();
	RCALL _view_flasher_11
; 0000 025E   view_flasher_12();
	RCALL _view_flasher_12
; 0000 025F   view_flasher_13();
	RCALL _view_flasher_13
; 0000 0260 
; 0000 0261  }; // -----------------------------   (end) ------------------------------------
	RJMP _0x7D
; 0000 0262 
; 0000 0263 } // =================================== end main ==========================================
_0x80:
	RJMP _0x80
;
;//
;// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- The End -=-=-=-=-=--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;//
;
;
;
;
;
;
;
;
;

	.DSEG
_digit_out:
	.BYTE 0x5
_yarkost:
	.BYTE 0x2

	.CSEG
;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:43 WORDS
SUBOPT_0x0:
	LDI  R30,LOW(255)
	LDI  R31,HIGH(255)
	STS  _yarkost,R30
	STS  _yarkost+1,R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:26 WORDS
SUBOPT_0x1:
	LDI  R30,LOW(15)
	STS  _digit_out,R30
	__PUTB1MN _digit_out,1
	__PUTB1MN _digit_out,2
	__PUTB1MN _digit_out,3
	__PUTB1MN _digit_out,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:22 WORDS
SUBOPT_0x2:
	LDS  R26,_yarkost
	LDS  R27,_yarkost+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x3:
	CPI  R26,LOW(0xFF)
	LDI  R30,HIGH(0xFF)
	CPC  R27,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:13 WORDS
SUBOPT_0x4:
	LDI  R26,LOW(_yarkost)
	LDI  R27,HIGH(_yarkost)
	LD   R30,X+
	LD   R31,X+
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x5:
	ADIW R30,1
	ST   -X,R31
	ST   -X,R30
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x6:
	RCALL SUBOPT_0x2
	RCALL __CPW02
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:12 WORDS
SUBOPT_0x7:
	SBIW R30,1
	ST   -X,R31
	ST   -X,R30
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x8:
	LDS  R30,_yarkost
	LDS  R31,_yarkost+1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x9:
	STS  _yarkost,R30
	STS  _yarkost+1,R31
	LDI  R30,LOW(3)
	LDI  R31,HIGH(3)
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 14 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0xA:
	__GETWRN 16,17,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0xB:
	ST   -Y,R31
	ST   -Y,R30
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0xC:
	ST   -Y,R7
	ST   -Y,R6
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 14 TIMES, CODE SIZE REDUCTION:11 WORDS
SUBOPT_0xD:
	__ADDWRN 16,17,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:22 WORDS
SUBOPT_0xE:
	RCALL __SAVELOCR4
	__GETWRN 18,19,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0xF:
	__CPWRR 18,19,10,11
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x10:
	SBIW R28,63
	SBIW R28,27
	LDI  R24,90
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x11:
	MOVW R30,R16
	MOVW R26,R28
	SUBI R26,LOW(-(72))
	SBCI R27,HIGH(-(72))
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:22 WORDS
SUBOPT_0x12:
	STS  _digit_out,R30
	MOVW R30,R16
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:38 WORDS
SUBOPT_0x13:
	MOVW R26,R28
	ADIW R26,54
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	__PUTB1MN _digit_out,1
	MOVW R30,R16
	MOVW R26,R28
	ADIW R26,36
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	__PUTB1MN _digit_out,2
	MOVW R30,R16
	MOVW R26,R28
	ADIW R26,18
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	__PUTB1MN _digit_out,3
	MOVW R30,R16
	MOVW R26,R28
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	__PUTB1MN _digit_out,4
	RCALL _view_yarkost
	RJMP SUBOPT_0xC

;OPTIMIZER ADDED SUBROUTINE, CALLED 13 TIMES, CODE SIZE REDUCTION:10 WORDS
SUBOPT_0x14:
	__ADDWRN 18,19,1
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x15:
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 54 TIMES, CODE SIZE REDUCTION:210 WORDS
SUBOPT_0x16:
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES, CODE SIZE REDUCTION:16 WORDS
SUBOPT_0x17:
	__PUTB1MN _digit_out,1
	MOVW R30,R16
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x18:
	__PUTB1MN _digit_out,2
	MOVW R30,R16
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES, CODE SIZE REDUCTION:48 WORDS
SUBOPT_0x19:
	__PUTB1MN _digit_out,3
	MOVW R30,R16
	MOVW R26,R28
	RJMP SUBOPT_0x16

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES, CODE SIZE REDUCTION:14 WORDS
SUBOPT_0x1A:
	__PUTB1MN _digit_out,4
	RJMP SUBOPT_0x0

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES, CODE SIZE REDUCTION:8 WORDS
SUBOPT_0x1B:
	ST   -Y,R9
	ST   -Y,R8
	RJMP _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1C:
	MOVW R30,R16
	MOVW R26,R28
	ADIW R26,40
	RJMP SUBOPT_0x16

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1D:
	MOVW R26,R28
	ADIW R26,20
	RJMP SUBOPT_0x16

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x1E:
	MOVW R26,R28
	ADIW R26,36
	RJMP SUBOPT_0x16

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x1F:
	SBIW R28,63
	SBIW R28,37
	LDI  R24,100
	RJMP SUBOPT_0x15

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:2 WORDS
SUBOPT_0x20:
	MOVW R30,R16
	MOVW R26,R28
	SUBI R26,LOW(-(80))
	SBCI R27,HIGH(-(80))
	RJMP SUBOPT_0x16

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x21:
	__PUTB1MN _digit_out,4
	RCALL _view_yarkost
	RJMP SUBOPT_0xC

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:1 WORDS
SUBOPT_0x22:
	MOVW R30,R16
	MOVW R26,R28
	ADIW R26,48
	RJMP SUBOPT_0x16


	.CSEG
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x7D0
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__LSLB12:
	TST  R30
	MOV  R0,R30
	MOV  R30,R26
	BREQ __LSLB12R
__LSLB12L:
	LSL  R30
	DEC  R0
	BRNE __LSLB12L
__LSLB12R:
	RET

__CPW02:
	CLR  R0
	CP   R0,R26
	CPC  R0,R27
	RET

__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

__LOADLOCR2P:
	LD   R16,Y+
	LD   R17,Y+
	RET

__INITLOCB:
	CLR  R25
__INITLOCW:
	ADD  R26,R28
	ADC  R27,R29
__INITLOC0:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __INITLOC0
	RET

;END OF CODE MARKER
__END_OF_CODE:
