#define RS(x)    GPIO_WritePin(GPIOB,GPIO_Pin_8,x)
#define E(x)     GPIO_WritePin(GPIOB,GPIO_Pin_7,x)
#define OD7(x)   GPIO_WritePin(GPIOB,GPIO_Pin_3,x)
#define OD6(x)   GPIO_WritePin(GPIOB,GPIO_Pin_4,x)
#define OD5(x)   GPIO_WritePin(GPIOB,GPIO_Pin_5,x)
#define OD4(x)   GPIO_WritePin(GPIOB,GPIO_Pin_6,x)

#define LINE0 0x80
#define LINE1 0xC0
#define CLEAR 1
#define CRH   2

u16 Vlcd;
char s1[17],s0[17];
volatile char* string_buff;
bool s_trg=0;
volatile unsigned char data_buff=0;
volatile unsigned char command_buff=0;

volatile u32 delay_tim;

void delay_ms(u32 ms)
{
 delay_tim = ms+1;
 while(delay_tim)asm("nop");//IWDG_ReloadCounter();
}

class glcd
{
 public:

 bool send_screen(char *s0,char *s1)
 {
  static char i=0;
  static bool trg0=0,trg1=0;
  static char ts0[17],ts1[17];

  if(!trg0 && strcmp(s0,ts0))
  {
   trg0=1;
   __disable_irq();
   strcpy(ts0,s0);
   __enable_irq();
  }
  if(!trg1 && strcmp(s1,ts1))
  {
   trg1=1;
   __disable_irq();
   strcpy(ts1,s1);
   __enable_irq();
  }

  if(!i && (trg0||trg1))
  {
   //command_buff = CLEAR;
   i++;
  }
  else if(i==1 && !command_buff)
  {
   command_buff = CRH;
   i++;
  }
  else if(i==2 && !command_buff)
  {
   if(trg0) command_buff = LINE0;
   i++;
  }
  else if(i==3 && !command_buff)
  {
   if(trg0) {string_buff = ts0; s_trg = 1;}
   i++;
  }
  else if(i==4 && !s_trg)
  {
   if(trg1) command_buff = LINE1;
   i++;
  }
  else if(i==5 && !command_buff)
  {
   if(trg1) {string_buff = ts1; s_trg = 1;}
   i++;
  }
  else if(i>5 && !s_trg)
  {
   i=0;
   trg1=trg0=0;
  }

  if(!trg1 && !trg0 && !i)return 1;
  return 0;
 }

 void Init()
 {
  E(0);
  delay_ms(20);
  command_buff = 0x03;//
  while(command_buff);
  delay_ms(5);
  command_buff = 0x03;//
  while(command_buff);

  command_buff = 0x02;// 
  while(command_buff);
  command_buff = 0x28;//4bit,2ln,5x8
  while(command_buff);
  command_buff = 0x0c;//
  while(command_buff);
  command_buff = 0x06;// 
  while(command_buff);
 }

 void command_queue(void)
 {
  static u8 i=0;
  static u8 tmp=0;

  if(command_buff)
  {
   RS(0);
   tmp = command_buff;
  }
  else if(data_buff)
  {
   RS(1);
   tmp = data_buff;
  }
  else if(s_trg)
  {
   RS(1);
   if(!i)
   {
    tmp = *string_buff++;
    if(!tmp)s_trg=0;
   }
  }
  else tmp=0;

  if(tmp)
  {
   if(!i)
   {
    (1<<7&tmp)?(OD7(1)):(OD7(0));
    (1<<6&tmp)?(OD6(1)):(OD6(0));
    (1<<5&tmp)?(OD5(1)):(OD5(0));
    (1<<4&tmp)?(OD4(1)):(OD4(0));
    E(1);
    i++;
   }
   else if(i==1)
   {
    E(0);
    i++;
   }
   else if(i==2)
   {
    (1<<7&tmp<<4)?(OD7(1)):(OD7(0));
    (1<<6&tmp<<4)?(OD6(1)):(OD6(0));
    (1<<5&tmp<<4)?(OD5(1)):(OD5(0));
    (1<<4&tmp<<4)?(OD4(1)):(OD4(0));
    E(1);
    i++;
   }
   else
   {
    E(0);
    i=0;
    data_buff=0;
    command_buff=0;
   }
  }
 }
}lcd;