#define VREF_CAL   (*(u16*)0x1FFFF7BA)

#define ADC_IN   conversion_result[0]
#define ADC_VREF conversion_result[1]

#define CHARGE_ON  GPIOB->OTYPER |=  (1<<12)
#define CHARGE_OFF GPIOB->OTYPER &= ~(1<<12)

u32 conversion_result[2];
u32 Vbat;

void dma_adc_config(void)
{
 RCC->AHBENR |= RCC_AHBENR_DMA1EN;

 DMA1_Channel1->CPAR = (u32)&ADC1->DR;
 DMA1_Channel1->CMAR = (uint32_t)conversion_result;
 DMA1_Channel1->CNDTR = 2;
 DMA1_Channel1->CCR  = DMA_CCR_MINC | DMA_CCR_CIRC | DMA_CCR_MSIZE_1 |
                       DMA_CCR_PSIZE_1 | DMA_CCR_EN;
}

void enable_adc(void)
{
 RCC->APB2ENR|= RCC_APB2ENR_ADC1EN;

 ADC1->CR = ADC_CR_ADCAL;
 while((ADC1->CR & ADC_CR_ADCAL)!=0) __NOP();
 ADC1->CR = ADC_CR_ADEN;
 while((ADC1->ISR & ADC_ISR_ADRDY)==0) __NOP();
}

void adc_config (void)
{
 dma_adc_config();
 enable_adc();

 ADC1->CFGR1 = ADC_CFGR1_AUTOFF | ADC_CFGR1_WAIT | ADC_CFGR1_DMAEN | ADC_CFGR1_DMACFG;

 ADC1->CFGR2 = 1UL<<31; //PCLK/4
 ADC1->CHSELR = 1<<17|1;
 ADC1->SMPR = 7;//240 cycles
 ADC->CCR = ADC_CCR_VREFEN;
}

bool do_conversion(u32 *Vbat)
{
 static bool trg=0;

 if(!trg)
 {
  trg=1;

  RCC->AHBENR |= RCC_AHBENR_DMA1EN;
  ADC1->CR = ADC_CR_ADSTART;
 }

 if((DMA1->ISR & DMA_ISR_TCIF1)!=0)
 {
  DMA1->IFCR = DMA_IFCR_CGIF1;

  *Vbat = 3300*ADC_IN/ADC_VREF*VREF_CAL>>12<<1;

  trg=0;
  RCC->AHBENR &= ~RCC_AHBENR_DMA1EN;

  return 1;
 }

 return 0;
}

