#define PIT_UP do{for(u8 i=1;i<PIT_DEPTH-1;i++){pit[i]=pit[i+1];}pit[PIT_DEPTH-1]=0;}while(0)
#define PIT_DN do{for(u8 i=PIT_DEPTH-1;i;i--)  pit[i]=pit[i-1];}while(0)

#define REG_X pit[0]
#define REG_Y pit[1]

#define ESP 12 //     

double storage[STORAGE_NUM];
double pit[PIT_DEPTH];
double shadow_pit[PIT_DEPTH];
char tmp_string[17]={'0'};
char *pt = tmp_string;
u8 *prog_pt = ee_buff;
bool dop_key_trg=0;

enum {ang_deg, ang_rad}angle_mode = ang_deg;

enum m_num {hex,dec,bin}num_mode = dec;
enum m_opc {edit_mnt, edit_exp, opc_processing}opc_mode = opc_processing;

void disp_output_processing(opcodes, m_num);

bool num_mode_selector(opcodes ops, m_num &num_mode)
{
 m_num tmp_num = num_mode;
 if     (ops == OP_DEC) {num_mode = dec;}
 else if(ops == OP_HEX) {num_mode = hex;}
 else if(ops == OP_BIN) {num_mode = bin;}

 if(tmp_num != num_mode) return 1;
 return 0;
}

void opc_mode_selector(opcodes ops, m_num num_mode, m_opc &opc_mode)
{
 //   
 if(opc_mode == edit_exp)
 //         backspace
 //    
 if((ops < OP_0 || ops > OP_9)&& ops!= OP_MNS && ops!= OP_BSP)
  opc_mode = opc_processing;

 //   
 if(opc_mode == edit_mnt)
 //    ,     , 
 // backspace     
 if(ops < OP_BSP || ops > OP_MNS)
  opc_mode = opc_processing;

 //       
 //   -  ,    
 if(opc_mode == opc_processing && ops >= OP_BSP && ops <= OP_COM)
  opc_mode = edit_mnt;

 //   -     
 //     
 else if(ops == OP_SEXP && num_mode == dec)
  opc_mode = edit_exp;
}

u16 convert_bina_u16(char s1[])
{
 u16 tmp = 0;

 for(s8 i=15;i>=0;i--) if(s1[i]=='1')tmp |= 1<<15-i;

 return tmp;
}

u64 convert_hexa_u64(char s1[])
{
 u64 tmp = 0;
 u32 hpow = 1;

 for(s8 i=15;i>=0;i--)
 {
  if(s1[i]!=' ')
  {
   u8 t;

   switch(s1[i])
   {
    case 'A' :{t = 0x0a;}break;
    case 'B' :{t = 0x0b;}break;
    case 'C' :{t = 0x0c;}break;
    case 'D' :{t = 0x0d;}break;
    case 'E' :{t = 0x0e;}break;
    case 'F' :{t = 0x0f;}break;
    case '0' :{t = 0x00;}break;
    case '1' :{t = 0x01;}break;
    case '2' :{t = 0x02;}break;
    case '3' :{t = 0x03;}break;
    case '4' :{t = 0x04;}break;
    case '5' :{t = 0x05;}break;
    case '6' :{t = 0x06;}break;
    case '7' :{t = 0x07;}break;
    case '8' :{t = 0x08;}break;
    case '9' :{t = 0x09;}break;
   }

   tmp += (u64)t*hpow;
   hpow*=16;
  }
 }

 return tmp;
}

void opc_mode_change_processing(opcodes ops, m_num num_mode, m_opc opc_mode)
{
 static opcodes tmp_ops = ops; //    
 static m_num tmp_num = num_mode;//         
 static m_opc tmp_opc = opc_mode; //     

 //,    
 if(tmp_opc != opc_mode)
 {
  //   
  if(opc_mode == edit_mnt)
  {
   if(tmp_ops!= OP_ENT && tmp_ops!= OP_Cx && ops!= OP_BSP) PIT_DN;

   //  
   if(ops != OP_BSP)
   {
    strcpy(tmp_string,blank_string);
    //    
    if(num_mode!=bin) pt = tmp_string;
    else              pt = tmp_string+15;
   }
   else
   {
    strcpy(tmp_string,s1);

    bool trg=0;
    bool sp_trg=0;
    int spe;

    for(int i=0;i<16;i++)
    {
     if(s1[i]=='e' || s1[i]=='E') trg=1;

     if(trg)tmp_string[i]=' ';

     if(tmp_string[i]==' ' && !sp_trg)
     {
      sp_trg=1;
      spe = i;
     }
    }

    //    
    if(num_mode!=bin) pt = tmp_string+spe;
    else              pt = tmp_string+15;
   }

   disp_output_processing(ops, num_mode);
  }
  //   
  else if(opc_mode == edit_exp)
  {
   //          
   if(tmp_opc == opc_processing)
    snprintf(tmp_string,17,"%-10.10g",REG_X);
   else if(tmp_opc == edit_mnt) REG_X = atof(s1);

   //       
   bool c_trg=0;

   for(u8 i=0;i<16;i++)
   {
    //          'E'
    //      
    if(tmp_string[i]==0 || c_trg)tmp_string[i]=' ';
    else if(tmp_string[i]=='E' || tmp_string[i]=='e' || i>11)
    {
     tmp_string[i]=' ';
     c_trg=1;
    }
   }

   //      
    pt   = tmp_string+12;
   *pt++ ='E';
   *pt++ ='0';
   *pt++ ='0';
   *pt   ='0';
  }
  //  
  else
  {
   //         
   if(tmp_opc == edit_mnt)
   {
    if     (tmp_num == bin) REG_X = convert_bina_u16(s1);
    else if(tmp_num == hex) REG_X = convert_hexa_u64(s1);
    else                    REG_X = atof(s1);
   }
  //-------------------------------------------------
   //         
   //             
   if(tmp_opc == edit_exp)
   {
    //          
    //     
    if(tmp_string[12]=='E')tmp_string[12]=' ';
    for(pt=tmp_string;pt<tmp_string+4;pt++)*pt = *(pt+12);
    for(pt=tmp_string+4;pt<tmp_string+16;pt++)*pt = ' ';

    //      
    //       
    //     
    double exponent = atoi(tmp_string);
    REG_X *= pow(10,exponent);
   }
  }

  tmp_opc = opc_mode;
 }

 tmp_ops = ops;
 tmp_num = num_mode;
}

void key2ops_processing(u8 key[], opcodes &ops, m_num num_mode)
{
 ops = OP_NULL;

 if     (key[1] == B_F && key[2]!= B_K)
 {
  switch(key[0])
  {
   case 0 : {               }break;
   case 1 : {ops = OP_VBAT; }break;
   case 2 : {ops = OP_RS_EE;}break;
   case 3 : {ops = OP_SR_EE;}break;
   case 4 : {ops = OP_FPRUN;}break;
   case 5 : {ops = OP_HEX;  }break;
   case 6 : {ops = OP_DEC;  }break;
   case 7 : {ops = OP_BIN;  }break;
   case 8 : {ops = OP_AND;  }break;
   case 9 : {ops = OP_NOT;  }break;
   case 10: {ops = OP_SIN;  }break;
   case 11: {ops = OP_COS;  }break;
   case 12: {ops = OP_TG;   }break;
   case 13: {ops = OP_PI;   }break;
   case 14: {if(num_mode == hex || dop_key_trg)ops = OP_C;}break;
   case 15: {ops = OP_10X;  }break;
   case 16: {ops = OP_X2;   }break;
   case 17: {ops = OP_XEY;  }break;
   case 18: {if(num_mode == hex || dop_key_trg)ops = OP_B; else ops = OP_RDG;}break;
   case 19: {if(num_mode == hex || dop_key_trg)ops = OP_E; else ops = OP_BX;}break;
   case 20: {ops = OP_LG;   }break;
   case 21: {ops = OP_PITR; }break;
   case 22: {if(num_mode == hex || dop_key_trg)ops = OP_A;}break;
   case 23: {if(num_mode == hex || dop_key_trg)ops = OP_D;}break;
   case 24: {if(num_mode == hex || dop_key_trg)ops = OP_F; else ops = OP_FCx;}break;
  }
 }
 else if(key[1] == B_K && key[2]!= B_F)
 {
  switch(key[0])
  {
   case 0 : {if(key[2] == B_K)ops = OP_PGMM;}break;
   case 1 : {               }break;
   case 2 : {ops = OP_SGR;  }break;
   case 3 : {ops = OP_SGL;  }break;
   case 4 : {ops = OP_KPRUN;}break;
   case 5 : {ops = OP_HEX;  }break;
   case 6 : {ops = OP_DEC;  }break;
   case 7 : {ops = OP_BIN;  }break;
   case 8 : {ops = OP_OR;   }break;
   case 9 : {ops = OP_XOR;  }break;
   case 10: {ops = OP_ASIN; }break;
   case 11: {ops = OP_ACOS; }break;
   case 12: {ops = OP_ATG;  }break;
   case 13: {ops = OP_1X;   }break;
   case 14: {if(num_mode == hex || dop_key_trg)ops = OP_C; else if(key[2]==B_K) ops=OP_KEYLOCK;}break;
   case 15: {ops = OP_EXP;  }break;
   case 16: {ops = OP_SQR;  }break;
   case 17: {ops = OP_YQX;  }break;
   case 18: {if(num_mode == hex || dop_key_trg)ops = OP_B;}break;
   case 19: {if(num_mode == hex || dop_key_trg)ops = OP_E;}break;
   case 20: {ops = OP_LN;   }break;
   case 21: {ops = OP_PITL; }break;
   case 22: {if(num_mode == hex || dop_key_trg)ops = OP_A;}break;
   case 23: {if(num_mode == hex || dop_key_trg)ops = OP_D; else ops = OP_PREC;}break;
   case 24: {if(num_mode == hex || dop_key_trg)ops = OP_F; else ops = OP_KCx;}break;
  }
 }
 else if(key[1] == B_Px && key[2]!= B_F && key[2]!= B_K)
 {
  switch(key[0])
  {
   case 0 : {               }break;
   case 1 : {               }break;
   case 2 : {               }break;
   case 3 : {               }break;
   case 4 : {               }break;
   case 5 : {ops = PX_REG0 ;}break;
   case 6 : {ops = PX_REG1 ;}break;
   case 7 : {ops = PX_REG2 ;}break;
   case 8 : {ops = PX_REG3 ;}break;
   case 9 : {ops = PX_REG4 ;}break;
   case 10: {ops = PX_REG5 ;}break;
   case 11: {ops = PX_REG6 ;}break;
   case 12: {ops = PX_REG7 ;}break;
   case 13: {ops = PX_REG8 ;}break;
   case 14: {ops = PX_REG9 ;}break;
   case 15: {ops = PX_REG10;}break;
   case 16: {ops = PX_REG11;}break;
   case 17: {ops = PX_REG12;}break;
   case 18: {ops = PX_REG13;}break;
   case 19: {ops = PX_REG14;}break;
   case 20: {ops = PX_REG15;}break;
   case 21: {ops = PX_REG16;}break;
   case 22: {ops = PX_REG17;}break;
   case 23: {ops = PX_REG18;}break;
   case 24: {ops = PX_REG19;}break;
  }
 }
 else if(key[1] == B_xP && key[2]!= B_F && key[2]!= B_K)
 {
  switch(key[0])
  {
   case 0 : {               }break;
   case 1 : {               }break;
   case 2 : {               }break;
   case 3 : {               }break;
   case 4 : {               }break;
   case 5 : {ops = XP_REG0 ;}break;
   case 6 : {ops = XP_REG1 ;}break;
   case 7 : {ops = XP_REG2 ;}break;
   case 8 : {ops = XP_REG3 ;}break;
   case 9 : {ops = XP_REG4 ;}break;
   case 10: {ops = XP_REG5 ;}break;
   case 11: {ops = XP_REG6 ;}break;
   case 12: {ops = XP_REG7 ;}break;
   case 13: {ops = XP_REG8 ;}break;
   case 14: {ops = XP_REG9 ;}break;
   case 15: {ops = XP_REG10;}break;
   case 16: {ops = XP_REG11;}break;
   case 17: {ops = XP_REG12;}break;
   case 18: {ops = XP_REG13;}break;
   case 19: {ops = XP_REG14;}break;
   case 20: {ops = XP_REG15;}break;
   case 21: {ops = XP_REG16;}break;
   case 22: {ops = XP_REG17;}break;
   case 23: {ops = XP_REG18;}break;
   case 24: {ops = XP_REG19;}break;
  }
 }
 else
 {
  switch(key[0])
  {
   case 0 : {               }break;
   case 1 : {               }break;
   case 2 : {               }break;
   case 3 : {               }break;
   case 4 : {ops = OP_BSP  ;}break;
   case 5 : {if(num_mode != bin)ops = OP_7;}break;
   case 6 : {if(num_mode != bin)ops = OP_8;}break;
   case 7 : {if(num_mode != bin)ops = OP_9;}break;
   case 8 : {ops = OP_SBT  ;}break;
   case 9 : {ops = OP_DIV  ;}break;
   case 10: {if(num_mode != bin)ops = OP_4;}break;
   case 11: {if(num_mode != bin)ops = OP_5;}break;
   case 12: {if(num_mode != bin)ops = OP_6;}break;
   case 13: {ops = OP_SUM  ;}break;
   case 14: {ops = OP_MUL  ;}break;
   case 15: {ops = OP_1;                   }break;
   case 16: {if(num_mode != bin)ops = OP_2;}break;
   case 17: {if(num_mode != bin)ops = OP_3;}break;
   case 18: {ops = OP_XY   ;}break;
   case 19: {ops = OP_ENT  ;}break;
   case 20: {ops = OP_0    ;               }break;
   case 21: {ops = OP_COM  ;}break;
   case 22: {ops = OP_MNS  ;}break;
   case 23: {ops = OP_SEXP ;}break;
   case 24: {ops = OP_Cx   ;}break;
  }
 }
}

void opcode_processing(opcodes ops,const u8 ee_bnum=1)
{
 switch(ops)
 {
  case OP_RS_EE:{if(ee_bnum)read_mregs();}break;
  case OP_SR_EE:{if(ee_bnum)save_mregs();}break;

  case PX_REG0 :
  case PX_REG1 :
  case PX_REG2 :
  case PX_REG3 :
  case PX_REG4 :
  case PX_REG5 :
  case PX_REG6 :
  case PX_REG7 :
  case PX_REG8 :
  case PX_REG9 :
  case PX_REG10:
  case PX_REG11:
  case PX_REG12:
  case PX_REG13:
  case PX_REG14:
  case PX_REG15:
  case PX_REG16:
  case PX_REG17:
  case PX_REG18:
  case PX_REG19:
  {
   PIT_DN;
   switch(ops)
   {
    case PX_REG0 :{REG_X = storage[1] ;}break;
    case PX_REG1 :{REG_X = storage[2] ;}break;
    case PX_REG2 :{REG_X = storage[3] ;}break;
    case PX_REG3 :{REG_X = storage[4] ;}break;
    case PX_REG4 :{REG_X = storage[5] ;}break;
    case PX_REG5 :{REG_X = storage[6] ;}break;
    case PX_REG6 :{REG_X = storage[7] ;}break;
    case PX_REG7 :{REG_X = storage[8] ;}break;
    case PX_REG8 :{REG_X = storage[9] ;}break;
    case PX_REG9 :{REG_X = storage[0] ;}break;
    case PX_REG10:{REG_X = storage[10];}break;
    case PX_REG11:{REG_X = storage[11];}break;
    case PX_REG12:{REG_X = storage[12];}break;
    case PX_REG13:{REG_X = storage[13];}break;
    case PX_REG14:{REG_X = storage[14];}break;
    case PX_REG15:{REG_X = storage[15];}break;
    case PX_REG16:{REG_X = storage[16];}break;
    case PX_REG17:{REG_X = storage[17];}break;
    case PX_REG18:{REG_X = storage[18];}break;
    case PX_REG19:{REG_X = storage[19];}break;
   }
  }break;

  case XP_REG0 :{storage[1]  = REG_X;}break;
  case XP_REG1 :{storage[2]  = REG_X;}break;
  case XP_REG2 :{storage[3]  = REG_X;}break;
  case XP_REG3 :{storage[4]  = REG_X;}break;
  case XP_REG4 :{storage[5]  = REG_X;}break;
  case XP_REG5 :{storage[6]  = REG_X;}break;
  case XP_REG6 :{storage[7]  = REG_X;}break;
  case XP_REG7 :{storage[8]  = REG_X;}break;
  case XP_REG8 :{storage[9]  = REG_X;}break;
  case XP_REG9 :{storage[0]  = REG_X;}break;
  case XP_REG10:{storage[10] = REG_X;}break;
  case XP_REG11:{storage[11] = REG_X;}break;
  case XP_REG12:{storage[12] = REG_X;}break;
  case XP_REG13:{storage[13] = REG_X;}break;
  case XP_REG14:{storage[14] = REG_X;}break;
  case XP_REG15:{storage[15] = REG_X;}break;
  case XP_REG16:{storage[16] = REG_X;}break;
  case XP_REG17:{storage[17] = REG_X;}break;
  case XP_REG18:{storage[18] = REG_X;}break;
  case XP_REG19:{storage[19] = REG_X;}break;

  case OP_SBT  :{REG_X = REG_Y-REG_X; PIT_UP;}break;
  case OP_DIV  :{REG_X = REG_Y/REG_X; PIT_UP;}break;
  case OP_SUM  :{REG_X = REG_Y+REG_X; PIT_UP;}break;
  case OP_MUL  :{REG_X = REG_Y*REG_X; PIT_UP;}break;
  case OP_XY   :{double tmp = REG_X; REG_X = REG_Y; REG_Y = tmp;}break;
  case OP_ENT  :{PIT_DN;}break;
  case OP_MNS  :{REG_X = -REG_X;}break;
  case OP_Cx   :{REG_X = 0;}break;
  case OP_OR   :{REG_X = (u16)REG_X & (u16)REG_Y; PIT_UP;}break;
  case OP_AND  :{REG_X = (u16)REG_X | (u16)REG_Y; PIT_UP;}break;
  case OP_NOT  :{REG_X = (u16)REG_X ^ 0xffff;}break;
  case OP_XOR  :{REG_X = (u16)REG_X ^ (u16)REG_Y; PIT_UP;}break;
  case OP_SIN  :
  {
   if(angle_mode == ang_deg) REG_X = sin(REG_X/180*PI);
   else                      REG_X = sin(REG_X);
  }break;
  case OP_COS  :
  {
   if(angle_mode == ang_deg) REG_X = cos(REG_X/180*PI);
   else                      REG_X = cos(REG_X);
  }break;
  case OP_TG   :
  {
   if(angle_mode == ang_deg) REG_X = tan(REG_X*PI/180);
   else                      REG_X = tan(REG_X);
  }break;
  case OP_ASIN :
  {
   if(angle_mode == ang_deg) REG_X = asin(REG_X)*180/PI;
   else                      REG_X = asin(REG_X);
  }break;
  case OP_ACOS :
  {
   if(angle_mode == ang_deg) REG_X = acos(REG_X)*180/PI;
   else                      REG_X = acos(REG_X);
  }break;
  case OP_ATG  :
  {
   if(angle_mode == ang_deg) REG_X = atan(REG_X)*180/PI;
   else                      REG_X = atan(REG_X);
  }break;
  case OP_PI   :{PIT_DN; REG_X = PI;}break;
  case OP_1X   :{REG_X = 1/REG_X;}break;
  case OP_10X  :{REG_X = pow(10,REG_X);}break;
  case OP_EXP  :{REG_X = exp(REG_X);}break;
  case OP_X2   :{REG_X = REG_X*REG_X;}break;
  case OP_XEY  :{REG_X = pow(REG_X,REG_Y); PIT_UP;}break;
  case OP_LG   :{REG_X = log10(REG_X);}break;
  case OP_LN   :{REG_X = log(REG_X);}break;
  case OP_SQR  :{REG_X = sqrt(REG_X);}break;
  case OP_YQX  :{REG_X = pow(REG_X,1/REG_Y); PIT_UP;}break;
  case OP_PITR :{double tmp = REG_X; REG_X = REG_Y; PIT_UP; pit[PIT_DEPTH-1] = tmp;}break;
  case OP_PITL :{double tmp = pit[PIT_DEPTH-1]; PIT_DN; REG_X = tmp;}break;
  case OP_FCx  :{for(int i=1;i<PIT_DEPTH;i++)pit[i]=0;}break;

  default: break;
 }
}

char* edit_mnt_processing(opcodes ops, m_num num_mode = dec)
{
 if(pt<tmp_string)pt = tmp_string;
 else if(pt>tmp_string+16) pt = tmp_string+16;

 char *tmp_pt = pt;

 //   
 if(ops == OP_BSP)
 {
  if(pt>tmp_string)pt--;
  *pt = ' ';
 }
 //  
 else if(ops == OP_MNS && num_mode == dec)
 {
  //  '-' 
  if(tmp_string[0]!='-')
  {
   //       
   for(u8 i=15;i;i--) tmp_string[i] = tmp_string[i-1];
   //     '-'
   tmp_string[0] = '-';
   //   ,      
   if(pt<tmp_string+15)pt++;
  }
  //  '-'  
  else
  {
   //       
   for(u8 i=0;i<15;i++) tmp_string[i] = tmp_string[i+1];
   //   ,      
   if(pt>tmp_string)pt--;
  }
 }
 //    
 else if(pt < tmp_string+16)
 {
  if(num_mode == hex)
  switch(ops)
  {
   case OP_A  :{*pt++ = 'A';}break;
   case OP_B  :{*pt++ = 'B';}break;
   case OP_C  :{*pt++ = 'C';}break;
   case OP_D  :{*pt++ = 'D';}break;
   case OP_E  :{*pt++ = 'E';}break;
   case OP_F  :{*pt++ = 'F';}break;
  }

  if(num_mode != bin)
  switch(ops)
  {
   case OP_2  :{*pt++ = '2';}break;
   case OP_3  :{*pt++ = '3';}break;
   case OP_4  :{*pt++ = '4';}break;
   case OP_5  :{*pt++ = '5';}break;
   case OP_6  :{*pt++ = '6';}break;
   case OP_7  :{*pt++ = '7';}break;
   case OP_8  :{*pt++ = '8';}break;
   case OP_9  :{*pt++ = '9';}break;
  }

  switch(ops)
  {
   case OP_0  :
   {
    if(num_mode != bin)*pt++ = '0';
    else
    {
     *pt = '0';
     if(pt > tmp_string)pt--;
    }
   }break;
   case OP_1  :
   {
    if(num_mode != bin)*pt++ = '1';
    else
    {
     *pt = '1';
     if(pt > tmp_string)pt--;
    }
   }break;

   case OP_COM:
   {
    //      
    if(num_mode == dec)
    {
     static bool trg=0;

     //        
     for(u8 i=0;i<SLN-1;i++)
      if(tmp_string[i]=='.')
      {
       trg=1;
       break;
      }

     if(!trg) *pt++ = '.';
    }
   }break;
  }
 }
 strcpy(s1, tmp_string);

 return tmp_pt;
}

void edit_exp_processing(opcodes ops)
{
 switch(ops)
 {
  case OP_BSP:
  {
   for(u8 i=0;i<2;i++) tmp_string[15-i]=tmp_string[14-i];
   tmp_string[13] = '0';
  }break;
  case OP_MNS:
  {
   if(tmp_string[12]!='-')tmp_string[12]='-';
   else tmp_string[12]=' ';
  }break;
  case OP_1  :
  case OP_2  :
  case OP_3  :
  case OP_4  :
  case OP_5  :
  case OP_6  :
  case OP_7  :
  case OP_8  :
  case OP_9  :
  case OP_0  :
  {
   for(u8 i=0;i<3;i++) tmp_string[13+i]=tmp_string[14+i];
   switch(ops)
   {
    case OP_1  : *pt= '1'; break;
    case OP_2  : *pt= '2'; break;
    case OP_3  : *pt= '3'; break;
    case OP_4  : *pt= '4'; break;
    case OP_5  : *pt= '5'; break;
    case OP_6  : *pt= '6'; break;
    case OP_7  : *pt= '7'; break;
    case OP_8  : *pt= '8'; break;
    case OP_9  : *pt= '9'; break;
    case OP_0  : *pt= '0'; break;
   }
  }
 }
 strcpy(s1, tmp_string);
}

void disp_output_processing(opcodes ops, m_num num_mode)
{

 strcpy(s0,blank_string);
 strcpy(s1,blank_string);

 static m_num tmp_num = num_mode;
 bool trg=0;

 if(tmp_num != num_mode)
 {
  tmp_num = num_mode;
  trg = 1;
 }

 switch(num_mode)
 {
  case hex:
  {
   if(!trg)snprintf(s0,17,"%16llX",(s64)REG_Y);
   snprintf(s1,17,"%16llX",(s64)REG_X);
  }break;

  case dec:
  {
   if(!trg) outstr_truncation (s0, REG_Y, options.precision);

   outstr_truncation (s1, REG_X, options.precision);

   for(u8 i=0;i<SLN-1;i++)
   {
    if(s0[i]==0)s0[i]=' ';
    if(s1[i]==0)s1[i]=' ';
   }
  }break;

  case bin:
  {
   s16 tmpY = (s64)REG_Y;
   s16 tmpX = (s64)REG_X;

   for(s8 i=SLN-2;i>=0;i--)
   {
    if(!trg)s0[i]= (tmpY&1) +0x30;
    s1[i]= (tmpX&1) +0x30;
    tmpY>>=1;
    tmpX>>=1;
   }
  }break;
 }
}


void clear_prog(u8 prog_data[])
{
 for(u8 i=0;i<0xff;i++)
 {
  if(prog_data[i]>sizeof(op_strings)/sizeof(*op_strings)-1) prog_data[i]=(u8)OP_NULL;

  if(op_strings[prog_data[i]][0]==0)
   prog_data[i] = (u8)OP_NULL;
 }
}

void init_prog_memory (u8 prog_data[])
{
 for(u8 i=0;i<0xff;i++)prog_data[i] = (u8)OP_NULL;
}

u8 prg_c(opcodes ops, u8 prog_data[], bool &pc_reset)
{
 static u8 i;

 //
 if(pc_reset !=0)
 {
  i = 0;
  pc_reset = 0;

  num_mode = dec;
  opc_mode = opc_processing;

  clear_prog(prog_data);
 }

 switch(ops)
 {
  case OP_SGL: {if(i)i--; else i = 0xfe;     }break;
  case OP_SGR: {if(i < 0xfe) i++; else i = 0;}break;
  case OP_BSP: {i = 0;                       }break;
  default:
  {
   if((ops> OP_SR_EE && ops< OP_PGMM && (ops< OP_VBAT || ops> OP_BSP))||ops == OP_KCx)
   {
    if(ops==OP_KCx)
     prog_data[i]=OP_NULL;
    else
     prog_data[i] = ops;

    if(i<0xfe) i++;
    else i=0;
   }
  }break;
 }
 return i;
}

void prg_visualisation(u8 prog_data[], u8 prog_cnt=0)
{
 //  ,      
 if(!prog_cnt)
 {
  snprintf(s0,17,"%-03.3d:%s MEM:%-03.3d",0,op_strings[prog_data[0]],0xfe);
  snprintf(s1,17,"%-03.3d:%s ELN:%-03.3d",1,op_strings[prog_data[1]],0);
 }
 else
 {
  snprintf(s0,17,"%-03.3d:%s MEM:%-03.3d",prog_cnt-1,op_strings[prog_data[prog_cnt-1]],0xfe - prog_cnt);
  snprintf(s1,17,"%-03.3d:%s ELN:%-03.3d",prog_cnt,  op_strings[prog_data[prog_cnt]]  ,prog_cnt);
 }
}

u8 prg_r(u8 prog_data[], bool &pc_reset, u8 prog_cnt=0)
{
 static u8 i=0;

 if(pc_reset)
 {
  pc_reset = 0;
  i = prog_cnt;

  clear_prog(prog_data);
 }
 else
 {
  opcodes ops = (opcodes)prog_data[i];
  if(ops!= OP_NULL)
  {
   opc_mode_selector(ops, num_mode, opc_mode);
   opc_mode_change_processing(ops, num_mode, opc_mode);
   switch(opc_mode)
   {
    case opc_processing: opcode_processing(ops);            break;
    case edit_mnt      : edit_mnt_processing(ops, num_mode);break;
    case edit_exp      : edit_exp_processing(ops);          break;
   }
  }

  i++;
 }

 return i;
}