extern int const __checksum;

#pragma section=".intvec"
#pragma section=".checksum"

bool get_crc(void)
{
 u32* begin = (u32*)__section_begin(".intvec");
 u32* end   = (u32*)__section_begin(".checksum");
 u32* pt;

 u32 tmp     = RCC->AHBENR;
 tmp        |= RCC_AHBENR_CRCEN;
 RCC->AHBENR = tmp;

 for(pt = begin; pt <end; pt++) CRC->DR = *pt;

 u32 tmp2 = CRC->DR;

 tmp &= ~RCC_AHBENR_CRCEN;
 RCC->AHBENR = tmp;

 return (tmp2==__checksum)?(1):(0);
}

bool get_crc_tdma(void)
{
 uint32_t begin = (uint32_t)__section_begin(".intvec");
 uint32_t end   = (uint32_t)__section_begin(".checksum");

 RCC->AHBENR |= RCC_AHBENR_DMA1EN | RCC_AHBENR_CRCEN;

 DMA1_Channel1->CPAR  = begin;
 DMA1_Channel1->CMAR  = (uint32_t)&CRC->DR;
 DMA1_Channel1->CNDTR = (end-begin)/4;
 DMA1_Channel1->CCR   = DMA_CCR_PINC | DMA_CCR_MSIZE_1 | DMA_CCR_PSIZE_1 |
                        DMA_CCR_MEM2MEM | DMA_CCR_PL | DMA_CCR_EN;

 while((DMA1->ISR & DMA_ISR_TCIF1) == 0)__NOP();
 DMA1->IFCR = DMA_IFCR_CGIF1;

 u32 tmp = CRC->DR;

 RCC->AHBENR &= ~RCC_AHBENR_CRCEN & ~RCC_AHBENR_DMA1EN;

 return (tmp == __checksum)?(1):(0);
}

