
typedef unsigned char   u8;
typedef signed char     s8;
typedef unsigned short  u16;
typedef signed short    s16;
typedef unsigned int    u32;
typedef signed int      s32;
typedef unsigned long long u64;
typedef signed long long s64;

#define system_frq (u32)16E6

//#define PI 3.14159265358979
#define PI 3.141592653589793238462643

#define SLN 17
#define PIT_DEPTH 16
#define KEY_DEPTH 3

//----------------------------
#define B_F   0
#define B_K   1
#define B_Px  2
#define B_xP  3
#define B_BS  4

#define B_7   5
#define B_8   6
#define B_9   7
#define B_SBT 8
#define B_DIV 9

#define B_4   10
#define B_5   11
#define B_6   12
#define B_SUM 13
#define B_MUL 14

#define B_1   15
#define B_2   16
#define B_3   17
#define B_XY  18
#define B_ENT 19

#define B_0   20
#define B_COM 21
#define B_MNS 22
#define B_EXP 23
#define B_Cx  24
#define B_NULL 0xff

//________________________
//opcodes

enum opcodes
{
 OP_NULL  ,

 OP_RS_EE ,
 OP_SR_EE ,

 PX_REG0 ,
 PX_REG1 ,
 PX_REG2 ,
 PX_REG3 ,
 PX_REG4 ,
 PX_REG5 ,
 PX_REG6 ,
 PX_REG7 ,
 PX_REG8 ,
 PX_REG9 ,
 PX_REG10,
 PX_REG11,
 PX_REG12,
 PX_REG13,
 PX_REG14,
 PX_REG15,
 PX_REG16,
 PX_REG17,
 PX_REG18,
 PX_REG19,

 XP_REG0 ,
 XP_REG1 ,
 XP_REG2 ,
 XP_REG3 ,
 XP_REG4 ,
 XP_REG5 ,
 XP_REG6 ,
 XP_REG7 ,
 XP_REG8 ,
 XP_REG9 ,
 XP_REG10,
 XP_REG11,
 XP_REG12,
 XP_REG13,
 XP_REG14,
 XP_REG15,
 XP_REG16,
 XP_REG17,
 XP_REG18,
 XP_REG19,

 OP_SBT   ,
 OP_DIV   ,
 OP_SUM   ,
 OP_MUL   ,
 OP_XY    ,
 OP_ENT   ,
 OP_Cx    ,
 OP_OR    ,
 OP_AND   ,
 OP_NOT   ,
 OP_XOR   ,
 OP_SIN   ,
 OP_COS   ,
 OP_TG    ,
 OP_ASIN  ,
 OP_ACOS  ,
 OP_ATG   ,
 OP_PI    ,
 OP_1X    ,
 OP_10X   ,
 OP_EXP   ,
 OP_X2    ,
 OP_XEY   ,
 OP_LG    ,
 OP_LN    ,
 OP_SQR   ,
 OP_YQX   ,
 OP_PITR  ,
 OP_PITL  ,

 OP_VBAT  ,
 OP_FPRUN ,
 OP_KPRUN ,
 OP_HEX   ,
 OP_DEC   ,
 OP_BIN   ,

 OP_SGR   ,
 OP_SGL   ,

 OP_BSP   ,
 OP_A     ,
 OP_B     ,
 OP_C     ,
 OP_D     ,
 OP_E     ,
 OP_F     ,
 OP_0     ,
 OP_1     ,
 OP_2     ,
 OP_3     ,
 OP_4     ,
 OP_5     ,
 OP_6     ,
 OP_7     ,
 OP_8     ,
 OP_9     ,
 OP_COM   ,
 OP_MNS   ,
 OP_SEXP  ,

 OP_PGMM  ,
 OP_KCx   ,
 OP_FCx   ,

 OP_RDG   ,
 OP_PREC  ,
 OP_BX    ,
 OP_KEYLOCK
}ops = OP_NULL;
