/*
for STM32f030C6

I2C initialization:


  RCC->APB1ENR |= RCC_APB1ENR_I2C1EN;

 //PB10,11 I2C
  GPIO_InitTypeDef GIS;
  GIS.GPIO_Speed = GPIO_Speed_2MHz;
  GIS.GPIO_Pin   = GPIO_Pin_10|GPIO_Pin_11;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOB, &GIS);
  GPIO_PinAFConfig(GPIOB, GPIO_PinSource10, GPIO_AF_1);
  GPIO_PinAFConfig(GPIOB, GPIO_PinSource11, GPIO_AF_1);

  //100kHz_i2c & 8MHz_clk
  I2C1->CR1 = 0;
  I2C1->TIMINGR = 0x1UL<<28;  //prescaler
  I2C1->TIMINGR|= 4UL<<20;  //SCLDEL
  I2C1->TIMINGR|= 2UL<<16;  //SDADEL
  I2C1->TIMINGR|= 0x0fUL<<8;//SCLH
  I2C1->TIMINGR|= 0x13UL;   //SCLL

*/

#define i2c_addr 0xA0
#define SDA_pin GPIO_Pin_11
#define SCL_pin GPIO_Pin_10

#define EEWRITE_ENABLE  GPIOB->BRR  = 1<<2;
#define EEWRITE_DISABLE GPIOB->BSRR = 1<<2;

volatile u8 ee_tim;  //1ms --

void i2c_delay(u32 ms)
{
 ee_tim = ms;
 while(ee_tim)asm("nop");
}

void i2c_on(void)
{
 if((I2C1->CR1 & I2C_CR1_PE)==0) I2C1->CR1 = 1UL<<8|I2C_CR1_PE;

}

void i2c_off(void)
{
 I2C1->CR1 = 0;

}

void rst_I2C()
{
 i2c_off();
 GPIO_InitTypeDef GIS;

 GIS.GPIO_Speed = GPIO_Speed_2MHz;
 GIS.GPIO_Pin   = GPIO_Pin_10|GPIO_Pin_11;
 GIS.GPIO_Mode  = GPIO_Mode_OUT;
 GIS.GPIO_PuPd  = GPIO_PuPd_UP;
 GIS.GPIO_OType = GPIO_OType_OD;
 GPIOB->BSRR    = GPIO_Pin_10|GPIO_Pin_11; //SDA & SCL == 1

 GPIO_Init(GPIOB, &GIS);

 for(u8 i=0;i<9;i++)
 {
  GPIOB->BRR   = SCL_pin; // SCL = 0
  i2c_delay(2);
  GPIOB->BSRR  = SCL_pin; // SCL = 1
  i2c_delay(2);
  if((GPIOB->IDR & SDA_pin)!=0) // (SDA == 1) ? Stop
  {
   GPIOB->BRR  = SCL_pin; // SCL = 0
   i2c_delay(2);
   GPIOB->BRR  = SDA_pin; // SDA = 0
   i2c_delay(2);

   GPIOB->BSRR = SCL_pin; // SCL = 1
   i2c_delay(2);
   GPIOB->BSRR = SDA_pin; // SDA = 1
   break;
  }
   else
  {
   GPIOB->BSRR = SDA_pin; // SDA = 1
   i2c_delay(2);
  }
 }

 GIS.GPIO_Speed = GPIO_Speed_2MHz;
 GIS.GPIO_Pin   = GPIO_Pin_10|GPIO_Pin_11;
 GIS.GPIO_Mode  = GPIO_Mode_AF;
 GIS.GPIO_PuPd  = GPIO_PuPd_UP;
 GIS.GPIO_OType = GPIO_OType_OD;

 GPIO_Init(GPIOB, &GIS);
}

bool i2c_read(u16 addr, u8 *rx)
{
 ee_tim = 0x0f;
 i2c_on();

 u8 addr_tmp = i2c_addr + (addr/(0xff+1)<<1);

 I2C1->CR2 = 1<<16 | I2C_CR2_START | addr_tmp;
 while((I2C1->ISR & I2C_ISR_TXIS)==0) if(ee_tim == 0)goto tmo_rx;

 I2C1->TXDR = addr%(0xff+1);
 while((I2C1->ISR & I2C_ISR_TC)==0) if(ee_tim == 0)goto tmo_rx;

 I2C1->CR2 = 1<<16 | I2C_CR2_START | addr_tmp | I2C_CR2_AUTOEND | I2C_CR2_RD_WRN;
 while((I2C1->ISR & I2C_ISR_RXNE)==0) if(ee_tim == 0)goto tmo_rx;

 *rx = (u8)I2C1->RXDR;
 return 1;

 tmo_rx:
// *err = I2C1->ISR;
 i2c_off();
 return 0;
}

bool i2c_write(u16 addr, u8 data)
{
 ee_tim = 0x0f;
 i2c_on();

 u8 addr_tmp = i2c_addr + (addr/(0xff+1)<<1);

 I2C1->TXDR = addr%(0xff+1);
 I2C1->CR2 = 2<<16 | I2C_CR2_START | addr_tmp | I2C_CR2_AUTOEND;
 while((I2C1->ISR & I2C_ISR_TXIS)==0) if(ee_tim == 0)goto tmo_tx;

 I2C1->TXDR = data;
 while((I2C1->ISR & I2C_ISR_STOPF)==0)if(ee_tim == 0)goto tmo_tx;

 i2m:

 I2C1->CR2 = 1<<16 | I2C_CR2_START | i2c_addr| I2C_CR2_AUTOEND | I2C_CR2_RD_WRN;
 while((I2C1->ISR & I2C_ISR_BUSY)!=0) if(ee_tim == 0)goto tmo_tx;

 if((I2C1->ISR & I2C_ISR_RXNE)==0)goto i2m;

 i2c_off();
 return 1;

 tmo_tx:
//  *err = I2C1->ISR;
  i2c_off();
  return 0;
}

bool i2c_bank_read(u8 bank, u8 *rx)
{
 ee_tim = 0xff;
 i2c_on();

 u8 addr_tmp = i2c_addr + (bank<<1);

 I2C1->CR2 = 1<<16 | I2C_CR2_START | addr_tmp;
 while((I2C1->ISR & I2C_ISR_TXIS)==0) if(ee_tim == 0)goto tmo_rx;

 I2C1->TXDR = 0;
 while((I2C1->ISR & I2C_ISR_TC)==0) if(ee_tim == 0)goto tmo_rx;

 I2C1->CR2 = 0xff<<16 | I2C_CR2_START | addr_tmp | I2C_CR2_AUTOEND | I2C_CR2_RD_WRN;
 for(u8 i=0; i<0xff; i++)
 {
  while((I2C1->ISR & I2C_ISR_RXNE)==0) if(ee_tim == 0)goto tmo_rx;
  *(rx+i) = (u8)I2C1->RXDR;
 }

 return 1;

 tmo_rx:

 i2c_off();
 return 0;
}

bool i2c_buffered_write(u16 addr, u8 data[16])
{
 i2c_on();
 ee_tim = 0xff;

 //   16 : addr = addr - addr%16
 u8 addr_tmp = i2c_addr + (addr/256<<1);

 I2C1->TXDR = addr%256;
 I2C1->CR2 = 17<<16 | I2C_CR2_START | addr_tmp | I2C_CR2_AUTOEND;

 u8 ccnt = 0;

 while(ccnt++ <16)
 {
  while((I2C1->ISR & I2C_ISR_TXIS)==0) if(ee_tim == 0)goto tmo_tx;
  I2C1->TXDR = data[ccnt-1];
 }

 while((I2C1->ISR & I2C_ISR_STOPF)==0) if(ee_tim == 0)goto tmo_tx;

 i2m:

 I2C1->CR2 = 1<<16 | I2C_CR2_START | i2c_addr| I2C_CR2_AUTOEND | I2C_CR2_RD_WRN;
 while((I2C1->ISR & I2C_ISR_BUSY)!=0) if(ee_tim == 0)goto tmo_tx;

 if((I2C1->ISR & I2C_ISR_RXNE)==0)goto i2m;

 i2c_off();
 return 1;

 tmo_tx:
//  *err = I2C1->ISR;
  i2c_off();
  return 0;
}








