/********************************************************
Workspace: IAR_ARM+SPL
MCU      : STM32f030C6T6
Project  : calculator with eeprom and programming and ts keyboard
Version  : 4
Date     : Dec 2018
*********************************************************/

#include <stm32f0xx.h>

#include <stdbool.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <stm32f0xx_gpio.h>
#include <bitset.c>
#include <defines.c>
#include <periph_cfg.c>
#include <kb.c>
#include <sb_works.c>
#include <beep_works.c>
#include <GLCD.c>
#include <display_work.c>
#include <ee_i2c.c>
#include <storage_routines.c>
#include <opstrings.c>
#include <bat_control.c>
#include <calculator_routines.c>
#include <interrupts.c>
#include <crc_calculation.c>
#include <code_lock_routines.c>


bool devcon(u8*);
u8 tmp_key;

void main()
{

 cfg.rcc();
 cfg.gpio();
 cfg.systic(2000);
 cfg.t17(1000); //nvg
 adc_config();

 lcd.Init();
 cfg.I2C();
 rst_I2C();

 beep(400);

 while(1)
 {
  static u8 keys[KEY_DEPTH]={B_NULL,B_NULL,B_NULL};
  static bool kc_trg=0;
  static bool devcon_trg = 1;
  static keyst kline[cols+rows];


  bool lcd_ret = lcd.send_screen(s0,s1);

  //    
  if(!tim2)
  {
   __disable_irq();
   scan_lines(sb_lines);
   __enable_irq();

   sensors_processing(sb_lines, kline);
   tmp_key = result_processing(kline, btn);
  }

  //    
  if(tmp_key == 0xff)
  {
   kc_trg = 0;
   if(!devcon_trg)__WFI();
  }
  //     
  else if(!kc_trg)
  {
   kc_trg = 1;
   tim2 = 200;
   beep(40);

   //  
   for(u8 i=KEY_DEPTH-1;i;i--) keys[i]=keys[i-1];
   keys[0] = tmp_key;

   key2ops_processing(keys, ops, num_mode);

   if(ops!=OP_NULL) devcon_trg=1;
  }

  if(lcd_ret)
  if(devcon_trg)devcon_trg=devcon(keys);

  //      
  if(!tim1)
  {
   static bool dl_trg=0;

   if(!dl_trg)
   {
    dl_trg = 1;
    tim1 = 500;
    CHARGE_OFF;
   }
   else if(do_conversion(&Vbat)==true)
   {
    tim1 = 4500;
    dl_trg = 0;

    if(Vbat>4150)      CHARGE_OFF;
    else if(Vbat<3900) CHARGE_ON;

    if(Vbat<3300) snprintf(s0,sizeof(s0),"Low Vbat: %u%c%02u%c",Vbat/1000,'.',Vbat%1000/10,'V');
   }
  }
 }
}


bool devcon(u8 keys[])
{
 static bool itr=0;
 static enum
 {
  start,work,prog_edit,prog_load,prog_run,edit_key
 } dev_st = start;

 static u8 prog_num;
 static u8 ee_bnum;
 u8 retval = 0;



 switch (dev_st)
 {
  case start:
  {
   static bool unlock_trg;

   if(!itr)
   {
    itr=1;
    unlock_trg = 0;

    ts_discharge();

    //    eeprom    
    //        
    ee_bnum = check_eeprom_bnum();

    //     eeprom   
    //    
    if(ee_bnum)
    {
     restore_options_from_ram(&options);
     restore_key_from_ram(&lock_keys);
    }
    else
    {
     options.precision = DEF_PRECISION;
     lock_keys.key = 0;
    }


    if(get_crc()==false){strcpy(s0,"FLASH CRC ERROR!"); tim0=1000;}
    else if(ee_bnum ==1) strcpy(s0,"EEPROM: 24xx02  ");
    else if(ee_bnum ==2) strcpy(s0,"EEPROM: 24xx04  ");
    else if(ee_bnum ==4) strcpy(s0,"EEPROM: 24xx08  ");
    else                 ee_bnum = 0;

    if(lock_keys.key!=0)
    {
     strcpy(s1,"INPUT UNLOCK KEY");
//     tim0=500;
     strcpy(tmp_string,blank_string);
     pt = tmp_string;
    }
    else strcpy(s1,blank_string);

    for(u8 i=0;i<0xff;i++)ee_buff[i]=OP_NULL;
    beep(30);
   }


   if(!tim0)
   {
    //        
    if(lock_keys.key==0)
    {
     dev_st = work;
     s1[0] = '0';
    }
    //      
    else
    {
     static bool trg=0;

     if(tmp_key == 0xff) trg=0;
     else if(!trg && ops != OP_NULL)
     {
      trg = 1;

      if(unlock_string_entering(lock_keys, ops)==true)
      {
       unlock_trg = 1;
       snprintf(s1,17,"unlocked");
       tim0 = 200;
      }
     }
    }
   }

   if(unlock_trg && !tim0) dev_st = work;


   if(dev_st!=start && !tim0){itr=0;}
  }
  break;

  case work:
  {
   if(!itr)
   {
    itr=1;
    for(u8 i=0;i<KEY_DEPTH;i++)keys[i]=B_NULL;
    ops = OP_NULL;

    retval=1;

    bool tmp =1;
    prg_r(ee_buff, tmp);
   }

   else
   {
    //     
    if(ops == OP_KEYLOCK)
    {
     dev_st = edit_key;
     retval = 1;
    }

    static bool prec_trg=0;
    //      
    if(ops == OP_PREC || prec_trg)
    {
     if(ops == OP_PREC)
     {
      prec_trg=1;
      dop_key_trg = 1;

      if(options.precision > 0x0F)options.precision = 0x0F;

      snprintf(s0,sizeof(s0),"SET PRECISION(%X%c",options.precision,')');
      strcpy(s1,"IN RANGE 0..F:  ");
     }
     else
     {
      switch(ops)
      {
       case OP_0:
       case OP_1:
       case OP_2:
       case OP_3:
       case OP_4:
       case OP_5:
       case OP_6:
       case OP_7:
       case OP_8:
       case OP_9:
       case OP_A:
       case OP_B:
       case OP_C:
       case OP_D:
       case OP_E:
       case OP_F:
       {
        prec_trg =0;
        dop_key_trg = 0;
        u8 tmp_precision = options.precision;

        switch(ops)
        {
         case OP_0: tmp_precision = 0; break;
         case OP_1: tmp_precision = 1; break;
         case OP_2: tmp_precision = 2; break;
         case OP_3: tmp_precision = 3; break;
         case OP_4: tmp_precision = 4; break;
         case OP_5: tmp_precision = 5; break;
         case OP_6: tmp_precision = 6; break;
         case OP_7: tmp_precision = 7; break;
         case OP_8: tmp_precision = 8; break;
         case OP_9: tmp_precision = 9; break;
         case OP_A: tmp_precision =10; break;
         case OP_B: tmp_precision =11; break;
         case OP_C: tmp_precision =12; break;
         case OP_D: tmp_precision =13; break;
         case OP_E: tmp_precision =14; break;
         case OP_F: tmp_precision =15; break;
        }

        if(options.precision != tmp_precision)
        {
         options.precision = tmp_precision;
         save_options(&options);
        }

        disp_output_processing(ops, num_mode);
       }
      }
     }
    }
    else
    {
     //    ,   
     bool ssc_trg = num_mode_selector(ops, num_mode);

     //   
     if(ops == OP_BX)
     {
      //restore stack
      for(int i=0;i<PIT_DEPTH;i++)pit[i] = shadow_pit[i];
     }
     else
     {
      //copy stack to shadow
      for(int i=0;i<PIT_DEPTH;i++)shadow_pit[i] = pit[i];
     }

     //   
     opc_mode_selector(ops, num_mode, opc_mode);
     //      
     opc_mode_change_processing(ops, num_mode, opc_mode);

     //       
     switch(opc_mode)
     {
      //   
      case opc_processing:
      {
       opcode_processing(ops, ee_bnum);
       disp_output_processing(ops, num_mode);
      }break;
      //   
      case edit_mnt      : edit_mnt_processing(ops, num_mode);break;
      //   
      case edit_exp      : edit_exp_processing(ops);          break;
     }

     //     ,   
     if(ssc_trg)
     {
      switch(num_mode)
      {
       case dec: strcpy(s0,"             DEC");break;
       case hex: strcpy(s0,"             HEX");break;
       case bin: strcpy(s0,"             BIN");break;
      }
     }

     if     (ops == OP_PGMM)  {dev_st = prog_edit; retval = 1;}
     else if(ops == OP_FPRUN) {dev_st = prog_load; retval = 1;}
     else if(ops == OP_KPRUN) {dev_st = prog_run;             }
     else if(ops == OP_VBAT)  {snprintf(s0,sizeof(s0),"    Vbat: %u%c%02u%c",Vbat/1000,'.',Vbat%1000/10,'V');}
     else if(ops == OP_RDG)
     {
      if(angle_mode == ang_deg)
      {
       angle_mode = ang_rad;
       strcpy(s0,"             RAD");
      }
      else
      {
       angle_mode = ang_deg;
       strcpy(s0,"             DGR");
      }
     }
    }
   }

   if(dev_st!=work){itr=0;}
  }
  break;

  case prog_load:
  {
   static u8 pre_run_st;
   static bool eem_trg;

   if(!itr)
   {
    itr=1;
    prog_num = 1;
    eem_trg = 0;

    // eeprom       
    //  
    if(ee_bnum<2) pre_run_st=0xff;
    else          pre_run_st=0;

    //        
    retval=1;
   }

   // ,       eeprom
   if(!pre_run_st)
   {
    strcpy(s0,"RESTORE FROM EE?");

    if(ee_bnum==2)
    {
     strcpy(s1,"YES(1)/NO(0)    ");
    }
    else
    {
     strcpy(s1,"YES(1 2 3)/NO(0)");
    }

    pre_run_st = 1;
   }
   else if(pre_run_st==1)
   {
    if(ee_bnum==2) //      
    {
     if(ops == OP_1)
     {
      eem_trg=1;
      pre_run_st=0xff;
      retval=1;
     }
     else if(ops == OP_0) //     eeprom     
     {
      pre_run_st=0xff;
      retval=1;
     }
    }
    else
    {
     if     (keys[0]==B_1)
     {
      pre_run_st=0xff;
      retval=1;
      eem_trg=1;
     }
     else if(keys[0]==B_2)
     {
      prog_num = 2;
      pre_run_st=0xff;
      retval=1;
      eem_trg=1;
     }
     else if(keys[0]==B_3)
     {
      prog_num = 3;
      pre_run_st=0xff;
      retval=1;
      eem_trg=1;
     }
     else if(keys[0]==B_0)
     {
      pre_run_st=0xff;
      retval=1;
     }
    }
   }
   else
   {
    if(eem_trg)i2c_bank_read(prog_num, ee_buff);
    beep(100);
    dev_st = prog_run;
   }


   if(dev_st!=prog_load){itr=0;}
  }
  break;

  case prog_run:
  {
   bool tmp;

   if(!itr)
   {
    itr=1;
    tmp = 1;
    prg_r(ee_buff, tmp);
   }

   while(prg_r(ee_buff, tmp)<0xff);

   dev_st = work;

   if(dev_st!=prog_run)
   {
    itr=0;
    retval = 1;
   }
  }
  break;

  case prog_edit:
  {
   static bool pc_reset;

   if(!itr)
   {
    itr=1;
    pc_reset=1;

    strcpy(s0,"EDIT PROG MODE  ");

    if(ee_bnum==4)
    {
     prog_num = 0xff;
     strcpy(s1,"SET PROG: 1 2 3 ");
    }
    else
    {
     prog_num = 1;
     strcpy(s1, blank_string);
     beep(300);
     retval = 1;
    }
   }

   else
   {
    if(prog_num ==0xff) //   
    {
     if     (ops == OP_1 || ops == OP_0) prog_num =1;
     else if(ops == OP_2) prog_num =2;
     else if(ops == OP_3) prog_num =3;

     if(prog_num !=0xff)
     {
      retval=1;
      if(ops!= OP_0) i2c_bank_read(prog_num, ee_buff);
      beep(300);

      ops = OP_NULL;
     }
    }
    else        // 
    {
     if(ops == OP_PGMM)        //    
     {
      dev_st = work;
      retval = 1;
     }
     else if(ops == OP_SR_EE) //   eeprom
     {
      if(ee_bnum>1)
      {
       save_bank(prog_num, ee_buff);
       beep(100);
      }
     }
     else if(ops == OP_RS_EE) //   eeprom
     {
      if(ee_bnum>1)
      {
       i2c_bank_read(prog_num, ee_buff);
       beep(100);

       pc_reset = 1;
       prg_c(ops,ee_buff,pc_reset);
      }
     }
     else if(ops == OP_FCx && keys[2]==0)
     {
      init_prog_memory(ee_buff);
      prg_visualisation(ee_buff);
     }
     else
     {
      u8 prog_cnt = prg_c(ops,ee_buff,pc_reset);
      prg_visualisation(ee_buff, prog_cnt);
     }
    }
   }

   if(dev_st!=prog_edit){itr=0;}
  }
  break;

  case edit_key:
  {
   static enum {enter_old, enter_new_0, enter_new_1, finalased, exit_from_keys} ks;

   if(!itr)
   {
    itr = 1;

    strcpy(s1, blank_string);

    //     
    strcpy(tmp_string,blank_string);
    pt = tmp_string;

    //    ,    
    if(lock_keys.key != 0)
    {
     snprintf(s0,sizeof(s0),"ENTER LOCK CODE:");
     ks = enter_old;
    }
    //   ,       
    else
    {
     snprintf(s0,sizeof(s0),"enter key 0     ");
     ks = enter_new_0;
    }
   }

   if(ks == enter_old)
   {
    if(unlock_string_entering(lock_keys, ops)==true)
    {
     ks = enter_new_0;
     strcpy(tmp_string,blank_string);
     pt = tmp_string;

     snprintf(s0,sizeof(s0),"enter key 0     ");
    }
   }
   else if(ks == enter_new_0)
   {
    u64 tmp_key;
    if(enter_key_string(&tmp_key, ops)==true)
    {
     lock_keys.key_0 = tmp_key;
     ks = enter_new_1;
     snprintf(s0,sizeof(s0),"enter key 1     ");

     strcpy(s1,blank_string);
     strcpy(tmp_string,blank_string);
     pt = tmp_string;
    }
   }
   else if(ks == enter_new_1)
   {
    u64 tmp_key;
    if(enter_key_string(&tmp_key, ops)==true)
    {
     lock_keys.key_1 = tmp_key;
     if(lock_keys.key_1 == lock_keys.key_0)
     {
      lock_keys.key = tmp_key;
      save_key(&lock_keys);

      ks = finalased;
      retval = 1;
     }
     else
     {
      ks = enter_new_0;
      snprintf(s0,sizeof(s0),"enter key 0     ");
      strcpy(s1,blank_string);
      strcpy(tmp_string,blank_string);
      pt = tmp_string;
     }
    }
   }
   else if(ks == finalased)
   {
    strcpy(s0,blank_string);
    snprintf(s1,sizeof(s1),"keys accepted   ");

    ks = exit_from_keys;
    save_key(&lock_keys);
    tim0 = 300;
    retval = 1;
   }
   else
   {
    if(!tim0) dev_st = work;
    else retval = 1;
   }


   if(dev_st != edit_key){itr = 0;}
  }break;

 }

 if(dev_st == start || dev_st==prog_run || !itr || retval) {retval=0; return 1;}
 return 0;
}