char const* const op_strings[] =
{
 "NOP ",
 "R_EE",
 "S_EE",
 "P0>X",
 "P1>X",
 "P2>X",
 "P3>X",
 "P4>X",
 "P5>X",
 "P6>X",
 "P7>X",
 "P8>X",
 "P9>X",
 "P10X",
 "P11X",
 "P12X",
 "P13X",
 "P14X",
 "P15X",
 "P16X",
 "P17X",
 "P18X",
 "P19X",
 "X>P0",
 "X>P1",
 "X>P2",
 "X>P3",
 "X>P4",
 "X>P5",
 "X>P6",
 "X>P7",
 "X>P8",
 "X>P9",
 "XP10",
 "XP11",
 "XP12",
 "XP13",
 "XP14",
 "XP15",
 "XP16",
 "XP17",
 "XP18",
 "XP19",
 "SBT ",
 "DIV ",
 "SUM ",
 "MUL ",
 "X<>Y",
 "ENT ",
 "Cx  ",
 "OR  ",
 "AND ",
 "NOT ",
 "XOR ",
 "SIN ",
 "COS ",
 "TG  ",
 "ASIN",
 "ACOS",
 "ATG ",
 "PI  ",
 "1X  ",
 "10X ",
 "EXP ",
 "x2  ",
 "X^Y ",
 "LG  ",
 "LN  ",
 "SQR ",
 "YQX ",
 "PITR",
 "PITL",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
     "",
 "A   ",
 "B   ",
 "C   ",
 "D   ",
 "E   ",
 "F   ",
 "0   ",
 "1   ",
 "2   ",
 "3   ",
 "4   ",
 "5   ",
 "6   ",
 "7   ",
 "8   ",
 "9   ",
 ".   ",
 "-   ",
 "E   ",
     ""
};


void outstr_truncation (char in_str[], double const val, u8 precision)
{
 const u8 mss_size    = 0x20;
 const u8 base_str_ln = 0x10;

 char smss [mss_size] = {0};

 int j = base_str_ln-1;
 int sl;

 //          base_str_ln 
 do
 {
  sl = snprintf(smss,sizeof(smss),"%-*.*g",j,j,val);
  j--;
 }
 while (sl > base_str_ln);

 bool exp_trg=0;
 bool comm_trg=0;

 int n_bfr = 0;
 int n_aft = 0;

 //     ,   
 for(int i = 0; i<base_str_ln; i++)
 {
  if     (smss[i]==' ' || smss[i] == 0) break;
  else if(smss[i]=='.')                 {comm_trg = 1;}
  else if(smss[i]=='e' || smss[i]=='E') {exp_trg = 1; comm_trg=1;}

  if(!comm_trg){if(smss[i] !='-') n_bfr++;}
  else if(!exp_trg) n_aft++;
 }

 //      
 if(n_aft) n_aft--;

 //      +  
 if(precision > n_aft) precision = n_aft;

 j = n_bfr + precision;

 if(j==0)j=1;
 else if(j>15)j=15;

 snprintf(in_str,17,"%-*.*g",j,j,val);
}

