
class
{
 public:

 void rcc()
 {
  RCC->CFGR = bin(0010)<<18;   //PLLMUL_x4
  RCC->CFGR&= ~RCC_CFGR_PLLSRC; //HSI/2 as PLL input clock

  RCC->CR|= RCC_CR_PLLON;
  while ((RCC->CR&RCC_CR_PLLON) == 0) asm("nop");

  RCC->CFGR|= bin(10); //PLL as system clock
  while (RCC->CFGR & bin(10)<<2 != bin(10)<<2) asm("nop");


  RCC->AHBENR |= RCC_AHBENR_GPIOAEN|RCC_AHBENR_GPIOBEN|RCC_AHBENR_GPIOCEN|RCC_AHBENR_GPIOFEN;

  RCC->APB2ENR|= RCC_APB2ENR_TIM17EN;

  RCC->APB1ENR |= RCC_APB1ENR_I2C1EN;
 }

 void gpio()
 {
  GPIO_InitTypeDef GIS;

  GIS.GPIO_Speed = GPIO_Speed_2MHz;

 //PC13,14,15 - pullup for reset
  GIS.GPIO_Pin   = GPIO_Pin_13|GPIO_Pin_14|GPIO_Pin_15;
  GIS.GPIO_Mode  = GPIO_Mode_IN;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;

  GPIO_Init(GPIOC, &GIS);

 //PF0 - pullup for reset
  GIS.GPIO_Pin   = GPIO_Pin_0;

  GPIO_Init(GPIOF, &GIS);

  //PF1 - output 2 buzzer
  GIS.GPIO_Pin   = GPIO_Pin_1;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_OType = GPIO_OType_PP;

  GPIO_Init(GPIOF, &GIS);

  //PA0 - adc input
  GIS.GPIO_Pin   = GPIO_Pin_0;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_Mode  = GPIO_Mode_AN;

  GPIO_Init(GPIOA, &GIS);

 //PA1...7 - TS
  GIS.GPIO_Pin   = GPIO_Pin_1|GPIO_Pin_2|GPIO_Pin_3|GPIO_Pin_4|
                   GPIO_Pin_5|GPIO_Pin_6|GPIO_Pin_7;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOA, &GIS);

 //PB0...2 TS
  GIS.GPIO_Pin   = GPIO_Pin_0|GPIO_Pin_1|GPIO_Pin_2;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOB, &GIS);

 //PB10,11 I2C interconnect
  GIS.GPIO_Pin   = GPIO_Pin_10|GPIO_Pin_11;
  GIS.GPIO_Mode  = GPIO_Mode_AF;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOB, &GIS);

  GPIO_PinAFConfig(GPIOB, GPIO_PinSource10, GPIO_AF_1);
  GPIO_PinAFConfig(GPIOB, GPIO_PinSource11, GPIO_AF_1);

 //PB12 charger control pin
  GIS.GPIO_Pin   = GPIO_Pin_12;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOB, &GIS);
  GPIO_WritePin(GPIOB,GPIO_Pin_12,1);

 //PB13...15 TS
  GIS.GPIO_Pin   = GPIO_Pin_13|GPIO_Pin_14|GPIO_Pin_15;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOB, &GIS);

 //PA8...12 -TS
  GIS.GPIO_Pin   = GPIO_Pin_8|GPIO_Pin_9|GPIO_Pin_10|GPIO_Pin_11|GPIO_Pin_12;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOA, &GIS);

 //PF6,7 - TS
  GIS.GPIO_Pin   = GPIO_Pin_6|GPIO_Pin_7;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_OType = GPIO_OType_OD;

  GPIO_Init(GPIOF, &GIS);

 //PA15 - nc
  GIS.GPIO_Pin   = GPIO_Pin_15;
  GIS.GPIO_PuPd  = GPIO_PuPd_UP;
  GIS.GPIO_Mode  = GPIO_Mode_IN;

  GPIO_Init(GPIOA, &GIS);

 //PB3...8 out 2 LCD
  GIS.GPIO_Pin   = GPIO_Pin_3|GPIO_Pin_4|GPIO_Pin_5|GPIO_Pin_6|GPIO_Pin_7|
                   GPIO_Pin_8;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_OType = GPIO_OType_PP;

  GPIO_Init(GPIOB, &GIS);

 //PB9 negative voltage generator 2 LCD
  GIS.GPIO_Pin   = GPIO_Pin_9;
  GIS.GPIO_OType = GPIO_OType_PP;
  GIS.GPIO_Mode  = GPIO_Mode_AF;

  GPIO_Init(GPIOB, &GIS);
  GPIO_PinAFConfig(GPIOB, GPIO_PinSource9, GPIO_AF_2);


 //----------------------------------------------- 

  GIS.GPIO_Pin   = GPIO_Pin_9|GPIO_Pin_7|GPIO_Pin_6;
  GIS.GPIO_Mode  = GPIO_Mode_OUT;
  GIS.GPIO_PuPd  = GPIO_PuPd_NOPULL;
  GIS.GPIO_OType = GPIO_OType_PP;
  GPIO_Init(GPIOA, &GIS);

  GIS.GPIO_Pin   = GPIO_Pin_14|GPIO_Pin_2;
  GPIO_Init(GPIOB, &GIS);

 //----------------------------------------------- 
  GIS.GPIO_Pin   = GPIO_Pin_15;
  GPIO_Init(GPIOB, &GIS);

  GIS.GPIO_Pin   = GPIO_Pin_11|GPIO_Pin_3|GPIO_Pin_1;
  GPIO_Init(GPIOA, &GIS);

  GIS.GPIO_Pin   = GPIO_Pin_6;
  GPIO_Init(GPIOF, &GIS);
 }

 void t17(u32 itr_frq) //negative voltage generator for LCD
 {
  TIM17->ARR    = system_frq/itr_frq/2-1;
  TIM17->CCMR1  = bin(011)<<4;//toggle
  TIM17->CCER   = TIM_CCER_CC1E;
  TIM17->BDTR   = TIM_BDTR_MOE;
  TIM17->CR1    = TIM_CR1_CEN;
 }

 void I2C()
 {
  I2C1->CR1 = 0;

  //10kHz_i2c & 8MHz_clk
  I2C1->TIMINGR = 1UL<<28;  //prescaler
  I2C1->TIMINGR|= 4UL<<20;  //SCLDEL
  I2C1->TIMINGR|= 2UL<<16;  //SDADEL
  I2C1->TIMINGR|= 0xC3UL<<8;//SCLH
  I2C1->TIMINGR|= 0xC7UL;   //SCLL

//  //100kHz_i2c & 8MHz_clk
//  I2C1->TIMINGR = 0x1UL<<28;  //prescaler
//  I2C1->TIMINGR|= 4UL<<20;  //SCLDEL
//  I2C1->TIMINGR|= 2UL<<16;  //SDADEL
//  I2C1->TIMINGR|= 0x0fUL<<8;//SCLH
//  I2C1->TIMINGR|= 0x13UL;   //SCLL

//  I2C1->TIMEOUTR = I2C_TIMEOUTR_TIMEOUTA | I2C_TIMEOUTR_TIMEOUTB
//                 | I2C_TIMEOUTR_TIMOUTEN;// | I2C_TIMEOUTR_TEXTEN;

 }

 void systic(int frq)
 {
  SysTick->LOAD  = system_frq/frq-1;
  NVIC_SetPriority (SysTick_IRQn, 3);
  SysTick->CTRL  = SysTick_CTRL_CLKSOURCE_Msk|SysTick_CTRL_TICKINT_Msk|SysTick_CTRL_ENABLE_Msk;
 }
}cfg;




