#include <sb_works.h>

#define PAD_TRSH 3

#define _IN  (GPIO_def+i)->GPIOx, (GPIO_def+i)->shift_a
#define OUT_ (GPIO_def+i)->GPIOx, (GPIO_def+i)->shift_a,(bool)
#define OUTC (GPIO_def+i)->GPIOxc,(GPIO_def+i)->shift_b,(bool)

u8 sb_lines[cols+rows];

u32 L_IDR (GPIO_TypeDef *GPIOx, u16 shift)
{
 return (u32)(GPIOx->IDR & 1<<shift);
}

void L_DDR (GPIO_TypeDef *GPIOx, u16 shift, bool x)
{
 (x)?(GPIOx->MODER|=1<<2*shift):(GPIOx->MODER&=(~(3<<2*shift)));
}

void L_ODR (GPIO_TypeDef *GPIOx, u16 shift, bool x)
{
 (x)?(GPIOx->BSRR  =1<<shift):(GPIOx->BRR =1<<shift);
}

void LC_ODR(GPIO_TypeDef *GPIOx, u16 shift, bool x)
{
 (x)?(GPIOx->BSRR  =1<<shift):(GPIOx->BRR =1<<shift);
}

void ts_discharge(void)
{
 for(u8 i=0;i<cols+rows;i++)
 {
  L_DDR (OUT_ 1);
  L_ODR (OUT_ 0);
  LC_ODR(OUTC 0);
 }
}

void scan_lines(u8 sb_lines[])
{
 for(u8 i=0;i<cols+rows;i++)
 {
  sb_lines[i] = 0;

  //    
  L_ODR (OUT_ 0);
  L_DDR (OUT_ 1);
  LC_ODR(OUTC 0);
  // 
  __no_operation();

  //     
  L_DDR(OUT_ 0);
  L_ODR(OUT_ 1);

  u8 cnt = 0;
  //    
  do
  {
   sb_lines[i]++;

   //    
   LC_ODR(OUTC 1);

   // 
   L_DDR(OUT_ 1);

   //  
   __no_operation();

   //   
   L_DDR(OUT_ 0);
   //    
   LC_ODR(OUTC 0);

   //    
   __no_operation();

   //      1  
   if(L_IDR(_IN) !=0) cnt++;
   else cnt = 0;
  }
  //       
  while (cnt<2 && sb_lines[i]<0xfe);

 //    
  L_ODR(OUT_ 0);
  L_DDR(OUT_ 1);
 }
}

void sensors_processing(u8 sb_lines[], enum keyst kline[])
{
 static u8 prev [cols+rows];
 static s8 delta[cols+rows];
 static u8 cntdn[cols+rows];

 static bool h = false;

 for(u8 i=0;i<cols+rows;i++)
 {
  static s8 tmp;
  if(i==0 || i==cols)tmp=0;

  // 
  if(h==false){prev[i] = sb_lines[i];}//kb_tim[i]=3000;}

 //    
  delta[i] += prev[i]-sb_lines[i];
 //      
  if(delta[i] <0)delta[i]=0;

  if(prev[i]+1 < sb_lines[i] || prev[i] > sb_lines[i]+1) //  
  {
   cntdn[i] = 0;
  }
  else  //  ,  
  {
   if(cntdn[i] < 2) cntdn[i]++;
   else  //      
   {
    if(delta[i] < PAD_TRSH) //  ,   
    {
     kline[i] = rls;
    }
    else if(delta[i] >= PAD_TRSH) //    
    {
     if(i<cols) //   
     {
      if(delta[i]>tmp) //      
      {
       tmp = delta[i];
       for(u8 z=0;z<cols;z++) kline[z] = rls;
       kline[i] = prs;
      }
     }
     else      //   
     {
      if(delta[i]>tmp) //      
      {
       tmp = delta[i];
       for(u8 z=cols;z<cols+rows;z++) kline[z] = rls;
       kline[i] = prs;
      }
     }
    }
   }
  }

  prev[i] = sb_lines[i];
 }

 h = true;
}

u8 result_processing(enum keyst kline[], enum keyst btn[cols][rows])
{
 u8 kbm = 0xff; //

 //  
 for(u8 c=0;c<cols;c++)
  for(u8 r=cols;r<cols+rows;r++)
  {
   //     
   if(kline[c] ==prs && kline[r] ==prs)
   {
    //      ""
    if(btn[c][r-cols] !=prs)
    {
     btn[c][r-cols] = prs;

     kbm = c + (r-cols)*cols; //     
    }
   }
   else btn[c][r-cols] = rls;
  }

 return kbm;
}



