#include <storage_routines.h>

#define DEF_PRECISION 4
#define STORAGE_NUM 20 //   2

u8 ee_buff[0xff];
extern double storage[STORAGE_NUM];


bool read_mregs(void)
{
 bool opres = i2c_bank_read(0, ee_buff);

 for(u8 i=0;i<STORAGE_NUM;i++)storage[i] = *((double*)ee_buff+i);

 return opres;
}

bool save_mregs(void)
{
 bool opres=1;
 double mreg[2];

 for(u8 i=0;i<STORAGE_NUM;i+=2)
 {
  mreg[0] = storage[i];
  mreg[1] = storage[i+1];

  opres &= i2c_buffered_write(i/2*16, (u8*)mreg);
 }

 return opres;
}

bool save_bank(u8 bank_num, u8 ee_buff[0xff])
{
 bool opres=1;
 u16 addr = bank_num*256;

 for(u16 i=0;i<0xff;)
 {
  opres &= i2c_buffered_write(addr+i,(u8*)(ee_buff+i));
  i += 16;
 }
 return opres;
}

u8 check_eeprom_bnum(void)
{
 u8 bank_num=0;
 const char ee_cps[]="num_of_banks:";
 bool i2c_ok=1;

 i2c_ok &= read_mregs();

 if(strcmp((char*)ee_cps,(char*)ee_buff+0xfe-sizeof(ee_cps))==0) bank_num = ee_buff[0xff-1];
 else
 {
  //      prom

  for(u8 i=0;i<4;i++)
  {
   i2c_ok &= i2c_write(i*256+0xfe, i+1);

   u8 tmp;
   i2c_ok &= i2c_read(i*256+0xfe, &tmp);

   if(i+1==tmp) bank_num++;
  }

  if(bank_num)
  {
   for(u8 i=0; i<sizeof(ee_cps);i++)
   {
    i2c_ok &= i2c_write(0xfe-sizeof(ee_cps)+i, ee_cps[i]);
   }

   i2c_ok &= i2c_write(0xfe, bank_num);

   //  
   for(int i=0;i<STORAGE_NUM-1;i++)storage[i]=0;
   save_mregs();

   lock_keys.key = 0;
   save_key(&lock_keys);

   options.precision = 4;
   save_options(&options);
  }
 }

 if(i2c_ok == false)return 0xff;

 return bank_num;
}

//_______________________________________________

bool save_key(ee_keys *keys)
{
 bool opres=1;

 keys->key_0 = keys->key;
 keys->key_1 = ~keys->key_0;

 //    
 opres &= i2c_buffered_write(sizeof storage, (u8*)keys);

 return opres;
}

bool restore_key(ee_keys *keys)
{
 bool opres =1;

 int m0 = sizeof(storage);
 int m1 = sizeof(ee_keys) - sizeof (u64);

 for(int i=m0;i<m0+m1;i++) opres &= i2c_read(i, (u8*)keys+i-m0);

 if(keys->key_0 == ~keys->key_1) keys->key = keys->key_0;
 else keys->key = 0;

 if(!opres) return 0;

 return 1;
}

void restore_key_from_ram(ee_keys *keys)
{
 int m0 = sizeof(storage);
 int m1 = sizeof(ee_keys) - sizeof(u64);

 for(int i=m0;i<m0+m1;i++) *((u8*)keys+i-m0) = ee_buff[i];

 if(keys->key_0 == ~keys->key_1) keys->key = keys->key_0;
 else keys->key = 0;
}

//_______________________________________________
bool save_options(const ee_options *options)
{
 int tmp = sizeof storage + sizeof lock_keys - sizeof (u64);
 // 16        
 bool opres = i2c_buffered_write(tmp, (u8*)options);

 return opres;
}

bool restore_options(ee_options *options)
{
 bool opres = 1;
 int m0 = sizeof(storage) + sizeof (ee_keys) - sizeof (u64);
 int m1 = sizeof(ee_options);

 for(int i=m0;i<m0+m1;i++) opres &= i2c_read(i, (u8*)options+i-m0);

 return opres;
}

void restore_options_from_ram(ee_options *options)
{
 int m0 = sizeof(storage) + sizeof (ee_keys) - sizeof(u64);
 int m1 = sizeof(ee_options);

 for(int i=m0;i<m0+m1;i++) *((u8*)options+i-m0) = ee_buff[i];
}