/*****************************************************
This program was produced by the
CodeWizardAVR V2.04.4a Advanced

Project :   
Version : 
Date    : 24.04.2010
Author  : Pervakov Danil

Chip type               : ATtiny2313
AVR Core Clock frequency: 4,000000 MHz
Memory model            : Tiny
External RAM size       : 0
Data Stack size         : 32
*****************************************************/
//
// Fuse CKSEL = 0010, SUT = 10 (Int.RC 4 MHz) 
//
// EEPROM usage: 0 byte(s), 0,0% of EEPROM
// Program size: 829 words (1658 bytes), 81,0% of FLASH
//
//  DS18S20 / DS18B20 - (PORTD bit 6)
//

//  -          ,    IBM PC XT   Intel 8088 
#include <tiny2313.h>

// 1 Wire Bus functions
#asm
   .equ __w1_port=0x12 ;PORTD
   .equ __w1_bit=6
#endasm

// DS18x20 Temperature Sensor functions
#include "ds18x20_v2.h"  

#include <delay.h> 
#include <bcd.h>

//---------------------------------------
#define A   2
#define B  32
#define C   4 
#define D  64  
#define E 128 
#define F   1 
#define G   1 

static flash unsigned char digits_PA[] = {
	(A+F), // 0
	(0),   // 1
	(A),   // 2
	(A),   // 3
	(F),   // 4
	(A+F), // 5
	(A+F), // 6
	(A),   // 7
	(A+F), // 8
	(A+F), // 9
	(A+F), // A - 10
	(F),   // b - 11
	(A+F), // C - 12
	(0),   // d - 13
	(A+F), // E - 14
	(A+F), // F - 15
	(0),   // 16 -  
	(A+F), // 17 -   
	(0)    // 18 - 
};

static flash unsigned char digits_PB[] = {
	(B+C+D+E),   // 0
	(B+C),       // 1
	(B+D+E+G),   // 2
	(B+C+D+G),   // 3
	(B+C+G),     // 4
	(C+D+G),     // 5
	(C+D+E+G),   // 6
	(B+C),       // 7
	(B+C+D+E+G), // 8
	(B+C+D+G),   // 9
	(B+C+E+G),   // A - 10
	(C+D+E+G),   // b - 11
	(D+E),       // C - 12
	(B+C+D+E+G), // d - 13
	(D+E+G),     // E - 14
	(E+G),       // F - 15
	(G),         // 16 -  
	(B+G),       // 17 -   
	(0)          // 18 - 
};

#define MINUS  16
#define GRADUS 17
#define PROBEL 18
#define SYMBOL_F 15

// K1 - PORTD.0-1, K2 - PORTD.2-3, K3 - PORTD.4-5
static flash unsigned char cursor[]={0b11111100, 0b11110011, 0b11001111}; 

unsigned char digit_out[3], cur_dig;
bit zpt_ON;
int temperature;       // ,    


// maximum number of DS1820/DS18S20/DS18B20 devices connected to the 1 Wire bus
#define MAX_DS18x20 4

// DS1820/DS18S20/DS18B20 devices ROM code storage area, 9 bytes are used for each device
unsigned char rom_code[MAX_DS18x20][9];


// ----------------------------------------------------------------------------
//
// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void) {
    //TCNT0=0xE6;// Reinitialize Timer 0 value

    PORTD|=0b00111111;    //   (   "1" -  ..)
        
    PORTA=digits_PA[digit_out[cur_dig]]; //   
    PORTB=digits_PB[digit_out[cur_dig]];

    if ((zpt_ON == 1) && (cur_dig == 1)) PORTB.4=1;  //     ( .  )        

    PORTD&=(cursor[cur_dig]);  //    (   "0" -  ..)

    cur_dig++; if (cur_dig > 2) cur_dig=0;
}



// ----------------------------------------------------------------------------
void view_term(void) {
	unsigned char celie, drob, tmp;
	unsigned int temp, celie_tmp, drob_tmp;


	temp = (unsigned int) temperature;
        
	if (temperature>=0) {
		digit_out[0]=PROBEL;       //   ()  
	} else {        
		temp = ( ~temp ) + 0x0001; //       . 
		digit_out[0]=MINUS;        //     (   ..)
		 };
	//digit_out[3]=GRADUS;
	zpt_ON=1; 

	celie_tmp = temp >> 4;              //   
	drob_tmp  = temp & 0x000F;          //      1/16 

	drob  = (unsigned char) ((drob_tmp * 10) / 16); //      "1/16 "      0,1  

	celie = (unsigned char) celie_tmp;  //     

	if (celie >= 100) {tmp=bin2bcd(celie-100); digit_out[0] = 1; } else { tmp=bin2bcd(celie); }   //   

	if ((celie >= 100) || ((digit_out[0] == MINUS) && (celie >= 10))) { //    100,0 .   .  -10  1 .
		zpt_ON=0;
		digit_out[1] = tmp >> 4;    // 
		digit_out[2] = tmp & 0x0F;  //  
	}

	if ((digit_out[0] == MINUS) && (celie < 10)) { //  . 0   -10  0,1 .
		digit_out[1] = celie; // 
		digit_out[2] = drob;  //  
	}

	if ((digit_out[0] == PROBEL) && (celie < 100)) { //  .  100,0    0   0,1 .
		if (tmp >> 4) digit_out[0] = tmp >> 4; //  -       
		digit_out[1] = tmp & 0x0F;             // 
		digit_out[2] = drob;                   //  
	}
}  // -------------------------------------------------------------------------





//================================== main =====================================
void main(void) {
unsigned char i, ds18x20_devices;

// Input/Output Ports initialization
// Port A initialization
PORTA=0x00; // State2=T State1=0 State0=0
DDRA=0x03;  // Func2=In Func1=Out Func0=Out

// Port B initialization
PORTB=0x00; // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
DDRB=0xFF; // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out

// Port D initialization
PORTD=0x3F;// State6=T State5=1 State4=1 State3=1 State2=1 State1=1 State0=1
DDRD=0xFF; // Func6=In Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out

/*
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 3,906 kHz
// Mode: Normal top=FFh
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x05;
TCNT0=0xE6;
OCR0A=0x00;
OCR0B=0x00;
*/

// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 62,500 kHz
// Mode: Normal top=FFh
// OC0A output: Disconnected
// OC0B output: Disconnected
TCCR0A=0x00;
TCCR0B=0x03;
TCNT0=0x00;
OCR0A=0x00;
OCR0B=0x00;


// Timer/Counter 1 initialization
// Clock value: Timer1 Stopped
TCCR1A=0x00;
TCCR1B=0x00;
TCNT1H=0x00;
TCNT1L=0x00;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x00;
OCR1BH=0x00;
OCR1BL=0x00;

// External Interrupt(s) initialization
// INT0, INT1, Interrupt on any change on pins PCINT0-7: Off
GIMSK=0x00;
MCUCR=0x00;

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK=0x02;

// Universal Serial Interface initialization
// Mode: Disabled
USICR=0x00;

// Analog Comparator initialization
// Analog Comparator: Off
ACSR=0x80;

// 1 Wire Bus initialization
w1_init();

// Determine the number of DS18x20 devices connected to the 1 Wire bus
ds18x20_devices=w1_search(0xf0,rom_code);

// Global enable interrupts
#asm("sei")

//    F '-  '
digit_out[0]=SYMBOL_F;
digit_out[1]=PROBEL;
digit_out[2]=ds18x20_devices;

// ..       
//      
if (ds18x20_devices >= 1) {
	for (i=0;i<ds18x20_devices;i++) {
//		if (rom_code[i][0] == DS18B20_FAMILY_CODE){
//			temperature=ds18b20_temperature(&rom_code[i][0]); 
//		}
		if (rom_code[i][0] == DS18S20_FAMILY_CODE){
			temperature=ds18s20_temperature(&rom_code[i][0]); 
		}
		delay_ms(1000);
	}
} else {
	delay_ms(2000);
}


 // --------------------------------   -----------------------------------
 while (1) {
                
        if (ds18x20_devices >= 1) {  //     

                for (i=0;i<ds18x20_devices;) {
                        if (rom_code[i][0] == DS18B20_FAMILY_CODE){
                             temperature=ds18b20_temperature(&rom_code[i][0]); 
                        }
                        if (rom_code[i][0] == DS18S20_FAMILY_CODE){
                             temperature=ds18s20_temperature(&rom_code[i][0]); 
                        }
                        if (temperature!=-9999) view_term();

                        delay_ms(2000);
                        i++;
                }
        }
 };// -----------------------------   (end) -----------------------------------

      
      
} // =================================== end main =========================================




//
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= The End -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//
                                                                              