//        NEC
//   16000000 MHz
//  IR NEC  \ T0.
// IR      INT0

#include <avr/io.h>
#include <avr/interrupt.h>
#include "ir_nec.h"

//***************************************************************************************************************************

ir_t ir; // structure for NEC protocols

//***************************************************************************************************************************
//   

char IrNecData [4];				//    
char IrNecCounBites;			//   

volatile char IrNecFlags;		// 
#define bIrNecStreamEnb	(1<<0)	//     
#define bIrNecRcvCmpltd	(1<<1)	//   
#define bIrNecTmrOvf 	(1<<2)	//   \

volatile char count=1;

//***************************************************************************************************************************
//  
void IrNecInit (void)
{
	//    
	DDRB |= _BV(PB1); PORTB |= _BV(PB1);		//   	
	DDRD &= ~_BV(PD2); PORTD |= _BV(PD2);		//    
	
	// / T0				(0x01-clk, 0x02-clk/8, 0x03-clk/64, 0x04-clk/256, 0x05-clk/1024)
	TCCR0 = (1 << CS02) | (1 << CS00);			//  T0 	
	TIMSK |= (1 << TOIE0);						//    T0

	//  
	GICR  |= (1 << INT0);						//     INT0
	MCUCR |= (1 << ISC01) | (0 << ISC00);		//     
}
//***************************************************************************************************************************
//   IR NEC
// -         (0x00 -   , 0xFF -  )
char IrNecDataCheck (void)
{
	if (IrNecFlags & bIrNecRcvCmpltd)
		return 0xff;
		return 0x00;
}
//***************************************************************************************************************************
//   IR NEC
// -   .
unsigned char IrNecDevNumGet (void)
{
	volatile char* pAddr = &IrNecData[0];					//      
	return *pAddr;
}
//***************************************************************************************************************************
//   IR NEC
// -  .
unsigned char IrNecCommandGet (void)
{
	volatile char* pCommand = &IrNecData[2];				//     
	IrNecFlags &= ~bIrNecRcvCmpltd;							//    
	return *pCommand;
}
//***************************************************************************************************************************
//  INT0 (  )
ISR (INT0_vect)
{
	uint16_t val = TCNT0*count;								//    
	TCNT0 = 0; count = 1;									//     (    )
	char flags = IrNecFlags;								//   						
	if (ir.flip == 0) return;								//    											
	
	//  
	if (flags & bIrNecTmrOvf) {						
		flags &= ~(bIrNecTmrOvf | bIrNecStreamEnb);
		IrNecFlags = flags; IrNecCounBites = 0;				//     (..   )
		return;
	}
	//  
	if((val > 170) && (val < 184))							//11,25   ( 10,8 ... 11,8 )
		{
		ir.flip = 0;
		return;
		}

	//   
	if ((val > 148) && (val < 256))							//16MHz 158  -     (  140 - 260)
		{
			IrNecCounBites = 0;								//   
			flags |= bIrNecStreamEnb;
			IrNecFlags = flags;								//   (..   )
			return;
		}			
	
	//   (..    )
	if (flags & bIrNecStreamEnb) {					
		if ((val < 10) || (val >= 46))						//    
		{	
			IrNecCounBites = 0;								//   
			flags &= ~bIrNecStreamEnb;
			IrNecFlags = flags;								//   (..   )
			return;
		}
		
		//   ,    
		char* pIrNecData = IrNecData + (IrNecCounBites >> 3);
		char BitNum = 0x80 >> (IrNecCounBites & 0x07);
		if (val >= 26)
			*pIrNecData |= BitNum;							//  = 1 ( = 1   17-35)	
		else
			*pIrNecData &= ~BitNum;							//  = 0 ( = 0   8-16)
			
		//,     IR NEC
		if (++IrNecCounBites == 32) {						//  32 	
			if ((char)~IrNecData[0] == IrNecData[1]) {		//      
				if ((char)~IrNecData[2] == IrNecData[3])	//     
				{	
					IrNecCounBites = 0;
					flags |= bIrNecRcvCmpltd;				//  -     
					ir.addr = IrNecData[0];					// 
					ir.code = IrNecData[2];					// 
					ir.flip = 1;							//   
				}

			}
			flags &= ~bIrNecStreamEnb;						// 
			IrNecFlags = flags;								//   (..   )
		}
	}
}
//***************************************************************************************************************************
//   T0
ISR (TIMER0_OVF_vect)
{
	IrNecFlags |= bIrNecTmrOvf;	count = 1; ir.flip = -1;		// 
}
//***************************************************************************************************************************

