lines = ["cmd:   size:   data:   subroutine: description:"]
for i in range(72):
    cmd = Byte(0x9a4f+i)
    size = Byte(0x9a05+i)
    data = Byte(0x992b+i)*0x100 + Byte(0x9973+i)
    sub = Byte(0x99bb+i)
    desc = Comment(0x9a4f+i)
    if desc is None:
        desc = ""
    lines.append(
            "0x{0:02X}   {1:<8}0x{2:04X}  {3:<12}{4}".format(
                cmd,
                size,
                data,
                sub,
                desc
            )
    )
with open("internal_cmd_table.txt", 'w') as txt:
    txt.write("\n".join(lines))

