								.include "m328Pdef.inc"
/*.equ	BITRATE_1200 = 1200
.equ	BAUD_1200 = 7372800 / (16 * BITRATE_1200)
.equ	BITRATE_9600 = 9600
.equ	BAUD_9600 = 7372800 / (16 * BITRATE_9600)
*/


//.equ	CPU_FREQUENCY = 1000000
//.equ	CPU_FREQUENCY = 7372800
.equ	CPU_FREQUENCY = 16000000

.equ	BITRATE_1200 = 1200
.equ	BAUD_1200 = CPU_FREQUENCY / (16 * BITRATE_1200)
.equ	BITRATE_9600 = 9600
.equ	BAUD_9600 = CPU_FREQUENCY / (16 * BITRATE_9600)

.equ 	RBSIZE=0x80
.equ	F_SCL = 100000
.equ	TWBR_DATA = ((CPU_FREQUENCY / F_SCL) -16) /2


.equ	DS1307_I2C_ADDRES =	0xD0	
.equ	RESET_COUNTER_MAX =	0x40


	.dseg
state:
	.byte 1						; 

op_type:
	.byte 1

data_out:
	.byte 1

meandervalue:
	.byte 1
;RESET_COUNTER:
;	.byte 1
;RESET_FMM_STATE:
	.byte 1								
DELAY_HI:
	.byte 1
DELAY_LO:
	.byte 1
CHAR_CODE:
	.byte 1
POS_NUMBER:
	.byte 1
X_POS:
	.byte 1
Y_POS:
	.byte 1
CURSOR_16_POS:
	.byte 1

TWI_BUSY:
	.byte 1
I2C_DEVICE_ADDRES:
	.byte 1
NUMBER_REGISTER_TO_READ:
	.byte 1
NUMBER_REGISTER_TO_WRITE:
	.byte 1
I2C_DATA_FOR_OUTPUT:
	.byte 1
I2C_DATA_FOR_OUTPUT_ENABLE:				; 0 - NO DATA FOR OUTPUT    1- DADA FOR OUTPUT PRESENT
	.BYTE 1
I2C_DATA_NEED_READ_START:
	.byte 1								; 0 nothing do   1-will by stsrt read TWI
I2C_INPUT_DATA:
	.byte 1
BCD_SECONDS:
	.byte 1
BCD_MINUTES:
	.byte 1
BCD_HOURS:
	.byte 1
BCD_DAY:
	.byte 1
BCD_DATE:
	.byte 1
BCD_MONTH:
	.byte 1
BCD_YAR:
	.byte 1


tmp_latch:
	.byte 1


	.cseg

	

	.org 0x00
		jmp RESET 		; Reset Handler
		jmp EXT_INT0 	; IRQ0 Handler
		jmp EXT_INT1 	; IRQ1 Handler
		jmp _PCINT0 		; PCINT0 Handler
		jmp _PCINT1 		; PCINT1 Handler
		jmp _PCINT2 		; PCINT2 Handler
		jmp WDT 		; Watchdog Timer Handler
		jmp TIM2_COMPA 	; Timer2 Compare A Handler
		jmp TIM2_COMPB 	; Timer2 Compare B Handler
		jmp TIM2_OVF 	; Timer2 Overflow Handler
		jmp TIM1_CAPT 	; Timer1 Capture Handler
		jmp TIM1_COMPA 	; Timer1 Compare A Handler
		jmp TIM1_COMPB 	; Timer1 Compare B Handler
		jmp TIM1_OVF 	; Timer1 Overflow Handler
		jmp TIM0_COMPA 	; Timer0 Compare A Handler
		jmp TIM0_COMPB 	; Timer0 Compare B Handler
		jmp TIM0_OVF 	; Timer0 Overflow Handler
		jmp SPI_STC 	; SPI Transfer Complete Handler
		jmp USART_RXC 	; USART, RX Complete Handler
		jmp USART_UDRE 	; USART, UDR Empty Handler
		jmp USART_TXC 	; USART, TX Complete Handler
		jmp _ADC 		; ADC Conversion Complete Handler
		jmp EE_RDY 		; EEPROM Ready Handler
		jmp ANA_COMP 	; Analog Comparator Handler
		jmp TWI 		; 2-wire Serial Interface Handler
		jmp SPM_RDY 	; Store Program Memory Ready Handler

EXT_INT0:			 	; IRQ0 Handler
		RETI
EXT_INT1:			 	; IRQ1 Handler
		RETI

_PCINT0:			 		; PCINT0 Handler
		RETI

_PCINT1:			 		; PCINT1 Handler
		RETI

_PCINT2: 				; PCINT2 Handler
		RETI

WDT: 					; Watchdog Timer Handler
		RETI

TIM2_COMPA: 




			; Timer2 Compare A Handler
	sbi		portc,2	



	push	r16
	uin		r16, SREG
	push 	r16
	push 	r17
	push	r18
	push 	zl
	push 	zh




	

	lds		zh, DELAY_HI
	lds		zl, DELAY_LO
	ldi		r16,1
	ldi		r17,0

	sub		zl, r16
	sbc		zh, r17

	sts		DELAY_HI, zh
	sts		DELAY_LO, Zl



	lds		r16, meandervalue
	inc		r16
	andi	r16,0b00000001
	sts		meandervalue,r16

	cpi		r16,0
	breq	tmr_0

	sbi		portc, 3
	jmp		tmr_end

tmr_0:
	cbi		portc, 3
	

tmr_end:


;-----------------------------------------------
;TWI_BUSY
; 0- free
; 1- start read witch repeat
; 2- read done
; 3- start write
; 5- write done
;--------------------TWI WR\RW START-------------

	uin		r16,TWCR
	ANDI	r16,0x80	;wait
	BRNE	twi_operatio_start_end				;TWI  H\W IS NOT FREE

	LDS		r16, TWI_BUSY
	CPI		r16, 0
	BRNE	twi_operatio_start_end				; TWI_BUSY is NOT CLEAR

	LDS		r16, I2C_DATA_NEED_READ_START
	CPI		r16, 1
	BRNE	write_section						; IF TWI read flag not set

	LDS 	r16, 0
	STS		I2C_DATA_NEED_READ_START, r16		; reset start read flag
	LDS 	r16, 1
	STS		TWI_BUSY, r16						; TWI_BUSY <= 1

	RJMP	i2c_hw_start



write_section:

	LDS		r16, I2C_DATA_FOR_OUTPUT_ENABLE
	CPI		r16, 1
	BRNE	twi_operatio_start_end				; IF TWI write flag not set

	LDI		r16, 0
	STS		I2C_DATA_FOR_OUTPUT_ENABLE, r16		; reset start write flag
	LDI		r16,3							
	STS		TWI_BUSY, r16						; - WR TWI operation busy flag

i2c_hw_start:
	LDI		r16,0xA5			;1<<TWINT|1<<TWSTA|1<<TWEN|1<<TWIE
	uout	TWCR,r16			; srart TWI sequence


twi_operatio_start_end:


timer_2_end:

	pop		zh
	pop		zl
	pop		r18	
	pop 	r17
	pop 	r16
	uout 	SREG, r16
	pop		r16


	cbi		portc,2

		RETI

TIM2_COMPB:			 	; Timer2 Compare B Handler
		RETI

TIM2_OVF: 				; Timer2 Overflow Handler
		RETI

TIM1_CAPT:			 	; Timer1 Capture Handler
		RETI

TIM1_COMPA:			 	; Timer1 Compare A Handler
		RETI

TIM1_COMPB: 			; Timer1 Compare B Handler
		RETI

TIM1_OVF:			 	; Timer1 Overflow Handler
		RETI

TIM0_COMPA:			 	; Timer0 Compare A Handler
		RETI

TIM0_COMPB: 			; Timer0 Compare B Handler
		RETI

TIM0_OVF:			 	; Timer0 Overflow Handler
		RETI

SPI_STC: 				; SPI Transfer Complete Handler
		RETI

USART_RXC:			 	; USART, RX Complete Handler
		RETI

USART_UDRE:				; USART, UDR Empty Handler
		RETI

USART_TXC:			 	; USART, TX Complete Handler
		RETI

_ADC:			 		; ADC Conversion Complete Handler
		RETI

EE_RDY:			 		; EEPROM Ready Handler
		RETI

ANA_COMP:			 	; Analog Comparator Handler
		RETI

TWI:
/*
	TWI_BUSY:
	0 - TWI FREE
	1 - TWI BUSY READ ONE REGISTER FROM REPEATED START
	2 - TWI BUSY READ ONE REGISTER FROM REPEATED START		DATA READY
	3 - TWI BUSY WRITE SAVE TO REGISTER NUMBER 				(STATE 28-1)
	4 - TWI BUSY WRITE SAVE TO REGISTER NUMBER 				STOP GENERATET STATE (STATE 28-2)
	5 - TWI BUSY WRITE SAVE TO REGISTER NUMBER 				SAWE COMPLETE
*/	
	push	r16
	uin		r16, SREG
	push 	r16
	push 	r17
	push	r18
	push 	zl
	push 	zh

	lds		r16, tmp_latch
	cpi		r16, 1
	breq	twi_latch
	call	twi_status

twi_latch:

	lds		r16, TWI_BUSY
	cpi		r16, 0
	breq	l_twsi_012
	cpi		r16, 1
	breq	l_twsi_012
	cpi		r16, 2
	breq	l_twsi_012
	jmp		l_twsi_WRITE
l_twsi_012:			
	
	uin		r16, TWSR
	andi	r16, 0xF8

	cpi		r16, 0x08
	breq	twi_08_r
	cpi		r16, 0x10
	breq	twi_10_r
	cpi		r16, 0x18
	breq	twi_18_r
	cpi		r16, 0x28
	breq	twi_28_r
	cpi		r16, 0x40
	breq	twi_40_r
	cpi		r16, 0x58
	breq	twi_58_r
	jmp		twi_err

twi_08_r:
	lds		r16, I2C_DEVICE_ADDRES
	uout	TWDR,r16
	ldi		r16,0x85	
	uout	TWCR, r16	;1<<TWINT|1<<TWEN|1<<TWIE
 	jmp		L_TWSI_END

twi_10_r:
	lds	r16, I2C_DEVICE_ADDRES
	ori	r16, 0b00000001				; Write to slave
	uout	TWDR,r16
	ldi		r16,0x85	
	uout	TWCR, r16	;1<<TWINT|1<<TWEN|1<<TWIE
 	jmp		L_TWSI_END
	
twi_18_r:
	lds		r16, NUMBER_REGISTER_TO_READ
	uout	TWDR,r16
	ldi		r16,0x85	
	uout	TWCR, r16	;1<<TWINT|1<<TWEN|1<<TWIE
 	jmp		L_TWSI_END
twi_28_r:
	ldi		r16,(1<<TWINT)|(1<<TWSTA)|(1<<TWEN)|(1<<TWIE)			;1<<TWINT|1<<TWSTA|1<<TWEN|1<<TWIE
	uout	TWCR,r16
	jmp		L_TWSI_END
twi_40_r:
	ldi		r16,0x85
	uout	TWCR, r16	;1<<TWINT|1<<TWEN|1<<TWIE
	jmp		L_TWSI_END
twi_58_r:
	uin		r16, TWDR
	sts		I2C_INPUT_DATA, r16	
	ldi		r16,0x94
	uout	TWCR,r16	;1<<TWINT|1<<TWSTO|1<<TWEN
	ldi		r16, 2
	sts		TWI_BUSY,r16
	jmp		L_TWSI_END


l_twsi_WRITE:

	

	
	uin		r16, TWSR
	andi	r16, 0xF8

	cpi		r16, 0x08
	breq	twi_08_w
	cpi		r16, 0x18
	breq	twi_18_w
	cpi		r16, 0x28
	breq	twi_28_w
	jmp		twi_err


twi_08_w:
	

	lds		r16, I2C_DEVICE_ADDRES
	uout	TWDR,r16
	ldi		r16,0x85	
	uout	TWCR, r16	;1<<TWINT|1<<TWEN|1<<TWIE
 	jmp		L_TWSI_END
	
twi_18_w:
	lds		r16, NUMBER_REGISTER_TO_WRITE
	uout	TWDR,r16
	ldi		r16,0x85	
	uout	TWCR, r16	;1<<TWINT|1<<TWEN|1<<TWIE
 	jmp		L_TWSI_END

twi_28_w:
	lds		r16,TWI_BUSY
	cpi		r16,3
	breq	twi_28_w_3	
	cpi		r16,4
	breq	twi_28_w_4

twi_28_w_3:
	lds		r16, I2C_DATA_FOR_OUTPUT
	uout	TWDR,r16
	ldi		r16,0x85	
	uout	TWCR, r16	;1<<TWINT|1<<TWEN|1<<TWIE
	ldi		r16, 4
	sts		TWI_BUSY,r16
 	jmp		L_TWSI_END

twi_28_w_4:
	ldi		r16,0x94
	uout	TWCR,r16	;1<<TWINT|1<<TWSTO|1<<TWEN|0<<TWIE
	ldi		r16, 5
	sts		TWI_BUSY,r16

	jmp		L_TWSI_END
	

twi_err:

L_TWSI_END:

	pop		zh
	pop		zl
	pop		r18	
	pop 	r17
	pop 	r16
	out 	SREG, r16
	pop		r16
			 		; 2-wire Serial Interface Handler
		RETI

SPM_RDY:			 	; Store Program Memory Ready Handler
		RETI



RESET:				;RESET HANDLER

/*
	UIN 	r16,WDTCSR
	UOUT	WDTCSR,r16
*/

	
;START MAIN PROGRAM
;---------INIT---------------

	ldi		r16, high(RAMEND)
	uout		sph,r16
	ldi		r16, low(RAMEND)
	uout		spl,r16




;-------------------test cs segment data--------------
/*
	ldi		zl, low(test_message1*2)
	ldi		zh, high(test_message1*2)
	lpm		r16,z+
	lpm		r17,z+
	lpm		r18,z+
	lpm		r19,z+
*/

	
;--------------------test cs segment data end---------	







	ldi		r16, 0
	sts		meandervalue, r16
	sts		tmp_latch, r16
	

	ldi		r16,0xFF		; nothing do





	uout		portc, r16
		
	ldi		r16,0b00000111
	uout		DDRB, r16

	ldi		r16,0b00001111
	uout		DDRC, r16	

	ldi		r16,0b11111111
	uout		DDRD, r16

	uout		portc, r16


	




	




	
// timer2 init & start

	LDI		R16,(1<<WGM21)  // wgm 20,21,22 - mode set  CTC mjde set

	uout		TCCR2a,R16
	LDI		R16,(0<<CS22)|(1<<CS21)|(0<<CS20)  // prescaller set		CT\8
	uout		TCCR2b,R16

	LDI		r16,199											// 0.1 ms per each interrupt ( 5,000 KHz frquency, 0,2 mS period )
	uout		ocr2a,r16

	ldi		r16,(1<<OCIE2A)									// enable compare interrupt 
	uout		timsk2,r16

/*
	ldi		r16,(1<<TOIE2)									// enable overflow interrupt
	uout		timsk2,r16
*/




// TWI init
	
	ldi		r16,0
	sts		TWI_BUSY, r16					; twi status
	sts		I2C_DEVICE_ADDRES, r16			; bus addres twi device
	sts		NUMBER_REGISTER_TO_READ, r16	; devise register number for peration read
	sts		NUMBER_REGISTER_TO_WRITE, r16	; devise register number for peration wrire
	sts		I2C_DATA_FOR_OUTPUT, r16		; data for write 
	sts		I2C_INPUT_DATA, r16				; readed data from device
	sts		I2C_DATA_FOR_OUTPUT_ENABLE, r16	; need output operation flag   0- nothing 1-need output
	sts		I2C_DATA_NEED_READ_START, r16	; need read operatio flag      0- nothing 1-need input






	sei




		
;-------------------------------------------------------------------------------------	


	ldi		r16, 0x20
	ldi		r17, 0x10
	call	delay

	cbi		portc, 0			;> reset ON

	ldi		r16, 0x10
	ldi		r17, 0x27
	call	delay

	sbi		portc,0

	ldi		r16, 0x10
	ldi		r17, 0x27
	call	delay




	ldi		r16, 0b00110000				;Function set
	call	command_exec

	ldi		r16, 0x42
	ldi		r17, 0x10
	call	delay

	ldi		r16, 0b00110000				;Function set 
	call	command_exec

	ldi		r16, 0x42
	ldi		r17, 0x10
	call	delay


	ldi		r16, 0b00001100				;Display On/Off
	call	command_exec

	ldi		r16, 0x42
	ldi		r17, 0x10
	call	delay


	ldi		r16, 0b00000001				;Display clear
	call	command_exec


	ldi		r16, 0x42
	ldi		r17, 0x10
	call	delay



	ldi		r16, 0b00110110				; extend mode
	call	command_exec

	

	ldi		r16, 0x42
	ldi		r17, 0x10
	call	delay





mx:









	ldi		r19,0
	ldi		r18,0
m2_2:
	ldi		r17,0
m1_2:
	mov		r16, r18
	ori		r16,0b10000000
	call	command_exec

	mov		r16, r17
	ori		r16,0b10000000
	call	command_exec
	
	ldi		r16, 0xff
	call	data_send


	ldi		r16, 0xff
	call	data_send


	inc		r17
	cpi		r17, 16			; max16    X
	brne	m1_2

	inc		r18
	cpi		r18, 32		; max32      Y
	brne	m2_2

	ldi		r16,5			; 5 sec
	call	pause


	call	clear_screen

	ldi		r16,2			; 2 sec
	call	pause



	ldi		r16, 'H'
	ldi		r17, 0
	call	char_out

	ldi		r16, 'E'
	ldi		r17, 1
	call	char_out

	ldi		r16, 'L'
	ldi		r17, 2
	call	char_out

	ldi		r16, 'L'
	ldi		r17, 3
	call	char_out

	ldi		r16, 'O'
	ldi		r17, 4
	call	char_out

	ldi		r16, ' '
	ldi		r17, 5
	call	char_out

	ldi		r16, 'W'
	ldi		r17, 6
	call	char_out

	ldi		r16, 'O'
	ldi		r17, 7
	call	char_out

	ldi		r16, 'R'
	ldi		r17, 8
	call	char_out

	ldi		r16, 'L'
	ldi		r17, 9
	call	char_out

	ldi		r16, 'D'
	ldi		r17, 10
	call	char_out

	ldi		r16, ' '
	ldi		r17, 11
	call	char_out

	ldi		r16, '!'
	ldi		r17, 12
	call	char_out

	ldi		r16,2			; 2 sec
	call	pause



	ldi		r16,2			; 2 sec
	call	pause

	call	clear_screen

	ldi		r16, 8
	sts		CURSOR_16_POS, r16



	uout	TWCR, r16
//	ldi		r16,TWBR_DATA + 5
	ldi		r16,0xE8
	uout	TWBR,r16





	ldi		r16, DS1307_I2C_ADDRES
	sts		I2C_DEVICE_ADDRES, r16
	ldi		r16,0x59 
	sts		I2C_DATA_FOR_OUTPUT, r16			; need 0 for ds1307 clock snfrt in bit 7 register 0
	ldi		r16, 0
	sts		NUMBER_REGISTER_TO_WRITE, r16			; register number = 0
	ldi		r16, 1
	sts		I2C_DATA_FOR_OUTPUT_ENABLE, r16		; start write flag

twi_wr_done_wait_1:
	lds		r16, I2C_DATA_FOR_OUTPUT_ENABLE
	cpi		r16, 1
	breq	twi_wr_done_wait_1					; wait start TWI save
	lds		r16, TWI_BUSY
	cpi		r16, 5
	brne	twi_wr_done_wait_1					; wait end   TWI  save

	ldi		r16,0
	sts		TWI_BUSY, r16










rd_1_loop:	


	ldi		r16,0
	call	read_ds1307_register
	lds		r16,I2C_INPUT_DATA
	sts		BCD_SECONDS, r16	
	call	convert_to_ascii
	mov		r18, r16		
	mov		r16,r17
	ldi		r17, 6
	call	char_out
	mov		r16, r18
	ldi		r17, 7
	call	char_out		


	ldi		r16, ':'
	ldi		r17, 2
	call	char_out

ldi		r16, 1
	sts		tmp_latch, r16

	ldi		r16,2
	call	read_ds1307_register
	lds		r16,I2C_INPUT_DATA
	sts		BCD_HOURS, r16
	call	convert_to_ascii
	mov		r18, r16
	mov		r16,r17
	ldi		r17, 0
	call	char_out
	mov		r16, r18
	ldi		r17, 1
	call	char_out

	ldi		r16, ':'
	ldi		r17, 5
	call	char_out


	ldi		r16,1
	call	read_ds1307_register
	lds		r16,I2C_INPUT_DATA
	sts		BCD_MINUTES, r16
	call	convert_to_ascii
	mov		r18, r16
	mov		r16,r17
	ldi		r17, 3
	call	char_out
	mov		r16, r18
	ldi		r17, 4
	call	char_out

	jmp		rd_1_loop














/*----------------MAIN-------------------*/

m_loop:



	rjmp m_loop
;------------------MAIN END-----------------


read_ds1307_register:

	sts		NUMBER_REGISTER_TO_READ, r16

	ldi		r16, DS1307_I2C_ADDRES
	sts		I2C_DEVICE_ADDRES, r16
	ldi		r16, 1
	sts		I2C_DATA_NEED_READ_START, r16

twi_rd_done_wait_1:
	lds		r16, I2C_DATA_NEED_READ_START
	cpi		r16,1
	breq	twi_rd_done_wait_1					; wait start TWI read
	lds		r16, TWI_BUSY
	cpi		r16, 2
	brne	twi_rd_done_wait_1					; wait start TWI read

	ldi		r16,0
	sts		TWI_BUSY, r16

	ret



	
command_exec:
	sts		data_out, r16
	ldi		r16, 0
	sts		op_type, r16				; 0 - command
	call	save_grafics
	ret



data_send:
	sts		data_out, r16
	ldi		r16, 1
	sts		op_type, r16				; 1 - command
	call	save_grafics
	ret
	




;---------------------------------------------------------
; db0-db7 	=> portd

; rs		=> portb, 0
; R\W		=> portb, 1
; E			=> portb, 2
;---------------------------------------------------------
	
save_grafics:	
		push	r16
		push	r17


	cbi		portb,2				; E <- 0

	ldi		r16, 1
	call	delay_us			; 1 us delay

	lds		r16, op_type
	cpi		r16,0
	breq	L_TIM2_COMP_03_0
	sbi		portb,0				; rs <- 1  data
	jmp		L_TIM2_COMP_03_1
L_TIM2_COMP_03_0:
	cbi		portb,0				; rs <- 0  command
L_TIM2_COMP_03_1:


	cbi		portb,1				; R\W <- 0	
				; 
	ldi		r16, 1
	call	delay_us			; 1 us delay

	sbi		portb,2				; E <- 1				; 


	lds		r16, data_out
	uout	portd, r16			; 
	ldi		r16, 1
	call	delay_us			; 1 us delay

	cbi		portb,2				; E <- 0	
	
	ldi		r16, 50
	call	delay_us			; 1 us delay				; 


		pop		r17
		pop		r16
		ret

delay_us:	
	cpi		r16,0
	breq	delay_us_end
	dec		r16

	ldi		r17, 5

delay_us_1:
	cpi		r17, 0
	dec 	r17
	brne	delay_us_1

	rjmp	delay_us

delay_us_end:
	ret

delay:
	cbi		portb,1

	push	r16
	push	r17
	cli
	sts		DELAY_LO, r16
	sts		DELAY_HI, r17
	sei

delay_0:
	lds		r16, DELAY_LO
	lds		r17, DELAY_HI	
	cpi		r16, 0
	breq	delay_1
	jmp		delay_0

delay_1:
	cpi		r17, 0
	breq	delay_exit
	jmp		delay_0

delay_exit:
	pop		r17
	pop		r16

	sbi		portb,1

	ret

pause:
	push	r16
	push	r17
	push	r18

	mov		r18,r16

pause_1:
	ldi		r17 ,0x27
	ldi		r17, 0x10		;10.0000 x 10uS = 0,1S
	call	delay

	dec		r18
	cpi		r18, 0
	brne	pause_1

	pop		r18
	pop		r17
	pop		r16
	ret	

char_out:
;-------------------------
;|00|01|02|03|04|05|06|07|
;|08|09|10|11|12|13|14|15|
;|16|17|18|19|20|21|22|23|
;|24|25|25|27|28|29|30|31|
;-------------------------		
; Input r16 char code
;		r17 place number
;---------------------------
	push 	zl
	push 	zh
	push	r18
	push	r19
	push	r20

	sts		CHAR_CODE, r16
	sts		POS_NUMBER, r17
	
	ldi		zl, low(chars*2)
	ldi		zh, high(chars*2)

	ror		zh
	ror		zl

	ldi		r17,0

	rol		r16
	rol		r17

	rol		r16
	rol		r17

	rol		r16
	rol		r17

	rol		r16
	rol		r17			; X 32

	add		zl, r16
	adc		zh, r17		; get char offset

	rol		zl
	rol		zh


	lds		r16, POS_NUMBER
	mov		r18, r16
	andi	r16, 0b00000111
	andi	r18, 0b00010000
	ror		r18
	or		r16,r18				; absolute X
	sts		X_POS, r16

	lds		r17, POS_NUMBER
	andi	r17, 0b00001000
	rol		r17					; absolute Y
	sts		Y_POS, r17

	ldi		r18,0

char_out_1:	
	lpm		r20, z+
	lpm		r19, z+

	push	r16
	lds		r16, Y_POS
	inc		r16
	sts		Y_POS, r16
	ori		r16,0b10000000
	call	command_exec		; send Y addres
	pop		r16
	push	r16
	lds		r16, X_POS
	ori		r16,0b10000000
	call	command_exec		; send X addres
	pop		r16
	push	r16
	mov		r16, r19
	call	data_send
	mov		r16, r20
	call	data_send
	pop		r16

	inc		r18
	cpi		r18, 16
	breq	char_out_end
	jmp		char_out_1


char_out_end:
	
	pop		r20
	pop		r19
	pop		r18
	pop		zh
	pop		zl
	ret


clear_screen:
	push	r16
	push	r17
	push	r18

	ldi		r18,0
m2:
	ldi		r17,0
m1:
	mov		r16, r18
	ori		r16,0b10000000
	call	command_exec

	mov		r16, r17
	ori		r16,0b10000000
	call	command_exec
	
	ldi		r16, 0b00000000
	call	data_send


	ldi		r16,0b00000000
	call	data_send


	inc		r17
	cpi		r17, 16
	brne	m1

	inc		r18
	cpi		r18, 32
	brne	m2

	ldi		r16, 0
	sts		CURSOR_16_POS, r16
	
	pop		r18
	pop		r17
	pop		r16
	ret



convert_to_ascii:
;	input BCD in r16
;	return	low in r16, high in r17
	push	r18
	MOV     R17,R16
    LDI     R18,0x30
    ANDI    R16,0x0F
    ADD     R16,R18

    ANDI    R17,0xF0
    SWAP    R17
    ADD     R17,R18
	pop		r18
    RET 	



twi_status:
	push	r16
	push	r17
	push	r18


	uin		r16, TWSR
	andi	r16, 0xF8
	call	convert_to_ascii

	mov		r18, r16
		
	mov		r16,r17
	lds		r17,CURSOR_16_POS
	call	char_out

	lds		r17, CURSOR_16_POS
	inc		r17
	sts		CURSOR_16_POS, r17
	mov		r16, r18
	call	char_out

	lds		r17, CURSOR_16_POS
	inc		r17
	sts		CURSOR_16_POS, r17
	ldi		r16, ':'
	call	char_out



	pop		r18
	pop		r17
	pop		r16
	ret








test_message:
	.dw 0b0000000110000000
	.dw 0b0001000110001000

start_mesage:
	.db "System started"
	.dw	0x0a0d				
	.db 0



;---------------------------------------------------



test_message1:
	.dw 0b0000000110000000
	.dw 0b0001000110001000



chars:
; Char # 0
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 1
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 2
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 3
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 4
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 5
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 6
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 7
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 8
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 9
; Code for char 	
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 10
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 11
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 12
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0011111111000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0011111111000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 13
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 14
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 15
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 16
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 17
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 18
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 19
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 20
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 21
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 22
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 23
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 24
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 25
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
;
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 27
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1001000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 28
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 29
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 30
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 31
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 32
; Code for char  
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 33
; Code for char !
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 34
; Code for char "
      .dw 0b0000000000000000
      .dw 0b0101000000000000
      .dw 0b0101000000000000
      .dw 0b0101000000000000
      .dw 0b0101000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 35
; Code for char #
      .dw 0b0000000000000000
      .dw 0b0001001000000000
      .dw 0b0001001000000000
      .dw 0b0001001000000000
      .dw 0b0010010000000000
      .dw 0b1111111100000000
      .dw 0b0010010000000000
      .dw 0b0010010000000000
      .dw 0b1111111100000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 36
; Code for char $
      .dw 0b0001000000000000
      .dw 0b0011110000000000
      .dw 0b0101001000000000
      .dw 0b0101001000000000
      .dw 0b0101000000000000
      .dw 0b0011000000000000
      .dw 0b0001100000000000
      .dw 0b0001010000000000
      .dw 0b0001001000000000
      .dw 0b0101001000000000
      .dw 0b0101001000000000
      .dw 0b0011110000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 37
; Code for char %
      .dw 0b0000000000000000
      .dw 0b0110000001000000
      .dw 0b1001000010000000
      .dw 0b1001000010000000
      .dw 0b1001000100000000
      .dw 0b1001001000000000
      .dw 0b0110010001100000
      .dw 0b0000010010010000
      .dw 0b0000100010010000
      .dw 0b0001000010010000
      .dw 0b0010000010010000
      .dw 0b0010000001100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 38
; Code for char &
      .dw 0b0000000000000000
      .dw 0b0000111000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001001100000000
      .dw 0b0000110011100000
      .dw 0b0001110001000000
      .dw 0b0010010010000000
      .dw 0b0100001010000000
      .dw 0b0100001100000000
      .dw 0b0110001100010000
      .dw 0b0011110011100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 39
; Code for char '
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 40
; Code for char (
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0000100000000000
      .dw 0b0000000000000000
; Char # 41
; Code for char )
      .dw 0b0000000000000000
      .dw 0b1000000000000000
      .dw 0b0100000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b1000000000000000
      .dw 0b0000000000000000
; Char # 42
; Code for char *
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0110101100000000
      .dw 0b0001110000000000
      .dw 0b0001110000000000
      .dw 0b0110101100000000
      .dw 0b0000100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 43
; Code for char +
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b1111111110000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 44
; Code for char ,
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0110000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 45
; Code for char -
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 46
; Code for char .
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 47
; Code for char /
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1000000000000000
      .dw 0b1000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 48
; Code for char 0
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 49
; Code for char 1
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0011100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0001110000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 50
; Code for char 2
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0100001000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0000010000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0100001000000000
      .dw 0b0111111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 51
; Code for char 3
      .dw 0b0000000000000000
      .dw 0b0011110000000000
      .dw 0b0100001000000000
      .dw 0b0000001000000000
      .dw 0b0000010000000000
      .dw 0b0000100000000000
      .dw 0b0001110000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0000010000000000
      .dw 0b0111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 52
; Code for char 4
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000110000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0010010000000000
      .dw 0b0100010000000000
      .dw 0b1000010000000000
      .dw 0b1111111000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 53
; Code for char 5
      .dw 0b0000000000000000
      .dw 0b0001111000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0111100000000000
      .dw 0b0000010000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0000010000000000
      .dw 0b0111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 54
; Code for char 6
      .dw 0b0000000000000000
      .dw 0b0000111000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0101100000000000
      .dw 0b0110010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 55
; Code for char 7
      .dw 0b0000000000000000
      .dw 0b0111111000000000
      .dw 0b1000001000000000
      .dw 0b0000001000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 56
; Code for char 8
      .dw 0b0000000000000000
      .dw 0b0011110000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0011110000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 57
; Code for char 9
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010011000000000
      .dw 0b0001101000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0001100000000000
      .dw 0b0110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 58
; Code for char :
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 59
; Code for char ;
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0110000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 60
; Code for char <
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000100000000
      .dw 0b0000111000000000
      .dw 0b0011000000000000
      .dw 0b0100000000000000
      .dw 0b0011000000000000
      .dw 0b0000111000000000
      .dw 0b0000000100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 61
; Code for char =
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1111111110000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1111111110000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 62
; Code for char >
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0011100000000000
      .dw 0b0000011000000000
      .dw 0b0000000100000000
      .dw 0b0000011000000000
      .dw 0b0011100000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 63
; Code for char ?
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0000010000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 64
; Code for char @
      .dw 0b0000000000000000
      .dw 0b0000001111100000
      .dw 0b0000110000010000
      .dw 0b0001000000001000
      .dw 0b0010000110100100
      .dw 0b0010001001100100
      .dw 0b0100010001000100
      .dw 0b0100010001000100
      .dw 0b0100100011000100
      .dw 0b0100100010001000
      .dw 0b0100100110011000
      .dw 0b0100111011100010
      .dw 0b0010000000000100
      .dw 0b0001000000001000
      .dw 0b0000100000010000
      .dw 0b0000011111100000
; Char # 65
; Code for char A
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001111100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 66
; Code for char B
      .dw 0b0000000000000000
      .dw 0b1111110000000000
      .dw 0b0010001000000000
      .dw 0b0010000100000000
      .dw 0b0010000100000000
      .dw 0b0010001000000000
      .dw 0b0011111000000000
      .dw 0b0010000100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 67
; Code for char C
      .dw 0b0000000000000000
      .dw 0b0000111101000000
      .dw 0b0001000011000000
      .dw 0b0010000001000000
      .dw 0b0100000001000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 68
; Code for char D
      .dw 0b0000000000000000
      .dw 0b1111111000000000
      .dw 0b0010000100000000
      .dw 0b0010000010000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 69
; Code for char E
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0010000100000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010001000000000
      .dw 0b0011111000000000
      .dw 0b0010001000000000
      .dw 0b0010000000000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 70
; Code for char F
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0010000100000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010001000000000
      .dw 0b0011111000000000
      .dw 0b0010001000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 71
; Code for char G
      .dw 0b0000000000000000
      .dw 0b0000111101000000
      .dw 0b0001000011000000
      .dw 0b0010000001000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000111100000
      .dw 0b0100000001000000
      .dw 0b0100000001000000
      .dw 0b0010000001000000
      .dw 0b0001000001000000
      .dw 0b0000111110000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 72
; Code for char H
      .dw 0b0000000000000000
      .dw 0b1111101111100000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0011111110000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111101111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 73
; Code for char I
      .dw 0b0000000000000000
      .dw 0b1111100000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 74
; Code for char J
      .dw 0b0000000000000000
      .dw 0b0111110000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b1001000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 75
; Code for char K
      .dw 0b0000000000000000
      .dw 0b1111101111000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b0010001000000000
      .dw 0b0010010000000000
      .dw 0b0011100000000000
      .dw 0b0010010000000000
      .dw 0b0010001000000000
      .dw 0b0010000100000000
      .dw 0b0010000010000000
      .dw 0b1111100111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 76
; Code for char L
      .dw 0b0000000000000000
      .dw 0b1111100000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 77
; Code for char M
      .dw 0b0000000000000000
      .dw 0b1110000000011100
      .dw 0b0011000000110000
      .dw 0b0011000000110000
      .dw 0b0010100001010000
      .dw 0b0010100001010000
      .dw 0b0010010001010000
      .dw 0b0010010010010000
      .dw 0b0010010010010000
      .dw 0b0010001100010000
      .dw 0b0010000100010000
      .dw 0b1111100101111100
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 78
; Code for char N
      .dw 0b0000000000000000
      .dw 0b1110000111110000
      .dw 0b0010000001000000
      .dw 0b0011000001000000
      .dw 0b0010100001000000
      .dw 0b0010010001000000
      .dw 0b0010001001000000
      .dw 0b0010001001000000
      .dw 0b0010000101000000
      .dw 0b0010000011000000
      .dw 0b0010000001000000
      .dw 0b1111100001000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 79
; Code for char O
      .dw 0b0000000000000000
      .dw 0b0000111100000000
      .dw 0b0001000010000000
      .dw 0b0010000001000000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 80
; Code for char P
      .dw 0b0000000000000000
      .dw 0b1111110000000000
      .dw 0b0010001000000000
      .dw 0b0010000100000000
      .dw 0b0010000100000000
      .dw 0b0010000100000000
      .dw 0b0010001000000000
      .dw 0b0011110000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 81
; Code for char Q
      .dw 0b0000000000000000
      .dw 0b0000111100000000
      .dw 0b0001000010000000
      .dw 0b0010000001000000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000001000000000
      .dw 0b0000000110000000
      .dw 0b0000000001100000
      .dw 0b0000000000000000
; Char # 82
; Code for char R
      .dw 0b0000000000000000
      .dw 0b1111110000000000
      .dw 0b0010001000000000
      .dw 0b0010000100000000
      .dw 0b0010000100000000
      .dw 0b0010001000000000
      .dw 0b0011110000000000
      .dw 0b0010010000000000
      .dw 0b0010001000000000
      .dw 0b0010001000000000
      .dw 0b0010000100000000
      .dw 0b1111100011000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 83
; Code for char S
      .dw 0b0000000000000000
      .dw 0b0001110100000000
      .dw 0b0010001100000000
      .dw 0b0100000100000000
      .dw 0b0100000000000000
      .dw 0b0011000000000000
      .dw 0b0000110000000000
      .dw 0b0000001000000000
      .dw 0b0000000100000000
      .dw 0b0100000100000000
      .dw 0b0110001000000000
      .dw 0b0101110000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 84
; Code for char T
      .dw 0b0000000000000000
      .dw 0b1111111110000000
      .dw 0b1000100010000000
      .dw 0b1000100010000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0011111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 85
; Code for char U
      .dw 0b0000000000000000
      .dw 0b1111101111100000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0001000100000000
      .dw 0b0000111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 86
; Code for char V
      .dw 0b0000000000000000
      .dw 0b1111000111100000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 87
; Code for char W
      .dw 0b0000000000000000
      .dw 0b1111011110011110
      .dw 0b0010000100001000
      .dw 0b0010000100001000
      .dw 0b0001000100001000
      .dw 0b0001000010010000
      .dw 0b0001000110010000
      .dw 0b0000101010010000
      .dw 0b0000101001010000
      .dw 0b0000101001010000
      .dw 0b0000010000100000
      .dw 0b0000010000100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 88
; Code for char X
      .dw 0b0000000000000000
      .dw 0b1111100111100000
      .dw 0b0010000010000000
      .dw 0b0001000100000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 89
; Code for char Y
      .dw 0b0000000000000000
      .dw 0b0111100111100000
      .dw 0b0001000010000000
      .dw 0b0001000100000000
      .dw 0b0000100100000000
      .dw 0b0000101000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0001111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 90
; Code for char Z
      .dw 0b0000000000000000
      .dw 0b0111111100000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0000010000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0100000010000000
      .dw 0b0100000100000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 91
; Code for char [
      .dw 0b0000000000000000
      .dw 0b0111000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0111000000000000
      .dw 0b0000000000000000
; Char # 92
; Code for char BackSlash
      .dw 0b0000000000000000
      .dw 0b1000000000000000
      .dw 0b1000000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 93
; Code for char ]
      .dw 0b0000000000000000
      .dw 0b0111000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0111000000000000
      .dw 0b0000000000000000
; Char # 94
; Code for char ^
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b1000000100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 95
; Code for char _
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
; Char # 96
; Code for char `
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 97
; Code for char a
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0000110000000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100110000000000
      .dw 0b0111011000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 98
; Code for char b
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0101100000000000
      .dw 0b0110010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 99
; Code for char c
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 100
; Code for char d
      .dw 0b0000000000000000
      .dw 0b0000001000000000
      .dw 0b0000011000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0001101000000000
      .dw 0b0010011000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010011100000000
      .dw 0b0001101000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 101
; Code for char e
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0111110000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 102
; Code for char f
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1111000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 103
; Code for char g
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011111000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0100000000000000
      .dw 0b0111110000000000
      .dw 0b1000001000000000
      .dw 0b1000001000000000
      .dw 0b0111110000000000
      .dw 0b0000000000000000
; Char # 104
; Code for char h
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0101100000000000
      .dw 0b0110010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b1110111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 105
; Code for char i
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 106
; Code for char j
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0110000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1100000000000000
      .dw 0b0000000000000000
; Char # 107
; Code for char k
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100111000000000
      .dw 0b0100100000000000
      .dw 0b0101000000000000
      .dw 0b0111000000000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b1110011100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 108
; Code for char l
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 109
; Code for char m
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0101100110000000
      .dw 0b1110011001000000
      .dw 0b0100010001000000
      .dw 0b0100010001000000
      .dw 0b0100010001000000
      .dw 0b0100010001000000
      .dw 0b1110111011100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 110
; Code for char n
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0101100000000000
      .dw 0b1110010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b1110111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 111
; Code for char o
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 112
; Code for char p
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0101100000000000
      .dw 0b1110010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0110010000000000
      .dw 0b0101100000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
; Char # 113
; Code for char q
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0001101000000000
      .dw 0b0010011000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100011000000000
      .dw 0b0011101000000000
      .dw 0b0000001000000000
      .dw 0b0000001000000000
      .dw 0b0000011100000000
      .dw 0b0000000000000000
; Char # 114
; Code for char r
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0101100000000000
      .dw 0b1110000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 115
; Code for char s
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100100000000000
      .dw 0b0100000000000000
      .dw 0b0011000000000000
      .dw 0b0000100000000000
      .dw 0b0100100000000000
      .dw 0b0111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 116
; Code for char t
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1111000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0101000000000000
      .dw 0b0110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 117
; Code for char u
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1100110000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100111000000000
      .dw 0b0011010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 118
; Code for char v
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1110111000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0010100000000000
      .dw 0b0010100000000000
      .dw 0b0010100000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 119
; Code for char w
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1110111011100000
      .dw 0b0100010001000000
      .dw 0b0100010001000000
      .dw 0b0010101010000000
      .dw 0b0010101010000000
      .dw 0b0011001100000000
      .dw 0b0001000100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 120
; Code for char x
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1110111000000000
      .dw 0b0100010000000000
      .dw 0b0010100000000000
      .dw 0b0001000000000000
      .dw 0b0010100000000000
      .dw 0b0100010000000000
      .dw 0b1110111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 121
; Code for char y
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1110111000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0010100000000000
      .dw 0b0010100000000000
      .dw 0b0001100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b1100000000000000
      .dw 0b0000000000000000
; Char # 122
; Code for char z
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0111110000000000
      .dw 0b0100100000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0100010000000000
      .dw 0b1111110000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 123
; Code for char {
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000100000000000
      .dw 0b0000010000000000
      .dw 0b0000000000000000
; Char # 124
; Code for char |
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
; Char # 125
; Code for char }
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
; Char # 126
; Code for char ~
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0111000010000000
      .dw 0b1000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 127
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1110000000000000
      .dw 0b1010000000000000
      .dw 0b1010000000000000
      .dw 0b1010000000000000
      .dw 0b1010000000000000
      .dw 0b1010000000000000
      .dw 0b1010000000000000
      .dw 0b1010000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 128
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 129
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 130
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 131
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 132
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 133
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 134
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 135
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 136
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 137
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 138
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 139
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 140
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 141
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 142
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 143
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 144
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 145
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 146
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 147
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 148
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 149
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 150
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 151
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 152
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 153
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 154
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 155
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 156
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 157
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 158
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 159
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 160
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 161
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
; Char # 162
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000001000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0001110000000000
      .dw 0b0010111000000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b0101001000000000
      .dw 0b0011001000000000
      .dw 0b0011110000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
; Char # 163
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0011110000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0111000100000000
      .dw 0b0110111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 164
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1011110100000000
      .dw 0b0100001000000000
      .dw 0b1000000100000000
      .dw 0b1000000100000000
      .dw 0b1000000100000000
      .dw 0b1000000100000000
      .dw 0b0100001000000000
      .dw 0b1011110100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 165
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0111011100000000
      .dw 0b0010001000000000
      .dw 0b0001001000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0111111100000000
      .dw 0b0000100000000000
      .dw 0b0111111100000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0001110000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 166
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
; Char # 167
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001110000000000
      .dw 0b0010010000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010001000000000
      .dw 0b0001010000000000
      .dw 0b0000100000000000
      .dw 0b0000010000000000
      .dw 0b0010010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
; Char # 168
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0101000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 169
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111110000000
      .dw 0b0001000001000000
      .dw 0b0010011110100000
      .dw 0b0100100010010000
      .dw 0b0101000000010000
      .dw 0b0101000000010000
      .dw 0b0101000000010000
      .dw 0b0100100010010000
      .dw 0b0010011100100000
      .dw 0b0001000001000000
      .dw 0b0000111110000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 170
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b1001000000000000
      .dw 0b0111000000000000
      .dw 0b1001000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 171
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010010000000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b1001000000000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b0010010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 172
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0000000100000000
      .dw 0b0000000100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 173
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 174
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111110000000
      .dw 0b0001000001000000
      .dw 0b0011111100100000
      .dw 0b0100100010010000
      .dw 0b0100100010010000
      .dw 0b0100111100010000
      .dw 0b0100100100010000
      .dw 0b0100100010010000
      .dw 0b0011110001100000
      .dw 0b0001000001000000
      .dw 0b0000111110000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 175
; Code for char 
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 176
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 177
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b1111111110000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b1111111110000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 178
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0110000000000000
      .dw 0b1001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b1111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 179
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000000000000
      .dw 0b0001000000000000
      .dw 0b0110000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 180
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 181
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0111111000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
; Char # 182
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0111111000000000
      .dw 0b1111010000000000
      .dw 0b1111010000000000
      .dw 0b1111010000000000
      .dw 0b1111010000000000
      .dw 0b0111010000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0001010000000000
      .dw 0b0000000000000000
; Char # 183
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 184
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0110000000000000
      .dw 0b0000000000000000
; Char # 185
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0110000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 186
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0111000000000000
      .dw 0b1000100000000000
      .dw 0b1000100000000000
      .dw 0b1000100000000000
      .dw 0b0111000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 187
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1001000000000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b0010010000000000
      .dw 0b0100100000000000
      .dw 0b0100100000000000
      .dw 0b1001000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 188
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010000001000000
      .dw 0b0110000010000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b0010001000000000
      .dw 0b0111001000100000
      .dw 0b0000010001100000
      .dw 0b0000100010100000
      .dw 0b0000100100100000
      .dw 0b0001000111110000
      .dw 0b0010000000100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 189
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010000001000000
      .dw 0b0110000010000000
      .dw 0b0010000100000000
      .dw 0b0010000100000000
      .dw 0b0010001000000000
      .dw 0b0111010001100000
      .dw 0b0000010010010000
      .dw 0b0000100000010000
      .dw 0b0001000000100000
      .dw 0b0001000001000000
      .dw 0b0010000011110000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 190
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111000001000000
      .dw 0b0001000010000000
      .dw 0b0110000100000000
      .dw 0b0001000100000000
      .dw 0b0001001000000000
      .dw 0b1110010000100000
      .dw 0b0000010001100000
      .dw 0b0000100010100000
      .dw 0b0001000100100000
      .dw 0b0001000111110000
      .dw 0b0010000000100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 191
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
; Char # 192
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001111100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 193
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001111100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 194
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001111100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 195
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001111100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 196
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001111100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 197
; Code for char 
      .dw 0b0000100100000000
      .dw 0b0000011000000000
      .dw 0b0000010000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0000101000000000
      .dw 0b0001000100000000
      .dw 0b0001000100000000
      .dw 0b0001111100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b1111000111100000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 198
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001111111111000
      .dw 0b0000011000001000
      .dw 0b0000101000000000
      .dw 0b0000101000100000
      .dw 0b0001001000100000
      .dw 0b0001001111100000
      .dw 0b0011111000100000
      .dw 0b0010001000100000
      .dw 0b0100001000001000
      .dw 0b0100001000011000
      .dw 0b1110111111110000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 199
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111101000000
      .dw 0b0001000011000000
      .dw 0b0010000001000000
      .dw 0b0100000001000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000110000000000
      .dw 0b0000000000000000
; Char # 200
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0010000100000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010001000000000
      .dw 0b0011111000000000
      .dw 0b0010001000000000
      .dw 0b0010000000000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 201
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0010000100000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010001000000000
      .dw 0b0011111000000000
      .dw 0b0010001000000000
      .dw 0b0010000000000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 202
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0010000100000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010001000000000
      .dw 0b0011111000000000
      .dw 0b0010001000000000
      .dw 0b0010000000000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 203
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111111100000000
      .dw 0b0010000100000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010001000000000
      .dw 0b0011111000000000
      .dw 0b0010001000000000
      .dw 0b0010000000000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 204
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111100000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 205
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111100000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 206
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111100000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 207
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111100000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 208
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111111000000000
      .dw 0b0010000100000000
      .dw 0b0010000010000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b1111110001000000
      .dw 0b0010000001000000
      .dw 0b0010000001000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b1111111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 209
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1110000111110000
      .dw 0b0010000001000000
      .dw 0b0011000001000000
      .dw 0b0010100001000000
      .dw 0b0010010001000000
      .dw 0b0010001001000000
      .dw 0b0010001001000000
      .dw 0b0010000101000000
      .dw 0b0010000011000000
      .dw 0b0010000001000000
      .dw 0b1111100001000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 210
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111100000000
      .dw 0b0001000010000000
      .dw 0b0010000001000000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 211
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111100000000
      .dw 0b0001000010000000
      .dw 0b0010000001000000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 212
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111100000000
      .dw 0b0001000010000000
      .dw 0b0010000001000000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 213
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111100000000
      .dw 0b0001000010000000
      .dw 0b0010000001000000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 214
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111100000000
      .dw 0b0001000010000000
      .dw 0b0010000001000000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0100000000100000
      .dw 0b0010000001000000
      .dw 0b0001000010000000
      .dw 0b0000111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 215
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 216
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000111100100000
      .dw 0b0001000011000000
      .dw 0b0010000011000000
      .dw 0b0100000100100000
      .dw 0b0100001000100000
      .dw 0b0100010000100000
      .dw 0b0100100000100000
      .dw 0b0100100000100000
      .dw 0b0011000001000000
      .dw 0b0011000010000000
      .dw 0b0100111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 217
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111101111100000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0001000100000000
      .dw 0b0000111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 218
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111101111100000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0001000100000000
      .dw 0b0000111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 219
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111101111100000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0001000100000000
      .dw 0b0000111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 220
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111101111100000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0001000100000000
      .dw 0b0000111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 221
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0111100111100000
      .dw 0b0001000010000000
      .dw 0b0001000100000000
      .dw 0b0000100100000000
      .dw 0b0000101000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0000010000000000
      .dw 0b0001111100000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 222
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1111100000000000
      .dw 0b0010000000000000
      .dw 0b0011111000000000
      .dw 0b0010000100000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000010000000
      .dw 0b0010000100000000
      .dw 0b0011111000000000
      .dw 0b0010000000000000
      .dw 0b1111100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 223
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0011110000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100110000000000
      .dw 0b0100011000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b1101110000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 224
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0000110000000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100110000000000
      .dw 0b0111011000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 225
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0000110000000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100110000000000
      .dw 0b0111011000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 226
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0010100000000000
      .dw 0b0100010000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0000110000000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100110000000000
      .dw 0b0111011000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 227
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011010000000000
      .dw 0b0101100000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0000110000000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100110000000000
      .dw 0b0111011000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 228
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010100000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0000110000000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100110000000000
      .dw 0b0111011000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 229
; Code for char 
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0000110000000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100110000000000
      .dw 0b0111011000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 230
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011111110000000
      .dw 0b0100010001000000
      .dw 0b0000111111000000
      .dw 0b0011010000000000
      .dw 0b0100010000000000
      .dw 0b0100010001000000
      .dw 0b0111101110000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 231
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0011000000000000
      .dw 0b0000000000000000
; Char # 232
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0111110000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 233
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0111110000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 234
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0010100000000000
      .dw 0b0100010000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0111110000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 235
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010100000000000
      .dw 0b0000000000000000
      .dw 0b0011100000000000
      .dw 0b0100010000000000
      .dw 0b0111110000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100010000000000
      .dw 0b0011100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 236
; Code for char 
      .dw 0b0000000000000000
      .dw 0b1000000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 237
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 238
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1010000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 239
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b1010000000000000
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 240
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0010100000000000
      .dw 0b0000010000000000
      .dw 0b0001110000000000
      .dw 0b0010001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 241
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0011010000000000
      .dw 0b0101100000000000
      .dw 0b0000000000000000
      .dw 0b0101100000000000
      .dw 0b1110010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b1110111000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 242
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 243
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000010000000000
      .dw 0b0000100000000000
      .dw 0b0000100000000000
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 244
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0010100000000000
      .dw 0b0100010000000000
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 245
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0001101000000000
      .dw 0b0010110000000000
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 246
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0001010000000000
      .dw 0b0000000000000000
      .dw 0b0001100000000000
      .dw 0b0010010000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0010010000000000
      .dw 0b0001100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 247
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0000000000000000
      .dw 0b1111111110000000
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 248
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0001100100000000
      .dw 0b0010011000000000
      .dw 0b0100010000000000
      .dw 0b0100101000000000
      .dw 0b0101001000000000
      .dw 0b0010010000000000
      .dw 0b0101100000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 249
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0010000000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b1100110000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100111000000000
      .dw 0b0011010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 250
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b1100110000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100111000000000
      .dw 0b0011010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 251
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0001000000000000
      .dw 0b0010100000000000
      .dw 0b0100010000000000
      .dw 0b0000000000000000
      .dw 0b1100110000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100111000000000
      .dw 0b0011010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 252
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010100000000000
      .dw 0b0000000000000000
      .dw 0b1100110000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0100111000000000
      .dw 0b0011010000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
; Char # 253
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0000000000000000
      .dw 0b1110111000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0010100000000000
      .dw 0b0010100000000000
      .dw 0b0001100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b1100000000000000
      .dw 0b0000000000000000
; Char # 254
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0100000000000000
      .dw 0b1100000000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b0101110000000000
      .dw 0b0110011000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0100001000000000
      .dw 0b0110010000000000
      .dw 0b0101100000000000
      .dw 0b0100000000000000
      .dw 0b0100000000000000
      .dw 0b1110000000000000
      .dw 0b0000000000000000
; Char # 255
; Code for char 
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0000000000000000
      .dw 0b0010100000000000
      .dw 0b0000000000000000
      .dw 0b1110111000000000
      .dw 0b0100010000000000
      .dw 0b0100010000000000
      .dw 0b0010100000000000
      .dw 0b0010100000000000
      .dw 0b0001100000000000
      .dw 0b0001000000000000
      .dw 0b0001000000000000
      .dw 0b0010000000000000
      .dw 0b1100000000000000
      .dw 0b0000000000000000

