/* 

  файл определений для dhsct.h 

*/
//-------------------------------------------------------

//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

 #include "dhsct.h" // заголовочный *.h файл текущего проекта

// --------------------------------------------------------------------------

// набор MAX7219 8-позиционник
const byte s_A = 6; // значение номера сегмента A
const byte s_B = 5; // значение номера сегмента B
const byte s_C = 4; // значение номера сегмента C
const byte s_D = 3; // значение номера сегмента D
const byte s_E = 2; // значение номера сегмента E
const byte s_F = 1; // значение номера сегмента F
const byte s_G = 0; // значение номера сегмента G
const byte s_H = 7; // значение номера сегмента H

/* 
 "кодовая страница кракозябр 7-сегментных"
 раскладка сегментов по символам определяется стандартной разметкой A-H
 по условию, что активный уровень(сегмент астивен/светится) принят за 1
 */
const byte fnt_bl = 0;
const byte fnt_0 = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F); // цифра 0 или символ "О"
const byte fnt_1 = (1<<s_B | 1<<s_C);
const byte fnt_2 = (1<<s_A | 1<<s_B | 1<<s_D | 1<<s_E | 1<<s_G);
const byte fnt_3 = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_G); // цифра 3 или символ "З"
const byte fnt_4 = (1<<s_B | 1<<s_C | 1<<s_F | 1<<s_G); // цифра 4 или символ "Ч"
const byte fnt_5 = (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G); // цифра 5 или символ "S"
const byte fnt_6 = (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G);
const byte fnt_7 = (1<<s_A | 1<<s_B | 1<<s_C);
const byte fnt_8 = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G);
const byte fnt_9 = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G);
const byte fnt_A = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G); // символ "A"
const byte fnt_b = (1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G); // символ "b"
const byte fnt_C = (1<<s_A | 1<<s_D | 1<<s_E | 1<<s_F); // символ "C"
const byte fnt_d = (1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_G); // символ "d"
const byte fnt_E = (1<<s_A | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G); // символ "E"
const byte fnt_F = (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_G); // символ "F"
const byte fnt_P = (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_G | 1<<s_B); // символ "P"
const byte fnt_L = (1<<s_E | 1<<s_F | 1<<s_D); // символ "L"
const byte fnt_H = (1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G); // символ "H"
const byte fnt_U = (1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_D); // символ "U"
const byte fnt_I = (1<<s_E | 1<<s_F); // левая 1 или латинская I
const byte fnt_S = (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G); // аналог цифры 5
const byte fnt_J = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E); // символ "J"
const byte fnt_r = (1<<s_G | 1<<s_E); // символ "r"
const byte fnt_n = (1<<s_G | 1<<s_E | 1<<s_C); // символ "п"
const byte fnt_c = (1<<s_G | 1<<s_E | 1<<s_D); // символ "с"
const byte fnt_o = (1<<s_G | 1<<s_E | 1<<s_D | 1<<s_C); // нижний кружок "о"
const byte fnt_u = (1<<s_C | 1<<s_E | 1<<s_D); // символ "u"
const byte fnt_i = (1<<s_E); // левая латинская i
const byte fnt_h = (1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G); // символ "h"
const byte fnt_rusg = (1<<s_A | 1<<s_E | 1<<s_F); // символ "Г"
const byte fnt_rusP = (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_B | 1<<s_C); // символ "П"
const byte fnt_rus_iE = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_G); // символ Э (инверсное Е)
const byte fnt_rusY = (1<<s_F | 1<<s_G | 1<<s_B | 1<<s_C | 1<<s_D); // символ "У"
const byte fnt_qest = (1<<s_A | 1<<s_B | 1<<s_E | 1<<s_G); // символ "?"
const byte fnt_rC = (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D); // символ ) (обратная скобка)
const byte fnt_gradus = (1<<s_A | 1<<s_B | 1<<s_F | 1<<s_G); // верхний кружок "символ грвдуса"
const byte fnt_minus = (1<<s_G); // символ "-" (средняя черта)
const byte fnt_aplin = (1<<s_A); // символ "верхняя черта"
const byte fnt_dnlin = (1<<s_D); // символ "_" (нижняя черта)
const byte fnt_trlin = (1<<s_A | 1<<s_G | 1<<s_D); // символ "три черты"
const byte fnt_coma = (1<<s_H); // символ "," (децимальная точка)

// набор кодов режима дешифратора
const byte B_fnt_0 = 0; // значение данных соответствующее символу 0 режима декодера
const byte B_fnt_1 = 1; // значение данных соответствующее символу 1 режима декодера
const byte B_fnt_2 = 2; // значение данных соответствующее символу 2 режима декодера
const byte B_fnt_3 = 3; // значение данных соответствующее символу 3 режима декодера
const byte B_fnt_4 = 4; // значение данных соответствующее символу 4 режима декодера
const byte B_fnt_5 = 5; // значение данных соответствующее символу 5 режима декодера
const byte B_fnt_6 = 6; // значение данных соответствующее символу 6 режима декодера
const byte B_fnt_7 = 7; // значение данных соответствующее символу 7 режима декодера
const byte B_fnt_8 = 8; // значение данных соответствующее символу 8 режима декодера
const byte B_fnt_9 = 9; // значение данных соответствующее символу 9 режима декодера
const byte B_fnt_minus = 0x0A; // значение данных соответствующее символу minus режима декодера
const byte B_fnt_E = 0x0B; // значение данных соответствующее символу E режима декодера
const byte B_fnt_H = 0x0C; // значение данных соответствующее символу H режима декодера
const byte B_fnt_L = 0x0D; // значение данных соответствующее символу L режима декодера
const byte B_fnt_P = 0x0E; // значение данных соответствующее символу P режима декодера
const byte B_fnt_bl = 0x0F; // значение данных соответствующее символу blank режима декодера
const byte B_fnt_comask = 0x80; // значение маски запятой в текущей позиции

// команды и адреса регистров управления для MAX7219
const byte addp0 = 1; // значение адреса регистра данных позиции 1 дисплея
const byte addp1 = 2; // значение адреса регистра данных позиции 2 дисплея
const byte addp2 = 3; // значение адреса регистра данных позиции 3 дисплея
const byte addp3 = 4; // значение адреса регистра данных позиции 4 дисплея
const byte addp4 = 5; // значение адреса регистра данных позиции 5 дисплея
const byte addp5 = 6; // значение адреса регистра данных позиции 6 дисплея
const byte addp6 = 7; // значение адреса регистра данных позиции 7 дисплея
const byte addp7 = 8; // значение адреса регистра данных позиции 8 дисплея

const byte No_Op = 0; // значение адреса регистра No_Op
// регистр No_Op используется исключительно при каскадировании max7219
const byte Dec_Mod = 9; // значение адреса регистра Decode_Mode
const byte Intensit = 0x0A; // значение адреса регистра Intensity
const byte Sc_Lim = 0x0B; // значение адреса регистра Scan_Limit
const byte Shut_Dn = 0x0C; // значение адреса регистра Shut_Down
const byte Disp_ts = 0x0F; // значение адреса регистра Display_test

const byte Com_DM_0 = 0; // Dec_Mod, все позиции только под знакосинтез DM отключен
const byte Com_DM_1 = 1; // Dec_Mod, B_fntN только для позиции 0, поз. 1-7 под знакосинтез
const byte Com_DM_2 = 0x0F; // Dec_Mod, B_fntN для позиций 0-3, поз. 4-7 под знакосинтез
const byte Com_DM_3 = 0xFF; // Dec_Mod, B_fntN для позиций 0-7

const byte Com_int_0 = 0; // Intensit, уровень яркости 1/32 (минимальный)
const byte Com_int_1 = 1; // Intensit, уровень яркости 3/32
const byte Com_int_2 = 2; // Intensit, уровень яркости 5/32
const byte Com_int_3 = 3; // Intensit, уровень яркости 7/32
const byte Com_int_4 = 4; // Intensit, уровень яркости 9/32
const byte Com_int_5 = 5; // Intensit, уровень яркости 11/32
const byte Com_int_6 = 6; // Intensit, уровень яркости 13/32
const byte Com_int_7 = 7; // Intensit, уровень яркости 15/32
const byte Com_int_8 = 8; // Intensit, уровень яркости 17/32
const byte Com_int_9 = 9; // Intensit, уровень яркости 19/32
const byte Com_int_A = 10; // Intensit, уровень яркости 21/32
const byte Com_int_B = 11; // Intensit, уровень яркости 23/32
const byte Com_int_C = 12; // Intensit, уровень яркости 25/32
const byte Com_int_D = 13; // Intensit, уровень яркости 27/32
const byte Com_int_E = 14; // Intensit, уровень яркости 29/32
const byte Com_int_F = 15; // Intensit, уровень яркости 31/32 (максимальный)

const byte Com_SL_0 = 0; // Sc_Lim, индикация только в позиции 0 (max s I 10mA!)
const byte Com_SL_1 = 1; // Sc_Lim, индикация только в позиции 0,1 (max s I 20mA!)
const byte Com_SL_2 = 2; // Sc_Lim, индикация только в позиции 0,1,2 (max s I 30mA!)
const byte Com_SL_3 = 3; // Sc_Lim, индикация только в позиции 0,1,2,3
const byte Com_SL_4 = 4; // Sc_Lim, индикация только в позиции 0,1,2,3,4
const byte Com_SL_5 = 5; // Sc_Lim, индикация только в позиции 0,1,2,3,4,5
const byte Com_SL_6 = 6; // Sc_Lim, индикация только в позиции 0,1,2,3,4,5,6
const byte Com_SL_7 = 7; // Sc_Lim, индикация только в позиции 0,1,2,3,4,5,6,7

const byte Com_Shutdn_md = 0; // Shut_Dn, значение данных команды Shutdown_mode
const byte Com_Normal_md = 1; // Shut_Dn, значение данных команды Normal_mode
const byte Com_tst_on_md = 1; // Disp_ts, значение данных команды display test on_mode
const byte Com_tst_of_md = 0; // Disp_ts, значение данных команды display test off_mode

// --------------------------------------------------------------------------
/*
 *    v_ram
 * буфер-массив видеопамяти дисплея MAX7219
 * развертка позиций справа налево (7:6:5:4:3:2:1:0)
 *  определение/инициализация
 */
byte v_ram[8]{0,0,0,0,0,0,0,0};


//-------------конец файла/end of file---------------------
