/*
 *            dhsct.h
 * "дефайн хард/софт описаний констант и типов"
 * 
 * файл описаний констант и типов 
 * для многофайловой модификации проекта
 * 
 * содержимое данного файла должно соответствовать
 * тому проекту, в папке которого данный файл размещен
 * 
 */
// защита от переоперделения с заключительным
// #endif в конце файла
#ifndef DHSCT_H
#define DHSCT_H 

//------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------

/*
 *  type_init секция
 */

//------------------------------------------------------------------

/*
 *  hard_init секция
 */

// набор MAX7219 8-позиционник

extern const byte s_A; // значение номера сегмента A
extern const byte s_B; // значение номера сегмента B
extern const byte s_C; // значение номера сегмента C
extern const byte s_D; // значение номера сегмента D
extern const byte s_E; // значение номера сегмента E
extern const byte s_F; // значение номера сегмента F
extern const byte s_G; // значение номера сегмента G
extern const byte s_H; // значение номера сегмента H

/*
 *  constant_init секция
 */

/*
 "кодовая страница кракозябр 7-сегментных"
 раскладка сегментов по символам определяется стандартной разметкой A-H
 по условию, что активный уровень(сегмент астивен/светится) принят за 1
 */
extern const byte fnt_bl;
extern const byte fnt_0; // цмфра 0 или символ "О"
extern const byte fnt_1;
extern const byte fnt_2;
extern const byte fnt_3; // цифра 3 или символ "З"
extern const byte fnt_4; // цифра 4 или символ "Ч"
extern const byte fnt_5; // цифра 5 или символ "S"
extern const byte fnt_6;
extern const byte fnt_7;
extern const byte fnt_8;
extern const byte fnt_9;
extern const byte fnt_A; // символ "A"
extern const byte fnt_b; // символ "b"
extern const byte fnt_C; // символ "C"
extern const byte fnt_d; // символ "d"
extern const byte fnt_E; // символ "E"
extern const byte fnt_F; // символ "F"
extern const byte fnt_P; // символ "P"
extern const byte fnt_L; // символ "L"
extern const byte fnt_H; // символ "H"
extern const byte fnt_U; // символ "U"
extern const byte fnt_I; // левая 1 или латинская I
extern const byte fnt_S; // аналог цифры 5
extern const byte fnt_J; // символ "J"
extern const byte fnt_r; // символ "r"
extern const byte fnt_n; // символ "п"
extern const byte fnt_c; // символ "с"
extern const byte fnt_o; // нижний кружок "о"
extern const byte fnt_u; // символ "u"
extern const byte fnt_i; // левая латинская i
extern const byte fnt_h; // символ "h"
extern const byte fnt_rusg; // символ "Г"
extern const byte fnt_rusP; // символ "П"
extern const byte fnt_rus_iE; // символ Э (инверсное Е)
extern const byte fnt_rusY; // символ "У"
extern const byte fnt_qest; // символ "?"
extern const byte fnt_rC; // символ ) (обратная скобка)
extern const byte fnt_gradus; // верхний кружок "символ грвдуса"
extern const byte fnt_minus; // символ "-" (средняя черта)
extern const byte fnt_aplin; // символ "верхняя черта"
extern const byte fnt_dnlin; // символ "_" (нижняя черта)
extern const byte fnt_trlin; // символ "три черты"
extern const byte fnt_coma; // символ "," (децимальная точка)

// набор кодов режима дешифратора
extern const byte B_fnt_0; // значение данных соответствующее символу 0 режима декодера
extern const byte B_fnt_1; // значение данных соответствующее символу 1 режима декодера
extern const byte B_fnt_2; // значение данных соответствующее символу 2 режима декодера
extern const byte B_fnt_3; // значение данных соответствующее символу 3 режима декодера
extern const byte B_fnt_4; // значение данных соответствующее символу 4 режима декодера
extern const byte B_fnt_5; // значение данных соответствующее символу 5 режима декодера
extern const byte B_fnt_6; // значение данных соответствующее символу 6 режима декодера
extern const byte B_fnt_7; // значение данных соответствующее символу 7 режима декодера
extern const byte B_fnt_8; // значение данных соответствующее символу 8 режима декодера
extern const byte B_fnt_9; // значение данных соответствующее символу 9 режима декодера
extern const byte B_fnt_minus; // значение данных соответствующее символу minus режима декодера
extern const byte B_fnt_E; // значение данных соответствующее символу E режима декодера
extern const byte B_fnt_H; // значение данных соответствующее символу H режима декодера
extern const byte B_fnt_L; // значение данных соответствующее символу L режима декодера
extern const byte B_fnt_P; // значение данных соответствующее символу P режима декодера
extern const byte B_fnt_bl; // значение данных соответствующее символу blank режима декодера
extern const byte B_fnt_comask; // значение маски запятой в текущей позиции

// команды и адреса регистров управления для MAX7219
extern const byte addp0; // значение адреса регистра данных позиции 1 дисплея
extern const byte addp1; // значение адреса регистра данных позиции 2 дисплея
extern const byte addp2; // значение адреса регистра данных позиции 3 дисплея
extern const byte addp3; // значение адреса регистра данных позиции 4 дисплея
extern const byte addp4; // значение адреса регистра данных позиции 5 дисплея
extern const byte addp5; // значение адреса регистра данных позиции 6 дисплея
extern const byte addp6; // значение адреса регистра данных позиции 7 дисплея
extern const byte addp7; // значение адреса регистра данных позиции 8 дисплея

extern const byte No_Op; // значение адреса регистра No_Op
// регистр No_Op используется исключительно при каскадировании max7219
extern const byte Dec_Mod; // значение адреса регистра Decode_Mode
extern const byte Intensit; // значение адреса регистра Intensity
extern const byte Sc_Lim; // значение адреса регистра Scan_Limit
extern const byte Shut_Dn; // значение адреса регистра Shut_Down
extern const byte Disp_ts; // значение адреса регистра Display_test

extern const byte Com_DM_0; // Dec_Mod, все позиции только под знакосинтез DM отключен
extern const byte Com_DM_1; // Dec_Mod, B_fntN только для позиции 0, поз. 1-7 под знакосинтез
extern const byte Com_DM_2; // Dec_Mod, B_fntN для позиций 0-3, поз. 4-7 под знакосинтез
extern const byte Com_DM_3; // Dec_Mod, B_fntN для позиций 0-7

extern const byte Com_int_0; // Intensit, уровень яркости 1/32 (минимальный)
extern const byte Com_int_1; // Intensit, уровень яркости 3/32
extern const byte Com_int_2; // Intensit, уровень яркости 5/32
extern const byte Com_int_3; // Intensit, уровень яркости 7/32
extern const byte Com_int_4; // Intensit, уровень яркости 9/32
extern const byte Com_int_5; // Intensit, уровень яркости 11/32
extern const byte Com_int_6; // Intensit, уровень яркости 13/32
extern const byte Com_int_7; // Intensit, уровень яркости 15/32
extern const byte Com_int_8; // Intensit, уровень яркости 17/32
extern const byte Com_int_9; // Intensit, уровень яркости 19/32
extern const byte Com_int_A; // Intensit, уровень яркости 21/32
extern const byte Com_int_B; // Intensit, уровень яркости 23/32
extern const byte Com_int_C; // Intensit, уровень яркости 25/32
extern const byte Com_int_D; // Intensit, уровень яркости 27/32
extern const byte Com_int_E; // Intensit, уровень яркости 29/32
extern const byte Com_int_F; // Intensit, уровень яркости 31/32 (максимальный)

extern const byte Com_SL_0; // Sc_Lim, индикация только в позиции 0 (max s I 10mA!)
extern const byte Com_SL_1; // Sc_Lim, индикация только в позиции 0,1 (max s I 20mA!)
extern const byte Com_SL_2; // Sc_Lim, индикация только в позиции 0,1,2 (max s I 30mA!)
extern const byte Com_SL_3; // Sc_Lim, индикация только в позиции 0,1,2,3
extern const byte Com_SL_4; // Sc_Lim, индикация только в позиции 0,1,2,3,4
extern const byte Com_SL_5; // Sc_Lim, индикация только в позиции 0,1,2,3,4,5
extern const byte Com_SL_6; // Sc_Lim, индикация только в позиции 0,1,2,3,4,5,6
extern const byte Com_SL_7; // Sc_Lim, индикация только в позиции 0,1,2,3,4,5,6,7

extern const byte Com_Shutdn_md; // Shut_Dn, значение данных команды Shutdown_mode
extern const byte Com_Normal_md; // Shut_Dn, значение данных команды Normal_mode
extern const byte Com_tst_on_md; // Disp_ts, значение данных команды display test on_mode
extern const byte Com_tst_of_md; // Disp_ts, значение данных команды display test off_mode

//------------------------------------------------------------------

/*
 *  soft_init секция
 */

/*
 *    v_ram
 * буфер-массив видеопамяти дисплея MAX7219
 * развертка позиций справа налево (7:6:5:4:3:2:1:0)
 *  объявление
 */
extern byte v_ram[8];

//------------------------------------------------------------------


//------------------------------------------------------------------

#endif

//-------------конец файла/end of file---------------------
