/*
 *    файл обработчика кнопки knop.cpp
 */

//******************************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//******************************************************************************

#include "knop.h" // заголовочный *.h файл текущего проекта

//******************************************************************************
//  Секция определения переменных, используемых в модуле
//******************************************************************************

byte work_flag =0; // передаточный флаг запроса исполнения закрепленной за 
 // активным состоянием кнопы функцией. Сбрасывается при исполнении функции
 // или при входе в селектор функций
volatile byte vect_scan =0; // указатель селектора статуса сканера состояния ЛВК
const unsigned long z_data =50; // константа длительности антидребезга контакта
// const unsigned long x_time =900; // константа автоповтора операции
volatile unsigned long z_cnt =0; // защелка входного значения millis обработки антидребезга
volatile unsigned long z_cntu =0; // текущее значение millis обработки антидребезга
//******************************************************************************
//  Секция определения функций, используемых в модуле
//******************************************************************************

void knop_hinit()
{
  pinMode(lvk, INPUT_PULLUP); // вход управляющей кнопки с "подтягивающим резистором"
}

//----------------------------------------------------------------
// настроено на активный уровень = 0
void skas()
{
  switch (vect_scan) {
    case 0:
      vect_scan = digitalRead(lvk) ? 0:1;
     break;
    case 1:
      z_cnt=millis(); vect_scan=2; work_flag=1; // ИСПОЛНЕНИЕ ПО ФРОНТУ
     break;
    case 2:
      z_cntu=millis();
      if ((z_cntu-z_cnt)>=z_data){vect_scan=3;z_cnt=millis();}
     break;
    case 3:
      vect_scan = digitalRead(lvk) ? 4:3; // простая альтернатива
/*
  if (!digitalRead(lvk)){vect_scan=0;} // FALSTART
   else {z_cntu=millis();}
// вертимся тут до захвата фронта отпускания (=1)
  if ((z_cntu-z_cnt)>=x_time){work_flag=1;z_cnt=millis();}
*/
     break;
    case 4:
      z_cnt=millis(); vect_scan=5;
     break;
    case 5:
      z_cntu=millis();
      if ((z_cntu-z_cnt)>=z_data){vect_scan=6;}
     break;
    case 6:
      vect_scan = digitalRead(lvk) ? 0:3; // если считан 0 ->FALSTART
      // вертимся тут до подтверждения фронта отпускания (=1)
     break;
    default:
      // if nothing else matches, do the default
      // default is optional
    break;
  }
}

//----------------------------------------------------------------

//-------------конец файла/end of file---------------------
