/* ---------------------------------------------------- */
/*         заголовочный файл проекта knop.h            */
//-------------------------------------------------------
#ifndef _KNOP_H        // Блокируем повторное включение этого модуля
#define _KNOP_H
//------------------------------------------------------------------------
// обязательная "магическая добавка" (начало)
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
// обязательная "магическая добавка" (конец)
//------------------------------------------------------------------------
//******************************************************************************
//  Секция include: здесь подключаются заголовочные файлы используемых модулей
//******************************************************************************
#include "dhsct.h" // относится к общим для всех файлов проекта
                   // "дефайн хард/софт описаний констант и типов"

//******************************************************************************
//  Секция объявления констант
//******************************************************************************
extern const byte lvk; // вывод линии возврата клавиатуры, активный уровень =0
extern byte work_flag; // передаточный флаг запроса исполнения закрепленной за 
 // активным состоянием кнопы функцией. Сбрасывается при исполнении функции
 // или при входе в селектор функций
extern volatile byte vect_scan; // указатель селектора статуса сканера состояния ЛВК
extern const unsigned long z_data; // константа длительности антидребезга контакта
// extern const unsigned long x_time; // константа автоповтора операции
extern volatile unsigned long z_cnt; // защелка входного значения millis обработки антидребезга
extern volatile unsigned long z_cntu; // текущее значение millis обработки антидребезга

//-----------------------------------------------------------------------------

extern void knop_hinit(); // начальная настройка вывода ЛВК
extern void skas(); // объявление функции сканера состояния ЛВК

//-----------------------------------------------------------------------------

#endif // Закрывающий #endif к блокировке повторного включения

//-------------конец файла/end of file---------------------
