/* 
 *  файл заголовочник основного файла проекта
 *        m72t7.h
 *  тестовое подключение дисплея на осове MAX7219
 *  и емкостной кнопки  
 */

// #include <avr/pgmspace.h> // только для поддержки индикации терминала
#include "dhsct.h" // относится к общим для всех файлов проекта
                   // "дефайн хард/софт описаний констант и типов"
#include "max72.h" // относится к библиотеке
#include "knop.h" // относится к библиотеке


//----------------------------------------------------------------------------------------------

const byte lvk = 8; // номер линии данных интерфейса кнопки
                    // активный уровень на выходе равен 0
#define dn 10 // значение линии данных интерфейса дисплея
              // активный уровень равен 1
#define clk 11 // значение линии строба интерфейса дисплея
             // активный уровень равен 1, защелкивание данных по переднему
             // (наростающему) фронту имрулса строба
#define cs 12 // значение линии выборки кристалла интерфейса дисплея
            // активный уровень равен 0
// ограничений на максимальную длительность импульсов clc не оговорено
// минимальная длительность clk = 50nS
// задержка начала/завершения пакета относительно cs не менее 50nS

//----------------------------------------------------------------------------------------------

// блок описаний вторичных часов

#define mark 50 // коэффициент предделителя вторичных часов
#define SM_mask 60 // коэффициент предделителя секунд и/или минут вторичных часов
#define Hr_mask 24 // коэффициент предделителя часов вторичных часов

byte Clk_clcO = 13; // выходная линия генератора тактовой частоты вторичных часов
byte Clk_clcI = 2; // входная линия обработчика прерывания тактовой частоты вторичных часов
volatile byte Clk_cnt0; // счетчик досчета до секунды вторичных часов
volatile byte Clk_sec; // счетчик секунд вторичных часов
volatile byte Clk_min; // счетчик минут вторичных часов
volatile byte Clk_hors; // счетчик часов вторичных часов
volatile char Clk_flags; // регистр флагов передачи управления/статуса работы вторичных часов

volatile byte vect_com =0; // указатель селектора исполняемых функций

void Clc_proc(); // обработчик вторичных часов
void ptrClk(); // обработчик вывода данных вторичных часов
void w_selekt(); // обработчик режимов работы "секундомера"

//----------------------------------------------------------------------------------------------

void disp_softinit();
void disp_labelinit();



//-------------конец файла/end of file---------------------
