
/* 
 *  тестовое подключение дисплея на основе MAX7219
 *  и емкостной кнопки  
 */

#include "m72t8.h" // заголовочник основного файла проекта


//----------------------------------------------------------------------------------------------
/*
 * создать экземпляр класса
 * номера выводов вносим в соответствии с текущей схемной раскладкой
 */
     m72 my_disp (dn, clk, cs);

//----------------------------------------------------------------------------------------------

void setup() {
  // put your setup code here, to run once:

//  Serial.begin(9600);

  my_disp.hinit(); // инициализация управляющих линий дисплея на MAX7219
  knop_hinit(); // инициализация управляющих линий кнопки
//       настройка выводов "генератора секундомера"
  pinMode(Clk_clcI, INPUT_PULLUP); // вход с "подтягивающим резистором"
  pinMode(Clk_clcO, OUTPUT);
  digitalWrite(Clk_clcO, LOW); // выход с исходным состоянием = 0
  delay(1000);
  disp_softinit(); // задаем режим для дисплея
  disp_labelinit(); // начальная заставка
  attachInterrupt(digitalPinToInterrupt(Clk_clcI), Clc_proc, RISING);
}

void loop() {
  // put your main code here, to run repeatedly:

  skas();
  if (work_flag)
     { work_flag=0; w_selekt();ptrClk(); }
  if (Clk_flags)
     { Clk_flags=0; ptrClk(); }
    
}

//----------------------------------------------------------------------------------------------

/*
 * данный обработчик обеспечивает 
 * приращение счетчиков вторичных часов и выставляет
 * флаг запроса пересылки новых данных в дисплей
 */

void Clc_proc()
{
  Clk_cnt0++;
  if (Clk_cnt0==mark)
  {
    Clk_cnt0=0; Clk_sec++; Clk_flags=1;
     if (Clk_sec==SM_mask)
     {
      Clk_sec=0; Clk_min++;
       if (Clk_min==SM_mask)
       {
        Clk_min=0; Clk_hors++;
         if (Clk_hors==Hr_mask)
         {
          Clk_hors=0;
         }
       }
     }
  }
}

//----------------------------------------------------------------------------------------------


//  вывод значений вторичных часов на индикацию

void ptrClk()
{
  Clk_flags=0;
  byte a=Clk_sec;byte b=Clk_min;byte c=Clk_hors;
  if (c>=10)
   {
      my_disp.write(addp7, (c/10)); c=c%10;
   }
  else
  {
    my_disp.write(addp7, B_fnt_bl);
  }
   my_disp.write(addp6, c);
   if (b>=10)
   {
    my_disp.write(addp4, (b/10)); b=b%10;
   }
   else
   {
    my_disp.write(addp4, B_fnt_bl); // B_fnt_bl или 0 на усмотрение
   }
    my_disp.write(addp3, b);
    if (a>=10)
    {
     my_disp.write(addp1, (a/10)); a=a%10;
    }
    else
    {
     my_disp.write(addp1, 0); // B_fnt_bl или 0 на усмотрение
    }
     my_disp.write(addp0, a);
}

//-----------------------------------------------------------------------------

// обработчик режимов работы "секундомера"

void w_selekt()
{
  switch (vect_com) {
    case 0:
      tone(Clk_clcO,mark); // запуск вторичных часов
      vect_com=1; // переопределение функции кнопы на ожидание команды "стоп"
     break; 
    case 1:
      noTone(Clk_clcO); // останов вторичных часов
      vect_com=2; // переопределение функции кнопы на ожидание команды "сброс"
     break;
    case 2:
      Clk_cnt0=0; Clk_sec=0; Clk_min=0; Clk_hors=0; // обнуление счетчиков
      vect_com=0; // переопределение функции кнопы на ожидание команды "пуск"
     break;
    default:
      // if nothing else matches, do the default
      // default is optional
    break;
  }
}

//-----------------------------------------------------------------------------
// настройка железа MAX7219

void disp_softinit()
{
  my_disp.write(Sc_Lim, Com_SL_7); // сканируются все разряды
  my_disp.write(Intensit, Com_int_F); // максисмальная яркость
  my_disp.write(Dec_Mod, Com_DM_3); // режим декодера тетрадного кода для всех позиций
  my_disp.write(Disp_ts, Com_tst_of_md);
}

//-----------------------------------------------------------------------------
// настройка тестовой заставки и первичного экрана примитив-секундомера

void disp_labelinit()
{
  for (byte cnt=0; cnt<=7; cnt++)
  {
    my_disp.write((cnt+1), B_fnt_minus); // заполнение '-'
  }
  my_disp.write(Shut_Dn, Com_Normal_md); // включить индикацию
  delay(1000);
  for (byte cnt=0; cnt<=7; cnt++)
  {
    my_disp.write((cnt+1), cnt); // заполнение 0,1,2,3,4,5,6,7
          // в позиции 1 отображается 0 в позиции 8 символ 7
  }
  delay(500);
  my_disp.write(Intensit,Com_int_7); // 50% яркость
  delay(500);
  Clk_cnt0=0;Clk_sec=0;Clk_min=0;Clk_hors=0;Clk_flags=0;
  my_disp.write(addp2, B_fnt_minus); // разделитель секунд и минут
  my_disp.write(addp5, B_fnt_minus); // разделитель минут и часов
  ptrClk();
}

//-------------конец файла/end of file---------------------
