/* 
 *  вариант дисплея на основе MAX7219
 *             файл max72.ccp
 */

#include "max72.h" // заголовочный *.h файл комплекта библиотеки max72_dl

//------------------------------------------------------------------------

/* 
 *  конструктор
 * задаем соответствие физических линий интерфейса закрытым переменным членам класса
*/

 m72::m72(byte dn, byte clk, byte cs) // аппаратные номера dn, clk, cs
 { 
  _ln_cs = cs; // линия разрешения обмена дисплея
  _ln_dn = dn; // линия данных дисплея
  _ln_clk = clk; // тактовый строб сопровождения данных дисплея
 }

//----------------------------------------------------------------------
/*
 * инициализация линий интерфейса управления МК
 */
void m72::hinit()
 {
  pinMode(_ln_dn, OUTPUT);
  pinMode(_ln_clk, OUTPUT);
  pinMode(_ln_cs , OUTPUT);
  digitalWrite(_ln_cs, HIGH); // исходное состояние = 1
  digitalWrite(_ln_clk, LOW); // исходное состояние = 0
  digitalWrite(_ln_dn, LOW); // исходное состояние = 0
 }

//---------------------------------------------------------------------
/*
 * запись двойного слова из командного
 * заголовка(адреса назначения или cmda) и собственно данных dat
 */
 
void m72::write(byte cmda, byte dat)
{
  digitalWrite(_ln_cs, LOW); delayMicroseconds(60);
  byte ptrb=7;
  for (byte cnt=0; cnt<=7; cnt++)
  {
    digitalWrite(_ln_dn,bitRead(cmda,ptrb)); clks(); ptrb--;
  }
  ptrb=7;
  for (byte cnt=0; cnt<=7; cnt++)
  {
    digitalWrite(_ln_dn,bitRead(dat,ptrb)); clks(); ptrb--;
  }
  digitalWrite(_ln_dn, LOW); delayMicroseconds(60);
  digitalWrite(_ln_cs, HIGH); delayMicroseconds(60);
}
//----------------------------------------------------------------------
// строб сопровождения данных для wr_m72

void m72::clks()
{
  delayMicroseconds(60);
  digitalWrite(_ln_clk, HIGH); delayMicroseconds(60);
  digitalWrite(_ln_clk, LOW); delayMicroseconds(60);
}

//-----------------------------------------------------------------------
// запись строки кодов символов из v_ram в ОЗУ индикатора

void m72::write_s()
{
  for (byte cnt=0; cnt<=7; cnt++)
  {
   write((cnt+1), v_ram[cnt]);
  }
}

//-----------------------------------------------------------------------

// утилитка знакогенератора

byte m72::znak(byte tetr)
 { byte buf;
  switch (tetr)
  {
   case 0:
    buf=fnt_0;
   break;
   case 1:
    buf=fnt_1;
   break;
   case 2:
    buf=fnt_2;
   break;
   case 3:
    buf=fnt_3;
   break;
   case 4:
    buf=fnt_4;
   break;
   case 5:
    buf=fnt_5;
   break;
   case 6:
    buf=fnt_6;
   break;
   case 7:
    buf=fnt_7;
   break;
   case 8:
    buf=fnt_8;
   break;
   case 9:
    buf=fnt_9;
   break;
   case 10:
    buf=fnt_A;
   break;
   case 11:
    buf=fnt_b;
   break;
   case 12:
    buf=fnt_C;
   break;
   case 13:
    buf=fnt_d;
   break;
   case 14:
    buf=fnt_E;
   break;
   case 15:
    buf=fnt_F;
   break;
   default: 
    buf=fnt_bl;
   break;
  }
  return buf;
 }

//-------------конец файла/end of file---------------------
