/* 
 *  вариант дисплея на основе MAX7219
 *            файл max72.h
 */
// защита от переоперделения с заключительным
// #endif в конце файла
#ifndef MAX72_H
#define MAX72_H

//------------------
#if ARDUINO >= 100
 #include "Arduino.h"
#else
 #include "WProgram.h"
#endif
//------------------
/*
 добавка для удобства работы с многофайловиками
 включает в себя объявление и инициализацию шрифтов,
 адресов регистров и команд управления для MAX7219
*/
 #include "dhsct.h"

//------------------

// собственно описание класса

class m72
{
  public:
  
  // объявление конструктора
  
   m72 (byte, byte, byte);
/*
 dn - значение линии данных интерфейса дисплея
              активный уровень равен 1
 clk - значение линии строба интерфейса дисплея
             активный уровень равен 1, защелкивание данных по переднему
             (наростающему) фронту импульса строба
 cs - значение линии выборки кристалла интерфейса дисплея
            активный уровень равен 0
ограничений на максимальную длительность импульсов clc не оговорено
минимальная длительность clk = 50nS
задержка начала/завершения пакета относительно cs не менее 50nS
предварительное гашение индикации перед сменой данных в ОЗУ ИС
НЕ ТРЕБУЕТСЯ - MAX7219 имеет аппаратную поддержку "беспроблесковой"
смены данных отображения
*/
   
 // объявление (и начальная инициализация) открытых членов класса
// для обеспечения удобства доступа (extern) к адресам регистров,
// командам и данным знакогенераторов частично вынесены
// в системные файлы dhsct.h и dhsct.cpp

 // объявление функций внешнего доступа
  void hinit(); // блок инициализации линий управления
  void write(byte, byte); // ( cmda, dat ) запись двойного слова из командного
               // заголовка(адреса назначения или cmda) и собственно данных dat
  void write_s(); // запись строки кодов символов из v_ram в ОЗУ индикатора
  byte znak(byte); // утилитка знакогенератора
   
 private:
  
  // объявление закрытых членов класса
  
   byte _ln_dn, _ln_clk, _ln_cs;
   void clks(); // строб сопровождения данных для wr_m72
   
}; // обязательное заключительное ";"


#endif

//-------------конец файла/end of file---------------------
