/*
*
* тест-оболочка сканера динамической развертки дисплея
*            disp4a.ccp
*
*/

//*****************************************************************
//  Секция include: здесь подключается заголовочный файл к модулю
//*****************************************************************
// #include <avr/pgmspace.h> // подключить библиотеку работ с таблицами в ПЗУ
#include <avr/interrupt.h> // обслуживание прерываний

//**************************************************
//       Секция создания экземпляров классов
//  задаем соответствие физических линий интерфейса
//         и передаваемых параметров
//      закрытым переменным членам класса
//***************************************************
//-------------------------------------------------------

//*********** секция обьявлений *****************

/*
SI = DS = Data // вход данных
SCK = SH_CP // тактовый сигнал сдвига данных
// активный наростающий фронт положительного импульса
// простой = 0
SCLR/ = MR = RESET_SH // сброс в 0 сдвигового регистра
// активный = 0, работа = 1
RCK = ST_CP = WR_ST // перезапись в буфер-защелку из сдвигового регистра
// активный наростающий фронт положительного импульса
// простой = 0
*/
#define DATA_PIN 5 // вывод SI, вход данных
#define CLK_PIN 7 // вывод SCK, сигнал тактового импульса сдвиового регистра
#define LATCH_PIN 6 // вывод RCK, сигнал защелкивания

//-------------------------------------------------------
/* загрузка регистров младшими битами вперед
DB7 = QA = SEG_F = R17/J10 // активный 0 / активный?
DB6 = QB = SEG_B = R15/J11 // активный 0 / активный?
DB5 = QC = SEG_C = D1 // активный 0 / активный 1
DB4 = QD = SEG_E = D2 // активный 0 / активный 1
DB3 = QE = SEG_D = SwA3 // активный 0 / активный 0
DB2 = QF = SEG_G = SwA1 // активный 0 / активный 0
DB1 = QG = SEG_H = SwA2 // активный 0 / активный 0
DB0 = QH = SEG_A = SwA0 // активный 0 / активный 0
*/

// нумерация по условию пересылки "мадшими битами вперел"
// (LSBFIRST)
#define p_r17j10 7 // управление линией R17/J10, активный? (0)
#define p_r15j11 6 // управление линией R15/J11, активный? (0)
#define p_d1 5 // управление линией D1 активный 1
#define p_d2 4 // управление линией D2 активный 1
#define SwA3 3 // управление линией А3(DT4) активный 0
#define SwA1 2 // управление линией А1(DT2) активный 0
#define SwA2 1 // управление линией А2(DT3) активный 0
#define SwA0 0 // управление линией А0(DT1) активный 0
#define bl_mask B11001111 // маска бланкирования регистра
// управления и позиционных ключей

// нумерация по условию пересылки "мадшими битами вперел"
// (LSBFIRST)
#define s_A 0 // значение номера сегмента A
#define s_B 6 // значение номера сегмента B
#define s_C 5 // значение номера сегмента C
#define s_D 3 // значение номера сегмента D
#define s_E 4 // значение номера сегмента E
#define s_F 7 // значение номера сегмента F
#define s_G 2 // значение номера сегмента G
#define s_H 1 // значение номера сегмента H

/* 
 "кодовая страница кракозябр 7-сегментных"
 раскладка сегментов по символам определяется стандартной разметкой A-H
 по условию, что активный уровень(сегмент астивен/светится) принят за 1
*/

#define fnt_bl 0
#define fnt_0 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F) // цифра 0 или символ "О"
#define fnt_1 (1<<s_B | 1<<s_C) // цифра 1
#define fnt_2 (1<<s_A | 1<<s_B | 1<<s_D | 1<<s_E | 1<<s_G) // цифра 2
#define fnt_3 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_G) // цифра 3 или символ "Э/З"
#define fnt_4 (1<<s_B | 1<<s_C | 1<<s_F | 1<<s_G) // цифра 4 или символ "Ч"
#define fnt_5 (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G) // цифра 5 или символ "S"
#define fnt_6 (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // цифра 6
#define fnt_7 (1<<s_A | 1<<s_B | 1<<s_C) // цифра 7
#define fnt_8 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // цифра 8
#define fnt_9 (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G) // цифра 9
#define fnt_A (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G) // символ "A"
#define fnt_b (1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // символ "b"
#define fnt_C (1<<s_A | 1<<s_D | 1<<s_E | 1<<s_F) // символ "C" (прямая скобка '[' )
#define fnt_d (1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_G) // символ "d"
#define fnt_E (1<<s_A | 1<<s_D | 1<<s_E | 1<<s_F | 1<<s_G) // символ "E"
#define fnt_F (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_G) // символ "F"
#define fnt_P (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_G | 1<<s_B) // символ "P"
#define fnt_L (1<<s_E | 1<<s_F | 1<<s_D) // символ "L"
#define fnt_H (1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G) // символ "H"
#define fnt_U (1<<s_B | 1<<s_C | 1<<s_E | 1<<s_F | 1<<s_D) // символ "U"
#define fnt_I (1<<s_E | 1<<s_F) // левая 1 или латинская I
#define fnt_S (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_F | 1<<s_G) // аналог цифры 5
#define fnt_J (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_E) // символ "J"
#define fnt_G (1<<s_A | 1<<s_C | 1<<s_D | 1<<s_E | 1<<s_F) // символ "G"
#define fnt_r (1<<s_G | 1<<s_E) // символ "r"
#define fnt_n (1<<s_G | 1<<s_E | 1<<s_C) // символ "п"
#define fnt_c (1<<s_G | 1<<s_E | 1<<s_D) // символ "с" или '<'
#define fnt_o (1<<s_G | 1<<s_E | 1<<s_D | 1<<s_C) // нижний кружок "о"
#define fnt_u (1<<s_C | 1<<s_E | 1<<s_D) // символ "u"
#define fnt_h (1<<s_C | 1<<s_E | 1<<s_F | 1<<s_G) // символ "h"
#define fnt_rusg (1<<s_A | 1<<s_E | 1<<s_F) // символ "Г"
#define fnt_rusP (1<<s_A | 1<<s_E | 1<<s_F | 1<<s_B | 1<<s_C) // символ "П"
#define fnt_rus_iE (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D | 1<<s_G) // символ Э/З/цифра 3 (инверсное Е)
#define fnt_rusY (1<<s_F | 1<<s_G | 1<<s_B | 1<<s_C | 1<<s_D) // символ "У"
#define fnt_qest (1<<s_A | 1<<s_B | 1<<s_E | 1<<s_G) // символ "?"
#define fnt_rC (1<<s_A | 1<<s_B | 1<<s_C | 1<<s_D) // символ ']' (обратная скобка/"вывернутая С")
#define fnt_rc (1<<s_G | 1<<s_C | 1<<s_D) // символ '>'
#define fnt_gradus (1<<s_A | 1<<s_B | 1<<s_F | 1<<s_G) // верхний кружок "символ грвдуса"
#define fnt_minus (1<<s_G) // символ "-" (средняя черта)
#define fnt_aplin (1<<s_A) // символ "верхняя черта"
#define fnt_dnlin (1<<s_D) // символ "_" (нижняя черта)
#define fnt_trlin (1<<s_A | 1<<s_G | 1<<s_D) // символ "три черты"
#define fnt_coma (1<<s_H) // символ "," (децимальная точка)
#define fnt_T_sk (1<<s_E | 1<<s_F | 1<<s_G) // символ "кракозябровое Т боком"
//-------------------------------------------------------

volatile byte QtVrLd; // флаг запроса смены данных в видеопамяти
volatile byte tmpSeg; // времянка сегментного кода
volatile byte tmpAk; // времянка данных управляющего кода
volatile byte tmpTetr; // врмянка для тетрады под знакогенератор

// массив видеопамяти дисплея
// !!! * перед выводом в регистры данные
// из VRAM[0]-VRAM[3] необходимо инвертировать * !!!
byte VRAM[5]{fnt_bl, fnt_bl, fnt_bl, fnt_bl, bl_mask};

// массив предподготовки данных для переноса в видеопамять
byte TrmDat[5];

// утилитка знакогенератора
byte znak(byte);


//------------------------------------------------

// обьявления для тестовой программы

volatile int Dcnt; // счетчик данных
volatile int temp; // РВХ разного назначения


//------------------------------------------------



//------------------------------------------------

//*************************************************
//       Секция начальной инициализации setup
//   (выполняется однократно при запуске системы)
//*************************************************

void setup() {
  // put your setup code here, to run once:

 digitalWrite(DATA_PIN, LOW); digitalWrite(CLK_PIN, LOW); digitalWrite(LATCH_PIN, LOW);
 pinMode(DATA_PIN, OUTPUT); pinMode(CLK_PIN, OUTPUT); pinMode(LATCH_PIN, OUTPUT);

 // вывод блокирующего набора данных (дисплей погашен)
 shiftOut(DATA_PIN, CLK_PIN, LSBFIRST, bl_mask);
 shiftOut(DATA_PIN, CLK_PIN, LSBFIRST, 0xFF);
 delayMicroseconds(2);
 digitalWrite(LATCH_PIN, HIGH);
 delayMicroseconds(5);
 digitalWrite(LATCH_PIN, LOW);

  // инициализация автономного 1mS прерывания
 cli(); //noInterrupts();
 OCR0A = 100; TIMSK0 |= (1<<OCIE0A);
 sei(); //interrupts();

 Dcnt = 0;

 
}

//***************************************************
//  Секция основной программы (в обычном Си = main)
//***************************************************

void loop() {
  // put your main code here, to run repeatedly:

  // обработка текущего значения Dcnt и
  // вывод двоично-десятичных значений в массив TrmDat
 temp = Dcnt;
 if (temp == 0)
  { for (byte m = 0; m <= 3; m++){ TrmDat[m] = 0; } }
 else 
  { if (temp >= 1000)
     { TrmDat[0] = temp / 1000; temp = temp % 1000; }
    else { TrmDat[0] = 0; }
    if (temp >= 100)
     { TrmDat[1] = temp / 100; temp = temp % 100; }
    else { TrmDat[1] = 0; }
    if (temp >= 10)
     { TrmDat[2] = temp / 10; temp = temp % 10; }
    else { TrmDat[2] = 0; }
    TrmDat[3] = temp;
  }
  // перекодировка в сегментный код
  for (byte m = 0; m <= 3; m++)
   { TrmDat[m] = znak(TrmDat[m]); }
  // если флаг запроса сброшен
  // выставить флаг запроса на обноление данных на индикаторе
  if (!QtVrLd){ QtVrLd = 1; }
  // выждать время удержания изображения
  delay (200);
  // приращение демосчетчика Dcnt
  Dcnt++;
  if (Dcnt >= 10000){ Dcnt = 0; }
}

//------------------------------------------------

//***************************************************
//              ПОДВАЛ С ФУНКЦЯМИ
//***************************************************

/* 
 * генератор сетки событий по прерыванию 1mS
 * используется для развертки дисплея
*/
ISR(TIMER0_COMPA_vect)
{
 static byte cnts = 0; // счетчик задержки до 0,004 секунды
 static byte cntk = 0; // счетчик кадров (позиций в сроке)
 switch (cnts) {
    case 0:
      //do something when var equals 0
	  if(QtVrLd && (cntk == 0))
	  {
	   // перенос данных из массва предподготовки
       // в массив видеопамяти
       for(byte n=0; n<=3; n++)
        { VRAM[n] = TrmDat[n]; }
       VRAM[4] = TrmDat[4]; QtVrLd = 0;
	  }
	  cnts++;
      break;
	case 1:
      //do something when var equals 1
	  cnts++;
      break;
    case 2:
      //do something when var equals 2
	  tmpSeg = ~VRAM[cntk]; tmpAk = (0xF0 & VRAM[4]);
	  // маскирование активного позиционного ключа
        switch (cntk) {
         case 0:
		       tmpAk = tmpAk | (( ~(1 << SwA0)) & 0x0F);
          break;
         case 1:
           tmpAk = tmpAk | (( ~(1 << SwA1)) & 0x0F);
          break;
         case 2:
           tmpAk = tmpAk | (( ~(1 << SwA2)) & 0x0F);
          break;
         case 3:
           tmpAk = tmpAk | (( ~(1 << SwA3)) & 0x0F);
          break;
         default:
          break;
        }
	  cnts++;
      break;
    case 3:
      //do something when var equals 3
	    shiftOut(DATA_PIN, CLK_PIN, LSBFIRST, tmpAk);
      shiftOut(DATA_PIN, CLK_PIN, LSBFIRST, tmpSeg);
      delayMicroseconds(2);
      digitalWrite(LATCH_PIN, HIGH);
      delayMicroseconds(5);
      digitalWrite(LATCH_PIN, LOW);
	  if (cntk <= 2){cntk++;}
	  else if(cntk == 3){cntk = 0;}
	  cnts = 0;
      break;
	default:
      // if nothing else matches, do the default
      // default is optional
    break;
  }
}

//------------------

// утилитка знакогенератора

byte znak(byte tetr)
 { byte buf;
  switch (tetr)
  {
   case 0:
    buf=fnt_0;
   break;
   case 1:
    buf=fnt_1;
   break;
   case 2:
    buf=fnt_2;
   break;
   case 3:
    buf=fnt_3;
   break;
   case 4:
    buf=fnt_4;
   break;
   case 5:
    buf=fnt_5;
   break;
   case 6:
    buf=fnt_6;
   break;
   case 7:
    buf=fnt_7;
   break;
   case 8:
    buf=fnt_8;
   break;
   case 9:
    buf=fnt_9;
   break;
   case 10:
    buf=fnt_A;
   break;
   case 11:
    buf=fnt_b;
   break;
   case 12:
    buf=fnt_C;
   break;
   case 13:
    buf=fnt_d;
   break;
   case 14:
    buf=fnt_E;
   break;
   case 15:
    buf=fnt_F;
   break;
   default: 
    buf=fnt_bl;
   break;
  }
  return buf;
 }

//------------------------------------------------





//----------**********************----------

//------------------------------------------------


//-------------конец файла/end of file---------------------
