

#ifndef _N5110_H_
#define _N5110_H_

#include "main.h"

//    
#define LCD_X_RES                  84    //   
#define LCD_Y_RES                  48    //   

//       LcdBars ( uint8_t data[], uint8_t numbBars, uint8_t width, uint8_t multiplier )
#define EMPTY_SPACE_BARS           2     //   
#define BAR_X                      30    //  x
#define BAR_Y                      47    //  y

//   ( 84 * 48 ) / 8 = 504 
#define LCD_CACHE_SIZE             ( ( LCD_X_RES * LCD_Y_RES ) / 8 )

#define FALSE                      0
#define TRUE                       1

//   
#define OK                         0   //  
#define OUT_OF_BORDER              1   //    
#define OK_WITH_WRAP               2   //    (       )

// 
typedef enum
{
	SEND_CMD = 0,     // 
	SEND_CHR = 1      // 

} LcdCmdData;


typedef enum
{
    PIXEL_OFF =  0,   //   
    PIXEL_ON  =  1,   //   
    PIXEL_XOR =  2    //  

} LcdPixelMode;

typedef enum
{
    FONT_1X = 0,      //    5x7
    FONT_2X = 1,      //   
	FONT_NEG= 4       // 
} LcdFontSize;

extern uint8_t  LcdCache [];

//  ,     n5110lcd.c
void LCDInit      ( void );   // 
void LCDClear     ( void );   //  
void Lcd_update    ( void );   //     
void LcdContrast   ( uint8_t contrast );   //   
uint8_t LCD_XY	   ( uint8_t x, uint8_t y );   //     x,y
uint8_t LcdChr        ( LcdFontSize size, uint8_t ch );   //     
uint8_t Lcd_pixel      ( uint8_t x, uint8_t y, LcdPixelMode mode );   // 
uint8_t Lcd_line       ( uint8_t x1, uint8_t y1, uint8_t x2, uint8_t y2, LcdPixelMode mode );   // 
uint8_t Lcd_circle     ( uint8_t x, uint8_t y, uint8_t radius, LcdPixelMode mode);   // 
uint8_t Lcd_rect_empty       ( uint8_t x1, uint8_t y1, uint8_t x2, uint8_t y2, LcdPixelMode mode );   // 
uint8_t Lcd_rect  ( uint8_t baseX, uint8_t baseY, uint8_t height, uint8_t width, LcdPixelMode mode );   // 

//uint8_t LCDStr ( uint8_t x, uint8_t y, LcdFontSize size, const uint8_t *dataPtr );
uint8_t LCDStr (LcdFontSize size, const uint8_t *dataPtr );
void LCDClearStr(uint8_t y, uint8_t count);// 

void Lcd_image(uint8_t x, uint8_t y, uint16_t RegAddr, uint16_t len);


//     (ASCII[0x20-0x7F] + CP1251[0xC0-0xFF])

static const uint8_t FontLookup [][5] =
{
   { 0x00, 0x00, 0x00, 0x00, 0x00 },   //   0x20  32
   { 0x00, 0x00, 0x5F, 0x00, 0x00 },   // ! 0x21  33
   { 0x00, 0x07, 0x00, 0x07, 0x00 },   // " 0x22  34
   { 0x14, 0x7F, 0x14, 0x7F, 0x14 },   // # 0x23  35
   { 0x24, 0x2A, 0x7F, 0x2A, 0x12 },   // $ 0x24  36
   { 0x4C, 0x2C, 0x10, 0x68, 0x64 },   // % 0x25  37
   { 0x36, 0x49, 0x55, 0x22, 0x50 },   // & 0x26  38
   { 0x00, 0x05, 0x03, 0x00, 0x00 },   // ' 0x27  39
   { 0x00, 0x1C, 0x22, 0x41, 0x00 },   // ( 0x28  40
   { 0x00, 0x41, 0x22, 0x1C, 0x00 },   // ) 0x29  41
   { 0x14, 0x08, 0x3E, 0x08, 0x14 },   // * 0x2A  42
   { 0x08, 0x08, 0x3E, 0x08, 0x08 },   // + 0x2B  43
   { 0x00, 0x00, 0x50, 0x30, 0x00 },   // , 0x2C  44
   { 0x10, 0x10, 0x10, 0x10, 0x10 },   // - 0x2D  45
   { 0x00, 0x60, 0x60, 0x00, 0x00 },   // . 0x2E  46
   { 0x20, 0x10, 0x08, 0x04, 0x02 },   // / 0x2F  47
   { 0x3E, 0x51, 0x49, 0x45, 0x3E },   // 0 0x30  48
   { 0x00, 0x42, 0x7F, 0x40, 0x00 },   // 1 0x31  49
   { 0x42, 0x61, 0x51, 0x49, 0x46 },   // 2 0x32  50
   { 0x21, 0x41, 0x45, 0x4B, 0x31 },   // 3 0x33  51
   { 0x18, 0x14, 0x12, 0x7F, 0x10 },   // 4 0x34  52
   { 0x27, 0x45, 0x45, 0x45, 0x39 },   // 5 0x35  53
   { 0x3C, 0x4A, 0x49, 0x49, 0x30 },   // 6 0x36  54
   { 0x01, 0x71, 0x09, 0x05, 0x03 },   // 7 0x37  55
   { 0x36, 0x49, 0x49, 0x49, 0x36 },   // 8 0x38  56
   { 0x06, 0x49, 0x49, 0x29, 0x1E },   // 9 0x39  57
   { 0x00, 0x36, 0x36, 0x00, 0x00 },   // : 0x3A  58
   { 0x00, 0x56, 0x36, 0x00, 0x00 },   // ; 0x3B  59
   { 0x08, 0x14, 0x22, 0x41, 0x00 },   // < 0x3C  60
   { 0x14, 0x14, 0x14, 0x14, 0x14 },   // = 0x3D  61
   { 0x00, 0x41, 0x22, 0x14, 0x08 },   // > 0x3E  62
   { 0x02, 0x01, 0x51, 0x09, 0x06 },   // ? 0x3F  63
   { 0x32, 0x49, 0x79, 0x41, 0x3E },   // @ 0x40  64
   { 0x7E, 0x11, 0x11, 0x11, 0x7E },   // A 0x41  65
   { 0x7F, 0x49, 0x49, 0x49, 0x36 },   // B 0x42  66
   { 0x3E, 0x41, 0x41, 0x41, 0x22 },   // C 0x43  67
   { 0x7F, 0x41, 0x41, 0x22, 0x1C },   // D 0x44  68
   { 0x7F, 0x49, 0x49, 0x49, 0x41 },   // E 0x45  69
   { 0x7F, 0x09, 0x09, 0x09, 0x01 },   // F 0x46  70
   { 0x3E, 0x41, 0x49, 0x49, 0x7A },   // G 0x47  71
   { 0x7F, 0x08, 0x08, 0x08, 0x7F },   // H 0x48  72
   { 0x00, 0x41, 0x7F, 0x41, 0x00 },   // I 0x49  73
   { 0x20, 0x40, 0x41, 0x3F, 0x01 },   // J 0x4A  74
   { 0x7F, 0x08, 0x14, 0x22, 0x41 },   // K 0x4B  75
   { 0x7F, 0x40, 0x40, 0x40, 0x40 },   // L 0x4C  76
   { 0x7F, 0x02, 0x0C, 0x02, 0x7F },   // M 0x4D  77
   { 0x7F, 0x04, 0x08, 0x10, 0x7F },   // N 0x4E  78
   { 0x3E, 0x41, 0x41, 0x41, 0x3E },   // O 0x4F  79
   { 0x7F, 0x09, 0x09, 0x09, 0x06 },   // P 0x50  80
   { 0x3E, 0x41, 0x51, 0x21, 0x5E },   // Q 0x51  81
   { 0x7F, 0x09, 0x19, 0x29, 0x46 },   // R 0x52  82
   { 0x46, 0x49, 0x49, 0x49, 0x31 },   // S 0x53  83
   { 0x01, 0x01, 0x7F, 0x01, 0x01 },   // T 0x54  84
   { 0x3F, 0x40, 0x40, 0x40, 0x3F },   // U 0x55  85
   { 0x1F, 0x20, 0x40, 0x20, 0x1F },   // V 0x56  86
   { 0x3F, 0x40, 0x38, 0x40, 0x3F },   // W 0x57  87
   { 0x63, 0x14, 0x08, 0x14, 0x63 },   // X 0x58  88
   { 0x07, 0x08, 0x70, 0x08, 0x07 },   // Y 0x59  89
   { 0x61, 0x51, 0x49, 0x45, 0x43 },   // Z 0x5A  90
   { 0x00, 0x7F, 0x41, 0x41, 0x00 },   // [ 0x5B  91
   { 0x02, 0x04, 0x08, 0x10, 0x20 },   // \ 0x5C  92
   { 0x00, 0x41, 0x41, 0x7F, 0x00 },   // ] 0x5D  93
   { 0x04, 0x02, 0x01, 0x02, 0x04 },   // ^ 0x5E  94
   { 0x40, 0x40, 0x40, 0x40, 0x40 },   // _ 0x5F  95
   { 0x00, 0x01, 0x02, 0x04, 0x00 },   // ` 0x60  96
   { 0x20, 0x54, 0x54, 0x54, 0x78 },   // a 0x61  97
   { 0x7F, 0x48, 0x44, 0x44, 0x38 },   // b 0x62  98
   { 0x38, 0x44, 0x44, 0x44, 0x20 },   // c 0x63  99
   { 0x38, 0x44, 0x44, 0x48, 0x7F },   // d 0x64 100
   { 0x38, 0x54, 0x54, 0x54, 0x18 },   // e 0x65 101
   { 0x08, 0x7E, 0x09, 0x01, 0x02 },   // f 0x66 102
   { 0x0C, 0x52, 0x52, 0x52, 0x3E },   // g 0x67 103
   { 0x7F, 0x08, 0x04, 0x04, 0x78 },   // h 0x68 104
   { 0x00, 0x44, 0x7D, 0x40, 0x00 },   // i 0x69 105
   { 0x20, 0x40, 0x44, 0x3D, 0x00 },   // j 0x6A 106
   { 0x7F, 0x10, 0x28, 0x44, 0x00 },   // k 0x6B 107
   { 0x00, 0x41, 0x7F, 0x40, 0x00 },   // l 0x6C 108
   { 0x7C, 0x04, 0x18, 0x04, 0x78 },   // m 0x6D 109
   { 0x7C, 0x08, 0x04, 0x04, 0x78 },   // n 0x6E 110
   { 0x38, 0x44, 0x44, 0x44, 0x38 },   // o 0x6F 111
   { 0x7C, 0x14, 0x14, 0x14, 0x08 },   // p 0x70 112
   { 0x08, 0x14, 0x14, 0x18, 0x7C },   // q 0x71 113
   { 0x7C, 0x08, 0x04, 0x04, 0x08 },   // r 0x72 114
   { 0x48, 0x54, 0x54, 0x54, 0x20 },   // s 0x73 115
   { 0x04, 0x3F, 0x44, 0x40, 0x20 },   // t 0x74 116
   { 0x3C, 0x40, 0x40, 0x20, 0x7C },   // u 0x75 117
   { 0x1C, 0x20, 0x40, 0x20, 0x1C },   // v 0x76 118
   { 0x3C, 0x40, 0x30, 0x40, 0x3C },   // w 0x77 119
   { 0x44, 0x28, 0x10, 0x28, 0x44 },   // x 0x78 120
   { 0x0C, 0x50, 0x50, 0x50, 0x3C },   // y 0x79 121
   { 0x44, 0x64, 0x54, 0x4C, 0x44 },   // z 0x7A 122
   { 0x00, 0x08, 0x36, 0x41, 0x00 },   // { 0x7B 123
   { 0x00, 0x00, 0x7F, 0x00, 0x00 },   // | 0x7C 124
   { 0x00, 0x41, 0x36, 0x08, 0x00 },   // } 0x7D 125
   { 0x08, 0x04, 0x08, 0x10, 0x08 },   // ~ 0x7E 126
   { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },   //  0x7F 127

   { 0x7C, 0x12, 0x11, 0x12, 0x7C },   //  0xC0 192
   { 0x7F, 0x49, 0x49, 0x49, 0x31 },   //  0xC1 193
   { 0x7F, 0x49, 0x49, 0x49, 0x36 },   //  0xC2 194
   { 0x7F, 0x01, 0x01, 0x01, 0x01 },   //  0xC3 195
   { 0x60, 0x3F, 0x21, 0x3F, 0x60 },   //  0xC4 196
   { 0x7F, 0x49, 0x49, 0x49, 0x41 },   //  0xC5 197
   { 0x77, 0x08, 0x7F, 0x08, 0x77 },   //  0xC6 198
   { 0x22, 0x41, 0x49, 0x49, 0x36 },   //  0xC7 199
   { 0x7F, 0x10, 0x08, 0x04, 0x7F },   //  0xC8 200
   { 0x7E, 0x10, 0x09, 0x04, 0x7E },   //  0xC9 201
   { 0x7F, 0x08, 0x14, 0x22, 0x41 },   //  0xCA 202
   { 0x40, 0x3E, 0x01, 0x01, 0x7F },   //  0xCB 203
   { 0x7F, 0x02, 0x0C, 0x02, 0x7F },   //  0xCC 204
   { 0x7F, 0x08, 0x08, 0x08, 0x7F },   //  0xCD 205
   { 0x3E, 0x41, 0x41, 0x41, 0x3E },   //  0xCE 206
   { 0x7F, 0x01, 0x01, 0x01, 0x7F },   //  0xCF 207
   { 0x7F, 0x09, 0x09, 0x09, 0x06 },   //  0xD0 208
   { 0x3E, 0x41, 0x41, 0x41, 0x22 },   //  0xD1 209
   { 0x01, 0x01, 0x7F, 0x01, 0x01 },   //  0xD2 210
   { 0x07, 0x48, 0x48, 0x48, 0x3F },   //  0xD3 211
   { 0x0E, 0x11, 0x7F, 0x11, 0x0E },   //  0xD4 212
   { 0x63, 0x14, 0x08, 0x14, 0x63 },   //  0xD5 213
   { 0x3F, 0x20, 0x20, 0x3F, 0x60 },   //  0xD6 214
   { 0x07, 0x08, 0x08, 0x08, 0x7F },   //  0xD7 215
   { 0x7F, 0x40, 0x7E, 0x40, 0x7F },   //  0xD8 216
   { 0x3F, 0x20, 0x3F, 0x20, 0x7F },   //  0xD9 217
   { 0x01, 0x7F, 0x48, 0x48, 0x30 },   //  0xDA 218
   { 0x7F, 0x48, 0x30, 0x00, 0x7F },   //  0xDB 219
   { 0x00, 0x7F, 0x48, 0x48, 0x30 },   //  0xDC 220
   { 0x22, 0x41, 0x49, 0x49, 0x3E },   //  0xDD 221
   { 0x7F, 0x08, 0x3E, 0x41, 0x3E },   //  0xDE 222
   { 0x46, 0x29, 0x19, 0x09, 0x7F },   //  0xDF 223
   { 0x20, 0x54, 0x54, 0x54, 0x78 },   //  0xE0 224
   { 0x3C, 0x4A, 0x4A, 0x4A, 0x31 },   //  0xE1 225
   { 0x7C, 0x54, 0x54, 0x28, 0x00 },   //  0xE2 226
   { 0x7C, 0x04, 0x04, 0x0C, 0x00 },   //  0xE3 227
   { 0x60, 0x3C, 0x24, 0x3C, 0x60 },   //  0xE4 228
   { 0x38, 0x54, 0x54, 0x54, 0x18 },   //  0xE5 229
   { 0x6C, 0x10, 0x7C, 0x10, 0x6C },   //  0xE6 230
   { 0x00, 0x44, 0x54, 0x54, 0x28 },   //  0xE7 231
   { 0x7C, 0x20, 0x10, 0x08, 0x7C },   //  0xE8 232
   { 0x7C, 0x21, 0x12, 0x09, 0x7C },   //  0xE9 233
   { 0x7C, 0x10, 0x28, 0x44, 0x00 },   //  0xEA 234
   { 0x40, 0x38, 0x04, 0x04, 0x7C },   //  0xEB 235
   { 0x7C, 0x08, 0x10, 0x08, 0x7C },   //  0xEC 236
   { 0x7C, 0x10, 0x10, 0x10, 0x7C },   //  0xED 237
   { 0x38, 0x44, 0x44, 0x44, 0x38 },   //  0xEE 238
   { 0x7C, 0x04, 0x04, 0x04, 0x7C },   //  0xEF 239
   { 0x7C, 0x14, 0x14, 0x14, 0x08 },   //  0xF0 240
   { 0x38, 0x44, 0x44, 0x44, 0x00 },   //  0xF1 241
   { 0x04, 0x04, 0x7C, 0x04, 0x04 },   //  0xF2 242
   { 0x0C, 0x50, 0x50, 0x50, 0x3C },   //  0xF3 243
   { 0x08, 0x14, 0x7C, 0x14, 0x08 },   //  0xF4 244
   { 0x44, 0x28, 0x10, 0x28, 0x44 },   //  0xF5 245
   { 0x3C, 0x20, 0x20, 0x3C, 0x60 },   //  0xF6 246
   { 0x0C, 0x10, 0x10, 0x10, 0x7C },   //  0xF7 247
   { 0x7C, 0x40, 0x7C, 0x40, 0x7C },   //  0xF8 248
   { 0x3C, 0x20, 0x3C, 0x20, 0x7C },   //  0xF9 249
   { 0x04, 0x7C, 0x50, 0x50, 0x20 },   //  0xFA 250
   { 0x7C, 0x50, 0x20, 0x00, 0x7C },   //  0xFB 251
   { 0x00, 0x7C, 0x50, 0x50, 0x20 },   //  0xFC 252
   { 0x28, 0x44, 0x54, 0x54, 0x38 },   //  0xFD 253
   { 0x7C, 0x10, 0x38, 0x44, 0x38 },   //  0xFE 254
   { 0x48, 0x54, 0x34, 0x14, 0x7C }    //  0xFF 255
};

#endif  /*  _N5110_H_ */
