/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2020 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include "rda5807.h"
#include "n5110.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

// 
#define LED_ON     	LL_GPIO_ResetOutputPin(LED_GPIO_Port, LED_Pin)
// 
#define LED_OFF		LL_GPIO_SetOutputPin(LED_GPIO_Port, LED_Pin)

#define REPIT_PROG  8

#define Reset_CR2(I2Cx) I2Cx->CR2 &= (uint32_t)~((uint32_t)(I2C_CR2_SADD |\
        I2C_CR2_HEAD10R | I2C_CR2_NBYTES | I2C_CR2_RELOAD | I2C_CR2_RD_WRN))

//    24cxx
#define adr_EPPROM 0xA0

/*     24cxx
0-991 - 31   32  (|)
992 - 1023 - Setup 32
1024 +504 - 
*/

/*    24c16 (2048 )
0-1535 - 48   32  (|)
1536 - 1543 - Setup 8
1544 + 504 - 
*/


//  48  32 
#define TABL_CT 0x00
//8 
#define MY_SETUP 1536
//504 
#define PICTURE  1544

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */


#define True       1
#define False      0

#define Short_Key 0x02
#define Long_Key  0x04


	typedef struct
	{
	 uint8_t vol;//
	 uint8_t n_station;//  
	 uint8_t Contrast;//
	 uint8_t bas;//
	}TSetup;

	enum
	{
		M_EXIT,
		M_VOL,
		M_station,
		M_FR,
		M_BASS,
		M_DispMenu,
		M_CONTR
	};


	typedef struct
	{
		void       *Next;
		void       *Prev;
		void       *SubMenu;
		uint8_t     SelProg;
		const char  Text[];
	} menuItem;

	#define MAKE_MENU(Name, Next, Prev, SubMenu, SelProg, Text)\
	   extern menuItem  const Next;\
	   extern menuItem  const Prev;\
	   extern menuItem  const SubMenu;\
	menuItem  const Name = {(menuItem*)&Next, (menuItem*)&Prev, (menuItem*)&SubMenu, (uint8_t)SelProg, { Text }}

	menuItem const NULL_M = {(menuItem*)0, (menuItem*)0,  (menuItem*)0,0,{0x00}};

	menuItem* selectedMenuItem; //   
	menuItem* returnMenuItem;   //     

	//        NAME     NEXT,    PREV       S_MENU,    SelProg       Text
	//MAKE_MENU(m_s1i1,  m_s1i2,  NULL_M,    NULL_M,   M_DispMenu,  " ");
	//MAKE_MENU(m_s1i2,  m_s1i3,  m_s1i1,    NULL_M,   M_DispMenu,  "   ");
	//MAKE_MENU(m_s1i3,  m_s1i4,  m_s1i2,    NULL_M,   M_DispMenu,  "   ");
	MAKE_MENU(m_s1i4,  m_s1i5,  NULL_M,    m_s2i4,   M_DispMenu,  "       ");
	MAKE_MENU(m_s1i5,  NULL_M,  m_s1i4,    m_s2i5,   M_DispMenu,  "  ");

	MAKE_MENU(m_s2i4,  NULL_M,  NULL_M,    NULL_M,   M_BASS,  "  ");
	MAKE_MENU(m_s2i5,  NULL_M,  NULL_M,    NULL_M,   M_CONTR, "  ");

	// 
	#define PREV       ((menuItem*)(selectedMenuItem->Prev))
	#define NEXT       ((menuItem*)(selectedMenuItem->Next))
	#define S_MENU     ((menuItem*)(selectedMenuItem->SubMenu))
	#define SEL_PROG   (selectedMenuItem->SelProg)


   void fun_02(void);
   void fun_04(void);
   //void fun_15(void);

   void null_EC (int8_t t);
   void EC_vol(int8_t pin);//  encjlthf

   uint32_t get_millis(void);

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

	__IO uint16_t ADC_ConvertedValue[2];

	volatile uint32_t Flag_Prog;//    
	volatile uint32_t Flag_Prog_Timer;//    
	volatile uint32_t SoftTimer[32];//     ( 65535ms)

	volatile FUN Fun[32];           //  

	volatile uint8_t flag_RX=0;
	volatile uint8_t data_RX;

	#define TX_BUFFER_SIZE 48
	#define RX_BUFFER_SIZE 48
	uint8_t tx_buffer[TX_BUFFER_SIZE];

	volatile uint8_t rx_buffer[RX_BUFFER_SIZE];
	volatile uint8_t rx_counter=0;
	volatile uint8_t Len_RX;

	volatile uint8_t fl_USART_tx=0;
	volatile uint8_t fl_SPI_tx = 0;// 

	uint8_t fSeekFr=0;//  

	uint8_t buff_LCD[20];

	uint8_t select_prog = M_VOL;//

	uint8_t RSSI;// 

	//   VREF  3.3  FLASH
	uint16_t VREF_CAL;//

	uint8_t Contrast = 66;//

	uint8_t n_station = 0;//  

	TSetup setup={2,1,66,1};

	uint8_t buf_I2C[32];

	volatile int8_t en_key=0;

	int16_t kal_ADC;

	uint16_t Fr=1009;// 
	uint16_t Fr_st = 1009;//    
	uint8_t current_station[32];
	uint8_t temp_station[32];
	uint8_t *ptr_station = current_station;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
static void MX_GPIO_Init(void);
static void MX_DMA_Init(void);
static void MX_I2C1_Init(void);
static void MX_SPI1_Init(void);
static void MX_USART1_UART_Init(void);
static void MX_ADC_Init(void);
static void MX_TIM14_Init(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */
//----------------------------------------------------------------------------------------
//=================================================================================================
/*    24cxx
0-992 - 31   32  (|)
992 - 1023 - Setup 32
1024 +504 - 
*/
void I2C_Master_Transmit(uint8_t chip_addr, uint8_t * pBuff, uint8_t len)
{
	 LL_I2C_HandleTransfer(I2C1, chip_addr, LL_I2C_ADDRSLAVE_7BIT, len,
						   LL_I2C_MODE_AUTOEND, LL_I2C_GENERATE_START_WRITE);
	 uint8_t error=0;
	 uint8_t TxIndex=0;
	 while(!LL_I2C_IsActiveFlag_STOP(I2C1))  // Loop until end of transfer received (STOP flag raised)
	  {
		 /* Check TXIS flag value in ISR register */
		if(LL_I2C_IsActiveFlag_TXIS(I2C1))
		 {
		   /* Write data in Transmit Data register. TXIS flag is cleared by writing data in TXDR register */
		   LL_I2C_TransmitData8(I2C1, pBuff[TxIndex++]);
		   error=0;
		 }
		else
		 {
			//  
		  if(++error == 0)break;
		 }

	  }
	 LL_I2C_ClearFlag_STOP(I2C1);
	 Reset_CR2(I2C1);
	 //I2C1->CR2=0;
	 //while(LL_I2C_IsActiveFlag_TXIS(I2C1));
	 LL_mDelay(5);
}



void I2C_Master_Receive(uint8_t chip_addr, uint8_t * pBuff, uint8_t len)
{
	 LL_I2C_HandleTransfer(I2C1, chip_addr, LL_I2C_ADDRSLAVE_7BIT, len,
						   LL_I2C_MODE_AUTOEND, LL_I2C_GENERATE_START_READ);
	 uint8_t error=0;
	 uint8_t RxIndex=0;
	  while(!LL_I2C_IsActiveFlag_STOP(I2C1))  // Loop until end of transfer received (STOP flag raised)
	   {
		  // Check  flag value in ISR register
		   if(LL_I2C_IsActiveFlag_RXNE(I2C1))
			  {
				//Write data in Receive Data register. TXIS flag is cleared by writing data in TXDR register
				pBuff[RxIndex++]=LL_I2C_ReceiveData8(I2C1);
				error=0;
			  }
		   else
			  {
			   //  
			   if(++error == 0)break;
			  }

	   }

	  LL_I2C_ClearFlag_STOP(I2C1);
	  Reset_CR2(I2C1);
	  //I2C1->CR2=0;
}

//--------------------------------------------------------------------------------------------------

void USART_TX ( uint16_t sz)
{
	  while (fl_USART_tx);
	  fl_USART_tx=1;
	  LL_DMA_DisableChannel(DMA1, LL_DMA_CHANNEL_2);
	  LL_DMA_SetDataLength(DMA1, LL_DMA_CHANNEL_2, sz);
	  LL_DMA_EnableChannel(DMA1, LL_DMA_CHANNEL_2);
}
//-----------------------------------------------------------------------------------------------
void SPI_DMA_TX (uint32_t MemoryAddress, uint16_t sz)
{
	  while (fl_SPI_tx);
	  fl_SPI_tx=1;
	  LL_DMA_DisableChannel(DMA1, LL_DMA_CHANNEL_3);
	  LL_DMA_SetMemoryAddress(DMA1, LL_DMA_CHANNEL_3, MemoryAddress);
	  LL_DMA_SetDataLength(DMA1, LL_DMA_CHANNEL_3, sz);
	  LL_DMA_EnableChannel(DMA1, LL_DMA_CHANNEL_3);
}

//===============================================================================================
//----------------------------------------------------------------------------------------
void Set_Prog_Timer(uint8_t n_prog, uint32_t timer)
 {
	 Flag_Prog_Timer |= (1LU << n_prog);

	 SoftTimer[n_prog] = get_millis() + timer;
 }

 void null_Prog (void)
 {return;}

 void null_EC (int8_t t)
  {return;}

//-------------------------------------------------------------------------
void save_setup(void)
{
	uint16_t RegAddr = MY_SETUP;
	buf_I2C[0]=(RegAddr>>8);buf_I2C[1]=(RegAddr);
	memcpy (&buf_I2C[2], &setup,sizeof(setup));
	I2C_Master_Transmit(0xA0,buf_I2C, 2 + sizeof(setup));
}

int8_t load_setup(void)
{
	 uint16_t RegAddr = MY_SETUP;
	 buf_I2C[0]=(RegAddr>>8);buf_I2C[1]=(RegAddr);

	 I2C_Master_Transmit(0xA0,buf_I2C, 2);
	 I2C_Master_Receive(0xA1,buf_I2C, sizeof(setup));

	 if(buf_I2C[0] > 15 || (buf_I2C[2] < 50 || buf_I2C[2] > 75))//    24Cxx
	   {
	  //  I2C   
		save_setup();

		buf_I2C[0]=(RegAddr>>8);buf_I2C[1]=(RegAddr);

		I2C_Master_Transmit(0xA0,buf_I2C, 2);
		I2C_Master_Receive(0xA1,buf_I2C, sizeof(setup));
	   }

	 memcpy (&setup, buf_I2C, sizeof(setup));
	 return 0;
}


void m_screen(void)
{
	 char buff_v[8],buff_temp[8];
	 static uint8_t cikl = 0;
	 uint16_t bat_mVolt = 3300;
	 uint32_t ADC_Data;

	 ++cikl;

	 LL_ADC_REG_StartConversion(ADC1);
	 while (!LL_ADC_IsActiveFlag_EOS(ADC1));
	 LL_ADC_ClearFlag_EOS(ADC1);
	 ADC_Data = LL_ADC_REG_ReadConversionData12(ADC1);
	 bat_mVolt = (3300UL * VREF_CAL) / ADC_Data;// 
	 uint16_t val=bat_mVolt/1000;
	 utoa(val, buff_v, 10);
	 strcat(buff_v,",");
	 val = (bat_mVolt-(val * 1000))/10;
	 if(val < 10)
	   {
		 buff_temp[0] ='0';// 0
		 utoa(val, &buff_temp[1], 10);
	   }
	 else  utoa(val, buff_temp, 10);
	 strcat(buff_v,buff_temp);
	 strcat(buff_v,"v");

	 LCDClearStr(0,2);// 
	 LCD_XY(0,0); LCDStr(FONT_1X,ptr_station);

	 LCDClearStr(2,3);// 
	 uint16_t F_temp = (select_prog == M_station) ? Fr_st : Fr;
	 uint16_t fr10 = F_temp / 10;
	 utoa(fr10,(char *) buff_LCD, 10);
	 strcat((char *) buff_LCD,",");
	 utoa(F_temp - (fr10*10), (char *)buff_temp, 10);
	 strcat((char *)buff_LCD,(char *)buff_temp);
	 LCD_XY(0,3);LCDStr(FONT_2X,buff_LCD);
	 LCDStr(FONT_1X,(unsigned char *)" ");

	 switch(select_prog)
	   {
		 case M_VOL:
		   {
			  LCDClearStr(5,1);// 
			  LCD_XY(0,5);

			 if( !(cikl % 4))
				{
				  LCDStr(FONT_1X,(unsigned char *)". ");
				}
			 else
				{
				 utoa(RSSI,(char *) buff_LCD, 10);
				 LCDStr(FONT_1X,(unsigned char *)"S");LCDStr(FONT_1X,buff_LCD);
				 utoa(rda5807_Get_VOLUME(),(char *) buff_LCD, 10);
				 LCDStr(FONT_1X,(unsigned char *)" ");LCDStr(FONT_1X,buff_LCD);
				 buff_LCD[0]=' ';buff_LCD[1]=0;
				 strcat((char *)buff_LCD,buff_v);
				 LCDStr(FONT_1X,buff_LCD);
				}
		   } break;

		 case M_station:
		     {
			   LCDClearStr(5,1);LCD_XY(0,5);LCDStr(FONT_1X,(unsigned char *)" ");
		     }break;

		 case M_FR:
		   {
			   LCDClearStr(5,1);LCD_XY(0,5);LCDStr(FONT_1X,(unsigned char *)" ");
		   }break;
	   }

	if( bat_mVolt < 3200 && !(cikl % 4))
	   {
		 LCDClearStr(0,2);// 
		 LCD_XY(0,0);
		 LED_ON;// 
		 LCD_XY(0,0);LCDStr(FONT_1X,(unsigned char *)" ");
		 LCDClearStr(3,2);LCD_XY(0,3);LCDStr(FONT_2X,(unsigned char *)buff_v);
	   }
	 else
	   {
		 if( bat_mVolt < 3200)LED_OFF;// 
	   }

	//Lcd_line(0,12,83,12,PIXEL_ON);
	Lcd_line(0,36,83,36,PIXEL_ON);
	Lcd_update ();// 
	return ;
}

uint8_t dispVol(int8_t pin)// 
{
   if(pin==+1 && setup.vol < 16)rda5807_SetVolume((uint8_t)++setup.vol);
   if(pin==-1 && setup.vol > 0) rda5807_SetVolume((uint8_t)--setup.vol);

   if(pin == 0x02)//   
	 {
	  save_setup();
	  select_prog = M_station;//   
	  return 1;
	 }

   if(pin == 0x04)//   
 	 {
	  selectedMenuItem =(menuItem*) &m_s1i4;//  
 	  select_prog = M_DispMenu;
 	  LCDClear();
 	  return 1;
 	 }

   m_screen();
   return 0;
}

uint8_t dispFr(int8_t pin)// 
{
	//LCDClearStr(5,1);//  
	//LCD_XY(0,5);LCDStr(FONT_1X,(unsigned char *)" ");
	if(pin==+1 && Fr < 1080)rda5807_SetFreq_In100Khz(++Fr);
	if(pin==-1 && Fr > 870 )rda5807_SetFreq_In100Khz(--Fr);

	if(pin == Short_Key)//  
		{
		 select_prog = M_VOL;//   
		 return 1;
		}

	if(pin == Long_Key)//   
		 {
		  selectedMenuItem = (menuItem*) &m_s1i4;//   
		  select_prog = M_DispMenu;
		  LCDClear();
		  return 1;
		 }

	m_screen();
	return 0;
}

uint8_t station (int8_t pin)// 
{
	if(pin==1  && n_station < 30)n_station++;
	if(pin==-1 && n_station > 0) n_station--;

	if(pin == Long_Key)//       
	   	{
		 setup.n_station=n_station;

		 rda5807_SetFreq_In100Khz(Fr_st);//  
		 select_prog = M_VOL;//     

		 strcpy((char *)current_station, (char *)ptr_station);
		 ptr_station = current_station;
		 save_setup();
		 return 1;
	   	}

	if(pin == Short_Key)//       
	    {
	 	 select_prog = M_FR;//   
	 	 ptr_station = current_station;
	 	 return 1;
	 	}

	uint16_t RegAddr = TABL_CT + n_station*32;
	buf_I2C[0]=(RegAddr>>8);buf_I2C[1]=(RegAddr);

	I2C_Master_Transmit(0xA0,buf_I2C, 2);
	I2C_Master_Receive(0xA1,buf_I2C, 32);

	Fr_st = buf_I2C[0] + (buf_I2C[1] << 8);
	ptr_station = &buf_I2C[2];

    m_screen();
    return 0;
}

uint8_t dispMenu(int8_t pin)// 
{
	 if(pin==-1)
		 if((void*)PREV != (void*)&NULL_M)
			 selectedMenuItem = PREV;
	 if(pin==+1)
		 if((void*)NEXT != (void*)&NULL_M)
			 selectedMenuItem = NEXT;

	 LCDClear();
	 LCD_XY(4,0);LCDStr(FONT_1X,(unsigned char *)"");

	 //LCDClearStr(1,0);// 1 
	 if((menuItem*)PREV != (menuItem*)&NULL_M && (menuItem*)(PREV->Prev) != (menuItem*)&NULL_M)
	   {LCD_XY(0,1);LCDStr(FONT_1X,  (unsigned char *)((menuItem*)(PREV->Prev))->Text);}

	 //LCDClearStr(2,1);// 2 
	 if((menuItem*)PREV != (menuItem*)&NULL_M)
		{LCD_XY(0,2);LCDStr(FONT_1X,(unsigned char *)PREV->Text);}

	 //LCDClearStr(3,1);// 3 
	 LCD_XY(0,3);LCDStr(FONT_1X|FONT_NEG,(unsigned char *)selectedMenuItem->Text);

	 //LCDClearStr(4,1);// 4 
	 if((menuItem*)NEXT != (menuItem*)&NULL_M)
		{LCD_XY(0,4);LCDStr(FONT_1X,(unsigned char *)NEXT->Text);}

	 //LCDClearStr(5,1);// 5 
	 if((menuItem*)NEXT != (menuItem*)&NULL_M && (menuItem*)NEXT->Next != (menuItem*)&NULL_M)
		{LCD_XY(0,5); LCDStr(FONT_1X,(unsigned char *)((menuItem*)(NEXT->Next))->Text);}

	 if(pin == Long_Key)//   
		{
		 select_prog = M_VOL;//   
		 return 1;
		}

	 if(pin == Short_Key)//      
		if((void*)S_MENU != (void*)&NULL_M)
		 {
		  returnMenuItem = selectedMenuItem;// 
		  selectedMenuItem = S_MENU;//  
		  select_prog = SEL_PROG;
		  return 1;
		 }

	 Lcd_update ();// 

	 return 0;
}

uint8_t set_contr (int8_t pin)
{
 if(pin==0)// 
  {
	LCDClear();
    LCD_XY(0,0);LCDStr(FONT_1X,(unsigned char *)".");
  }

  if(pin == +1 && Contrast < 80)LcdContrast(++Contrast);
  if(pin == -1 && Contrast > 50)LcdContrast(--Contrast);

  setup.Contrast = Contrast;

  utoa(Contrast,(char *) buff_LCD, 10);
  LCDClearStr(3,3);// 3 
  LCD_XY(3,3);LCDStr(FONT_2X,buff_LCD);

  if(pin == Long_Key)//   
	 {
	  save_setup();
	  LCDClear();
	  select_prog = M_VOL;//      
	  return 1;
	 }

  if(pin == Short_Key)
	 {
	  save_setup();
	  LCDClear();
	  selectedMenuItem = returnMenuItem;//
	  select_prog = M_DispMenu;
	  return 1;
	 }

  Lcd_update ();// 
  return 0;
}

uint8_t set_bass (int8_t pin)
{
  if(pin==0)// 
	 {
	   LCDClear();
	   LCD_XY(0,0);LCDStr(FONT_1X,(unsigned char *)". ");
	 }

  if(pin == +1)setup.bas = 1;
  if(pin == -1)setup.bas = 0;

  rda5807_SetBassBoost(setup.bas);

  strcpy((char  *)buff_LCD,(char  *)(setup.bas ? ".":"."));
  LCDClearStr(2,3);// 3 
  LCD_XY(3,3);LCDStr(FONT_2X,buff_LCD);

  if(pin == Long_Key)//   
	 {
	  save_setup();
	  LCDClear();
	  select_prog = M_VOL;//      
	  return 1;
	 }

  if(pin == Short_Key)
	 {
	  save_setup();
	  LCDClear();
	  selectedMenuItem = returnMenuItem;//
	  select_prog = M_DispMenu;
	  return 1;
	 }

  Lcd_update ();// 
  return 0;

}


//-----------------------------------------------------------------
void selectProg(int8_t pin) //  
{
	 LED_ON;// 
	 Set_Prog_Timer(0x0f,30000);//    Led 30
	 switch (select_prog)
	  {
	   case M_VOL://  ( )
			 {
				if(dispVol(pin))
					en_key=REPIT_PROG; //     select_prog
			 } break;
		case M_FR:// 
			 {
				if(dispFr(pin))
					en_key=REPIT_PROG;	//     select_prog
			 }break;
		case M_station: // 
			 {
				if(station(pin))
					en_key=REPIT_PROG; //     select_prog
			  }break;


		case M_DispMenu:// 
			{
			  if( dispMenu(pin) )
					en_key=REPIT_PROG;//     select_prog
			} break;

		case M_CONTR://.
		   {
			 if( set_contr (pin) )
				 en_key=REPIT_PROG;//     select_prog
		   }break;

		case M_BASS://.
		   {
			 if( set_bass (pin) )
				 en_key=REPIT_PROG;//     select_prog
		   }break;
	  }

    Lcd_update ();// 
}

 void fun_01(void)// 
 {
  uint16_t freq_in;
  freq_in = rx_buffer[1];
  freq_in <<= 8;
  freq_in += rx_buffer[0];

  n_station = rx_buffer[2];

  station (0);// 

  rda5807_SetFreq_In100Khz(freq_in);

  Flag_Prog |= ( 1UL << 0x02 );
 }

 void fun_02(void)//   
 {
  uint8_t i;
  uint8_t len=5;//  crc

  Fr=rda5807_GetFreq_In100Khz();

  uint8_t crc=0;
  tx_buffer[0]=':';
  tx_buffer[1]= len;
  tx_buffer[2]= 0x02;
  tx_buffer[3]= (uint8_t)Fr;
  tx_buffer[4]= (uint8_t)(Fr>>8);

  for(i=0;i<len;i++)crc+=tx_buffer[i];

  tx_buffer[i]=crc;

  USART_TX(len+1);

  Flag_Prog |= (1UL << 0x04 );//   (RSSI)
 }

 void fun_03(void)//  
   {
    rda5807_StartSeek(rx_buffer[0]);
    fSeekFr=1;
   }

 void fun_04(void)//RSSI
  {
   uint8_t i;
   uint8_t len=4;//  crc

   RSSI=rda5807_Get_RSSI();

   uint8_t crc=0;
   tx_buffer[0]=':';
   tx_buffer[1]= len;
   tx_buffer[2]= 0x04;
   tx_buffer[3]= RSSI;

   for(i=0;i<len;i++)crc+=tx_buffer[i];

   tx_buffer[i]=crc;

   USART_TX(len+1);

   if(select_prog==M_VOL || select_prog==M_FR)m_screen();
  }

 void fun_07(void)//  I2C
 {

  if(Len_RX==3)
	  Set_Prog_Timer(0x02, 2000);// fun_02()
  else
	  Flag_Prog_Timer &=  ~(1UL << 2);//  

  I2C_Master_Transmit(rx_buffer[0], (uint8_t * )&rx_buffer[1], Len_RX-1);

  LL_mDelay(5);

  //
  uint8_t crc=0;
   tx_buffer[0] = ':';
   tx_buffer[1] = 3;
   tx_buffer[2] = 0x07;

   uint8_t i;
   for(i=0; i < tx_buffer[1]; i++)crc+=tx_buffer[i];
   tx_buffer[i]=crc;

   USART_TX (tx_buffer[1]+1);

 }

 void fun_08(void)//  I2C
 {
  uint8_t i;
  uint8_t adr_chip = rx_buffer[0];

  uint8_t len=rx_buffer[3];
  uint8_t crc=0;

  if(len==0)
	  Set_Prog_Timer(0x02, 2000);// fun_02()
  else
	  Flag_Prog_Timer &=  ~(1UL << 2);//  

  tx_buffer[0] = ':';
  tx_buffer[1] = len+6;
  tx_buffer[2] = 0x08;

  tx_buffer[3]=adr_chip;
  tx_buffer[4]=rx_buffer[1];
  tx_buffer[5]=rx_buffer[2];

  if(len>0)
  	{
	  I2C_Master_Transmit(adr_chip, (uint8_t * )&tx_buffer[4], 2);
	  I2C_Master_Receive(adr_chip, (uint8_t * )&tx_buffer[6], len);
  	}

  for(i=0; i < tx_buffer[1]; i++)crc+=tx_buffer[i];
  tx_buffer[i]=crc;

  USART_TX (tx_buffer[1]+1);

 }

 void fun_05(void)// 
 {
  setup.vol=rx_buffer[0];
  rda5807_SetVolume(setup.vol);
 }

 void fun_06(void)// / 
 {
  rda5807_SetBassBoost(rx_buffer[0]);
 }

 void fun_0f(void)//Led off
   {
 	LED_OFF;
   }

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{
  /* USER CODE BEGIN 1 */
   uint8_t  i;
   uint32_t  sdvig;
   uint8_t fSeekYes = 0;
   uint32_t delay_temp;

   for(i=0;i<32;i++)Fun[i]=null_Prog;

   Fun[0x01]=fun_01;// 
   Fun[0x02]=fun_02;//   
   Fun[0x03]=fun_03;//  
   Fun[0x04]=fun_04;//RSSI
   Fun[0x05]=fun_05;//
   Fun[0x06]=fun_06;//

   Fun[0x07]=fun_07;//  I2C
   Fun[0x08]=fun_08;//  I2C
   Fun[0x0f]=fun_0f;//Led off

  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_SYSCFG);
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_PWR);

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_I2C1_Init();
  MX_SPI1_Init();
  MX_USART1_UART_Init();
  MX_ADC_Init();
  MX_TIM14_Init();
  /* USER CODE BEGIN 2 */

  LL_mDelay(30);
  LL_SYSTICK_EnableIT();

  LL_USART_EnableIT_RXNE(USART1);//      
  LL_USART_EnableIT_ERROR(USART1);

  LL_DMA_DisableChannel(DMA1, LL_DMA_CHANNEL_2);
  LL_DMA_ClearFlag_TC2(DMA1);
  LL_DMA_ClearFlag_TE2(DMA1);
  LL_USART_EnableDMAReq_TX(USART1);
  LL_DMA_EnableIT_TC(DMA1, LL_DMA_CHANNEL_2);
  LL_DMA_EnableIT_TE(DMA1, LL_DMA_CHANNEL_2);
  LL_DMA_ClearFlag_GI2(DMA1);
  LL_DMA_ClearFlag_TC2(DMA1);
  LL_DMA_ClearFlag_TE2(DMA1);
  LL_DMA_ConfigAddresses(DMA1, LL_DMA_CHANNEL_2, (uint32_t)&tx_buffer,
  		  LL_USART_DMA_GetRegAddr(USART1,LL_USART_DMA_REG_DATA_TRANSMIT),
  		  LL_DMA_GetDataTransferDirection(DMA1, LL_DMA_CHANNEL_2));

	LL_DMA_DisableChannel(DMA1, LL_DMA_CHANNEL_3);
	LL_DMA_ClearFlag_HT3(DMA1);
	LL_DMA_ClearFlag_TC3(DMA1);
	LL_DMA_ClearFlag_TE3(DMA1);
	LL_SPI_EnableDMAReq_TX(SPI1);
	//LL_DMA_EnableIT_HT(DMA1, LL_DMA_CHANNEL_3);//    
	LL_DMA_EnableIT_TC(DMA1, LL_DMA_CHANNEL_3); //    
	LL_DMA_EnableIT_TE(DMA1, LL_DMA_CHANNEL_3);
	LL_DMA_ClearFlag_GI3(DMA1);
	LL_DMA_ClearFlag_TC3(DMA1);
	LL_DMA_ClearFlag_TE3(DMA1);
	LL_DMA_ConfigAddresses(DMA1, LL_DMA_CHANNEL_3, (uint32_t) &LcdCache,
			LL_SPI_DMA_GetRegAddr(SPI1), LL_DMA_DIRECTION_MEMORY_TO_PERIPH);

	LL_SPI_SetRxFIFOThreshold(SPI1, LL_SPI_RX_FIFO_TH_QUARTER); // RX    8 
	LL_SPI_Enable(SPI1);
	LCDInit();

	LED_ON; // 
	Set_Prog_Timer(0x0f, 30000); //    Led 30

	load_setup();

	Contrast = setup.Contrast;
	//vol = setup.vol;
	n_station = setup.n_station;

	Lcd_image(0, 0, PICTURE, 504);
	LCD_XY(0, 0);
	//LCDStr(FONT_1X, (unsigned char*) " RDA5807M");
	LCDStr(FONT_1X, (unsigned char*)"Ver.22.03.25.");
	LcdContrast(setup.Contrast);
	Lcd_update(); // 

	LL_mDelay(3000);

	//   VREF  3.3  FLASH
	VREF_CAL = *((uint16_t*) 0x1FFFF7BA);
	/* disable ADC */
	if ((ADC1->CR & ADC_CR_ADEN) != 0)
	{
		ADC1->CR |= ADC_CR_ADDIS;
		while (ADC1->CR & ADC_CR_ADEN);
	}

	/* calibrate ADC */
	ADC1->CFGR1 &= ~ADC_CFGR1_DMAEN;
	ADC1->CR |= ADC_CR_ADCAL;
	while ((ADC1->CR & ADC_CR_ADCAL) != 0);
	/* reset configuration */
	ADC1->CFGR2 = 0;
	/* enable device */
	LL_ADC_Enable(ADC1);
	while (!(ADC1->ISR & ADC_ISR_ADRDY));
	//   AWD  3,2(TH==4095)
	ADC1->TR = (((VREF_CAL * 32) / 33) & 0xFFF) | 0xfff0000;

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */

   //    

    rda5807_SoftReset();
    LL_mDelay(100);
    rda5807_SetupDefault();
    LL_mDelay(100);
    rda5807_SetVolume(setup.vol);// ( 15 )
    LL_mDelay(100);

    //  
    n_station = setup.n_station;
    station(0);//  
    station(Long_Key);//

    //   2 
    LL_TIM_EnableIT_UPDATE(TIM14);
    LL_TIM_EnableCounter(TIM14);

    LCDClear();
    selectProg(0);

  while (1)
    {

		if(en_key != 0)// encode
		  {
			 if(en_key == REPIT_PROG)en_key=0;
			 selectProg(en_key);
			 if(en_key != REPIT_PROG)en_key=0;
		  }

		for(i=0,sdvig = 0x01; i<32 ;sdvig <<= 1,i++)
		  {
			 if(Flag_Prog==0 && Flag_Prog_Timer==0 )break;
			 if(Flag_Prog & sdvig)
				{
				  Flag_Prog &=  ~sdvig;// 
				  Fun[i]();
				}

			 delay_temp=get_millis();
			 if((Flag_Prog_Timer & sdvig) && (delay_temp  >= SoftTimer[i] ))
				{
				  Flag_Prog_Timer &=  ~sdvig;// 
				  Fun[i]();
				}
		   }

		if( fSeekFr==1)
			  {
				fSeekYes=rda5807_Get_SeekTuneReadyFlag();
				if(fSeekYes==0)
					{
					 fSeekFr=0;
					 Set_Prog_Timer(0x02, 2000);//fun_02()   UART  2000ms
					}
			  }

    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
    }//while
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  LL_FLASH_SetLatency(LL_FLASH_LATENCY_0);
  while(LL_FLASH_GetLatency() != LL_FLASH_LATENCY_0)
  {
  }
  LL_RCC_HSI_Enable();

   /* Wait till HSI is ready */
  while(LL_RCC_HSI_IsReady() != 1)
  {

  }
  LL_RCC_HSI_SetCalibTrimming(16);
  LL_RCC_HSI14_Enable();

   /* Wait till HSI14 is ready */
  while(LL_RCC_HSI14_IsReady() != 1)
  {

  }
  LL_RCC_HSI14_SetCalibTrimming(16);
  LL_RCC_PLL_ConfigDomain_SYS(LL_RCC_PLLSOURCE_HSI_DIV_2, LL_RCC_PLL_MUL_4);
  LL_RCC_PLL_Enable();

   /* Wait till PLL is ready */
  while(LL_RCC_PLL_IsReady() != 1)
  {

  }
  LL_RCC_SetAHBPrescaler(LL_RCC_SYSCLK_DIV_2);
  LL_RCC_SetAPB1Prescaler(LL_RCC_APB1_DIV_1);
  LL_RCC_SetSysClkSource(LL_RCC_SYS_CLKSOURCE_PLL);

   /* Wait till System clock is ready */
  while(LL_RCC_GetSysClkSource() != LL_RCC_SYS_CLKSOURCE_STATUS_PLL)
  {

  }
  LL_Init1msTick(8000000);
  LL_SetSystemCoreClock(8000000);
  LL_RCC_HSI14_EnableADCControl();
  LL_RCC_SetUSARTClockSource(LL_RCC_USART1_CLKSOURCE_HSI);
  LL_RCC_SetI2CClockSource(LL_RCC_I2C1_CLKSOURCE_HSI);
}

/**
  * @brief ADC Initialization Function
  * @param None
  * @retval None
  */
static void MX_ADC_Init(void)
{

  /* USER CODE BEGIN ADC_Init 0 */

  /* USER CODE END ADC_Init 0 */

  LL_ADC_InitTypeDef ADC_InitStruct = {0};
  LL_ADC_REG_InitTypeDef ADC_REG_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_ADC1);

  /* USER CODE BEGIN ADC_Init 1 */
  //LL_DMA_SetPeriphAddress(DMA1,LL_DMA_CHANNEL_1, LL_ADC_DMA_GetRegAddr(ADC1,ADC_DR_DATA ));


  /* USER CODE END ADC_Init 1 */

  /** Configure Regular Channel
  */
  LL_ADC_REG_SetSequencerChAdd(ADC1, LL_ADC_CHANNEL_VREFINT);

  /** Configure Internal Channel
  */
  LL_ADC_SetCommonPathInternalCh(__LL_ADC_COMMON_INSTANCE(ADC1), LL_ADC_PATH_INTERNAL_VREFINT);

  /** Configure the global features of the ADC (Clock, Resolution, Data Alignment and number of conversion)
  */
  ADC_InitStruct.Clock = LL_ADC_CLOCK_ASYNC;
  ADC_InitStruct.Resolution = LL_ADC_RESOLUTION_12B;
  ADC_InitStruct.DataAlignment = LL_ADC_DATA_ALIGN_RIGHT;
  ADC_InitStruct.LowPowerMode = LL_ADC_LP_MODE_NONE;
  LL_ADC_Init(ADC1, &ADC_InitStruct);
  ADC_REG_InitStruct.TriggerSource = LL_ADC_REG_TRIG_SOFTWARE;
  ADC_REG_InitStruct.SequencerDiscont = LL_ADC_REG_SEQ_DISCONT_DISABLE;
  ADC_REG_InitStruct.ContinuousMode = LL_ADC_REG_CONV_SINGLE;
  ADC_REG_InitStruct.DMATransfer = LL_ADC_REG_DMA_TRANSFER_LIMITED;
  ADC_REG_InitStruct.Overrun = LL_ADC_REG_OVR_DATA_PRESERVED;
  LL_ADC_REG_Init(ADC1, &ADC_REG_InitStruct);
  LL_ADC_REG_SetSequencerScanDirection(ADC1, LL_ADC_REG_SEQ_SCAN_DIR_FORWARD);
  LL_ADC_SetSamplingTimeCommonChannels(ADC1, LL_ADC_SAMPLINGTIME_239CYCLES_5);
  /* USER CODE BEGIN ADC_Init 2 */

  /* USER CODE END ADC_Init 2 */

}

/**
  * @brief I2C1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_I2C1_Init(void)
{

  /* USER CODE BEGIN I2C1_Init 0 */

  /* USER CODE END I2C1_Init 0 */

  LL_I2C_InitTypeDef I2C_InitStruct = {0};

  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  /**I2C1 GPIO Configuration
  PA9   ------> I2C1_SCL
  PA10   ------> I2C1_SDA
  */
  GPIO_InitStruct.Pin = LL_GPIO_PIN_9;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_MEDIUM;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_OPENDRAIN;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_UP;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_4;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_10;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_MEDIUM;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_OPENDRAIN;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_UP;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_4;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* Peripheral clock enable */
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_I2C1);

  /* USER CODE BEGIN I2C1_Init 1 */

  /* USER CODE END I2C1_Init 1 */

  /** I2C Initialization
  */
  LL_I2C_DisableOwnAddress2(I2C1);
  LL_I2C_DisableGeneralCall(I2C1);
  LL_I2C_EnableClockStretching(I2C1);
  I2C_InitStruct.PeripheralMode = LL_I2C_MODE_I2C;
  I2C_InitStruct.Timing = 0x2000090E;
  I2C_InitStruct.AnalogFilter = LL_I2C_ANALOGFILTER_ENABLE;
  I2C_InitStruct.DigitalFilter = 0;
  I2C_InitStruct.OwnAddress1 = 0;
  I2C_InitStruct.TypeAcknowledge = LL_I2C_ACK;
  I2C_InitStruct.OwnAddrSize = LL_I2C_OWNADDRESS1_7BIT;
  LL_I2C_Init(I2C1, &I2C_InitStruct);
  LL_I2C_EnableAutoEndMode(I2C1);
  LL_I2C_SetOwnAddress2(I2C1, 0, LL_I2C_OWNADDRESS2_NOMASK);
  /* USER CODE BEGIN I2C1_Init 2 */

  /* USER CODE END I2C1_Init 2 */

}

/**
  * @brief SPI1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_SPI1_Init(void)
{

  /* USER CODE BEGIN SPI1_Init 0 */

  /* USER CODE END SPI1_Init 0 */

  LL_SPI_InitTypeDef SPI_InitStruct = {0};

  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_SPI1);

  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  /**SPI1 GPIO Configuration
  PA4   ------> SPI1_NSS
  PA5   ------> SPI1_SCK
  PA7   ------> SPI1_MOSI
  */
  GPIO_InitStruct.Pin = CE_Pin;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_HIGH;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_0;
  LL_GPIO_Init(CE_GPIO_Port, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_5;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_MEDIUM;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_UP;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_0;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_7;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_MEDIUM;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_0;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* SPI1 DMA Init */

  /* SPI1_TX Init */
  LL_DMA_SetDataTransferDirection(DMA1, LL_DMA_CHANNEL_3, LL_DMA_DIRECTION_MEMORY_TO_PERIPH);

  LL_DMA_SetChannelPriorityLevel(DMA1, LL_DMA_CHANNEL_3, LL_DMA_PRIORITY_MEDIUM);

  LL_DMA_SetMode(DMA1, LL_DMA_CHANNEL_3, LL_DMA_MODE_NORMAL);

  LL_DMA_SetPeriphIncMode(DMA1, LL_DMA_CHANNEL_3, LL_DMA_PERIPH_NOINCREMENT);

  LL_DMA_SetMemoryIncMode(DMA1, LL_DMA_CHANNEL_3, LL_DMA_MEMORY_INCREMENT);

  LL_DMA_SetPeriphSize(DMA1, LL_DMA_CHANNEL_3, LL_DMA_PDATAALIGN_BYTE);

  LL_DMA_SetMemorySize(DMA1, LL_DMA_CHANNEL_3, LL_DMA_MDATAALIGN_BYTE);

  /* USER CODE BEGIN SPI1_Init 1 */

  /* USER CODE END SPI1_Init 1 */
  /* SPI1 parameter configuration*/
  SPI_InitStruct.TransferDirection = LL_SPI_FULL_DUPLEX;
  SPI_InitStruct.Mode = LL_SPI_MODE_MASTER;
  SPI_InitStruct.DataWidth = LL_SPI_DATAWIDTH_8BIT;
  SPI_InitStruct.ClockPolarity = LL_SPI_POLARITY_LOW;
  SPI_InitStruct.ClockPhase = LL_SPI_PHASE_1EDGE;
  SPI_InitStruct.NSS = LL_SPI_NSS_HARD_OUTPUT;
  SPI_InitStruct.BaudRate = LL_SPI_BAUDRATEPRESCALER_DIV2;
  SPI_InitStruct.BitOrder = LL_SPI_MSB_FIRST;
  SPI_InitStruct.CRCCalculation = LL_SPI_CRCCALCULATION_DISABLE;
  SPI_InitStruct.CRCPoly = 7;
  LL_SPI_Init(SPI1, &SPI_InitStruct);
  LL_SPI_SetStandard(SPI1, LL_SPI_PROTOCOL_MOTOROLA);
  LL_SPI_EnableNSSPulseMgt(SPI1);
  /* USER CODE BEGIN SPI1_Init 2 */

  /* USER CODE END SPI1_Init 2 */

}

/**
  * @brief TIM14 Initialization Function
  * @param None
  * @retval None
  */
static void MX_TIM14_Init(void)
{

  /* USER CODE BEGIN TIM14_Init 0 */

  /* USER CODE END TIM14_Init 0 */

  LL_TIM_InitTypeDef TIM_InitStruct = {0};
  LL_TIM_OC_InitTypeDef TIM_OC_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP1_EnableClock(LL_APB1_GRP1_PERIPH_TIM14);

  /* TIM14 interrupt Init */
  NVIC_SetPriority(TIM14_IRQn, 0);
  NVIC_EnableIRQ(TIM14_IRQn);

  /* USER CODE BEGIN TIM14_Init 1 */

  /* USER CODE END TIM14_Init 1 */
  TIM_InitStruct.Prescaler = 8000;
  TIM_InitStruct.CounterMode = LL_TIM_COUNTERMODE_UP;
  TIM_InitStruct.Autoreload = 1999;
  TIM_InitStruct.ClockDivision = LL_TIM_CLOCKDIVISION_DIV1;
  LL_TIM_Init(TIM14, &TIM_InitStruct);
  LL_TIM_EnableARRPreload(TIM14);
  TIM_OC_InitStruct.OCMode = LL_TIM_OCMODE_FROZEN;
  TIM_OC_InitStruct.OCState = LL_TIM_OCSTATE_DISABLE;
  TIM_OC_InitStruct.OCNState = LL_TIM_OCSTATE_DISABLE;
  TIM_OC_InitStruct.CompareValue = 0;
  TIM_OC_InitStruct.OCPolarity = LL_TIM_OCPOLARITY_HIGH;
  LL_TIM_OC_Init(TIM14, LL_TIM_CHANNEL_CH1, &TIM_OC_InitStruct);
  LL_TIM_OC_DisableFast(TIM14, LL_TIM_CHANNEL_CH1);
  /* USER CODE BEGIN TIM14_Init 2 */

  /* USER CODE END TIM14_Init 2 */

}

/**
  * @brief USART1 Initialization Function
  * @param None
  * @retval None
  */
static void MX_USART1_UART_Init(void)
{

  /* USER CODE BEGIN USART1_Init 0 */

  /* USER CODE END USART1_Init 0 */

  LL_USART_InitTypeDef USART_InitStruct = {0};

  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};

  /* Peripheral clock enable */
  LL_APB1_GRP2_EnableClock(LL_APB1_GRP2_PERIPH_USART1);

  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  /**USART1 GPIO Configuration
  PA2   ------> USART1_TX
  PA3   ------> USART1_RX
  */
  GPIO_InitStruct.Pin = LL_GPIO_PIN_2;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_MEDIUM;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_1;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  GPIO_InitStruct.Pin = LL_GPIO_PIN_3;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_ALTERNATE;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_MEDIUM;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_UP;
  GPIO_InitStruct.Alternate = LL_GPIO_AF_1;
  LL_GPIO_Init(GPIOA, &GPIO_InitStruct);

  /* USART1 DMA Init */

  /* USART1_TX Init */
  LL_DMA_SetDataTransferDirection(DMA1, LL_DMA_CHANNEL_2, LL_DMA_DIRECTION_MEMORY_TO_PERIPH);

  LL_DMA_SetChannelPriorityLevel(DMA1, LL_DMA_CHANNEL_2, LL_DMA_PRIORITY_LOW);

  LL_DMA_SetMode(DMA1, LL_DMA_CHANNEL_2, LL_DMA_MODE_NORMAL);

  LL_DMA_SetPeriphIncMode(DMA1, LL_DMA_CHANNEL_2, LL_DMA_PERIPH_NOINCREMENT);

  LL_DMA_SetMemoryIncMode(DMA1, LL_DMA_CHANNEL_2, LL_DMA_MEMORY_INCREMENT);

  LL_DMA_SetPeriphSize(DMA1, LL_DMA_CHANNEL_2, LL_DMA_PDATAALIGN_BYTE);

  LL_DMA_SetMemorySize(DMA1, LL_DMA_CHANNEL_2, LL_DMA_MDATAALIGN_BYTE);

  /* USART1 interrupt Init */
  NVIC_SetPriority(USART1_IRQn, 0);
  NVIC_EnableIRQ(USART1_IRQn);

  /* USER CODE BEGIN USART1_Init 1 */

  /* USER CODE END USART1_Init 1 */
  USART_InitStruct.BaudRate = 38400;
  USART_InitStruct.DataWidth = LL_USART_DATAWIDTH_8B;
  USART_InitStruct.StopBits = LL_USART_STOPBITS_1;
  USART_InitStruct.Parity = LL_USART_PARITY_NONE;
  USART_InitStruct.TransferDirection = LL_USART_DIRECTION_TX_RX;
  USART_InitStruct.HardwareFlowControl = LL_USART_HWCONTROL_NONE;
  USART_InitStruct.OverSampling = LL_USART_OVERSAMPLING_8;
  LL_USART_Init(USART1, &USART_InitStruct);
  LL_USART_DisableIT_CTS(USART1);
  LL_USART_ConfigAsyncMode(USART1);
  LL_USART_Enable(USART1);
  /* USER CODE BEGIN USART1_Init 2 */


  /* USER CODE END USART1_Init 2 */

}

/**
  * Enable DMA controller clock
  */
static void MX_DMA_Init(void)
{

  /* Init with LL driver */
  /* DMA controller clock enable */
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_DMA1);

  /* DMA interrupt init */
  /* DMA1_Channel2_3_IRQn interrupt configuration */
  NVIC_SetPriority(DMA1_Channel2_3_IRQn, 0);
  NVIC_EnableIRQ(DMA1_Channel2_3_IRQn);

}

/**
  * @brief GPIO Initialization Function
  * @param None
  * @retval None
  */
static void MX_GPIO_Init(void)
{
  LL_EXTI_InitTypeDef EXTI_InitStruct = {0};
  LL_GPIO_InitTypeDef GPIO_InitStruct = {0};
/* USER CODE BEGIN MX_GPIO_Init_1 */
/* USER CODE END MX_GPIO_Init_1 */

  /* GPIO Ports Clock Enable */
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOF);
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOA);
  LL_AHB1_GRP1_EnableClock(LL_AHB1_GRP1_PERIPH_GPIOB);

  /**/
  LL_GPIO_SetOutputPin(LED_GPIO_Port, LED_Pin);

  /**/
  LL_GPIO_ResetOutputPin(D_C_GPIO_Port, D_C_Pin);

  /**/
  LL_GPIO_ResetOutputPin(RST_GPIO_Port, RST_Pin);

  /**/
  GPIO_InitStruct.Pin = ecode_D_Pin;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_INPUT;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(ecode_D_GPIO_Port, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = LED_Pin;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_OPENDRAIN;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(LED_GPIO_Port, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = D_C_Pin;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(D_C_GPIO_Port, &GPIO_InitStruct);

  /**/
  GPIO_InitStruct.Pin = RST_Pin;
  GPIO_InitStruct.Mode = LL_GPIO_MODE_OUTPUT;
  GPIO_InitStruct.Speed = LL_GPIO_SPEED_FREQ_LOW;
  GPIO_InitStruct.OutputType = LL_GPIO_OUTPUT_PUSHPULL;
  GPIO_InitStruct.Pull = LL_GPIO_PULL_NO;
  LL_GPIO_Init(RST_GPIO_Port, &GPIO_InitStruct);

  /**/
  LL_SYSCFG_SetEXTISource(LL_SYSCFG_EXTI_PORTF, LL_SYSCFG_EXTI_LINE1);

  /**/
  LL_SYSCFG_SetEXTISource(LL_SYSCFG_EXTI_PORTA, LL_SYSCFG_EXTI_LINE0);

  /**/
  LL_GPIO_SetPinPull(ecode_CLK_GPIO_Port, ecode_CLK_Pin, LL_GPIO_PULL_NO);

  /**/
  LL_GPIO_SetPinPull(ecode_Kn_GPIO_Port, ecode_Kn_Pin, LL_GPIO_PULL_NO);

  /**/
  LL_GPIO_SetPinMode(ecode_CLK_GPIO_Port, ecode_CLK_Pin, LL_GPIO_MODE_INPUT);

  /**/
  LL_GPIO_SetPinMode(ecode_Kn_GPIO_Port, ecode_Kn_Pin, LL_GPIO_MODE_INPUT);

  /**/
  EXTI_InitStruct.Line_0_31 = LL_EXTI_LINE_1;
  EXTI_InitStruct.LineCommand = ENABLE;
  EXTI_InitStruct.Mode = LL_EXTI_MODE_IT;
  EXTI_InitStruct.Trigger = LL_EXTI_TRIGGER_FALLING;
  LL_EXTI_Init(&EXTI_InitStruct);

  /**/
  EXTI_InitStruct.Line_0_31 = LL_EXTI_LINE_0;
  EXTI_InitStruct.LineCommand = ENABLE;
  EXTI_InitStruct.Mode = LL_EXTI_MODE_IT;
  EXTI_InitStruct.Trigger = LL_EXTI_TRIGGER_RISING_FALLING;
  LL_EXTI_Init(&EXTI_InitStruct);

  /* EXTI interrupt init*/
  NVIC_SetPriority(EXTI0_1_IRQn, 2);
  NVIC_EnableIRQ(EXTI0_1_IRQn);

/* USER CODE BEGIN MX_GPIO_Init_2 */
/* USER CODE END MX_GPIO_Init_2 */
}

/* USER CODE BEGIN 4 */

void EXTI0_Callback(uint32_t delay)
 {
   if(delay < 750)
	 {
		en_key = Short_Key;
	 }
   else
	 {
		en_key = Long_Key;
	 }

  // selectProg(en_key);
 }

void EXTI1_Callback(uint8_t pin)
 {
	if (pin == 1)
	{
		en_key = +1;
		//selectProg(en_key);
		LL_mDelay(3);
	}


	if (pin == 0)
	{
		en_key = -1;
		//selectProg(en_key);
		LL_mDelay(3);
	}

 }

//---------------------------------------------------------------------------------------
void  USART1_RX_Callback(void)
{
	//uint8_t data_RX ;
	static uint8_t len;
	static uint8_t crc;
	static uint8_t kod_command=255;
	static uint8_t obr=0;

	data_RX = LL_USART_ReceiveData8(USART1);
	flag_RX=1;

	switch(obr)
	 {
		 case 0: if(data_RX==':'){obr=1; rx_counter=0;crc=':';}break;

		 case 1:
		  {
			len = data_RX;
			if(len > RX_BUFFER_SIZE-1 || len < 3) obr=0;
			else obr=2;
			crc+=len;
			len-=3;//   3  - 0=':', 1=len, 2= 
		  } break;

		case 2:
		  {
		   kod_command=data_RX;
		   crc+=kod_command;
		   obr=3;
		  }break;

		default :
		  {
		   if(rx_counter >= len) // CRC
			  {
				 if(crc==data_RX)
				   {
					 Len_RX=len;
					 Flag_Prog |= (1UL << kod_command );//    
				   }

				  obr=0;
				  return;
			  }

		   rx_buffer[rx_counter++]=data_RX;
		   crc+= data_RX;
		 }
	} //switch

}

void DMA1_SPI_TXComplete(void)
{
  fl_SPI_tx = 0;// SPI 
}

//-----------------------------------------------------------------------------
void DMA1_USART_TXComplete(void)
{
  fl_USART_tx = 0;// 
}
//----------------------------------------------------------------------------

void TIM14_Callback(void)
{
  Flag_Prog |= ( 1UL << 0x02 );//1   2 .
}
/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */

  /* USER CODE END Error_Handler_Debug */
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     tex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
